/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.esi;

import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.encoding.Base64;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.JobKt;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import theorycrafter.esi.EsiAuthScope;
import theorycrafter.esi.EsiKt;
import theorycrafter.esi.EveSsoKt;
import theorycrafter.esi.EveSsoTokens;
import theorycrafter.esi.EveSsoTokensResponse;
import theorycrafter.utils.ValueOrError;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u001a'\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007\u00a2\u0006\u0002\u0010\b\u001a\u0006\u0010\t\u001a\u00020\u0001\u001a\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a~\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u00020\u00010\u0014\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0016\u001a\u00020\u000f2$\u0010\u0017\u001a \b\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u00182.\u0010\u001c\u001a*\b\u0001\u0012\u0004\u0012\u00020\u000f\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u00020\u00010\u00140\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u0018H\u0086@\u00a2\u0006\u0002\u0010\u001d\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"EVE_OAUTH_TOKEN_URL", "", "HOST_HEADER_VALUE", "authStartUrl", "codeVerifier", "scopes", "", "Ltheorycrafter/esi/EsiAuthScope;", "(Ljava/lang/String;[Ltheorycrafter/esi/EsiAuthScope;)Ljava/lang/String;", "generateCodeVerifier", "obtainEveSsoTokens", "Ltheorycrafter/esi/EveSsoTokensResponse;", "authCode", "refreshEveSsoTokens", "ssoTokens", "Ltheorycrafter/esi/EveSsoTokens;", "sendEveSsoTokensRequestAndParseResponse", "request", "Lokhttp3/Request;", "withFreshEveSsoTokens", "Ltheorycrafter/utils/ValueOrError;", "T", "tokens", "onTokensUpdated", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "", "", "block", "(Ltheorycrafter/esi/EveSsoTokens;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Theorycrafter"})
public final class EveSsoKt {
    @NotNull
    private static final String EVE_OAUTH_TOKEN_URL = "https://login.eveonline.com/v2/oauth/token";
    @NotNull
    private static final String HOST_HEADER_VALUE = "login.eveonline.com";

    @NotNull
    public static final String authStartUrl(@NotNull String codeVerifier, EsiAuthScope ... scopes) {
        Intrinsics.checkNotNullParameter((Object)codeVerifier, (String)"codeVerifier");
        Intrinsics.checkNotNullParameter((Object)scopes, (String)"scopes");
        Base64 base64 = Base64.Default.getUrlSafe();
        byte[] byArray = MessageDigest.getInstance("SHA-256").digest(StringsKt.encodeToByteArray((String)codeVerifier));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        char[] cArray = new char[]{'='};
        String codeChallenge = StringsKt.trimEnd((String)Base64.encode$default((Base64)base64, (byte[])byArray, (int)0, (int)0, (int)6, null), (char[])cArray);
        return HttpUrl.Companion.get("https://login.eveonline.com/v2/oauth/authorize/").newBuilder().addEncodedQueryParameter("response_type", "code").addEncodedQueryParameter("redirect_uri", "https://theorycrafter.pro/sso_auth_callback").addEncodedQueryParameter("client_id", "eb7f961a3639401da02a946f0b5e5dd6").addEncodedQueryParameter("scope", ArraysKt.joinToString$default((Object[])scopes, (CharSequence)",", null, null, (int)0, null, EveSsoKt::authStartUrl$lambda$0, (int)30, null)).addEncodedQueryParameter("code_challenge", codeChallenge).addEncodedQueryParameter("code_challenge_method", "S256").addEncodedQueryParameter("state", "Theorycrafter rules").toString();
    }

    @NotNull
    public static final String generateCodeVerifier() {
        return Base64.encode$default((Base64)Base64.Default.getUrlSafe(), (byte[])Random.Default.nextBytes(64), (int)0, (int)0, (int)6, null);
    }

    @NotNull
    public static final EveSsoTokensResponse obtainEveSsoTokens(@NotNull String authCode, @NotNull String codeVerifier) {
        Intrinsics.checkNotNullParameter((Object)authCode, (String)"authCode");
        Intrinsics.checkNotNullParameter((Object)codeVerifier, (String)"codeVerifier");
        RequestBody requestBody = (RequestBody)new FormBody.Builder(null, 1, null).add("grant_type", "authorization_code").add("client_id", "eb7f961a3639401da02a946f0b5e5dd6").add("code", authCode).add("code_verifier", codeVerifier).build();
        Request request = new Request.Builder().url(EVE_OAUTH_TOKEN_URL).header("Content-Type", "application/x-www-form-urlencoded").header("Host", HOST_HEADER_VALUE).post(requestBody).build();
        return EveSsoKt.sendEveSsoTokensRequestAndParseResponse(request);
    }

    @NotNull
    public static final EveSsoTokensResponse refreshEveSsoTokens(@NotNull EveSsoTokens ssoTokens) {
        Intrinsics.checkNotNullParameter((Object)ssoTokens, (String)"ssoTokens");
        RequestBody requestBody = (RequestBody)new FormBody.Builder(null, 1, null).add("grant_type", "refresh_token").add("refresh_token", ssoTokens.getRefreshToken()).add("client_id", "eb7f961a3639401da02a946f0b5e5dd6").build();
        Request request = new Request.Builder().url(EVE_OAUTH_TOKEN_URL).header("Content-Type", "application/x-www-form-urlencoded").header("Host", HOST_HEADER_VALUE).post(requestBody).build();
        return EveSsoKt.sendEveSsoTokensRequestAndParseResponse(request);
    }

    private static final EveSsoTokensResponse sendEveSsoTokensRequestAndParseResponse(Request request) {
        Response response = EsiKt.getESI_HTTP_CLIENT().newCall(request).execute();
        ResponseBody responseBody = response.body();
        if (response.code() != 200 || responseBody == null) {
            ResponseBody responseBody2 = responseBody;
            return new EveSsoTokensResponse(ValueOrError.Companion.failure("Error retrieving tokens\nResponse code: " + response.code() + "\nResponse body: " + (responseBody2 != null ? responseBody2.string() : null)), response.code());
        }
        String bodyString = responseBody.string();
        try {
            JsonElement jsonElement = Json.Default.parseToJsonElement(bodyString);
            JsonObject jsonObject = jsonElement instanceof JsonObject ? (JsonObject)jsonElement : null;
            if (jsonObject == null) {
                throw new SerializationException("Unexpected root JSON element");
            }
            JsonObject json = jsonObject;
            Object object = json.get((Object)"access_token");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonPrimitive");
            String accessToken = ((JsonPrimitive)object).getContent();
            Object object2 = json.get((Object)"expires_in");
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonPrimitive");
            int expiresInSec = JsonElementKt.getInt((JsonPrimitive)((JsonPrimitive)object2));
            Object object3 = json.get((Object)"refresh_token");
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonPrimitive");
            String refreshToken = ((JsonPrimitive)object3).getContent();
            return new EveSsoTokensResponse(ValueOrError.Companion.success(new EveSsoTokens(accessToken, System.currentTimeMillis() + Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)expiresInSec, (DurationUnit)DurationUnit.SECONDS)), refreshToken, System.currentTimeMillis())), response.code());
        }
        catch (Exception e) {
            return new EveSsoTokensResponse(ValueOrError.Companion.failure("Invalid response retrieving tokens: " + e.getMessage()), response.code());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final <T> Object withFreshEveSsoTokens(@NotNull EveSsoTokens var0, @NotNull Function2<? super EveSsoTokens, ? super Continuation<? super Unit>, ? extends Object> var1_1, @NotNull Function2<? super EveSsoTokens, ? super Continuation<? super ValueOrError<? extends T, String>>, ? extends Object> var2_2, @NotNull Continuation<? super ValueOrError<? extends T, String>> $completion) {
        if (!($completion instanceof withFreshEveSsoTokens.1)) ** GOTO lbl-1000
        var11_4 = $completion;
        if ((var11_4.label & -2147483648) != 0) {
            var11_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return EveSsoKt.withFreshEveSsoTokens(null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (tokens.getExpirationUtcMillis() <= System.currentTimeMillis() + (long)10000) ** GOTO lbl15
                v0 = tokens;
                ** GOTO lbl52
lbl15:
                // 1 sources

                tokensResponse = EveSsoKt.refreshEveSsoTokens(tokens);
                if (tokensResponse.getResponseCode() == 400) {
                    $continuation.L$0 = onTokensUpdated;
                    $continuation.L$1 = block;
                    $continuation.L$2 = tokensResponse;
                    $continuation.label = 1;
                    v1 = onTokensUpdated.invoke(null, $continuation);
                    if (v1 == var12_6) {
                        return var12_6;
                    }
                }
                ** GOTO lbl31
            }
            case 1: {
                tokensResponse = (EveSsoTokensResponse)$continuation.L$2;
                block = (Function2)$continuation.L$1;
                onTokensUpdated = (Function2)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl31:
                // 2 sources

                if ((result = tokensResponse.getResult()).isFailure()) {
                    return ValueOrError.Companion.failure(result.failure());
                }
                var7_9 = result.value();
                it = (EveSsoTokens)var7_9;
                $i$a$-also-EveSsoKt$withFreshEveSsoTokens$freshTokens$1 = false;
                $continuation.L$0 = block;
                $continuation.L$1 = var7_9;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v2 = onTokensUpdated.invoke((Object)it, $continuation);
                if (v2 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl51
            }
            case 2: {
                $i$a$-also-EveSsoKt$withFreshEveSsoTokens$freshTokens$1 = false;
                var7_9 = $continuation.L$1;
                block = (Function2)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl51:
                // 2 sources

                v0 = (EveSsoTokens)var7_9;
lbl52:
                // 2 sources

                freshTokens = v0;
                JobKt.ensureActive((CoroutineContext)$continuation.getContext());
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 3;
                v3 = block.invoke((Object)freshTokens, $continuation);
                if (v3 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl64
            }
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl64:
                // 2 sources

                return v3;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final CharSequence authStartUrl$lambda$0(EsiAuthScope it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getId();
    }
}

