/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.formats;

import eve.data.Attribute;
import eve.data.BoosterType;
import eve.data.ChargeType;
import eve.data.DroneType;
import eve.data.EveData;
import eve.data.EveItemType;
import eve.data.ImplantType;
import eve.data.ModuleSlotType;
import eve.data.ModuleType;
import eve.data.Mutaplasmid;
import eve.data.ShipType;
import eve.data.SubsystemType;
import eve.data.TacticalModeType;
import eve.data.utils.ValueByEnum;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import theorycrafter.fitting.Module;
import theorycrafter.formats.EftExportOptions;
import theorycrafter.formats.EftMutationDescriptor;
import theorycrafter.formats.FormatUtilsKt;
import theorycrafter.formats.PossiblyMutated;
import theorycrafter.storage.ExtraAttribute;
import theorycrafter.storage.StoredFit;
import theorycrafter.ui.fiteditor.InitialSubsystemsKt;
import theorycrafter.ui.fiteditor.MutaplasmidsKt;
import theorycrafter.ui.fiteditor.TacticalModesKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\u001a\u001d\u0010\u0000\u001a\u00020\u0001*\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005R\u00020\u0002\u00a2\u0006\u0002\u0010\u0006\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\b\u001a\u0019\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u0001R\u00020\u0002\u00a2\u0006\u0002\u0010\u000b\u001a!\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u00020\u0002\u00a2\u0006\u0002\u0010\u0012\u001a\u0019\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u00020\u0002\u00a2\u0006\u0002\u0010\u0015\u001a\u0019\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u00020\u0002\u00a2\u0006\u0002\u0010\u0018\u001a\f\u0010\u0019\u001a\u0004\u0018\u00010\r*\u00020\u0001\u001a\u0014\u0010\u0019\u001a\u0004\u0018\u00010\r*\b\u0012\u0004\u0012\u00020\u00010\u001aH\u0002\u00a8\u0006\u001b\u00b2\u0006\u0016\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dX\u008a\u0084\u0002\u00b2\u0006\u0010\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u008a\u0084\u0002"}, d2={"toEft", "", "Leve/data/EveData;", "Ltheorycrafter/storage/StoredFit;", "options", "Ltheorycrafter/formats/EftExportOptions;", "(Leve/data/EveData;Ltheorycrafter/storage/StoredFit;Ltheorycrafter/formats/EftExportOptions;)Ljava/lang/String;", "emptySlot", "Leve/data/ModuleSlotType;", "fitFromEft", "text", "(Leve/data/EveData;Ljava/lang/String;)Ltheorycrafter/storage/StoredFit;", "EftMutationDescriptor", "Ltheorycrafter/formats/EftMutationDescriptor;", "baseType", "Leve/data/EveItemType;", "mutation", "Ltheorycrafter/storage/StoredFit$StoredMutation;", "(Leve/data/EveData;Leve/data/EveItemType;Ltheorycrafter/storage/StoredFit$StoredMutation;)Ltheorycrafter/formats/EftMutationDescriptor;", "storedModule", "Ltheorycrafter/storage/StoredFit$StoredModule;", "(Leve/data/EveData;Ltheorycrafter/storage/StoredFit$StoredModule;)Ltheorycrafter/formats/EftMutationDescriptor;", "storedDroneGroup", "Ltheorycrafter/storage/StoredFit$StoredDroneGroup;", "(Leve/data/EveData;Ltheorycrafter/storage/StoredFit$StoredDroneGroup;)Ltheorycrafter/formats/EftMutationDescriptor;", "toEftMutationDescriptor", "", "Theorycrafter", "defaultSubsystemTypeByKind", "Leve/data/utils/ValueByEnum;", "Leve/data/SubsystemType$Kind;", "Leve/data/SubsystemType;", "cargoItems", "", "Ltheorycrafter/storage/StoredFit$StoredCargoItem;"})
@SourceDebugExtension(value={"SMAP\nEft.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Eft.kt\ntheorycrafter/formats/EftKt\n+ 2 ReadWrite.kt\nkotlin/io/TextStreamsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ValueByEnum.kt\neve/data/utils/ValueByEnumKt\n*L\n1#1,702:1\n54#2,4:703\n1#3:707\n1#3:708\n1#3:737\n1#3:750\n1557#4:709\n1628#4,3:710\n1557#4:713\n1628#4,3:714\n1557#4:720\n1628#4,3:721\n1611#4,9:727\n1863#4:736\n1864#4:738\n1620#4:739\n1611#4,9:740\n1863#4:749\n1864#4:751\n1620#4:752\n1557#4:753\n1628#4,3:754\n1557#4:757\n1628#4,3:758\n80#5,3:717\n39#5,3:724\n*S KotlinDebug\n*F\n+ 1 Eft.kt\ntheorycrafter/formats/EftKt\n*L\n563#1:703,4\n563#1:707\n512#1:737\n530#1:750\n636#1:709\n636#1:710,3\n689#1:713\n689#1:714,3\n263#1:720\n263#1:721,3\n512#1:727,9\n512#1:736\n512#1:738\n512#1:739\n530#1:740,9\n530#1:749\n530#1:751\n530#1:752\n539#1:753\n539#1:754,3\n553#1:757\n553#1:758,3\n57#1:717,3\n322#1:724,3\n*E\n"})
public final class EftKt {
    @NotNull
    public static final String toEft(@NotNull EveData $context_receiver_0, @NotNull StoredFit $this$toEft, @NotNull EftExportOptions options) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$toEft, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        List mutations = new ArrayList();
        StringBuilder $this$toEft_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        ShipType shipType = $context_receiver_0.shipType($this$toEft.getShipTypeId());
        StringBuilder stringBuilder2 = $this$toEft_u24lambda_u242.append("[" + shipType.getName() + ", " + $this$toEft.getName() + "]");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)$this$toEft_u24lambda_u242.append('\n'), (String)"append(...)");
        EftKt.toEft$appendModuleRack($this$toEft_u24lambda_u242, $context_receiver_0, options, mutations, ModuleSlotType.LOW, $this$toEft.getLowSlotRack());
        EftKt.toEft$appendModuleRack($this$toEft_u24lambda_u242, $context_receiver_0, options, mutations, ModuleSlotType.MEDIUM, $this$toEft.getMedSlotRack());
        EftKt.toEft$appendModuleRack($this$toEft_u24lambda_u242, $context_receiver_0, options, mutations, ModuleSlotType.HIGH, $this$toEft.getHighSlotRack());
        EftKt.toEft$appendModuleRack($this$toEft_u24lambda_u242, $context_receiver_0, options, mutations, ModuleSlotType.RIG, $this$toEft.getRigs());
        EftKt.toEft$appendSubsystems($this$toEft_u24lambda_u242, $context_receiver_0, $this$toEft.getSubsystems());
        Intrinsics.checkNotNullExpressionValue((Object)$this$toEft_u24lambda_u242.append('\n'), (String)"append(...)");
        EftKt.toEft$appendDrones($this$toEft_u24lambda_u242, $context_receiver_0, options, mutations, (Collection<StoredFit.StoredDroneGroup>)$this$toEft.getDroneGroups());
        if (options.getImplants()) {
            EftKt.toEft$appendImplants($this$toEft_u24lambda_u242, $context_receiver_0, (Collection<StoredFit.StoredImplant>)$this$toEft.getImplants());
        }
        if (options.getBoosters()) {
            EftKt.toEft$appendBoosters($this$toEft_u24lambda_u242, $context_receiver_0, (Collection<StoredFit.StoredBooster>)$this$toEft.getBoosters());
        }
        if (options.getCargo()) {
            EftKt.toEft$appendCargo($this$toEft_u24lambda_u242, $context_receiver_0, (Collection<StoredFit.StoredCargoItem>)$this$toEft.getCargoItems());
        }
        if (options.getMutatedAttributes()) {
            EftKt.toEft$appendMutatedItemDescriptions($this$toEft_u24lambda_u242, mutations);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return ((Object)StringsKt.trimEnd((CharSequence)string)).toString();
    }

    public static /* synthetic */ String toEft$default(EveData eveData2, StoredFit storedFit, EftExportOptions eftExportOptions, int n, Object object) {
        if ((n & 2) != 0) {
            eftExportOptions = EftExportOptions.Companion.getIncludeAll();
        }
        return EftKt.toEft(eveData2, storedFit, eftExportOptions);
    }

    @NotNull
    public static final String emptySlot(@NotNull ModuleSlotType $this$emptySlot) {
        Intrinsics.checkNotNullParameter((Object)$this$emptySlot, (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$emptySlot.ordinal()]) {
            case 1 -> "[Empty High slot]";
            case 2 -> "[Empty Med slot]";
            case 3 -> "[Empty Low slot]";
            case 4 -> "[Empty Rig slot]";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final StoredFit fitFromEft(@NotNull EveData $context_receiver_0, @NotNull String text) {
        StoredFit storedFit;
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Ref.IntRef mutationCount = new Ref.IntRef();
        Reader $this$useLines$iv = new StringReader(text);
        boolean $i$f$useLines = false;
        Closeable closeable = $this$useLines$iv;
        int n = 8192;
        closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        Throwable throwable = null;
        try {
            Object object;
            BufferedReader it$iv = (BufferedReader)closeable;
            boolean bl = false;
            Sequence lines2 = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            boolean bl2 = false;
            Object object2 = new ArrayDeque((Collection)SequencesKt.toList((Sequence)lines2));
            try {
                StoredFit.StoredTacticalMode storedTacticalMode;
                ArrayDeque $this$fitFromEft_u24lambda_u2421_u24lambda_u2420 = object2;
                boolean bl3 = false;
                Pair<ShipType, String> pair = EftKt.fitFromEft$readShipTypeAndFitName((ArrayDeque<String>)$this$fitFromEft_u24lambda_u2421_u24lambda_u2420, $context_receiver_0);
                ShipType shipType = (ShipType)pair.component1();
                String fitName = (String)pair.component2();
                boolean usesSubsystems = shipType.getUsesSubsystems();
                Integer n2 = shipType.getFitting().getSlots().getLow();
                int n3 = ((Number)n2).intValue();
                ModuleSlotType moduleSlotType = ModuleSlotType.LOW;
                EveData eveData2 = $context_receiver_0;
                Ref.IntRef intRef = mutationCount;
                ArrayDeque arrayDeque = $this$fitFromEft_u24lambda_u2421_u24lambda_u2420;
                int n4 = 0;
                boolean bl4 = usesSubsystems;
                List<PossiblyMutated<StoredFit.StoredModule>> lowSlotRack = EftKt.fitFromEft$readModuleRack((ArrayDeque<String>)arrayDeque, intRef, eveData2, moduleSlotType, !bl4 ? n2 : null);
                Integer it = shipType.getFitting().getSlots().getMed();
                n4 = ((Number)it).intValue();
                moduleSlotType = ModuleSlotType.MEDIUM;
                eveData2 = $context_receiver_0;
                intRef = mutationCount;
                arrayDeque = $this$fitFromEft_u24lambda_u2421_u24lambda_u2420;
                int n5 = 0;
                bl4 = usesSubsystems;
                List<PossiblyMutated<StoredFit.StoredModule>> medSlotRack = EftKt.fitFromEft$readModuleRack((ArrayDeque<String>)arrayDeque, intRef, eveData2, moduleSlotType, !bl4 ? it : null);
                Integer it2 = shipType.getFitting().getSlots().getHigh();
                n5 = ((Number)it2).intValue();
                moduleSlotType = ModuleSlotType.HIGH;
                eveData2 = $context_receiver_0;
                intRef = mutationCount;
                arrayDeque = $this$fitFromEft_u24lambda_u2421_u24lambda_u2420;
                boolean bl5 = false;
                bl4 = usesSubsystems;
                List<PossiblyMutated<StoredFit.StoredModule>> highSlotRack = EftKt.fitFromEft$readModuleRack((ArrayDeque<String>)arrayDeque, intRef, eveData2, moduleSlotType, !bl4 ? it2 : null);
                List<PossiblyMutated<StoredFit.StoredModule>> rigs = EftKt.fitFromEft$readModuleRack((ArrayDeque<String>)$this$fitFromEft_u24lambda_u2421_u24lambda_u2420, mutationCount, $context_receiver_0, ModuleSlotType.RIG, shipType.getFitting().getSlots().getRig());
                ValueByEnum<SubsystemType.Kind, StoredFit.StoredSubsystem> subsystems = shipType.getUsesSubsystems() ? EftKt.fitFromEft$readSubsystems((ArrayDeque<String>)$this$fitFromEft_u24lambda_u2421_u24lambda_u2420, $context_receiver_0, shipType) : null;
                List<PossiblyMutated<StoredFit.StoredDroneGroup>> drones = EftKt.fitFromEft$readDrones((ArrayDeque<String>)$this$fitFromEft_u24lambda_u2421_u24lambda_u2420, mutationCount, $context_receiver_0);
                List<StoredFit.StoredImplant> implants = EftKt.fitFromEft$readImplants((ArrayDeque<String>)$this$fitFromEft_u24lambda_u2421_u24lambda_u2420, $context_receiver_0);
                List<StoredFit.StoredBooster> boosters = EftKt.fitFromEft$readBoosters((ArrayDeque<String>)$this$fitFromEft_u24lambda_u2421_u24lambda_u2420, $context_receiver_0);
                List<StoredFit.StoredCargoItem> cargoItems = EftKt.fitFromEft$readCargoItems((ArrayDeque<String>)$this$fitFromEft_u24lambda_u2421_u24lambda_u2420, $context_receiver_0);
                List<EftMutationDescriptor> mutations = EftKt.fitFromEft$readMutations((ArrayDeque<String>)$this$fitFromEft_u24lambda_u2421_u24lambda_u2420);
                StoredFit.Companion companion = StoredFit.Companion;
                TacticalModeType tacticalModeType = TacticalModesKt.initialTacticalMode(shipType);
                if (tacticalModeType != null) {
                    TacticalModeType p0 = tacticalModeType;
                    boolean bl6 = false;
                    boolean $i$f$fitFromEft$lambda$21$lambda$20$stub_for_inlining = false;
                    storedTacticalMode = new StoredFit.StoredTacticalMode(p0);
                } else {
                    storedTacticalMode = null;
                }
                StoredFit.StoredTacticalMode storedTacticalMode2 = storedTacticalMode;
                List<StoredFit.StoredModule> list = EftKt.fitFromEft$toStoredModules(highSlotRack, $context_receiver_0, mutations);
                List<StoredFit.StoredModule> list2 = EftKt.fitFromEft$toStoredModules(medSlotRack, $context_receiver_0, mutations);
                List<StoredFit.StoredModule> list3 = EftKt.fitFromEft$toStoredModules(lowSlotRack, $context_receiver_0, mutations);
                List<StoredFit.StoredModule> list4 = EftKt.fitFromEft$toStoredModules(rigs, $context_receiver_0, null);
                List<StoredFit.StoredDroneGroup> list5 = EftKt.fitFromEft$toStoredDrones(drones, $context_receiver_0, mutations);
                object = Result.constructor-impl((Object)companion.new(fitName, null, shipType, storedTacticalMode2, subsystems, list, list2, list3, list4, list5, cargoItems, implants, boosters));
            }
            catch (Throwable throwable2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            object2 = object;
            storedFit = (StoredFit)(Result.isFailure-impl((Object)object2) ? null : object2);
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return storedFit;
    }

    /*
     * WARNING - void declaration
     */
    private static final EftMutationDescriptor EftMutationDescriptor(EveData $context_receiver_0, EveItemType baseType, StoredFit.StoredMutation mutation) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Mutaplasmid mutaplasmid = $context_receiver_0.mutaplasmid(mutation.getMutaplasmidId());
        Iterable iterable = mutation.getAttributeIdsAndValues();
        String string = mutaplasmid.getName();
        String string2 = baseType.getName();
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            int attrId = ((Number)pair.component1()).intValue();
            double value = ((Number)pair.component2()).doubleValue();
            Attribute attribute = $context_receiver_0.getAttributes().get(attrId);
            collection.add(new Pair((Object)attribute.getName(), (Object)value));
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        String string3 = string;
        String string4 = string2;
        return new EftMutationDescriptor(string4, string3, list);
    }

    private static final EftMutationDescriptor EftMutationDescriptor(EveData $context_receiver_0, StoredFit.StoredModule storedModule) {
        StoredFit.StoredMutation storedMutation = storedModule.getMutation();
        if (storedMutation == null) {
            throw new IllegalArgumentException(storedModule + " is not mutated");
        }
        StoredFit.StoredMutation mutation = storedMutation;
        return EftKt.EftMutationDescriptor($context_receiver_0, (EveItemType)$context_receiver_0.moduleType(storedModule.getItemId()), mutation);
    }

    private static final EftMutationDescriptor EftMutationDescriptor(EveData $context_receiver_0, StoredFit.StoredDroneGroup storedDroneGroup) {
        StoredFit.StoredMutation storedMutation = storedDroneGroup.getMutation();
        if (storedMutation == null) {
            throw new IllegalArgumentException(storedDroneGroup + " is not mutated");
        }
        StoredFit.StoredMutation mutation = storedMutation;
        return EftKt.EftMutationDescriptor($context_receiver_0, (EveItemType)$context_receiver_0.droneType(storedDroneGroup.getItemId()), mutation);
    }

    @Nullable
    public static final EftMutationDescriptor toEftMutationDescriptor(@NotNull String $this$toEftMutationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$toEftMutationDescriptor, (String)"<this>");
        String[] stringArray = new String[]{"\n", "\r"};
        return EftKt.toEftMutationDescriptor(StringsKt.split$default((CharSequence)$this$toEftMutationDescriptor, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    /*
     * WARNING - void declaration
     */
    private static final EftMutationDescriptor toEftMutationDescriptor(List<String> $this$toEftMutationDescriptor) {
        void $this$mapTo$iv$iv;
        if ($this$toEftMutationDescriptor.size() != 3) {
            return null;
        }
        String baseTypeName = $this$toEftMutationDescriptor.get(0);
        String mutaplasmidName = ((Object)StringsKt.trimStart((CharSequence)$this$toEftMutationDescriptor.get(1))).toString();
        String[] stringArray = new String[]{","};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)((Object)StringsKt.trimStart((CharSequence)$this$toEftMutationDescriptor.get(2))).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void attrNameAndValue;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{" "};
            List parts = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)((CharSequence)attrNameAndValue))).toString(), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            if (parts.size() != 2) {
                return null;
            }
            String attrName = (String)parts.get(0);
            Double d = StringsKt.toDoubleOrNull((String)((String)parts.get(1)));
            if (d == null) {
                return null;
            }
            double value = d;
            collection.add(new Pair((Object)attrName, (Object)value));
        }
        List attributeNamesAndValues = (List)destination$iv$iv;
        return new EftMutationDescriptor(baseTypeName, mutaplasmidName, attributeNamesAndValues);
    }

    private static final void toEft$appendModuleRack(StringBuilder $this$toEft_u24appendModuleRack, EveData $$context_receiver_0, EftExportOptions $options, List<EftMutationDescriptor> mutations, ModuleSlotType rack, List<StoredFit.StoredModule> slots) {
        for (StoredFit.StoredModule module : slots) {
            StringBuilder stringBuilder;
            if (module == null) {
                StringBuilder stringBuilder2 = $this$toEft_u24appendModuleRack.append(EftKt.emptySlot(rack));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
                StringBuilder stringBuilder3 = stringBuilder2.append('\n');
                stringBuilder = stringBuilder3;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                continue;
            }
            ModuleType baseType = $$context_receiver_0.moduleType(module.getItemId());
            $this$toEft_u24appendModuleRack.append(baseType.getName());
            if ($options.getLoadedCharges()) {
                ChargeType charge;
                Integer n = module.getChargeId();
                if (n != null) {
                    int it = ((Number)n).intValue();
                    boolean bl = false;
                    v4 = $$context_receiver_0.chargeType(it);
                } else {
                    v4 = charge = null;
                }
                if (charge != null) {
                    $this$toEft_u24appendModuleRack.append(", ");
                    $this$toEft_u24appendModuleRack.append(charge.getName());
                }
            }
            if ($options.getMutatedAttributes() && module.getMutation() != null) {
                mutations.add(EftKt.EftMutationDescriptor($$context_receiver_0, module));
                $this$toEft_u24appendModuleRack.append(" [" + mutations.size() + "]");
            }
            StringBuilder stringBuilder4 = $this$toEft_u24appendModuleRack.append('\n');
            stringBuilder = stringBuilder4;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        }
        Intrinsics.checkNotNullExpressionValue((Object)$this$toEft_u24appendModuleRack.append('\n'), (String)"append(...)");
    }

    private static final void toEft$appendSubsystems(StringBuilder $this$toEft_u24appendSubsystems, EveData $$context_receiver_0, ValueByEnum<SubsystemType.Kind, StoredFit.StoredSubsystem> subsystems) {
        if (subsystems == null) {
            return;
        }
        ValueByEnum<SubsystemType.Kind, StoredFit.StoredSubsystem> $this$forEach$iv = subsystems;
        boolean $i$f$forEach = false;
        for (SubsystemType.Kind key$iv : SubsystemType.Kind.values()) {
            StoredFit.StoredSubsystem storedSubsystem = (StoredFit.StoredSubsystem)$this$forEach$iv.get((Enum)key$iv);
            boolean bl = false;
            SubsystemType subsystemType = $$context_receiver_0.subsystemType(storedSubsystem.getItemId());
            StringBuilder stringBuilder = $this$toEft_u24appendSubsystems.append(subsystemType.getName());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        }
        Intrinsics.checkNotNullExpressionValue((Object)$this$toEft_u24appendSubsystems.append('\n'), (String)"append(...)");
    }

    private static final void toEft$appendDrones(StringBuilder $this$toEft_u24appendDrones, EveData $$context_receiver_0, EftExportOptions $options, List<EftMutationDescriptor> mutations, Collection<StoredFit.StoredDroneGroup> drones) {
        for (StoredFit.StoredDroneGroup droneGroup : drones) {
            DroneType baseType = $$context_receiver_0.droneType(droneGroup.getItemId());
            $this$toEft_u24appendDrones.append(baseType.getName() + " x" + droneGroup.getSize());
            if ($options.getMutatedAttributes() && droneGroup.getMutation() != null) {
                mutations.add(EftKt.EftMutationDescriptor($$context_receiver_0, droneGroup));
                $this$toEft_u24appendDrones.append(" [" + mutations.size() + "]");
            }
            Intrinsics.checkNotNullExpressionValue((Object)$this$toEft_u24appendDrones.append('\n'), (String)"append(...)");
        }
        if (!drones.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)$this$toEft_u24appendDrones.append('\n'), (String)"append(...)");
        }
    }

    private static final void toEft$appendImplants(StringBuilder $this$toEft_u24appendImplants, EveData $$context_receiver_0, Collection<StoredFit.StoredImplant> implants) {
        for (StoredFit.StoredImplant implant : implants) {
            ImplantType implantType = $$context_receiver_0.getImplantTypes().get(implant.getItemId());
            StringBuilder stringBuilder = $this$toEft_u24appendImplants.append(implantType.getName());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        }
        if (!implants.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)$this$toEft_u24appendImplants.append('\n'), (String)"append(...)");
        }
    }

    private static final void toEft$appendBoosters(StringBuilder $this$toEft_u24appendBoosters, EveData $$context_receiver_0, Collection<StoredFit.StoredBooster> boosters) {
        for (StoredFit.StoredBooster booster : boosters) {
            BoosterType boosterType = $$context_receiver_0.boosterType(booster.getItemId());
            StringBuilder stringBuilder = $this$toEft_u24appendBoosters.append(boosterType.getName());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        }
        if (!boosters.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)$this$toEft_u24appendBoosters.append('\n'), (String)"append(...)");
        }
    }

    private static final void toEft$appendCargo(StringBuilder $this$toEft_u24appendCargo, EveData $$context_receiver_0, Collection<StoredFit.StoredCargoItem> cargoItems) {
        for (StoredFit.StoredCargoItem cargoItem : cargoItems) {
            EveItemType itemType = $$context_receiver_0.cargoItemType(cargoItem.getItemId());
            StringBuilder stringBuilder = $this$toEft_u24appendCargo.append(itemType.getName() + " x" + cargoItem.getAmount());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        }
        if (!cargoItems.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)$this$toEft_u24appendCargo.append('\n'), (String)"append(...)");
        }
    }

    private static final void toEft$appendMutatedItemDescriptions(StringBuilder $this$toEft_u24appendMutatedItemDescriptions, List<EftMutationDescriptor> mutations) {
        if (mutations.isEmpty()) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)$this$toEft_u24appendMutatedItemDescriptions.append('\n'), (String)"append(...)");
        Iterator iterator = ((Iterable)mutations).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            EftMutationDescriptor mutationDesc = (EftMutationDescriptor)iterator.next();
            $this$toEft_u24appendMutatedItemDescriptions.append("[" + (index + 1) + "] ");
            $this$toEft_u24appendMutatedItemDescriptions.append(mutationDesc.toString());
            Intrinsics.checkNotNullExpressionValue((Object)$this$toEft_u24appendMutatedItemDescriptions.append('\n'), (String)"append(...)");
        }
    }

    private static final Pair<ShipType, String> fitFromEft$readShipTypeAndFitName(ArrayDeque<String> $this$fitFromEft_u24readShipTypeAndFitName, EveData $$context_receiver_0) {
        while (!((Collection)$this$fitFromEft_u24readShipTypeAndFitName).isEmpty()) {
            String line = (String)$this$fitFromEft_u24readShipTypeAndFitName.removeFirst();
            if (StringsKt.isBlank((CharSequence)line)) continue;
            String string = line.substring(1, line.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String[] stringArray = new String[]{", "};
            List list = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String shipTypeName = (String)list.get(0);
            String fitName = (String)list.get(1);
            ShipType shipType = $$context_receiver_0.shipTypeOrNull(shipTypeName);
            if (shipType == null) {
                throw new IllegalArgumentException("Unknown ship type: " + shipTypeName);
            }
            ShipType shipType2 = shipType;
            return new Pair((Object)shipType2, (Object)fitName);
        }
        throw new IllegalArgumentException("Missing ship type and fit name");
    }

    /*
     * WARNING - void declaration
     */
    private static final void fitFromEft$readModuleRack$appendModule(ArrayList<PossiblyMutated<StoredFit.StoredModule>> modules, Ref.IntRef mutationCount, StoredFit.StoredModule module, Integer mutationIndex) {
        PossiblyMutated<void> possiblyMutated;
        ArrayList<PossiblyMutated<StoredFit.StoredModule>> arrayList = modules;
        StoredFit.StoredModule storedModule = module;
        if (storedModule != null) {
            void it;
            StoredFit.StoredModule storedModule2 = storedModule;
            ArrayList<PossiblyMutated<StoredFit.StoredModule>> arrayList2 = arrayList;
            boolean bl = false;
            possiblyMutated = new PossiblyMutated<void>(it, mutationIndex);
            arrayList = arrayList2;
        } else {
            possiblyMutated = null;
        }
        arrayList.add(possiblyMutated);
        if (mutationIndex != null) {
            ++mutationCount.element;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<PossiblyMutated<StoredFit.StoredModule>> fitFromEft$readModuleRack(ArrayDeque<String> $this$fitFromEft_u24readModuleRack, Ref.IntRef mutationCount, EveData $$context_receiver_0, ModuleSlotType slotType, Integer expectedSize) {
        Integer n = expectedSize;
        ArrayList<PossiblyMutated<StoredFit.StoredModule>> modules = new ArrayList<PossiblyMutated<StoredFit.StoredModule>>(n != null ? n.intValue() : slotType.getMaxSlotCount());
        while (!((Collection)$this$fitFromEft_u24readModuleRack).isEmpty()) {
            String string;
            void $this$mapTo$iv$iv;
            String offlineMarker;
            boolean isOffline;
            String originalLine = (String)$this$fitFromEft_u24readModuleRack.removeFirst();
            String line = originalLine;
            if (StringsKt.isBlank((CharSequence)line)) continue;
            if (StringsKt.startsWith$default((String)line, (String)"[Empty", (boolean)false, (int)2, null)) {
                if (Intrinsics.areEqual((Object)line, (Object)EftKt.emptySlot(slotType))) {
                    modules.add(null);
                    continue;
                }
                $this$fitFromEft_u24readModuleRack.addFirst((Object)originalLine);
                break;
            }
            Integer mutationIndex = null;
            String mutationIndexString = " [" + (mutationCount.element + 1) + "]";
            if (StringsKt.endsWith$default((String)line, (String)mutationIndexString, (boolean)false, (int)2, null)) {
                mutationIndex = mutationCount.element;
                String string2 = line.substring(0, line.length() - mutationIndexString.length());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                line = string2;
            }
            if (isOffline = StringsKt.endsWith$default((String)line, (String)(offlineMarker = " /OFFLINE"), (boolean)false, (int)2, null)) {
                String string3 = line.substring(0, line.length() - offlineMarker.length());
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                line = string3;
            }
            String[] stringArray = new String[]{","};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)(line + ","), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            }
            List list = (List)destination$iv$iv;
            String moduleName = (String)list.get(0);
            String chargeName = (String)list.get(1);
            ModuleType moduleType2 = $$context_receiver_0.moduleTypeOrNull(moduleName);
            if (moduleType2 == null) {
                Integer n2 = expectedSize;
                if (modules.size() < (n2 != null ? n2.intValue() : slotType.getMaxSlotCount())) {
                    EftKt.fitFromEft$readModuleRack$appendModule(modules, mutationCount, null, mutationIndex);
                    continue;
                }
                $this$fitFromEft_u24readModuleRack.addFirst((Object)originalLine);
                break;
            }
            if (moduleType2.getSlotType() != slotType) {
                $this$fitFromEft_u24readModuleRack.addFirst((Object)originalLine);
                break;
            }
            ChargeType chargeType = ((CharSequence)chargeName).length() > 0 ? $$context_receiver_0.chargeTypeOrNull(chargeName) : null;
            int n3 = moduleType2.getItemId();
            boolean bl = moduleType2.isRig() ? !isOffline : true;
            string = FormatUtilsKt.importedState(moduleType2, isOffline);
            ChargeType chargeType2 = chargeType;
            Integer n4 = chargeType2 != null ? Integer.valueOf(chargeType2.getItemId()) : null;
            List<ExtraAttribute<Module>> list2 = FormatUtilsKt.importedExtraAttributes(moduleType2);
            StoredFit.StoredModule module = new StoredFit.StoredModule(n3, bl, (Module.State)string, n4, null, list2);
            EftKt.fitFromEft$readModuleRack$appendModule(modules, mutationCount, module, mutationIndex);
        }
        return modules;
    }

    private static final ValueByEnum fitFromEft$readSubsystems$lambda$5(ShipType $shipType) {
        ValueByEnum<SubsystemType.Kind, SubsystemType> valueByEnum = InitialSubsystemsKt.initialSubsystems($shipType);
        Intrinsics.checkNotNull(valueByEnum);
        return valueByEnum;
    }

    private static final ValueByEnum<SubsystemType.Kind, SubsystemType> fitFromEft$readSubsystems$lambda$6(Lazy<ValueByEnum<SubsystemType.Kind, SubsystemType>> $defaultSubsystemTypeByKind$delegate) {
        Lazy<ValueByEnum<SubsystemType.Kind, SubsystemType>> lazy = $defaultSubsystemTypeByKind$delegate;
        return (ValueByEnum)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private static final ValueByEnum<SubsystemType.Kind, StoredFit.StoredSubsystem> fitFromEft$readSubsystems(ArrayDeque<String> $this$fitFromEft_u24readSubsystems, EveData $$context_receiver_0, ShipType shipType) {
        Map subsystemTypeByKind = new LinkedHashMap();
        while (!((Collection)$this$fitFromEft_u24readSubsystems).isEmpty()) {
            String line = (String)$this$fitFromEft_u24readSubsystems.removeFirst();
            if (StringsKt.isBlank((CharSequence)line) && Intrinsics.areEqual((Object)line, (Object)"[Empty Subsystem slot]")) continue;
            SubsystemType subsystemType = $$context_receiver_0.subsystemTypeOrNull(line);
            if (subsystemType == null) {
                $this$fitFromEft_u24readSubsystems.addFirst((Object)line);
                break;
            }
            subsystemTypeByKind.put(subsystemType.getKind(), subsystemType);
            if (subsystemTypeByKind.size() != SubsystemType.Kind.getEntries().size()) continue;
        }
        Lazy defaultSubsystemTypeByKind$delegate = LazyKt.lazy(() -> EftKt.fitFromEft$readSubsystems$lambda$5(shipType));
        boolean $i$f$valueByEnum = false;
        SubsystemType.Kind[] enumValues$iv = SubsystemType.Kind.values();
        int n = enumValues$iv.length;
        Object[] objectArray = new StoredFit.StoredSubsystem[n];
        for (int i = 0; i < n; ++i) {
            void it;
            int n2 = i;
            SubsystemType.Kind kind = enumValues$iv[n2];
            int n3 = n2;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            SubsystemType subsystemType = (SubsystemType)subsystemTypeByKind.get(it);
            if (subsystemType == null) {
                subsystemType = (SubsystemType)EftKt.fitFromEft$readSubsystems$lambda$6((Lazy<ValueByEnum<SubsystemType.Kind, SubsystemType>>)defaultSubsystemTypeByKind$delegate).get((Enum)it);
            }
            SubsystemType subsystemType2 = subsystemType;
            StoredFit.StoredSubsystem storedSubsystem = new StoredFit.StoredSubsystem(subsystemType2.getItemId());
            objectArray2[n3] = storedSubsystem;
        }
        Object[] valueByOrdinal$iv = objectArray;
        return new ValueByEnum(valueByOrdinal$iv);
    }

    private static final void fitFromEft$readDrones$appendDrone(List<PossiblyMutated<StoredFit.StoredDroneGroup>> drones, Ref.IntRef mutationCount, StoredFit.StoredDroneGroup drone, Integer mutationIndex) {
        drones.add(new PossiblyMutated<StoredFit.StoredDroneGroup>(drone, mutationIndex));
        if (mutationIndex != null) {
            ++mutationCount.element;
        }
    }

    private static final List<PossiblyMutated<StoredFit.StoredDroneGroup>> fitFromEft$readDrones(ArrayDeque<String> $this$fitFromEft_u24readDrones, Ref.IntRef mutationCount, EveData $$context_receiver_0) {
        List drones = new ArrayList();
        int skippedEmptyLines = 0;
        while (!((Collection)$this$fitFromEft_u24readDrones).isEmpty()) {
            String droneName;
            String line = (String)$this$fitFromEft_u24readDrones.removeFirst();
            if (StringsKt.isBlank((CharSequence)line)) {
                if (++skippedEmptyLines != 2) continue;
                break;
            }
            skippedEmptyLines = 0;
            Integer mutationIndex = null;
            String mutationIndexString = " [" + (mutationCount.element + 1) + "]";
            String droneTypeAndAmountString = null;
            if (StringsKt.endsWith$default((String)line, (String)mutationIndexString, (boolean)false, (int)2, null)) {
                mutationIndex = mutationCount.element;
                String string = line.substring(0, line.length() - mutationIndexString.length());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                droneTypeAndAmountString = string;
            } else {
                droneTypeAndAmountString = line;
            }
            int indexOfX = StringsKt.lastIndexOf$default((CharSequence)droneTypeAndAmountString, (char)'x', (int)0, (boolean)false, (int)6, null);
            if (indexOfX == -1) {
                $this$fitFromEft_u24readDrones.addFirst((Object)line);
                break;
            }
            Intrinsics.checkNotNullExpressionValue((Object)droneTypeAndAmountString.substring(0, indexOfX - 1), (String)"substring(...)");
            String string = droneTypeAndAmountString.substring(indexOfX + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            Integer amount = StringsKt.toIntOrNull((String)string);
            DroneType droneType2 = $$context_receiver_0.droneTypeOrNull(droneName);
            if (amount == null || droneType2 == null) {
                $this$fitFromEft_u24readDrones.addFirst((Object)line);
                break;
            }
            StoredFit.StoredDroneGroup droneGroup = new StoredFit.StoredDroneGroup(droneType2.getItemId(), amount, drones.isEmpty(), null);
            EftKt.fitFromEft$readDrones$appendDrone(drones, mutationCount, droneGroup, mutationIndex);
        }
        return drones;
    }

    private static final List<StoredFit.StoredImplant> fitFromEft$readImplants(ArrayDeque<String> $this$fitFromEft_u24readImplants, EveData $$context_receiver_0) {
        List implants = new ArrayList();
        while (!((Collection)$this$fitFromEft_u24readImplants).isEmpty()) {
            String line = (String)$this$fitFromEft_u24readImplants.removeFirst();
            if (StringsKt.isBlank((CharSequence)line)) continue;
            ImplantType implantType = $$context_receiver_0.getImplantTypes().getOrNull(line);
            if (implantType == null) {
                $this$fitFromEft_u24readImplants.addFirst((Object)line);
                break;
            }
            implants.add(new StoredFit.StoredImplant(implantType.getItemId(), true));
        }
        return implants;
    }

    private static final List<StoredFit.StoredBooster> fitFromEft$readBoosters(ArrayDeque<String> $this$fitFromEft_u24readBoosters, EveData $$context_receiver_0) {
        List boosters = new ArrayList();
        while (!((Collection)$this$fitFromEft_u24readBoosters).isEmpty()) {
            String line = (String)$this$fitFromEft_u24readBoosters.removeFirst();
            if (StringsKt.isBlank((CharSequence)line)) continue;
            BoosterType boosterType = $$context_receiver_0.boosterTypeOrNull(line);
            if (boosterType == null) {
                $this$fitFromEft_u24readBoosters.addFirst((Object)line);
                break;
            }
            boosters.add(new StoredFit.StoredBooster(boosterType.getItemId(), true, CollectionsKt.emptyList()));
        }
        return boosters;
    }

    private static final List fitFromEft$readCargoItems$lambda$8() {
        return new ArrayList();
    }

    private static final List<StoredFit.StoredCargoItem> fitFromEft$readCargoItems$lambda$9(Lazy<? extends List<StoredFit.StoredCargoItem>> $cargoItems$delegate) {
        Lazy<? extends List<StoredFit.StoredCargoItem>> lazy = $cargoItems$delegate;
        return (List)lazy.getValue();
    }

    private static final List<StoredFit.StoredCargoItem> fitFromEft$readCargoItems(ArrayDeque<String> $this$fitFromEft_u24readCargoItems, EveData $$context_receiver_0) {
        Lazy cargoItems$delegate = LazyKt.lazy(EftKt::fitFromEft$readCargoItems$lambda$8);
        while (!((Collection)$this$fitFromEft_u24readCargoItems).isEmpty()) {
            String itemName;
            String line = (String)$this$fitFromEft_u24readCargoItems.removeFirst();
            if (StringsKt.isBlank((CharSequence)line)) continue;
            int indexOfX = StringsKt.lastIndexOf$default((CharSequence)line, (char)'x', (int)0, (boolean)false, (int)6, null);
            if (indexOfX == -1) {
                $this$fitFromEft_u24readCargoItems.addFirst((Object)line);
                break;
            }
            Intrinsics.checkNotNullExpressionValue((Object)line.substring(0, indexOfX - 1), (String)"substring(...)");
            String string = line.substring(indexOfX + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            Integer amount = StringsKt.toIntOrNull((String)string);
            EveItemType cargoItemType = $$context_receiver_0.cargoItemTypeOrNull(itemName);
            if (amount == null || cargoItemType == null) {
                $this$fitFromEft_u24readCargoItems.addFirst((Object)line);
                break;
            }
            EftKt.fitFromEft$readCargoItems$lambda$9((Lazy<? extends List<StoredFit.StoredCargoItem>>)cargoItems$delegate).add(new StoredFit.StoredCargoItem(cargoItemType.getItemId(), amount));
        }
        return EftKt.fitFromEft$readCargoItems$lambda$9((Lazy<? extends List<StoredFit.StoredCargoItem>>)cargoItems$delegate);
    }

    private static final List<EftMutationDescriptor> fitFromEft$readMutations(ArrayDeque<String> $this$fitFromEft_u24readMutations) {
        Collection collection;
        Collection collection2;
        List mutations = new ArrayList();
        while (!((Collection)$this$fitFromEft_u24readMutations).isEmpty()) {
            EftMutationDescriptor mutationDesc;
            List list;
            List $this$fitFromEft_u24readMutations_u24lambda_u2410 = list = CollectionsKt.createListBuilder((int)3);
            boolean bl = false;
            ArrayDeque<String> input = $this$fitFromEft_u24readMutations;
            while (!((Collection)input).isEmpty() && $this$fitFromEft_u24readMutations_u24lambda_u2410.size() < 3) {
                String line = (String)input.removeFirst();
                if (StringsKt.isBlank((CharSequence)line)) continue;
                $this$fitFromEft_u24readMutations_u24lambda_u2410.add(line);
            }
            List mutationDescLines = CollectionsKt.build((List)list);
            if (mutationDescLines.size() != 3) break;
            String indexText = "[" + (mutations.size() + 1) + "] ";
            if (!StringsKt.startsWith$default((String)((String)mutationDescLines.get(0)), (String)indexText, (boolean)false, (int)2, null) || (mutationDesc = EftKt.toEftMutationDescriptor(mutationDescLines)) == null) break;
            mutations.add(mutationDesc);
        }
        if ((collection2 = (Collection)mutations).isEmpty()) {
            boolean bl = false;
            collection = null;
        } else {
            collection = collection2;
        }
        return (List)collection;
    }

    /*
     * WARNING - void declaration
     */
    private static final StoredFit.StoredModule fitFromEft$mutatedWith(StoredFit.StoredModule $this$fitFromEft_u24mutatedWith, EveData $$context_receiver_0, EftMutationDescriptor mutationDesc) {
        List list;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        ModuleType baseModuleType = $$context_receiver_0.moduleType($this$fitFromEft_u24mutatedWith.getItemId());
        Mutaplasmid mutaplasmid = $$context_receiver_0.mutaplasmidOrNull(mutationDesc.getMutaplasmidName());
        if (mutaplasmid == null) {
            return $this$fitFromEft_u24mutatedWith;
        }
        Mutaplasmid mutaplasmid2 = mutaplasmid;
        int n = $this$fitFromEft_u24mutatedWith.getItemId();
        boolean bl = $this$fitFromEft_u24mutatedWith.getEnabled();
        Module.State state = $this$fitFromEft_u24mutatedWith.getState();
        Integer n2 = $this$fitFromEft_u24mutatedWith.getChargeId();
        List<ExtraAttribute<Module>> list2 = $this$fitFromEft_u24mutatedWith.getExtraAttributes();
        Iterable iterable = mutationDesc.getAttributeNamesAndValues();
        String string = MutaplasmidsKt.defaultMutatedName(baseModuleType, mutaplasmid2);
        int n3 = mutaplasmid2.getId();
        boolean $i$f$mapNotNull = false;
        void var13_14 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            Attribute attribute;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            Pair pair = (Pair)element$iv$iv;
            boolean bl3 = false;
            String attrName = (String)pair.component1();
            double value = ((Number)pair.component2()).doubleValue();
            if (($$context_receiver_0.getAttributes().get(attrName) == null ? null : new Pair((Object)attribute.getId(), (Object)value)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list3 = list = (List)destination$iv$iv;
        String string2 = string;
        int n4 = n3;
        StoredFit.StoredMutation storedMutation = new StoredFit.StoredMutation(n4, string2, list3);
        return new StoredFit.StoredModule(n, bl, state, n2, storedMutation, list2);
    }

    /*
     * WARNING - void declaration
     */
    private static final StoredFit.StoredDroneGroup fitFromEft$mutatedWith$14(StoredFit.StoredDroneGroup $this$fitFromEft_u24mutatedWith_u2414, EveData $$context_receiver_0, EftMutationDescriptor mutationDesc) {
        List list;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        DroneType baseDroneType = $$context_receiver_0.droneType($this$fitFromEft_u24mutatedWith_u2414.getItemId());
        Mutaplasmid mutaplasmid = $$context_receiver_0.mutaplasmidOrNull(mutationDesc.getMutaplasmidName());
        if (mutaplasmid == null) {
            return $this$fitFromEft_u24mutatedWith_u2414;
        }
        Mutaplasmid mutaplasmid2 = mutaplasmid;
        Iterable iterable = mutationDesc.getAttributeNamesAndValues();
        String string = MutaplasmidsKt.defaultMutatedName(baseDroneType, mutaplasmid2);
        int n = mutaplasmid2.getId();
        boolean bl = $this$fitFromEft_u24mutatedWith_u2414.getActive();
        int n2 = $this$fitFromEft_u24mutatedWith_u2414.getSize();
        int n3 = $this$fitFromEft_u24mutatedWith_u2414.getItemId();
        boolean $i$f$mapNotNull = false;
        void var7_12 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            Attribute attribute;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            Pair pair = (Pair)element$iv$iv;
            boolean bl3 = false;
            String attrName = (String)pair.component1();
            double value = ((Number)pair.component2()).doubleValue();
            if (($$context_receiver_0.getAttributes().get(attrName) == null ? null : new Pair((Object)attribute.getId(), (Object)value)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = list = (List)destination$iv$iv;
        String string2 = string;
        int n4 = n;
        StoredFit.StoredMutation storedMutation = new StoredFit.StoredMutation(n4, string2, list2);
        boolean bl5 = bl;
        int n5 = n2;
        int n6 = n3;
        return new StoredFit.StoredDroneGroup(n6, n5, bl5, storedMutation);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<StoredFit.StoredModule> fitFromEft$toStoredModules(List<PossiblyMutated<StoredFit.StoredModule>> $this$fitFromEft_u24toStoredModules, EveData $$context_receiver_0, List<EftMutationDescriptor> mutations) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$fitFromEft_u24toStoredModules;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            StoredFit.StoredModule storedModule;
            void it;
            PossiblyMutated possiblyMutated = (PossiblyMutated)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (it == null) {
                storedModule = null;
            } else {
                EftMutationDescriptor mutationDesc;
                StoredFit.StoredModule module = (StoredFit.StoredModule)it.component1();
                Integer mutationIndex = it.component2();
                storedModule = mutationIndex == null || mutations == null ? module : ((EftMutationDescriptor)CollectionsKt.getOrNull(mutations, (int)mutationIndex) == null ? module : EftKt.fitFromEft$mutatedWith(module, $$context_receiver_0, mutationDesc));
            }
            collection.add(storedModule);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<StoredFit.StoredDroneGroup> fitFromEft$toStoredDrones(List<PossiblyMutated<StoredFit.StoredDroneGroup>> $this$fitFromEft_u24toStoredDrones, EveData $$context_receiver_0, List<EftMutationDescriptor> mutations) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$fitFromEft_u24toStoredDrones;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            EftMutationDescriptor mutationDesc;
            void it;
            PossiblyMutated possiblyMutated = (PossiblyMutated)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            StoredFit.StoredDroneGroup droneGroup = (StoredFit.StoredDroneGroup)it.component1();
            Integer mutationIndex = it.component2();
            collection.add(mutationIndex == null || mutations == null ? droneGroup : ((EftMutationDescriptor)CollectionsKt.getOrNull(mutations, (int)mutationIndex) == null ? droneGroup : EftKt.fitFromEft$mutatedWith$14(droneGroup, $$context_receiver_0, mutationDesc)));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ModuleSlotType.values().length];
            try {
                nArray[ModuleSlotType.HIGH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModuleSlotType.MEDIUM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModuleSlotType.LOW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModuleSlotType.RIG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

