/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.formats;

import eve.data.EveData;
import eve.data.ShipType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;
import theorycrafter.formats.FitItem;
import theorycrafter.formats.ParsedCompositionShip;
import theorycrafter.formats.UnloadedFit;
import theorycrafter.formats.XmlKt;
import theorycrafter.storage.StoredFit;
import theorycrafter.utils.CollectionUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u000201H\u0016J \u00102\u001a\u00020,2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u0007H\u0016J \u00107\u001a\u00020,2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR%\u0010\u000b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\"\u0010\u001a\u001a\n\u0018\u00010\u001bj\u0004\u0018\u0001`\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0011R\u0010\u0010$\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Ltheorycrafter/formats/XmlHandler;", "Lorg/xml/sax/helpers/DefaultHandler;", "eveData", "Leve/data/EveData;", "<init>", "(Leve/data/EveData;)V", "value", "", "readFitsCount", "getReadFitsCount", "()I", "fitsAndIds", "", "Lkotlin/Pair;", "Ltheorycrafter/storage/StoredFit;", "", "getFitsAndIds", "()Ljava/util/List;", "unparsed", "Ltheorycrafter/formats/UnloadedFit;", "getUnparsed", "compositionName", "getCompositionName", "()Ljava/lang/String;", "setCompositionName", "(Ljava/lang/String;)V", "compositionNote", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getCompositionNote", "()Ljava/lang/StringBuilder;", "setCompositionNote", "(Ljava/lang/StringBuilder;)V", "compositionShips", "Ltheorycrafter/formats/ParsedCompositionShip;", "getCompositionShips", "fitName", "fitShipTypeName", "fitId", "readingCompositionNote", "", "fitItemList", "Ltheorycrafter/formats/FitItem;", "startElement", "", "uri", "localName", "qName", "attributes", "Lorg/xml/sax/Attributes;", "characters", "ch", "", "start", "length", "endElement", "Theorycrafter"})
final class XmlHandler
extends DefaultHandler {
    @NotNull
    private final EveData eveData;
    private int readFitsCount;
    @NotNull
    private final List<Pair<StoredFit, String>> fitsAndIds;
    @NotNull
    private final List<UnloadedFit> unparsed;
    @Nullable
    private String compositionName;
    @Nullable
    private StringBuilder compositionNote;
    @NotNull
    private final List<ParsedCompositionShip> compositionShips;
    @Nullable
    private String fitName;
    @Nullable
    private String fitShipTypeName;
    @Nullable
    private String fitId;
    private boolean readingCompositionNote;
    @NotNull
    private final List<FitItem> fitItemList;

    public XmlHandler(@NotNull EveData eveData2) {
        Intrinsics.checkNotNullParameter((Object)eveData2, (String)"eveData");
        this.eveData = eveData2;
        this.fitsAndIds = new ArrayList();
        this.unparsed = new ArrayList();
        this.compositionShips = new ArrayList();
        this.fitItemList = new ArrayList();
    }

    public final int getReadFitsCount() {
        return this.readFitsCount;
    }

    @NotNull
    public final List<Pair<StoredFit, String>> getFitsAndIds() {
        return this.fitsAndIds;
    }

    @NotNull
    public final List<UnloadedFit> getUnparsed() {
        return this.unparsed;
    }

    @Nullable
    public final String getCompositionName() {
        return this.compositionName;
    }

    public final void setCompositionName(@Nullable String string) {
        this.compositionName = string;
    }

    @Nullable
    public final StringBuilder getCompositionNote() {
        return this.compositionNote;
    }

    public final void setCompositionNote(@Nullable StringBuilder stringBuilder) {
        this.compositionNote = stringBuilder;
    }

    @NotNull
    public final List<ParsedCompositionShip> getCompositionShips() {
        return this.compositionShips;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startElement(@NotNull String uri, @NotNull String localName, @NotNull String qName, @NotNull Attributes attributes) {
        FitItem.Kind kind;
        block23: {
            block22: {
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
                Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
                Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
                switch (qName) {
                    case "composition": {
                        this.compositionName = attributes.getValue("name");
                        return;
                    }
                    case "note": {
                        this.compositionNote = new StringBuilder();
                        this.readingCompositionNote = true;
                        return;
                    }
                    case "ship": {
                        String string = attributes.getValue("shipType");
                        if (string == null) {
                            return;
                        }
                        String shipTypeName = string;
                        ShipType shipType = this.eveData.shipTypeOrNull(shipTypeName);
                        if (shipType == null) {
                            return;
                        }
                        ShipType shipType2 = shipType;
                        String string2 = attributes.getValue("active");
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
                        Boolean bl = StringsKt.toBooleanStrictOrNull((String)string2);
                        boolean active2 = bl != null ? bl : true;
                        String fitId2 = attributes.getValue("fitId");
                        this.compositionShips.add(new ParsedCompositionShip(shipType2.getItemId(), active2, fitId2));
                        return;
                    }
                    case "fitting": {
                        this.fitName = attributes.getValue("name");
                        this.fitId = attributes.getValue("fitId");
                        return;
                    }
                    case "shipType": {
                        this.fitShipTypeName = attributes.getValue("value");
                        return;
                    }
                }
                String string = qName;
                switch (string.hashCode()) {
                    case 1925931975: {
                        if (string.equals("implant")) break;
                        return;
                    }
                    case 64934800: {
                        if (!string.equals("booster")) {
                            return;
                        }
                        break block22;
                    }
                    case 116909544: {
                        if (!string.equals("hardware")) return;
                        kind = FitItem.Kind.Hardware;
                        break block23;
                    }
                }
                kind = FitItem.Kind.Implant;
                break block23;
            }
            kind = FitItem.Kind.Booster;
            break block23;
            return;
        }
        FitItem.Kind kind2 = kind;
        CollectionUtilsKt.addNotNull((Collection)this.fitItemList, XmlKt.access$asFitItem(attributes, kind2));
    }

    @Override
    public void characters(@NotNull char[] ch, int start, int length) {
        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
        if (this.readingCompositionNote) {
            StringBuilder stringBuilder = this.compositionNote;
            Intrinsics.checkNotNull((Object)stringBuilder);
            StringBuilder stringBuilder2 = stringBuilder;
            int n = start + length;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append(ch, start, n - start), (String)"append(...)");
        }
    }

    @Override
    public void endElement(@NotNull String uri, @NotNull String localName, @NotNull String qName) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
        Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
        if (Intrinsics.areEqual((Object)qName, (Object)"fitting")) {
            ++this.readFitsCount;
            String string = this.fitName;
            if (string == null) {
                return;
            }
            String name2 = string;
            String string2 = this.fitShipTypeName;
            if (string2 == null) {
                return;
            }
            String shipTypeName = string2;
            EveData $this$endElement_u24lambda_u240 = this.eveData;
            boolean bl = false;
            StoredFit fit2 = XmlKt.access$parseFit($this$endElement_u24lambda_u240, name2, shipTypeName, this.fitItemList);
            boolean bl2 = fit2 == null ? this.unparsed.add(new UnloadedFit(name2, shipTypeName)) : this.fitsAndIds.add((Pair<StoredFit, String>)new Pair((Object)fit2, (Object)this.fitId));
            this.fitName = null;
            this.fitShipTypeName = null;
            this.fitId = null;
            this.fitItemList.clear();
        } else if (Intrinsics.areEqual((Object)qName, (Object)"note")) {
            this.readingCompositionNote = false;
        }
    }
}

