/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.storage;

import androidx.compose.runtime.Immutable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import theorycrafter.storage.StoredFit;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B-\u0012$\u0010\u0002\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\bJ\u0016\u0010\u000f\u001a\u00020\u000e*\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\bH\u0002R,\u0010\u0002\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ltheorycrafter/storage/DuplicateFitDetector;", "", "fitsByShipTypeIdAndName", "", "Lkotlin/Pair;", "", "", "", "Ltheorycrafter/storage/StoredFit;", "<init>", "(Ljava/util/Map;)V", "findDuplicateOf", "fit", "duplicateOfExists", "", "isDuplicateOf", "other", "Theorycrafter"})
@Immutable
@SourceDebugExtension(value={"SMAP\nDuplicateFitDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DuplicateFitDetector.kt\ntheorycrafter/storage/DuplicateFitDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1053#2:140\n1485#2:141\n1510#2,3:142\n1513#2,3:152\n1485#2:155\n1510#2,3:156\n1513#2,3:166\n381#3,7:145\n381#3,7:159\n1#4:169\n*S KotlinDebug\n*F\n+ 1 DuplicateFitDetector.kt\ntheorycrafter/storage/DuplicateFitDetector\n*L\n51#1:140\n67#1:141\n67#1:142,3\n67#1:152,3\n68#1:155\n68#1:156,3\n68#1:166,3\n67#1:145,7\n68#1:159,7\n*E\n"})
public final class DuplicateFitDetector {
    @NotNull
    private final Map<Pair<Integer, String>, List<StoredFit>> fitsByShipTypeIdAndName;
    public static final int $stable;

    public DuplicateFitDetector(@NotNull Map<Pair<Integer, String>, ? extends List<StoredFit>> fitsByShipTypeIdAndName) {
        Intrinsics.checkNotNullParameter(fitsByShipTypeIdAndName, (String)"fitsByShipTypeIdAndName");
        this.fitsByShipTypeIdAndName = fitsByShipTypeIdAndName;
    }

    @Nullable
    public final StoredFit findDuplicateOf(@NotNull StoredFit fit2) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)fit2, (String)"fit");
            List list = this.fitsByShipTypeIdAndName.get(new Pair((Object)fit2.getShipTypeId(), (Object)fit2.getName()));
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List duplicateCandidates = list;
            Iterable iterable = duplicateCandidates;
            for (Object t : iterable) {
                StoredFit candidate = (StoredFit)t;
                boolean bl = false;
                if (!this.isDuplicateOf(fit2, candidate)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    public final boolean duplicateOfExists(@NotNull StoredFit fit2) {
        Intrinsics.checkNotNullParameter((Object)fit2, (String)"fit");
        return this.findDuplicateOf(fit2) != null;
    }

    private final boolean isDuplicateOf(StoredFit $this$isDuplicateOf, StoredFit other) {
        if (other == null) {
            return false;
        }
        return DuplicateFitDetector.isDuplicateOf$racksEqual($this$isDuplicateOf.getHighSlotRack(), other.getHighSlotRack()) && DuplicateFitDetector.isDuplicateOf$racksEqual($this$isDuplicateOf.getMedSlotRack(), other.getMedSlotRack()) && DuplicateFitDetector.isDuplicateOf$racksEqual($this$isDuplicateOf.getLowSlotRack(), other.getLowSlotRack()) && DuplicateFitDetector.isDuplicateOf$racksEqual($this$isDuplicateOf.getRigs(), other.getRigs()) && DuplicateFitDetector.isDuplicateOf$cargoholdsEqual($this$isDuplicateOf.getCargoItems(), other.getCargoItems()) && DuplicateFitDetector.isDuplicateOf$implantsEqual($this$isDuplicateOf.getImplants(), other.getImplants()) && DuplicateFitDetector.isDuplicateOf$boostersEqual($this$isDuplicateOf.getBoosters(), other.getBoosters());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isDuplicateOf$mutationsEqual(StoredFit.StoredMutation mutation1, StoredFit.StoredMutation mutation2) {
        if (mutation1 == null && mutation2 == null) {
            return true;
        }
        if (mutation1 == null) return false;
        if (mutation2 == null) {
            return false;
        }
        if (mutation1.getMutaplasmidId() != mutation2.getMutaplasmidId()) return false;
        if (!Intrinsics.areEqual((Object)mutation1.getName(), (Object)mutation2.getName())) return false;
        Iterable $this$sortedBy$iv = mutation1.getAttributeIdsAndValues();
        boolean $i$f$sortedBy = false;
        List list = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getFirst();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getFirst()));
            }
        });
        $this$sortedBy$iv = mutation2.getAttributeIdsAndValues();
        $i$f$sortedBy = false;
        if (!Intrinsics.areEqual((Object)list, (Object)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getFirst();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getFirst()));
            }
        }))) return false;
        return true;
    }

    private static final boolean isDuplicateOf$racksEqual(List<StoredFit.StoredModule> rack1, List<StoredFit.StoredModule> rack2) {
        int index = 0;
        int n = Math.max(CollectionsKt.getLastIndex(rack1), CollectionsKt.getLastIndex(rack2));
        if (index <= n) {
            while (true) {
                StoredFit.StoredModule module1 = (StoredFit.StoredModule)CollectionsKt.getOrNull(rack1, (int)index);
                StoredFit.StoredModule module2 = (StoredFit.StoredModule)CollectionsKt.getOrNull(rack2, (int)index);
                StoredFit.StoredModule storedModule = module1;
                StoredFit.StoredModule storedModule2 = module2;
                if (!Intrinsics.areEqual((Object)(storedModule != null ? Integer.valueOf(storedModule.getItemId()) : null), (Object)(storedModule2 != null ? Integer.valueOf(storedModule2.getItemId()) : null))) {
                    return false;
                }
                StoredFit.StoredModule storedModule3 = module1;
                StoredFit.StoredModule storedModule4 = module2;
                if (!DuplicateFitDetector.isDuplicateOf$mutationsEqual(storedModule3 != null ? storedModule3.getMutation() : null, storedModule4 != null ? storedModule4.getMutation() : null)) {
                    return false;
                }
                if (index == n) break;
                ++index;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isDuplicateOf$cargoholdsEqual(List<StoredFit.StoredCargoItem> cargo1, List<StoredFit.StoredCargoItem> cargo2) {
        void $this$groupByTo$iv$iv;
        void $this$groupByTo$iv$iv2;
        Iterable $this$groupBy$iv = cargo1;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
            Object object;
            StoredFit.StoredCargoItem it = (StoredFit.StoredCargoItem)element$iv$iv;
            boolean bl = false;
            Integer key$iv$iv = it.getItemId();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map itemsById1 = destination$iv$iv;
        Iterable $this$groupBy$iv2 = cargo2;
        boolean $i$f$groupBy2 = false;
        destination$iv$iv = $this$groupBy$iv2;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo22 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            StoredFit.StoredCargoItem it = (StoredFit.StoredCargoItem)element$iv$iv;
            boolean bl = false;
            Integer key$iv$iv = it.getItemId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map itemsById2 = destination$iv$iv2;
        if (itemsById1.size() != itemsById2.size()) {
            return false;
        }
        Set allItemIds = SetsKt.plus(itemsById1.keySet(), (Iterable)itemsById2.keySet());
        Iterator iterator = allItemIds.iterator();
        while (iterator.hasNext()) {
            int n;
            int n2;
            Object object2;
            int itemId = ((Number)iterator.next()).intValue();
            List list = (List)itemsById1.get(itemId);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable $i$f$groupByTo22 = list;
            int n3 = 0;
            for (Object object2 : $i$f$groupByTo22) {
                void it;
                StoredFit.StoredCargoItem bl = (StoredFit.StoredCargoItem)object2;
                n2 = n3;
                boolean bl4 = false;
                n = it.getAmount();
                n3 = n2 + n;
            }
            int itemAmount1 = n3;
            List list2 = (List)itemsById2.get(itemId);
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            Iterable iterable2 = list2;
            int n4 = 0;
            object2 = iterable2.iterator();
            while (object2.hasNext()) {
                void it;
                Object e = object2.next();
                StoredFit.StoredCargoItem bl4 = (StoredFit.StoredCargoItem)e;
                n2 = n4;
                boolean bl = false;
                n = it.getAmount();
                n4 = n2 + n;
            }
            int itemAmount2 = n4;
            if (itemAmount1 == itemAmount2) continue;
            return false;
        }
        return true;
    }

    private static final boolean isDuplicateOf$implantsEqual(List<StoredFit.StoredImplant> implants1, List<StoredFit.StoredImplant> implants2) {
        if (implants1.size() != implants2.size()) {
            return false;
        }
        int index = 0;
        int n = CollectionsKt.getLastIndex(implants1);
        if (index <= n) {
            while (true) {
                StoredFit.StoredImplant implant1 = implants1.get(index);
                StoredFit.StoredImplant implant2 = implants2.get(index);
                if (implant1.getItemId() != implant2.getItemId()) {
                    return false;
                }
                if (index == n) break;
                ++index;
            }
        }
        return true;
    }

    private static final boolean isDuplicateOf$boostersEqual(List<StoredFit.StoredBooster> boosters1, List<StoredFit.StoredBooster> boosters2) {
        if (boosters1.size() != boosters2.size()) {
            return false;
        }
        int index = 0;
        int n = CollectionsKt.getLastIndex(boosters1);
        if (index <= n) {
            while (true) {
                StoredFit.StoredBooster booster1 = boosters1.get(index);
                StoredFit.StoredBooster booster2 = boosters2.get(index);
                if (booster1.getItemId() != booster2.getItemId()) {
                    return false;
                }
                if (index == n) break;
                ++index;
            }
        }
        return true;
    }
}

