/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.storage;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import theorycrafter.storage.CorruptFitRepository;
import theorycrafter.storage.FitRepoItem;
import theorycrafter.storage.FittingRepositoryKt;
import theorycrafter.storage.StoredFit;
import theorycrafter.storage.StoredItemFormatVersions;
import theorycrafter.storage.StoredSkillSet;
import theorycrafter.utils.StoredCollection;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003*\u0001\u0006\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\f\u0010\u0000\u001a\u00020\u0003*\u00020\u0004H\u0002\"\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"asRepoItem", "Ltheorycrafter/storage/FitRepoItem$Fit;", "Ltheorycrafter/storage/StoredFit;", "Ltheorycrafter/storage/FitRepoItem$SkillSet;", "Ltheorycrafter/storage/StoredSkillSet;", "Serializer", "theorycrafter/storage/FittingRepositoryKt$Serializer$1", "Ltheorycrafter/storage/FittingRepositoryKt$Serializer$1;", "Theorycrafter"})
public final class FittingRepositoryKt {
    @NotNull
    private static final Serializer.1 Serializer = new StoredCollection.Serializer<FitRepoItem>(){
        private final int FIT_TYPE_ID;
        private final int SKILL_SET_TYPE_ID;
        private final Map<Integer, StoredItemFormatVersions> itemFormatVersionsByRepoFormatVersion;
        private final int itemFormatVersion;
        {
            this.FIT_TYPE_ID = 1;
            this.SKILL_SET_TYPE_ID = 2;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)1, (Object)new StoredItemFormatVersions(1, null)), TuplesKt.to((Object)2, (Object)new StoredItemFormatVersions(2, null)), TuplesKt.to((Object)3, (Object)new StoredItemFormatVersions(3, null)), TuplesKt.to((Object)4, (Object)new StoredItemFormatVersions(4, null)), TuplesKt.to((Object)5, (Object)new StoredItemFormatVersions(5, 1)), TuplesKt.to((Object)6, (Object)new StoredItemFormatVersions(6, 1)), TuplesKt.to((Object)7, (Object)new StoredItemFormatVersions(7, 1)), TuplesKt.to((Object)8, (Object)new StoredItemFormatVersions(7, 2)), TuplesKt.to((Object)9, (Object)new StoredItemFormatVersions(8, 2)), TuplesKt.to((Object)10, (Object)new StoredItemFormatVersions(9, 2)), TuplesKt.to((Object)11, (Object)new StoredItemFormatVersions(10, 2)), TuplesKt.to((Object)12, (Object)new StoredItemFormatVersions(11, 2))};
            this.itemFormatVersionsByRepoFormatVersion = MapsKt.mapOf((Pair[])pairArray);
            this.itemFormatVersion = ((Number)((Object)CollectionsKt.maxOrThrow((Iterable)this.itemFormatVersionsByRepoFormatVersion.keySet()))).intValue();
        }

        public int getItemFormatVersion() {
            return this.itemFormatVersion;
        }

        public FitRepoItem readItem(DataInput input, int formatVersion) {
            FitRepoItem fitRepoItem;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            StoredItemFormatVersions storedItemFormatVersions = this.itemFormatVersionsByRepoFormatVersion.get(formatVersion);
            if (storedItemFormatVersions == null) {
                throw new CorruptFitRepository("Bad format version: " + formatVersion);
            }
            StoredItemFormatVersions formatVersions = storedItemFormatVersions;
            Integer skillSetFormatVersion = formatVersions.getSkillSets();
            if (skillSetFormatVersion == null) {
                return new FitRepoItem.Fit(StoredFit.Serializer.INSTANCE.readItem(input, formatVersions.getFits()));
            }
            int typeId = input.readInt();
            if (typeId == this.FIT_TYPE_ID) {
                fitRepoItem = FittingRepositoryKt.access$asRepoItem(StoredFit.Serializer.INSTANCE.readItem(input, formatVersions.getFits()));
            } else if (typeId == this.SKILL_SET_TYPE_ID) {
                fitRepoItem = FittingRepositoryKt.access$asRepoItem(StoredSkillSet.Serializer.INSTANCE.readItem(input, skillSetFormatVersion));
            } else {
                throw new CorruptFitRepository("Bad item type id: " + typeId);
            }
            return fitRepoItem;
        }

        public void writeItem(DataOutput output, FitRepoItem item) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            FitRepoItem fitRepoItem = item;
            if (fitRepoItem instanceof FitRepoItem.Fit) {
                output.writeInt(this.FIT_TYPE_ID);
                StoredFit.Serializer.INSTANCE.writeItem(output, ((FitRepoItem.Fit)item).getStoredFit());
            } else if (fitRepoItem instanceof FitRepoItem.SkillSet) {
                output.writeInt(this.SKILL_SET_TYPE_ID);
                StoredSkillSet.Serializer.INSTANCE.writeItem(output, ((FitRepoItem.SkillSet)item).getStoredSkillSet());
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    };

    private static final FitRepoItem.Fit asRepoItem(StoredFit $this$asRepoItem) {
        return new FitRepoItem.Fit($this$asRepoItem);
    }

    private static final FitRepoItem.SkillSet asRepoItem(StoredSkillSet $this$asRepoItem) {
        return new FitRepoItem.SkillSet($this$asRepoItem);
    }

    public static final /* synthetic */ Serializer.1 access$getSerializer$p() {
        return Serializer;
    }

    public static final /* synthetic */ FitRepoItem.Fit access$asRepoItem(StoredFit $receiver) {
        return FittingRepositoryKt.asRepoItem($receiver);
    }

    public static final /* synthetic */ FitRepoItem.SkillSet access$asRepoItem(StoredSkillSet $receiver) {
        return FittingRepositoryKt.asRepoItem($receiver);
    }
}

