/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.tournaments;

import androidx.compose.runtime.internal.StabilityInferred;
import eve.data.EveData;
import eve.data.ShipType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import theorycrafter.tournaments.Composition;
import theorycrafter.tournaments.PointsCompositionRules;
import theorycrafter.tournaments.PointsTournamentRulesKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0016J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u001bH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u001bH\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00140\u001b2\u0006\u0010!\u001a\u00020\"H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Ltheorycrafter/tournaments/BasicPointsCompositionRules;", "Ltheorycrafter/tournaments/PointsCompositionRules;", "eveData", "Leve/data/EveData;", "maxCompositionSize", "", "maxCompositionCost", "shipCostByType", "", "Leve/data/ShipType;", "<init>", "(Leve/data/EveData;IILjava/util/Map;)V", "getEveData", "()Leve/data/EveData;", "getMaxCompositionSize", "()I", "getMaxCompositionCost", "getShipCostByType", "()Ljava/util/Map;", "isShipLegal", "", "shipType", "legalShips", "", "getLegalShips", "()Ljava/util/Collection;", "shipsCost", "", "shipTypes", "marginalShipCostComputation", "Ltheorycrafter/tournaments/PointsCompositionRules$MarginalShipCostComputation;", "usedShipTypes", "compositionShipsLegality", "composition", "Ltheorycrafter/tournaments/Composition;", "Theorycrafter"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPointsTournamentRules.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PointsTournamentRules.kt\ntheorycrafter/tournaments/BasicPointsCompositionRules\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n1557#2:162\n1628#2,3:163\n1557#2:166\n1628#2,3:167\n*S KotlinDebug\n*F\n+ 1 PointsTournamentRules.kt\ntheorycrafter/tournaments/BasicPointsCompositionRules\n*L\n84#1:162\n84#1:163,3\n110#1:166\n110#1:167,3\n*E\n"})
public abstract class BasicPointsCompositionRules
implements PointsCompositionRules {
    @NotNull
    private final EveData eveData;
    private final int maxCompositionSize;
    private final int maxCompositionCost;
    @NotNull
    private final Map<ShipType, Integer> shipCostByType;
    @NotNull
    private final Collection<ShipType> legalShips;
    @NotNull
    private final PointsCompositionRules.MarginalShipCostComputation marginalShipCostComputation;
    public static final int $stable = 8;

    public BasicPointsCompositionRules(@NotNull EveData eveData2, int maxCompositionSize, int maxCompositionCost, @NotNull Map<ShipType, Integer> shipCostByType) {
        Intrinsics.checkNotNullParameter((Object)eveData2, (String)"eveData");
        Intrinsics.checkNotNullParameter(shipCostByType, (String)"shipCostByType");
        this.eveData = eveData2;
        this.maxCompositionSize = maxCompositionSize;
        this.maxCompositionCost = maxCompositionCost;
        this.shipCostByType = shipCostByType;
        this.legalShips = this.shipCostByType.keySet();
        this.marginalShipCostComputation = PointsTournamentRulesKt.regularMarginalShipCostComputation(this.shipCostByType);
    }

    @NotNull
    protected final EveData getEveData() {
        return this.eveData;
    }

    @Override
    public int getMaxCompositionSize() {
        return this.maxCompositionSize;
    }

    @Override
    public int getMaxCompositionCost() {
        return this.maxCompositionCost;
    }

    @NotNull
    public final Map<ShipType, Integer> getShipCostByType() {
        return this.shipCostByType;
    }

    @Override
    public boolean isShipLegal(@NotNull ShipType shipType) {
        Intrinsics.checkNotNullParameter((Object)shipType, (String)"shipType");
        return this.shipCostByType.containsKey(shipType);
    }

    @Override
    @NotNull
    public Collection<ShipType> getLegalShips() {
        return this.legalShips;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Integer> shipsCost(@NotNull List<ShipType> shipTypes2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(shipTypes2, (String)"shipTypes");
        Iterable $this$map$iv = shipTypes2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            int n;
            void it;
            ShipType shipType = (ShipType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (it == null) {
                n = 0;
            } else {
                Integer n2 = this.shipCostByType.get(it);
                n = n2 != null ? n2 : 0;
            }
            collection.add(n);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public PointsCompositionRules.MarginalShipCostComputation marginalShipCostComputation(@NotNull List<ShipType> usedShipTypes) {
        Intrinsics.checkNotNullParameter(usedShipTypes, (String)"usedShipTypes");
        return this.marginalShipCostComputation;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Boolean> compositionShipsLegality(@NotNull Composition composition) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)composition, (String)"composition");
        Iterable $this$map$iv = composition.getShips();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Composition.Ship ship = (Composition.Ship)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v0 = it;
            collection.add(v0 == null ? true : this.isShipLegal(v0.getShipType()));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<Integer> shipsCost(@NotNull Composition composition) {
        return PointsCompositionRules.DefaultImpls.shipsCost(this, composition);
    }
}

