/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.ui.fiteditor;

import eve.data.ModuleSlotType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import theorycrafter.fitting.Fit;
import theorycrafter.fitting.FittingEngine;
import theorycrafter.fitting.Module;
import theorycrafter.ui.fiteditor.FitEditingAction;
import theorycrafter.ui.fiteditor.FitEditorUndoRedoContext;
import theorycrafter.ui.fiteditor.NoRoomForModuleEffectException;
import theorycrafter.ui.fiteditor.RemoteModuleEffectInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\r\u001a\u00020\u000e*\u00020\u0010H\u0016R\u00020\u000f\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u000e*\u00020\u0010H\u0016R\u00020\u000f\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ltheorycrafter/ui/fiteditor/ModuleEffectReplacement;", "Ltheorycrafter/ui/fiteditor/FitEditingAction;", "fit", "Ltheorycrafter/fitting/Fit;", "slotType", "Leve/data/ModuleSlotType;", "slotIndex", "", "removed", "Ltheorycrafter/ui/fiteditor/RemoteModuleEffectInfo;", "added", "<init>", "(Ltheorycrafter/fitting/Fit;Leve/data/ModuleSlotType;ILtheorycrafter/ui/fiteditor/RemoteModuleEffectInfo;Ltheorycrafter/ui/fiteditor/RemoteModuleEffectInfo;)V", "performEdit", "", "Ltheorycrafter/ui/fiteditor/FitEditorUndoRedoContext;", "Ltheorycrafter/fitting/FittingEngine$ModificationScope;", "(Ltheorycrafter/ui/fiteditor/FitEditorUndoRedoContext;Ltheorycrafter/fitting/FittingEngine$ModificationScope;)V", "revertEdit", "Theorycrafter"})
final class ModuleEffectReplacement
extends FitEditingAction {
    @NotNull
    private final Fit fit;
    @NotNull
    private final ModuleSlotType slotType;
    private final int slotIndex;
    @Nullable
    private final RemoteModuleEffectInfo removed;
    @Nullable
    private final RemoteModuleEffectInfo added;

    public ModuleEffectReplacement(@NotNull Fit fit2, @NotNull ModuleSlotType slotType, int slotIndex, @Nullable RemoteModuleEffectInfo removed, @Nullable RemoteModuleEffectInfo added) {
        Intrinsics.checkNotNullParameter((Object)fit2, (String)"fit");
        Intrinsics.checkNotNullParameter((Object)slotType, (String)"slotType");
        this.fit = fit2;
        this.slotType = slotType;
        this.slotIndex = slotIndex;
        this.removed = removed;
        this.added = added;
    }

    @Override
    public void performEdit(@NotNull FitEditorUndoRedoContext $context_receiver_0, @NotNull FittingEngine.ModificationScope $this$performEdit) {
        Module module;
        Intrinsics.checkNotNullParameter((Object)$this$performEdit, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        if (this.removed != null) {
            Fit fit2 = this.fit.getAuxiliaryFit();
            Intrinsics.checkNotNull((Object)fit2);
            Module module2 = fit2.getModules().inSlot(this.slotType, this.slotIndex);
            Intrinsics.checkNotNull((Object)module2);
            module = module2;
            $this$performEdit.removeModuleEffect(this.fit, module);
        }
        if (this.added != null) {
            module = $this$performEdit.addModuleEffect(this.fit, this.added.getModuleType(), Integer.valueOf(this.slotIndex));
            if (module == null) {
                throw new NoRoomForModuleEffectException(this.slotIndex);
            }
            if (this.added.getChargeType() != null) {
                $this$performEdit.setCharge(module, this.added.getChargeType());
            }
            $this$performEdit.setState(module, this.added.getState());
        }
    }

    @Override
    public void revertEdit(@NotNull FitEditorUndoRedoContext $context_receiver_0, @NotNull FittingEngine.ModificationScope $this$revertEdit) {
        Module module;
        Intrinsics.checkNotNullParameter((Object)$this$revertEdit, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        if (this.added != null) {
            Fit fit2 = this.fit.getAuxiliaryFit();
            Intrinsics.checkNotNull((Object)fit2);
            Module module2 = fit2.getModules().inSlot(this.slotType, this.slotIndex);
            Intrinsics.checkNotNull((Object)module2);
            module = module2;
            $this$revertEdit.removeModuleEffect(this.fit, module);
        }
        if (this.removed != null) {
            Module module3 = $this$revertEdit.addModuleEffect(this.fit, this.removed.getModuleType(), Integer.valueOf(this.slotIndex));
            Intrinsics.checkNotNull((Object)module3);
            module = module3;
            if (this.removed.getChargeType() != null) {
                $this$revertEdit.setCharge(module, this.removed.getChargeType());
            }
            $this$revertEdit.setState(module, this.removed.getState());
        }
    }
}

