/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.ui.fiteditor;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.ComposableTarget;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import eve.data.ValueFormatsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import theorycrafter.fitting.AttributeProperty;
import theorycrafter.fitting.Charge;
import theorycrafter.fitting.DroneGroup;
import theorycrafter.fitting.MissileRange;
import theorycrafter.fitting.Module;
import theorycrafter.ui.fiteditor.ValueWithDescription;
import theorycrafter.ui.fiteditor.ValueWithDescriptionTableKt;
import theorycrafter.ui.widgets.TextAndTooltip;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\u0010\u0004\u001a\u0015\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\b\u001a)\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\u000e\u001a/\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\u0012\u001a\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000bH\u0002\u001a=\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\u001d\u001a\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u000bH\u0002\u001a\f\u0010\u001f\u001a\u00020 *\u00020\u000bH\u0002\u001a\f\u0010!\u001a\u00020 *\u00020\u000bH\u0002\u001a\f\u0010\"\u001a\u00020 *\u00020\u0018H\u0002\u00a8\u0006#"}, d2={"displayedModuleRange", "Ltheorycrafter/ui/widgets/TextAndTooltip;", "module", "Ltheorycrafter/fitting/Module;", "(Ltheorycrafter/fitting/Module;Landroidx/compose/runtime/Composer;I)Ltheorycrafter/ui/widgets/TextAndTooltip;", "displayedDroneRange", "droneGroup", "Ltheorycrafter/fitting/DroneGroup;", "(Ltheorycrafter/fitting/DroneGroup;Landroidx/compose/runtime/Composer;I)Ltheorycrafter/ui/widgets/TextAndTooltip;", "optimalFalloffAndTrackingDisplayedRange", "optimal", "", "falloff", "trackingSpeed", "(DLjava/lang/Double;Ljava/lang/Double;)Ltheorycrafter/ui/widgets/TextAndTooltip;", "optimalFalloffAndTrackingTooltipItems", "", "Ltheorycrafter/ui/fiteditor/ValueWithDescription;", "(DLjava/lang/Double;Ljava/lang/Double;)Ljava/util/List;", "optimalTooltipItem", "falloffTooltipItem", "trackingSpeedTooltipItem", "missileDisplayedRange", "range", "Ltheorycrafter/fitting/MissileRange;", "velocity", "flightTime", "explosionRadius", "explosionVelocity", "(Ltheorycrafter/fitting/MissileRange;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;)Ltheorycrafter/ui/widgets/TextAndTooltip;", "displayedRange", "asTooltipDistance", "", "asTooltipChance", "asString", "Theorycrafter"})
public final class RangeColumnKt {
    @Composable
    @Nullable
    public static final TextAndTooltip displayedModuleRange(@NotNull Module module, @Nullable Composer $composer, int $changed) {
        Double stasisWebificationRange;
        Double warpDisruptionRange;
        Double explosionVelocity;
        Charge charge;
        Double trackingSpeed;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        $composer.startReplaceableGroup(-881439244);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-881439244, (int)$changed, (int)-1, (String)"theorycrafter.ui.fiteditor.displayedModuleRange (RangeColumn.kt:19)");
        }
        AttributeProperty attributeProperty = module.getOptimalRange();
        Double optimal = attributeProperty != null ? (Double)attributeProperty.getValue() : null;
        AttributeProperty attributeProperty2 = module.getFalloffRange();
        Double falloff = attributeProperty2 != null ? (Double)attributeProperty2.getValue() : null;
        AttributeProperty attributeProperty3 = module.getTrackingSpeed();
        Double d = trackingSpeed = attributeProperty3 != null ? (Double)attributeProperty3.getValue() : null;
        if (optimal != null) {
            TextAndTooltip textAndTooltip = RangeColumnKt.optimalFalloffAndTrackingDisplayedRange(optimal, falloff, trackingSpeed);
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventEnd();
            }
            $composer.endReplaceableGroup();
            return textAndTooltip;
        }
        Charge charge2 = charge = module.getLoadedCharge();
        MissileRange missileRange = charge2 != null ? charge2.getMissileRange() : null;
        Charge charge3 = charge;
        Double missileVelocity = charge3 != null && (charge3 = charge3.getMissileVelocity()) != null ? (Double)charge3.getValue() : null;
        Charge charge4 = charge;
        Double missileFlightTime = charge4 != null && (charge4 = charge4.getMissileFlightTime()) != null ? (Double)charge4.getValue() : null;
        Charge charge5 = charge;
        Double explosionRadius = charge5 != null && (charge5 = charge5.getMissileExplosionRadius()) != null ? (Double)charge5.getValue() : null;
        Charge charge6 = charge;
        Double d2 = charge6 != null && (charge6 = charge6.getMissileExplosionVelocity()) != null ? (Double)charge6.getValue() : (explosionVelocity = null);
        if (missileRange != null) {
            TextAndTooltip textAndTooltip = RangeColumnKt.missileDisplayedRange(missileRange, missileVelocity, missileFlightTime, explosionRadius, explosionVelocity);
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventEnd();
            }
            $composer.endReplaceableGroup();
            return textAndTooltip;
        }
        Charge charge7 = charge;
        Double d3 = charge7 != null && (charge7 = charge7.getWarpDisruptionRange()) != null ? (Double)charge7.getValue() : (warpDisruptionRange = null);
        if (warpDisruptionRange != null) {
            TextAndTooltip textAndTooltip = RangeColumnKt.displayedRange(warpDisruptionRange);
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventEnd();
            }
            $composer.endReplaceableGroup();
            return textAndTooltip;
        }
        Charge charge8 = charge;
        Double d4 = charge8 != null && (charge8 = charge8.getStasisWebificationRange()) != null ? (Double)charge8.getValue() : (stasisWebificationRange = null);
        if (stasisWebificationRange != null) {
            TextAndTooltip textAndTooltip = RangeColumnKt.displayedRange(stasisWebificationRange);
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventEnd();
            }
            $composer.endReplaceableGroup();
            return textAndTooltip;
        }
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        $composer.endReplaceableGroup();
        return null;
    }

    @Composable
    @NotNull
    public static final TextAndTooltip displayedDroneRange(@NotNull DroneGroup droneGroup, @Nullable Composer $composer, int $changed) {
        Double speed;
        Intrinsics.checkNotNullParameter((Object)droneGroup, (String)"droneGroup");
        $composer.startReplaceableGroup(-394596619);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-394596619, (int)$changed, (int)-1, (String)"theorycrafter.ui.fiteditor.displayedDroneRange (RangeColumn.kt:58)");
        }
        double optimal = ((Number)droneGroup.getOptimalRange().getValue()).doubleValue();
        AttributeProperty attributeProperty = droneGroup.getFalloffRange();
        Double falloff = attributeProperty != null ? (Double)attributeProperty.getValue() : null;
        AttributeProperty attributeProperty2 = droneGroup.getTrackingSpeed();
        Double trackingSpeed = attributeProperty2 != null ? (Double)attributeProperty2.getValue() : null;
        AttributeProperty attributeProperty3 = droneGroup.getMwdSpeed();
        Double d = speed = attributeProperty3 != null ? (Double)attributeProperty3.getValue() : null;
        if (speed != null) {
            String speedText = ValueFormatsKt.asSpeed$default((double)speed, (boolean)false, (boolean)false, (int)0, (int)7, null);
            TextAndTooltip textAndTooltip = new TextAndTooltip(speedText, 0L, (Function2)ComposableLambdaKt.composableLambda((Composer)$composer, (int)-2112703365, (boolean)true, (Object)new Function2<Composer, Integer, Unit>(speedText, optimal, falloff, trackingSpeed){
                final /* synthetic */ String $speedText;
                final /* synthetic */ double $optimal;
                final /* synthetic */ Double $falloff;
                final /* synthetic */ Double $trackingSpeed;
                {
                    this.$speedText = $speedText;
                    this.$optimal = $optimal;
                    this.$falloff = $falloff;
                    this.$trackingSpeed = $trackingSpeed;
                }

                @Composable
                @ComposableTarget(applier="androidx.compose.ui.UiComposable")
                public final void invoke(Composer $composer, int $changed) {
                    if (($changed & 3) != 2 || !$composer.getSkipping()) {
                        if (ComposerKt.isTraceInProgress()) {
                            ComposerKt.traceEventStart((int)-2112703365, (int)$changed, (int)-1, (String)"theorycrafter.ui.fiteditor.displayedDroneRange.<anonymous> (RangeColumn.kt:69)");
                        }
                        ValueWithDescriptionTableKt.ValueWithDescriptionTable(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)new ValueWithDescription(this.$speedText, "speed")), (Iterable)RangeColumnKt.access$optimalFalloffAndTrackingTooltipItems(this.$optimal, this.$falloff, this.$trackingSpeed)), null, null, $composer, 0, 6);
                        if (ComposerKt.isTraceInProgress()) {
                            ComposerKt.traceEventEnd();
                        }
                    } else {
                        $composer.skipToGroupEnd();
                    }
                }
            }), 2, null);
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventEnd();
            }
            $composer.endReplaceableGroup();
            return textAndTooltip;
        }
        TextAndTooltip textAndTooltip = RangeColumnKt.optimalFalloffAndTrackingDisplayedRange(optimal, falloff, trackingSpeed);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        $composer.endReplaceableGroup();
        return textAndTooltip;
    }

    private static final TextAndTooltip optimalFalloffAndTrackingDisplayedRange(double optimal, Double falloff, Double trackingSpeed) {
        return new TextAndTooltip(ValueFormatsKt.asRange$default((double)optimal, (Double)falloff, (boolean)false, (int)4, null), 0L, (Function2)ComposableLambdaKt.composableLambdaInstance((int)-295279154, (boolean)true, (Object)new Function2<Composer, Integer, Unit>(optimal, falloff, trackingSpeed){
            final /* synthetic */ double $optimal;
            final /* synthetic */ Double $falloff;
            final /* synthetic */ Double $trackingSpeed;
            {
                this.$optimal = $optimal;
                this.$falloff = $falloff;
                this.$trackingSpeed = $trackingSpeed;
            }

            @Composable
            @ComposableTarget(applier="androidx.compose.ui.UiComposable")
            public final void invoke(Composer $composer, int $changed) {
                if (($changed & 3) != 2 || !$composer.getSkipping()) {
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventStart((int)-295279154, (int)$changed, (int)-1, (String)"theorycrafter.ui.fiteditor.optimalFalloffAndTrackingDisplayedRange.<anonymous> (RangeColumn.kt:92)");
                    }
                    ValueWithDescriptionTableKt.ValueWithDescriptionTable(RangeColumnKt.access$optimalFalloffAndTrackingTooltipItems(this.$optimal, this.$falloff, this.$trackingSpeed), null, null, $composer, 0, 6);
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventEnd();
                    }
                } else {
                    $composer.skipToGroupEnd();
                }
            }
        }), 2, null);
    }

    private static final List<ValueWithDescription> optimalFalloffAndTrackingTooltipItems(double optimal, Double falloff, Double trackingSpeed) {
        List list;
        List $this$optimalFalloffAndTrackingTooltipItems_u24lambda_u240 = list = CollectionsKt.createListBuilder((int)2);
        boolean bl = false;
        $this$optimalFalloffAndTrackingTooltipItems_u24lambda_u240.add(RangeColumnKt.optimalTooltipItem(optimal));
        if (falloff != null && !Intrinsics.areEqual((Double)falloff, (double)0.0)) {
            $this$optimalFalloffAndTrackingTooltipItems_u24lambda_u240.add(RangeColumnKt.falloffTooltipItem(falloff));
        }
        if (trackingSpeed != null) {
            $this$optimalFalloffAndTrackingTooltipItems_u24lambda_u240.add(RangeColumnKt.trackingSpeedTooltipItem(trackingSpeed));
        }
        return CollectionsKt.build((List)list);
    }

    private static final ValueWithDescription optimalTooltipItem(double optimal) {
        return new ValueWithDescription(RangeColumnKt.asTooltipDistance(optimal), "optimal range");
    }

    private static final ValueWithDescription falloffTooltipItem(double falloff) {
        return new ValueWithDescription(RangeColumnKt.asTooltipDistance(falloff), "falloff range");
    }

    private static final ValueWithDescription trackingSpeedTooltipItem(double trackingSpeed) {
        return new ValueWithDescription(ValueFormatsKt.asTrackingSpeed$default((double)trackingSpeed, (boolean)false, (int)1, null), "tracking speed");
    }

    private static final TextAndTooltip missileDisplayedRange(MissileRange range, Double velocity, Double flightTime, Double explosionRadius, Double explosionVelocity) {
        List list;
        List $this$missileDisplayedRange_u24lambda_u241 = list = CollectionsKt.createListBuilder((int)5);
        boolean bl = false;
        $this$missileDisplayedRange_u24lambda_u241.add(new ValueWithDescription(RangeColumnKt.asTooltipDistance(range.getShortRange()), "with " + RangeColumnKt.asTooltipChance(range.getShortProbability()) + " chance"));
        $this$missileDisplayedRange_u24lambda_u241.add(new ValueWithDescription(RangeColumnKt.asTooltipDistance(range.getLongRange()), "with " + RangeColumnKt.asTooltipChance(range.getLongProbability()) + " chance"));
        double averageRange = range.getAverageRange();
        $this$missileDisplayedRange_u24lambda_u241.add(new ValueWithDescription(RangeColumnKt.asTooltipDistance(averageRange), "avg. flight distance"));
        if (velocity != null) {
            $this$missileDisplayedRange_u24lambda_u241.add(new ValueWithDescription(ValueFormatsKt.asSpeed$default((double)velocity, (boolean)false, (boolean)false, (int)0, (int)7, null), "flight velocity"));
        }
        if (flightTime != null) {
            $this$missileDisplayedRange_u24lambda_u241.add(new ValueWithDescription(ValueFormatsKt.millisAsTimeSec$default((double)flightTime, (boolean)false, (boolean)false, null, (int)7, null), "flight time"));
        }
        if (explosionRadius != null) {
            $this$missileDisplayedRange_u24lambda_u241.add(new ValueWithDescription(ValueFormatsKt.asDistance$default((double)explosionRadius, (boolean)false, (boolean)false, (int)0, (int)7, null), "explosion radius"));
        }
        if (explosionVelocity != null) {
            $this$missileDisplayedRange_u24lambda_u241.add(new ValueWithDescription(ValueFormatsKt.asSpeed$default((double)explosionVelocity, (boolean)false, (boolean)false, (int)0, (int)7, null), "explosion velocity"));
        }
        List tooltipItems = CollectionsKt.build((List)list);
        return new TextAndTooltip(RangeColumnKt.asString(range), 0L, (Function2)ComposableLambdaKt.composableLambdaInstance((int)-789867702, (boolean)true, (Object)new Function2<Composer, Integer, Unit>((List<ValueWithDescription>)tooltipItems){
            final /* synthetic */ List<ValueWithDescription> $tooltipItems;
            {
                this.$tooltipItems = $tooltipItems;
            }

            @Composable
            @ComposableTarget(applier="androidx.compose.ui.UiComposable")
            public final void invoke(Composer $composer, int $changed) {
                if (($changed & 3) != 2 || !$composer.getSkipping()) {
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventStart((int)-789867702, (int)$changed, (int)-1, (String)"theorycrafter.ui.fiteditor.missileDisplayedRange.<anonymous> (RangeColumn.kt:218)");
                    }
                    ValueWithDescriptionTableKt.ValueWithDescriptionTable(this.$tooltipItems, null, null, $composer, 0, 6);
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventEnd();
                    }
                } else {
                    $composer.skipToGroupEnd();
                }
            }
        }), 2, null);
    }

    private static final TextAndTooltip displayedRange(double range) {
        return new TextAndTooltip(ValueFormatsKt.asDistance$default((double)range, (boolean)false, (boolean)false, (int)0, (int)7, null), 0L, (Function2)ComposableLambdaKt.composableLambdaInstance((int)543829292, (boolean)true, (Object)new Function2<Composer, Integer, Unit>(range){
            final /* synthetic */ double $range;
            {
                this.$range = $range;
            }

            @Composable
            @ComposableTarget(applier="androidx.compose.ui.UiComposable")
            public final void invoke(Composer $composer, int $changed) {
                if (($changed & 3) != 2 || !$composer.getSkipping()) {
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventStart((int)543829292, (int)$changed, (int)-1, (String)"theorycrafter.ui.fiteditor.displayedRange.<anonymous> (RangeColumn.kt:233)");
                    }
                    ValueWithDescription[] valueWithDescriptionArray = new ValueWithDescription[]{new ValueWithDescription(RangeColumnKt.access$asTooltipDistance(this.$range), "range")};
                    ValueWithDescriptionTableKt.ValueWithDescriptionTable(valueWithDescriptionArray, null, null, $composer, 0, 6);
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventEnd();
                    }
                } else {
                    $composer.skipToGroupEnd();
                }
            }
        }), 2, null);
    }

    private static final String asTooltipDistance(double $this$asTooltipDistance) {
        return ValueFormatsKt.asDistanceWithPrecision$default((double)$this$asTooltipDistance, (int)1, (boolean)false, (boolean)false, (int)6, null);
    }

    private static final String asTooltipChance(double $this$asTooltipChance) {
        return ValueFormatsKt.fractionAsPercentage$default((double)$this$asTooltipChance, (int)1, (boolean)false, (int)2, null);
    }

    private static final String asString(MissileRange $this$asString) {
        StringBuilder stringBuilder;
        int shortKm = (int)($this$asString.getShortRange() / (double)1000);
        int longKm = (int)Math.ceil($this$asString.getLongRange() / (double)1000);
        StringBuilder $this$asString_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$asString_u24lambda_u242.append(shortKm);
        $this$asString_u24lambda_u242.append("\u2013");
        $this$asString_u24lambda_u242.append(longKm);
        $this$asString_u24lambda_u242.append("\u202f");
        $this$asString_u24lambda_u242.append("km");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static final /* synthetic */ List access$optimalFalloffAndTrackingTooltipItems(double optimal, Double falloff, Double trackingSpeed) {
        return RangeColumnKt.optimalFalloffAndTrackingTooltipItems(optimal, falloff, trackingSpeed);
    }

    public static final /* synthetic */ String access$asTooltipDistance(double $receiver) {
        return RangeColumnKt.asTooltipDistance($receiver);
    }
}

