/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.ui.fitstats;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.ComposableTarget;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.RecomposeScopeImplKt;
import androidx.compose.runtime.ScopeUpdateScope;
import eve.data.ValueFormatsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import theorycrafter.fitting.CapacitorStability;
import theorycrafter.fitting.Fit;
import theorycrafter.ui.fiteditor.ValueWithDescription;
import theorycrafter.ui.fitstats.FitStatsKt;
import theorycrafter.ui.fitstats.Stat;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\u0015\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\u0010\u0004\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"MiscStats", "", "fit", "Ltheorycrafter/fitting/Fit;", "(Ltheorycrafter/fitting/Fit;Landroidx/compose/runtime/Composer;I)V", "displayText", "", "Ltheorycrafter/fitting/CapacitorStability;", "Theorycrafter"})
public final class MiscStatsKt {
    @Composable
    @ComposableTarget(applier="androidx.compose.ui.UiComposable")
    public static final void MiscStats(@NotNull Fit fit2, @Nullable Composer $composer, int $changed) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)fit2, (String)"fit");
            $composer = $composer.startRestartGroup(-1887115817);
            int $dirty = $changed;
            if (($changed & 6) == 0) {
                $dirty |= $composer.changed((Object)fit2) ? 4 : 2;
            }
            if (($dirty & 3) != 2 || !$composer.getSkipping()) {
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventStart((int)-1887115817, (int)$dirty, (int)-1, (String)"theorycrafter.ui.fitstats.MiscStats (MiscStats.kt:17)");
                }
                Fit $this$MiscStats_u24lambda_u240 = fit2;
                boolean bl = false;
                double signatureRadius = ((Number)$this$MiscStats_u24lambda_u240.getShip().getSignatureRadius().getValue()).doubleValue();
                CapacitorStability capacitorStability = $this$MiscStats_u24lambda_u240.getCapacitor().getStability();
                double capacitorCapacity = ((Number)$this$MiscStats_u24lambda_u240.getCapacitor().getCapacity().getValue()).doubleValue();
                double capacitorPeakRechargeRate = $this$MiscStats_u24lambda_u240.getCapacitor().getPeakRechargeRate();
                double droneControlRange = ((Number)fit2.getDrones().getControlRange().getValue()).doubleValue();
                double energyNeutralizationResonance = ((Number)fit2.getElectronicWarfare().getEnergyNeutralizationResistance().getValue()).doubleValue();
                ValueWithDescription energyNeutralizationTooltip = !(energyNeutralizationResonance == 1.0) ? new ValueWithDescription(ValueFormatsKt.resonanceAsResistancePercentageWithPrecisionAtMost((double)energyNeutralizationResonance, (int)0), "resistance to energy neutralization") : null;
                Stat[] statArray = new Stat[3];
                statArray[0] = new Stat("Signature", ValueFormatsKt.asSignatureRadius$default((double)signatureRadius, (boolean)true, (boolean)false, (int)2, null), null, 4, null);
                Object[] objectArray = new ValueWithDescription[]{new ValueWithDescription(ValueFormatsKt.asCapacitorEnergy$default((double)capacitorCapacity, (boolean)false, (boolean)false, (int)3, null), "capacity"), new ValueWithDescription(ValueFormatsKt.asCapacitorEnergyPerSecond$default((double)capacitorPeakRechargeRate, (boolean)false, (boolean)false, (int)3, null), "peak recharge rate"), energyNeutralizationTooltip};
                statArray[1] = new Stat("Capacitor", MiscStatsKt.displayText(capacitorStability), CollectionsKt.listOfNotNull((Object[])objectArray));
                statArray[2] = new Stat("Drone Control", ValueFormatsKt.asDistance$default((double)droneControlRange, (boolean)true, (boolean)false, (int)0, (int)6, null), null, 4, null);
                FitStatsKt.StatsTable(3, statArray, $composer, 6);
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventEnd();
                }
            } else {
                $composer.skipToGroupEnd();
            }
            ScopeUpdateScope scopeUpdateScope = $composer.endRestartGroup();
            if (scopeUpdateScope == null) break block5;
            scopeUpdateScope.updateScope((arg_0, arg_1) -> MiscStatsKt.MiscStats$lambda$1(fit2, $changed, arg_0, arg_1));
        }
    }

    private static final String displayText(CapacitorStability $this$displayText) {
        String string;
        CapacitorStability capacitorStability = $this$displayText;
        if (capacitorStability instanceof CapacitorStability.Stable) {
            string = "Stable at " + ValueFormatsKt.fractionAsPercentage$default((double)((CapacitorStability.Stable)$this$displayText).getMinCapacityRelative(), (int)0, (boolean)false, (int)2, null);
        } else if (capacitorStability instanceof CapacitorStability.Unstable) {
            string = "Lasts " + ValueFormatsKt.millisAsTime$default((double)((double)((CapacitorStability.Unstable)$this$displayText).getTimeUntilDepleted() * 1000.0), (boolean)false, (int)1, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private static final Unit MiscStats$lambda$1(Fit $fit, int $$changed, Composer $composer, int $force) {
        MiscStatsKt.MiscStats($fit, $composer, RecomposeScopeImplKt.updateChangedFlags((int)($$changed | 1)));
        return Unit.INSTANCE;
    }
}

