/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.ui.fitstats;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.ComposableTarget;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.RecomposeScopeImplKt;
import androidx.compose.runtime.ScopeUpdateScope;
import eve.data.SensorType;
import eve.data.ValueFormatsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import theorycrafter.fitting.DroneGroup;
import theorycrafter.fitting.Fit;
import theorycrafter.fitting.MechanicsKt;
import theorycrafter.fitting.Module;
import theorycrafter.fitting.RemoteEffect;
import theorycrafter.ui.fiteditor.ValueWithDescription;
import theorycrafter.ui.fitstats.FitStatsKt;
import theorycrafter.ui.fitstats.Stat;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\u001a\u0015\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\u0010\u0004\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0003H\u0002\u00a8\u0006\u0007"}, d2={"TargetingStats", "", "fit", "Ltheorycrafter/fitting/Fit;", "(Ltheorycrafter/fitting/Fit;Landroidx/compose/runtime/Composer;I)V", "jammedChance", "", "Theorycrafter"})
@SourceDebugExtension(value={"SMAP\nTargetingStats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetingStats.kt\ntheorycrafter/ui/fitstats/TargetingStatsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n774#2:103\n865#2,2:104\n1368#2:106\n1454#2,2:107\n774#2:109\n865#2,2:110\n1456#2,3:112\n1368#2:115\n1454#2,2:116\n774#2:118\n865#2,2:119\n1456#2,3:121\n*S KotlinDebug\n*F\n+ 1 TargetingStats.kt\ntheorycrafter/ui/fitstats/TargetingStatsKt\n*L\n88#1:103\n88#1:104,2\n89#1:106\n89#1:107,2\n90#1:109\n90#1:110,2\n89#1:112,3\n92#1:115\n92#1:116,2\n93#1:118\n93#1:119,2\n92#1:121,3\n*E\n"})
public final class TargetingStatsKt {
    @Composable
    @ComposableTarget(applier="androidx.compose.ui.UiComposable")
    public static final void TargetingStats(@NotNull Fit fit2, @Nullable Composer $composer, int $changed) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)fit2, (String)"fit");
            $composer = $composer.startRestartGroup(-305627315);
            int $dirty = $changed;
            if (($changed & 6) == 0) {
                $dirty |= $composer.changed((Object)fit2) ? 4 : 2;
            }
            if (($dirty & 3) != 2 || !$composer.getSkipping()) {
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventStart((int)-305627315, (int)$dirty, (int)-1, (String)"theorycrafter.ui.fitstats.TargetingStats (TargetingStats.kt:17)");
                }
                Fit.Targeting $this$TargetingStats_u24lambda_u240 = fit2.getTargeting();
                boolean bl = false;
                double range = ((Number)$this$TargetingStats_u24lambda_u240.getTargetingRange().getValue()).doubleValue();
                int maxTargets = $this$TargetingStats_u24lambda_u240.getMaxLockedTargets();
                double sensorStrength = ((Number)$this$TargetingStats_u24lambda_u240.getSensors().getStrength().getValue()).doubleValue();
                SensorType sensorType = $this$TargetingStats_u24lambda_u240.getSensors().getType();
                double jamChance = TargetingStatsKt.jammedChance(fit2);
                double scanRes = ((Number)$this$TargetingStats_u24lambda_u240.getScanResolution().getValue()).doubleValue();
                double sensorDampeningResonance = ((Number)fit2.getElectronicWarfare().getSensorDampenerResistance().getValue()).doubleValue();
                double ecmResonance = ((Number)fit2.getElectronicWarfare().getEcmResistance().getValue()).doubleValue();
                ValueWithDescription resistanceToDampeningTooltip = !(sensorDampeningResonance == 1.0) ? new ValueWithDescription(ValueFormatsKt.resonanceAsResistancePercentageWithPrecisionAtMost((double)sensorDampeningResonance, (int)0), "resistance to sensor dampening") : null;
                ValueWithDescription resistanceToEcmTooltip = !(ecmResonance == 1.0) ? new ValueWithDescription(ValueFormatsKt.resonanceAsResistancePercentageWithPrecisionAtMost((double)ecmResonance, (int)0), "resistance to ECM") : null;
                Stat[] statArray = new Stat[3];
                Object[] objectArray = new ValueWithDescription[]{new ValueWithDescription(ValueFormatsKt.asDistance$default((double)range, (boolean)true, (boolean)false, (int)Integer.MAX_VALUE, (int)2, null), "targeting range"), new ValueWithDescription(String.valueOf(maxTargets), "max. locked targets"), resistanceToDampeningTooltip};
                statArray[0] = new Stat("Targeting Range", ValueFormatsKt.asDistance$default((double)range, (boolean)true, (boolean)false, (int)0, (int)6, null), CollectionsKt.listOfNotNull((Object[])objectArray));
                objectArray = new ValueWithDescription[]{new ValueWithDescription(ValueFormatsKt.fractionAsPercentageWithPrecisionAtMost$default((double)jamChance, (int)1, (boolean)false, (int)2, null), "chance of being jammed"), resistanceToEcmTooltip};
                statArray[1] = new Stat(sensorType.getShortDisplayName() + " Sensors", ValueFormatsKt.asSensorStrength$default((double)sensorStrength, (boolean)true, (boolean)false, (int)2, null) + (String)(jamChance > 0.0 ? " (" + ValueFormatsKt.fractionAsPercentage$default((double)jamChance, (int)0, (boolean)false, (int)2, null) + ")" : ""), CollectionsKt.listOfNotNull((Object[])objectArray));
                statArray[2] = new Stat("Scan Resolution", ValueFormatsKt.asScanResolution$default((double)scanRes, (boolean)true, (boolean)false, (int)2, null), CollectionsKt.listOfNotNull((Object)resistanceToDampeningTooltip));
                FitStatsKt.StatsTable(3, statArray, $composer, 6);
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventEnd();
                }
            } else {
                $composer.skipToGroupEnd();
            }
            ScopeUpdateScope scopeUpdateScope = $composer.endRestartGroup();
            if (scopeUpdateScope == null) break block5;
            scopeUpdateScope.updateScope((arg_0, arg_1) -> TargetingStatsKt.TargetingStats$lambda$1(fit2, $changed, arg_0, arg_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final double jammedChance(Fit $this$jammedChance) {
        void $this$flatMapTo$iv$iv;
        Iterable destination$iv$iv;
        void $this$flatMapTo$iv$iv2;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$jammedChance.getHostileEffects();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RemoteEffect it = (RemoteEffect)element$iv$iv;
            boolean bl = false;
            if (!it.getEnabled()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List enabledEffects = (List)destination$iv$iv2;
        Iterable $this$flatMap$iv = enabledEffects;
        boolean $i$f$flatMap = false;
        destination$iv$iv2 = $this$flatMap$iv;
        Iterable destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            void $this$filterTo$iv$iv2;
            RemoteEffect effect = (RemoteEffect)element$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv2 = effect.getAffectingModules();
            boolean $i$f$filter2 = false;
            Iterable iterable2 = $this$filter$iv2;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                Module it = (Module)element$iv$iv2;
                boolean bl2 = false;
                if (!it.getActive()) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        List ecmModules = (List)destination$iv$iv3;
        Iterable $this$flatMap$iv2 = enabledEffects;
        boolean $i$f$flatMap2 = false;
        destination$iv$iv3 = $this$flatMap$iv2;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$filterTo$iv$iv3;
            RemoteEffect effect = (RemoteEffect)element$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv3 = effect.getAffectingDrones();
            boolean $i$f$filter3 = false;
            destination$iv$iv = $this$filter$iv3;
            Collection destination$iv$iv5 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv3 : $this$filterTo$iv$iv3) {
                DroneGroup it = (DroneGroup)element$iv$iv3;
                boolean bl3 = false;
                if (!it.getActive()) continue;
                destination$iv$iv5.add(element$iv$iv3);
            }
            Iterable list$iv$iv = (List)destination$iv$iv5;
            CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
        }
        List ecmDrones = (List)destination$iv$iv4;
        return MechanicsKt.jamChance$default((SensorType)$this$jammedChance.getTargeting().getSensors().getType(), (double)((Number)$this$jammedChance.getTargeting().getSensors().getStrength().getValue()).doubleValue(), (double)((Number)$this$jammedChance.getElectronicWarfare().getEcmResistance().getValue()).doubleValue(), (Iterable)ecmModules, null, (Iterable)ecmDrones, null, (int)80, null);
    }

    private static final Unit TargetingStats$lambda$1(Fit $fit, int $$changed, Composer $composer, int $force) {
        TargetingStatsKt.TargetingStats($fit, $composer, RecomposeScopeImplKt.updateChangedFlags((int)($$changed | 1)));
        return Unit.INSTANCE;
    }
}

