/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.utils;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.style.TextDecoration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\r\u001a\u001c\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011\u001a\u0011\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\r\u00a2\u0006\u0002\u0010\u0014\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"trimNewlinesFromEnd", "Landroidx/compose/ui/text/AnnotatedString;", "ITALIC_STYLE", "Landroidx/compose/ui/text/SpanStyle;", "BOLD_STYLE", "UNDERLINE_STYLE", "TAG_REGEX", "Lkotlin/text/Regex;", "getTAG_REGEX", "()Lkotlin/text/Regex;", "TAG_REGEX$delegate", "Lkotlin/Lazy;", "simpleStyleTagsToAnnotatedString", "", "copyName", "name", "allNames", "Lkotlin/sequences/Sequence;", "substringIntOrNull", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "Theorycrafter"})
@SourceDebugExtension(value={"SMAP\nTextUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextUtils.kt\ntheorycrafter/utils/TextUtilsKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n170#2,6:110\n158#2,6:118\n1317#3,2:116\n295#4,2:124\n*S KotlinDebug\n*F\n+ 1 TextUtils.kt\ntheorycrafter/utils/TextUtilsKt\n*L\n18#1:110,6\n103#1:118,6\n62#1:116,2\n107#1:124,2\n*E\n"})
public final class TextUtilsKt {
    @NotNull
    private static final SpanStyle ITALIC_STYLE = new SpanStyle(0L, 0L, null, FontStyle.box-impl((int)FontStyle.Companion.getItalic-_-LCdwA()), null, null, null, 0L, null, null, null, 0L, null, null, null, null, 65527, null);
    @NotNull
    private static final SpanStyle BOLD_STYLE = new SpanStyle(0L, 0L, FontWeight.Companion.getBold(), null, null, null, null, 0L, null, null, null, 0L, null, null, null, null, 65531, null);
    @NotNull
    private static final SpanStyle UNDERLINE_STYLE = new SpanStyle(0L, 0L, null, null, null, null, null, 0L, null, null, null, 0L, TextDecoration.Companion.getUnderline(), null, null, null, 61439, null);
    @NotNull
    private static final Lazy TAG_REGEX$delegate = LazyKt.lazy(TextUtilsKt::TAG_REGEX_delegate$lambda$1);

    @NotNull
    public static final AnnotatedString trimNewlinesFromEnd(@NotNull AnnotatedString $this$trimNewlinesFromEnd) {
        int n;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$trimNewlinesFromEnd, (String)"<this>");
            CharSequence $this$indexOfLast$iv = (CharSequence)$this$trimNewlinesFromEnd;
            boolean $i$f$indexOfLast = false;
            int n2 = $this$indexOfLast$iv.length() + -1;
            if (0 <= n2) {
                do {
                    int index$iv = n2--;
                    char it = $this$indexOfLast$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(it != '\n')) continue;
                    n = index$iv;
                    break block2;
                } while (0 <= n2);
            }
            n = -1;
        }
        int lastNonNewlineIndex = n;
        return $this$trimNewlinesFromEnd.subSequence(0, lastNonNewlineIndex + 1);
    }

    private static final Regex getTAG_REGEX() {
        Lazy lazy = TAG_REGEX$delegate;
        return (Regex)lazy.getValue();
    }

    @NotNull
    public static final AnnotatedString simpleStyleTagsToAnnotatedString(@NotNull String $this$simpleStyleTagsToAnnotatedString) {
        Intrinsics.checkNotNullParameter((Object)$this$simpleStyleTagsToAnnotatedString, (String)"<this>");
        ArrayList<Integer> italicStack = new ArrayList<Integer>(1);
        ArrayList<Integer> boldStack = new ArrayList<Integer>(1);
        ArrayList<Integer> underlineStack = new ArrayList<Integer>(1);
        List spanStyles = new ArrayList();
        CharSequence charSequence = $this$simpleStyleTagsToAnnotatedString;
        Object object = TextUtilsKt.getTAG_REGEX();
        String string = "";
        String linksStripped = object.replace(charSequence, string);
        Object $this$simpleStyleTagsToAnnotatedString_u24lambda_u243 = object = new StringBuilder();
        boolean bl = false;
        char[] cArray = new char[]{'<', '>'};
        Sequence $this$forEach$iv = StringsKt.splitToSequence$default((CharSequence)linksStripped, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            switch (it) {
                case "i": 
                case "I": {
                    Comparable<StringBuilder> comparable = italicStack.add(((StringBuilder)$this$simpleStyleTagsToAnnotatedString_u24lambda_u243).length());
                    break;
                }
                case "b": 
                case "B": {
                    Comparable<StringBuilder> comparable = boldStack.add(((StringBuilder)$this$simpleStyleTagsToAnnotatedString_u24lambda_u243).length());
                    break;
                }
                case "u": 
                case "U": {
                    Comparable<StringBuilder> comparable = underlineStack.add(((StringBuilder)$this$simpleStyleTagsToAnnotatedString_u24lambda_u243).length());
                    break;
                }
                case "/i": 
                case "/I": {
                    Comparable<StringBuilder> comparable = spanStyles.add(new AnnotatedString.Range((Object)ITALIC_STYLE, ((Number)CollectionsKt.removeLast((List)italicStack)).intValue(), ((StringBuilder)$this$simpleStyleTagsToAnnotatedString_u24lambda_u243).length()));
                    break;
                }
                case "/b": 
                case "/B": {
                    Comparable<StringBuilder> comparable = spanStyles.add(new AnnotatedString.Range((Object)BOLD_STYLE, ((Number)CollectionsKt.removeLast((List)boldStack)).intValue(), ((StringBuilder)$this$simpleStyleTagsToAnnotatedString_u24lambda_u243).length()));
                    break;
                }
                case "/u": 
                case "/U": {
                    Comparable<StringBuilder> comparable = spanStyles.add(new AnnotatedString.Range((Object)UNDERLINE_STYLE, ((Number)CollectionsKt.removeLast((List)underlineStack)).intValue(), ((StringBuilder)$this$simpleStyleTagsToAnnotatedString_u24lambda_u243).length()));
                    break;
                }
                default: {
                    Comparable<StringBuilder> comparable = ((StringBuilder)$this$simpleStyleTagsToAnnotatedString_u24lambda_u243).append(it);
                }
            }
        }
        String string2 = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String plainText = string2;
        return new AnnotatedString(plainText, spanStyles, null, 4, null);
    }

    @NotNull
    public static final String copyName(@NotNull String name2, @NotNull Sequence<String> allNames) {
        Comparable comparable;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(allNames, (String)"allNames");
        String baseName = StringsKt.toIntOrNull((String)StringsKt.substringAfterLast$default((String)name2, (String)" copy ", null, (int)2, null)) != null ? StringsKt.substringBeforeLast$default((String)name2, (String)" copy ", null, (int)2, null) : name2;
        Iterator iterator = allNames.iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            String it = (String)iterator.next();
            boolean bl = false;
            Integer n = StringsKt.toIntOrNull((String)StringsKt.substringAfter((String)it, (String)(baseName + " copy "), (String)"0"));
            Comparable comparable2 = Integer.valueOf(n != null ? n : 0);
            while (iterator.hasNext()) {
                String it2 = (String)iterator.next();
                $i$a$-maxOfOrNull-TextUtilsKt$copyName$maxCopyNumber$1 = false;
                Integer n2 = StringsKt.toIntOrNull((String)StringsKt.substringAfter((String)it2, (String)(baseName + " copy "), (String)"0"));
                Comparable comparable3 = Integer.valueOf(n2 != null ? n2 : 0);
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        int maxCopyNumber = n != null ? n : 0;
        return baseName + " copy " + (maxCopyNumber + 1);
    }

    @Nullable
    public static final Integer substringIntOrNull(@NotNull String $this$substringIntOrNull) {
        Object v1;
        int firstDigitIndex;
        block4: {
            block3: {
                int n;
                Intrinsics.checkNotNullParameter((Object)$this$substringIntOrNull, (String)"<this>");
                CharSequence $this$indexOfFirst$iv = $this$substringIntOrNull;
                boolean $i$f$indexOfFirst = false;
                int n2 = $this$indexOfFirst$iv.length();
                for (int index$iv = 0; index$iv < n2; ++index$iv) {
                    char it = $this$indexOfFirst$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!Character.isDigit(it)) continue;
                    n = index$iv;
                    break block3;
                }
                n = firstDigitIndex = -1;
            }
            if (firstDigitIndex == -1) {
                return null;
            }
            Iterable $this$firstOrNull$iv = (Iterable)new IntRange(firstDigitIndex + 1, StringsKt.getLastIndex((CharSequence)$this$substringIntOrNull));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                if (!(!Character.isDigit($this$substringIntOrNull.charAt(it)))) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        Integer n = v1;
        int endIndex = n != null ? n.intValue() : $this$substringIntOrNull.length();
        String string = $this$substringIntOrNull.substring(firstDigitIndex, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return StringsKt.toIntOrNull((String)string);
    }

    private static final Regex TAG_REGEX_delegate$lambda$1() {
        return new Regex("<(?!/?i\\b|/?b\\b|/?u\\b)[^>]*>", RegexOption.IGNORE_CASE);
    }
}

