/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.fitting;

import eve.data.ChargeType;
import eve.data.ModuleType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import theorycrafter.fitting.AttributeProperty;
import theorycrafter.fitting.Charge;
import theorycrafter.fitting.MechanicsKt;
import theorycrafter.fitting.Module;
import theorycrafter.fitting.ModuleOrDrone;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001:\u0001 B-\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J\u0012\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0004J.\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u000e2\u0018\b\u0004\u0010\u001f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\b0\u0006H\u0086\b\u00f8\u0001\u0000R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006!"}, d2={"Ltheorycrafter/fitting/ItemActivationHeap;", "", "items", "", "Ltheorycrafter/fitting/ModuleOrDrone;", "includeReloadTime", "Lkotlin/Function1;", "Ltheorycrafter/fitting/Module;", "", "<init>", "(Ljava/util/Collection;Lkotlin/jvm/functions/Function1;)V", "getIncludeReloadTime", "()Lkotlin/jvm/functions/Function1;", "value", "", "currentTime", "getCurrentTime", "()I", "queue", "Ljava/util/PriorityQueue;", "Ltheorycrafter/fitting/ItemActivationHeap$Entry;", "readyToActivate", "", "activationsUntilReload", "", "onActivated", "", "entry", "item", "advanceClock", "delta", "onReadyToActivate", "Entry", "FittingEngine"})
@SourceDebugExtension(value={"SMAP\nMechanics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Mechanics.kt\ntheorycrafter/fitting/ItemActivationHeap\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1612:1\n360#2,7:1613\n*S KotlinDebug\n*F\n+ 1 Mechanics.kt\ntheorycrafter/fitting/ItemActivationHeap\n*L\n634#1:1613,7\n*E\n"})
final class ItemActivationHeap {
    @NotNull
    private final Function1<Module, Boolean> includeReloadTime;
    private int currentTime;
    @NotNull
    private final PriorityQueue<Entry> queue;
    @NotNull
    private final List<Entry> readyToActivate;
    @NotNull
    private final Map<Module, Integer> activationsUntilReload;

    public ItemActivationHeap(@NotNull Collection<? extends ModuleOrDrone<?>> items, @NotNull Function1<? super Module, Boolean> includeReloadTime) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter(includeReloadTime, (String)"includeReloadTime");
        this.includeReloadTime = includeReloadTime;
        this.queue = new PriorityQueue(RangesKt.coerceAtLeast((int)items.size(), (int)1));
        for (ModuleOrDrone<?> module : items) {
            this.queue.offer(new Entry(module, this.currentTime));
        }
        this.readyToActivate = new ArrayList(2);
        this.activationsUntilReload = new LinkedHashMap();
        for (ModuleOrDrone<?> item : items) {
            Charge charge;
            if (!(item instanceof Module) || !((Boolean)this.includeReloadTime.invoke(item)).booleanValue() || ((Module)item).getLoadedCharge() == null) continue;
            Integer n = MechanicsKt.maxLoadedChargeAmount((ModuleType)((Module)item).getType(), (ChargeType)charge.getType());
            if (n == null) {
                continue;
            }
            int chargeCount = n;
            Integer n2 = chargeCount;
            this.activationsUntilReload.put((Module)item, n2);
        }
    }

    @NotNull
    public final Function1<Module, Boolean> getIncludeReloadTime() {
        return this.includeReloadTime;
    }

    public final int getCurrentTime() {
        return this.currentTime;
    }

    private final void onActivated(Entry entry) {
        ModuleOrDrone<?> item = entry.getItem();
        AttributeProperty<Double> attributeProperty = item.getActivationDuration();
        Intrinsics.checkNotNull(attributeProperty);
        double activationDuration = ((Number)attributeProperty.getValue()).doubleValue();
        Object object = item instanceof Module ? (Module)item : null;
        double reactivationDelay = object != null && (object = ((Module)object).getReactivationDelay()) != null ? ((Number)((AttributeProperty)object).getValue()).doubleValue() : 0.0;
        entry.setNextActivationTime(entry.getNextActivationTime() + (activationDuration + reactivationDelay));
        if (item instanceof Module) {
            Integer activations;
            Integer n = activations = this.activationsUntilReload.computeIfPresent((Module)item, (BiFunction<Module, Integer, Integer>)((BiFunction<Object, Object, Integer>)(arg_0, arg_1) -> ItemActivationHeap.onActivated$lambda$1(ItemActivationHeap::onActivated$lambda$0, arg_0, arg_1)));
            if (n != null && n == 0) {
                ModuleType moduleType = (ModuleType)((Module)item).getType();
                Charge charge = ((Module)item).getLoadedCharge();
                Intrinsics.checkNotNull((Object)charge);
                Integer n2 = MechanicsKt.maxLoadedChargeAmount(moduleType, (ChargeType)charge.getType());
                Intrinsics.checkNotNull((Object)n2);
                this.activationsUntilReload.put((Module)item, n2);
                AttributeProperty<Double> attributeProperty2 = ((Module)item).getReloadTime();
                entry.setNextActivationTime(entry.getNextActivationTime() + (attributeProperty2 != null ? ((Number)attributeProperty2.getValue()).doubleValue() : 0.0));
            }
        }
        this.queue.offer(entry);
    }

    public final void onActivated(@NotNull ModuleOrDrone<?> item) {
        int index;
        block3: {
            int n;
            Intrinsics.checkNotNullParameter(item, (String)"item");
            List<Entry> $this$indexOfFirst$iv = this.readyToActivate;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<Entry> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                Entry item$iv;
                Entry it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual(it.getItem(), item)) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (index < 0) {
            throw new IllegalArgumentException(item + " is unknown or is not ready to be activated");
        }
        Entry entry = this.readyToActivate.remove(index);
        this.onActivated(entry);
    }

    public final void advanceClock(int delta, @NotNull Function1<? super ModuleOrDrone<?>, Boolean> onReadyToActivate) {
        Intrinsics.checkNotNullParameter(onReadyToActivate, (String)"onReadyToActivate");
        boolean $i$f$advanceClock = false;
        this.currentTime = this.getCurrentTime() + delta;
        while (!this.queue.isEmpty() && !(((Entry)this.queue.peek()).getNextActivationTime() > (double)this.getCurrentTime())) {
            Entry entry = (Entry)this.queue.poll();
            if (((Boolean)onReadyToActivate.invoke(entry.getItem())).booleanValue()) {
                Intrinsics.checkNotNull((Object)entry);
                this.onActivated(entry);
                continue;
            }
            List list = this.readyToActivate;
            Intrinsics.checkNotNull((Object)entry);
            list.add(entry);
        }
        return;
    }

    private static final Integer onActivated$lambda$0(Module module, Integer count) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)count, (String)"count");
        return count - 1;
    }

    private static final Integer onActivated$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Ltheorycrafter/fitting/ItemActivationHeap$Entry;", "", "item", "Ltheorycrafter/fitting/ModuleOrDrone;", "nextActivationTime", "", "<init>", "(Ltheorycrafter/fitting/ModuleOrDrone;D)V", "getItem", "()Ltheorycrafter/fitting/ModuleOrDrone;", "getNextActivationTime", "()D", "setNextActivationTime", "(D)V", "compareTo", "", "other", "FittingEngine"})
    private static final class Entry
    implements Comparable<Entry> {
        @NotNull
        private final ModuleOrDrone<?> item;
        private double nextActivationTime;

        public Entry(@NotNull ModuleOrDrone<?> item, double nextActivationTime) {
            Intrinsics.checkNotNullParameter(item, (String)"item");
            this.item = item;
            this.nextActivationTime = nextActivationTime;
        }

        @NotNull
        public final ModuleOrDrone<?> getItem() {
            return this.item;
        }

        public final double getNextActivationTime() {
            return this.nextActivationTime;
        }

        public final void setNextActivationTime(double d) {
            this.nextActivationTime = d;
        }

        @Override
        public int compareTo(@NotNull Entry other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.nextActivationTime < other.nextActivationTime ? -1 : (this.nextActivationTime > other.nextActivationTime ? 1 : 0);
        }
    }
}

