/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.fitting;

import androidx.compose.runtime.Stable;
import eve.data.ChargeType;
import eve.data.DamageType;
import eve.data.DroneType;
import eve.data.MiscKt;
import eve.data.ModuleType;
import eve.data.SensorType;
import eve.data.utils.ValueByEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import theorycrafter.fitting.AttributeProperty;
import theorycrafter.fitting.CapacitorSimulation;
import theorycrafter.fitting.CapacitorStability;
import theorycrafter.fitting.CapacitorStableAtFullSimulation;
import theorycrafter.fitting.Charge;
import theorycrafter.fitting.DroneGroup;
import theorycrafter.fitting.Fit;
import theorycrafter.fitting.ItemActivationHeap;
import theorycrafter.fitting.MechanicsKt;
import theorycrafter.fitting.MissileRange;
import theorycrafter.fitting.Module;
import theorycrafter.fitting.ModuleOrDrone;
import theorycrafter.fitting.utils.MathUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u00aa\u0001\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a3\u0010\u0005\u001a\u00020\u0001\"\f\b\u0000\u0010\u0006*\u0006\u0012\u0002\b\u00030\u0007*\u0002H\u00062\u0006\u0010\u0002\u001a\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t\u00a2\u0006\u0002\u0010\n\u001a&\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u0018\u0010\u0010\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001H\u0002\u001a&\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001\u001a\u001e\u0010\u0014\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001\u001a&\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001\u001a\u0016\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001\u001a0\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0001H\u0007\u001a,\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00010\u001ej\u0002` *\u0012\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00010\u001ej\u0002` H\u0003\u001a:\u0010!\u001a\u00020\u00012\u0016\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00010\u001ej\u0002`#2\u0018\b\u0002\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00010\u001ej\u0002` H\u0007\u001a\u0010\u0010!\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u0001H\u0007\u001a\u001d\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+\u00a2\u0006\u0002\u0010,\u001a \u0010-\u001a\u00020\u00012\u0006\u0010.\u001a\u00020\u00012\u0006\u0010/\u001a\u00020\u00012\u0006\u00100\u001a\u00020\u0001H\u0007\u001aj\u00101\u001a\u0012\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00010\u001ej\u0002`#2\u0016\u00102\u001a\u0012\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00010\u001ej\u0002`#2\u0016\u00103\u001a\u0012\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00010\u001ej\u0002`#2\u0006\u00104\u001a\u00020\u00012\u0018\b\u0002\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00010\u001ej\u0002` H\u0007\u001a(\u00105\u001a\u00020\u00012\u0006\u00106\u001a\u00020\u00012\u0006\u00107\u001a\u00020'2\u0006\u0010/\u001a\u00020\u00012\u0006\u00108\u001a\u00020\u0001H\u0007\u001a \u00109\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\u00012\u0006\u0010;\u001a\u00020\u00012\u0006\u0010<\u001a\u00020\u0001H\u0007\u001a\u0018\u0010=\u001a\u00020\u00012\u0006\u0010;\u001a\u00020\u00012\u0006\u0010<\u001a\u00020\u0001H\u0007\u001aL\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u00012\u0006\u0010<\u001a\u00020\u00012\u0006\u0010A\u001a\u00020\u00012\f\u0010B\u001a\b\u0012\u0004\u0012\u00020D0C2\u0010\u0010E\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070C2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020D0C\u001a\n\u0010G\u001a\u00020H*\u00020D\u001a\u000e\u0010I\u001a\u00020H*\u0006\u0012\u0002\b\u00030\u0007\u001a\n\u0010J\u001a\u00020H*\u00020D\u001aL\u0010K\u001a\u00020L2\u0006\u0010@\u001a\u00020\u00012\u0006\u0010<\u001a\u00020\u00012\u0006\u0010A\u001a\u00020\u00012\f\u0010B\u001a\b\u0012\u0004\u0012\u00020D0C2\u0010\u0010E\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070C2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020D0C\u001a(\u0010Q\u001a\u00020'2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\u00012\u0006\u0010U\u001a\u00020'2\u0006\u0010V\u001a\u00020'H\u0007\u001a(\u0010W\u001a\u00020H2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\u00012\u0006\u0010U\u001a\u00020'2\u0006\u0010V\u001a\u00020'H\u0007\u001ax\u0010[\u001a\u00020\u00012\u0006\u0010\\\u001a\u00020Z2\u0006\u0010]\u001a\u00020\u00012\b\b\u0002\u0010^\u001a\u00020\u00012\u000e\b\u0002\u0010_\u001a\b\u0012\u0004\u0012\u00020D0`2\u001a\b\u0002\u0010a\u001a\u0014\u0012\u0004\u0012\u00020D\u0012\u0004\u0012\u00020Z\u0012\u0004\u0012\u00020\u00010Y2\u000e\b\u0002\u0010b\u001a\b\u0012\u0004\u0012\u00020c0`2\u001a\b\u0002\u0010d\u001a\u0014\u0012\u0004\u0012\u00020c\u0012\u0004\u0012\u00020Z\u0012\u0004\u0012\u00020\u00010Y\u001a.\u0010[\u001a\u00020\u00012\u0006\u0010e\u001a\u00020f2\u000e\b\u0002\u0010_\u001a\b\u0012\u0004\u0012\u00020D0`2\u000e\b\u0002\u0010b\u001a\b\u0012\u0004\u0012\u00020c0`\u001ax\u0010g\u001a\u00020\u00012\u0006\u0010\\\u001a\u00020Z2\u0006\u0010]\u001a\u00020\u00012\b\b\u0002\u0010^\u001a\u00020\u00012\u000e\b\u0002\u0010_\u001a\b\u0012\u0004\u0012\u00020D0`2\u001a\b\u0002\u0010a\u001a\u0014\u0012\u0004\u0012\u00020D\u0012\u0004\u0012\u00020Z\u0012\u0004\u0012\u00020\u00010Y2\u000e\b\u0002\u0010b\u001a\b\u0012\u0004\u0012\u00020c0`2\u001a\b\u0002\u0010d\u001a\u0014\u0012\u0004\u0012\u00020c\u0012\u0004\u0012\u00020Z\u0012\u0004\u0012\u00020\u00010Y\u001a\u0018\u0010h\u001a\u00020'2\u0006\u0010i\u001a\u00020\u00012\u0006\u0010j\u001a\u00020\u0001H\u0007\u001a\u0018\u0010k\u001a\u00020\u00012\u0006\u0010l\u001a\u00020\u00012\u0006\u0010m\u001a\u00020\u0001H\u0007\u001a@\u0010n\u001a\u00020\u00012\u0006\u0010o\u001a\u00020\u00012\u0006\u0010p\u001a\u00020\u00012\u0006\u0010m\u001a\u00020\u00012\u0006\u0010q\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0003\u001aH\u0010r\u001a\u00020\u00012\u0006\u0010s\u001a\u00020\u00012\u0006\u0010o\u001a\u00020\u00012\u0006\u0010m\u001a\u00020\u00012\u0006\u0010p\u001a\u00020\u00012\u0006\u0010q\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010t\u001a\u00020HH\u0007\u001a0\u0010o\u001a\u00020\u00012\u0006\u0010s\u001a\u00020\u00012\u0006\u0010u\u001a\u00020\u00012\u0006\u0010v\u001a\u00020\u00012\u0006\u0010w\u001a\u00020\u00012\u0006\u0010x\u001a\u00020\u0001H\u0007\u001a0\u0010y\u001a\u00020\u00012\u0006\u0010z\u001a\u00020\u00012\u0006\u0010{\u001a\u00020\u00012\u0006\u0010|\u001a\u00020\u00012\u0006\u0010}\u001a\u00020\u00012\u0006\u0010~\u001a\u00020\u0001H\u0007\u001a\u0018\u0010\u007f\u001a\u00020\u00012\u0006\u0010z\u001a\u00020\u00012\u0006\u0010~\u001a\u00020\u0001H\u0007\u001a8\u0010\u0080\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0081\u00012\u0007\u0010\u0082\u0001\u001a\u00020\u00012\u0007\u0010\u0083\u0001\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001H\u0007\"\u000e\u0010\u0017\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010M\u001a\u00020NX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010O\u001a\u00020'X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010P\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"$\u0010X\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020Z\u0012\u0004\u0012\u00020\u00010YX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0084\u0001"}, d2={"effectivenessAtDistance", "", "distance", "optimal", "falloff", "effectAtDistance", "T", "Ltheorycrafter/fitting/ModuleOrDrone;", "effectAtOptimal", "Lkotlin/Function0;", "(Ltheorycrafter/fitting/ModuleOrDrone;DLkotlin/jvm/functions/Function0;)D", "maxVelocity", "baseMaxVelocity", "mass", "propulsionModuleSpeedFactor", "propulsionModuleThrust", "inertia", "inertiaModifier", "velocity", "timeSec", "timeToFractionOfMaxVelocity", "fraction", "distanceTravelled", "LN_2", "alignTime", "missileRange", "Ltheorycrafter/fitting/MissileRange;", "flightTimeMs", "shipRadius", "normalize", "Leve/data/utils/ValueByEnum;", "Leve/data/DamageType;", "Leve/data/DamagePattern;", "resistFactor", "resonances", "Leve/data/ResonancePattern;", "damagePattern", "resonance", "maxLoadedChargeAmount", "", "moduleType", "Leve/data/ModuleType;", "chargeType", "Leve/data/ChargeType;", "(Leve/data/ModuleType;Leve/data/ChargeType;)Ljava/lang/Integer;", "dps", "volley", "durationMs", "reactivationDelayMs", "computeNextReactiveArmorResonances", "shipArmorResonances", "rahResonances", "resistanceShiftAmount", "capBoostedPerSecond", "capacitorBonus", "chargeCount", "reloadTimeMs", "rechargeRate", "value", "maxValue", "rechargeTime", "maxRechargeRate", "capacitorSimulation", "Ltheorycrafter/fitting/CapacitorSimulation;", "totalCapacity", "energyNeutralizationResistance", "localModules", "", "Ltheorycrafter/fitting/Module;", "hostileItems", "friendlyModules", "isRelevantForCapacitorStabilityAsLocalModule", "", "isRelevantForCapacitorStabilityAsHostileItem", "isRelevantForCapacitorStabilityAsFriendlyModule", "capacitorStability", "Ltheorycrafter/fitting/CapacitorStability;", "CapacitorStabilityMaxSimulatedTimeMillis", "", "TimeWithoutBreakingMinimumCapForStabilityMillis", "CapDeltaForBreakingMinimum", "maxDroneGroupSize", "droneType", "Leve/data/DroneType;", "fitBandwidth", "fitCapacity", "maxActiveDrones", "canDroneTypeBeFitted", "DefaultEcmStrength", "Lkotlin/Function2;", "Leve/data/SensorType;", "jamChance", "sensorType", "sensorStrength", "ecmResistance", "ecmModules", "", "appliedModuleEcmStrength", "ecmDrones", "Ltheorycrafter/fitting/DroneGroup;", "appliedDroneEcmStrength", "targetFit", "Ltheorycrafter/fitting/Fit;", "timeFractionJammed", "crystalLifeExpectancyCycles", "volatilityChance", "volatilityDamage", "lockTime", "scanResolution", "signatureRadius", "chanceToHit", "angularVelocity", "trackingSpeed", "signatureResolution", "turretDamageCoefficient", "centersDistance", "includeWreckingShots", "speed1", "direction1", "speed2", "direction2", "missileDamageCoefficient", "explosionRadius", "explosionVelocity", "drf", "targetSpeed", "targetSignatureRadius", "bombDamageCoefficient", "orbitRadiusAndSpeed", "Lkotlin/Pair;", "requestedRadius", "requestedSpeed", "FittingEngine"})
@SourceDebugExtension(value={"SMAP\nMechanics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Mechanics.kt\ntheorycrafter/fitting/MechanicsKt\n+ 2 ValueByEnum.kt\neve/data/utils/ValueByEnumKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1612:1\n39#2,3:1613\n39#2,3:1617\n39#2,3:1621\n1#3:1616\n1062#4:1620\n774#4:1624\n865#4,2:1625\n1279#4,2:1627\n1293#4,4:1629\n774#4:1633\n865#4,2:1634\n1279#4,2:1636\n1293#4,4:1638\n774#4:1642\n865#4,2:1643\n1279#4,2:1645\n1293#4,4:1647\n1734#4,3:1651\n*S KotlinDebug\n*F\n+ 1 Mechanics.kt\ntheorycrafter/fitting/MechanicsKt\n*L\n328#1:1613,3\n417#1:1617,3\n442#1:1621,3\n422#1:1620\n820#1:1624\n820#1:1625,2\n821#1:1627,2\n821#1:1629,4\n836#1:1633\n836#1:1634,2\n837#1:1636,2\n837#1:1638,4\n851#1:1642\n851#1:1643,2\n852#1:1645,2\n852#1:1647,4\n864#1:1651,3\n*E\n"})
public final class MechanicsKt {
    private static final double LN_2 = Math.log(2.0);
    private static final long CapacitorStabilityMaxSimulatedTimeMillis = Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)60, (DurationUnit)DurationUnit.MINUTES));
    public static final int TimeWithoutBreakingMinimumCapForStabilityMillis = 120000;
    public static final double CapDeltaForBreakingMinimum = 0.1;
    @NotNull
    private static final Function2<ModuleOrDrone<?>, SensorType, Double> DefaultEcmStrength = MechanicsKt::DefaultEcmStrength$lambda$17;

    public static final double effectivenessAtDistance(double distance, double optimal, double falloff) {
        return distance <= optimal ? 1.0 : (falloff > 0.0 ? Math.pow(0.5, MathUtilsKt.sqr((distance - optimal) / falloff)) : 0.0);
    }

    public static final <T extends ModuleOrDrone<?>> double effectAtDistance(@NotNull T $this$effectAtDistance, double distance, @NotNull Function0<Double> effectAtOptimal) {
        Intrinsics.checkNotNullParameter($this$effectAtDistance, (String)"<this>");
        Intrinsics.checkNotNullParameter(effectAtOptimal, (String)"effectAtOptimal");
        AttributeProperty<Double> attributeProperty = $this$effectAtDistance.getOptimalRange();
        if (attributeProperty == null) {
            return 0.0;
        }
        double optimal = ((Number)attributeProperty.getValue()).doubleValue();
        AttributeProperty<Double> attributeProperty2 = $this$effectAtDistance.getFalloffRange();
        double falloff = attributeProperty2 != null ? ((Number)attributeProperty2.getValue()).doubleValue() : 0.0;
        double effectiveness = MechanicsKt.effectivenessAtDistance(distance, optimal, falloff);
        double maxEffect = ((Number)effectAtOptimal.invoke()).doubleValue();
        return maxEffect * effectiveness;
    }

    public static final double maxVelocity(double baseMaxVelocity, double mass, double propulsionModuleSpeedFactor, double propulsionModuleThrust) {
        return baseMaxVelocity * (1.0 + propulsionModuleSpeedFactor * (propulsionModuleThrust / mass));
    }

    private static final double inertia(double mass, double inertiaModifier) {
        return mass * inertiaModifier * 1.0E-6;
    }

    public static final double velocity(double maxVelocity, double mass, double inertiaModifier, double timeSec) {
        return maxVelocity * (1.0 - Math.exp(-timeSec / MechanicsKt.inertia(mass, inertiaModifier)));
    }

    public static final double timeToFractionOfMaxVelocity(double mass, double inertiaModifier, double fraction) {
        return -MechanicsKt.inertia(mass, inertiaModifier) * Math.log(1.0 - fraction);
    }

    public static final double distanceTravelled(double maxVelocity, double mass, double inertiaModifier, double timeSec) {
        double inertia = MechanicsKt.inertia(mass, inertiaModifier);
        return maxVelocity * (timeSec + inertia * (Math.exp(-timeSec / inertia) - 1.0));
    }

    public static final double alignTime(double inertiaModifier, double mass) {
        return LN_2 * inertiaModifier * mass / (double)500;
    }

    @Stable
    @NotNull
    public static final MissileRange missileRange(double velocity, double flightTimeMs, double mass, double inertiaModifier, double shipRadius) {
        double flightTimeSec = flightTimeMs / (double)1000;
        double actualFlightTimeSec = flightTimeSec + shipRadius / velocity;
        double lessTimeSec = Math.floor(actualFlightTimeSec);
        double moreTimeSec = Math.ceil(actualFlightTimeSec);
        return new MissileRange(MechanicsKt.missileRange$range(velocity, mass, inertiaModifier, lessTimeSec) - shipRadius, moreTimeSec - actualFlightTimeSec, MechanicsKt.missileRange$range(velocity, mass, inertiaModifier, moreTimeSec) - shipRadius, actualFlightTimeSec - lessTimeSec);
    }

    /*
     * WARNING - void declaration
     */
    @Stable
    private static final ValueByEnum<DamageType, Double> normalize(ValueByEnum<DamageType, Double> $this$normalize) {
        double sum = CollectionsKt.sumOfDouble((Iterable)$this$normalize.getValues());
        if (sum == 1.0) {
            return $this$normalize;
        }
        boolean $i$f$valueByEnum = false;
        DamageType[] enumValues$iv = DamageType.values();
        int n = 0;
        int n2 = enumValues$iv.length;
        Object[] objectArray = new Double[n2];
        while (n < n2) {
            void it;
            int n3 = n++;
            DamageType damageType = enumValues$iv[n3];
            int n4 = n3;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            Double d = ((Number)$this$normalize.get((Enum)it)).doubleValue() / sum;
            objectArray2[n4] = d;
        }
        Object[] valueByOrdinal$iv = objectArray;
        return new ValueByEnum(valueByOrdinal$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Stable
    public static final double resistFactor(@NotNull ValueByEnum<DamageType, Double> resonances, @NotNull ValueByEnum<DamageType, Double> damagePattern) {
        double d;
        Intrinsics.checkNotNullParameter(resonances, (String)"resonances");
        Intrinsics.checkNotNullParameter(damagePattern, (String)"damagePattern");
        ValueByEnum<DamageType, Double> normalDamagePattern = MechanicsKt.normalize(damagePattern);
        Iterable iterable = (Iterable)DamageType.getEntries();
        double d2 = 1.0;
        double d3 = 0.0;
        for (Object t : iterable) {
            void it;
            DamageType damageType = (DamageType)t;
            d = d3;
            boolean bl = false;
            double d4 = ((Number)normalDamagePattern.get((Enum)it)).doubleValue() * ((Number)resonances.get((Enum)it)).doubleValue();
            d3 = d + d4;
        }
        d = d3;
        return d2 / d;
    }

    public static /* synthetic */ double resistFactor$default(ValueByEnum valueByEnum, ValueByEnum valueByEnum2, int n, Object object) {
        if ((n & 2) != 0) {
            valueByEnum2 = MiscKt.getUNIFORM_DAMAGE_PATTERN();
        }
        return MechanicsKt.resistFactor((ValueByEnum<DamageType, Double>)valueByEnum, (ValueByEnum<DamageType, Double>)valueByEnum2);
    }

    @Stable
    public static final double resistFactor(double resonance) {
        return 1.0 / resonance;
    }

    @Nullable
    public static final Integer maxLoadedChargeAmount(@NotNull ModuleType moduleType, @NotNull ChargeType chargeType) {
        Intrinsics.checkNotNullParameter((Object)moduleType, (String)"moduleType");
        Intrinsics.checkNotNullParameter((Object)chargeType, (String)"chargeType");
        if (!moduleType.canLoadCharge(chargeType)) {
            return null;
        }
        Double d = moduleType.getChargeCapacity();
        if (d == null) {
            return null;
        }
        double capacity = d;
        return (int)(capacity / chargeType.getVolume());
    }

    @Stable
    public static final double dps(double volley, double durationMs, double reactivationDelayMs) {
        double cycleTimeSec = (durationMs + reactivationDelayMs) / 1000.0;
        return volley / cycleTimeSec;
    }

    /*
     * WARNING - void declaration
     */
    @Stable
    @NotNull
    public static final ValueByEnum<DamageType, Double> computeNextReactiveArmorResonances(@NotNull ValueByEnum<DamageType, Double> shipArmorResonances, @NotNull ValueByEnum<DamageType, Double> rahResonances, double resistanceShiftAmount, @NotNull ValueByEnum<DamageType, Double> damagePattern) {
        int i;
        Double d;
        Object[] objectArray;
        int n;
        Intrinsics.checkNotNullParameter(shipArmorResonances, (String)"shipArmorResonances");
        Intrinsics.checkNotNullParameter(rahResonances, (String)"rahResonances");
        Intrinsics.checkNotNullParameter(damagePattern, (String)"damagePattern");
        boolean $i$f$valueByEnum = false;
        DamageType[] enumValues$iv = DamageType.values();
        int n2 = 0;
        int n3 = enumValues$iv.length;
        Object[] objectArray2 = new Double[n3];
        while (n2 < n3) {
            void it;
            int n4 = n2++;
            DamageType damageType = enumValues$iv[n4];
            n = n4;
            objectArray = objectArray2;
            boolean bl = false;
            d = ((Number)shipArmorResonances.get((Enum)it)).doubleValue() * ((Number)damagePattern.get((Enum)it)).doubleValue();
            objectArray[n] = d;
        }
        Object[] valueByOrdinal$iv = objectArray2;
        ValueByEnum incomingDamage = new ValueByEnum(valueByOrdinal$iv);
        Iterable $this$sortedByDescending$iv = (Iterable)DamageType.getEntries();
        boolean $i$f$sortedByDescending = false;
        List sortedDamageTypes = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(incomingDamage){
            final /* synthetic */ ValueByEnum $incomingDamage$inlined;
            {
                this.$incomingDamage$inlined = valueByEnum;
            }

            public final int compare(T a, T b) {
                DamageType it = (DamageType)b;
                boolean bl = false;
                Comparable comparable = (Double)this.$incomingDamage$inlined.get((Enum)it);
                it = (DamageType)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)this.$incomingDamage$inlined.get((Enum)it)));
            }
        });
        Map shiftByDamageType = new LinkedHashMap();
        int givenCount = ((Number)incomingDamage.get((Enum)sortedDamageTypes.get(1))).doubleValue() == 0.0 ? 1 : 2;
        int takenCount = 4 - givenCount;
        double given = 0.0;
        for (i = givenCount; i < 4; ++i) {
            DamageType damageType = (DamageType)sortedDamageTypes.get(i);
            double taken = RangesKt.coerceAtMost((double)(resistanceShiftAmount / (double)takenCount), (double)(1.0 - ((Number)rahResonances.get((Enum)damageType)).doubleValue()));
            Double d2 = taken;
            shiftByDamageType.put(damageType, d2);
            given += taken;
        }
        for (i = 0; i < givenCount; ++i) {
            shiftByDamageType.put(sortedDamageTypes.get(i), -given / (double)givenCount);
        }
        boolean $i$f$valueByEnum2 = false;
        DamageType[] enumValues$iv2 = DamageType.values();
        int n5 = 0;
        int n6 = enumValues$iv2.length;
        Object[] objectArray3 = new Double[n6];
        while (n5 < n6) {
            void it;
            int n7 = n5++;
            DamageType damageType = enumValues$iv2[n7];
            n = n7;
            objectArray = objectArray3;
            boolean bl = false;
            double d3 = ((Number)rahResonances.get((Enum)it)).doubleValue();
            Object v = shiftByDamageType.get(it);
            Intrinsics.checkNotNull(v);
            d = d3 + ((Number)v).doubleValue();
            objectArray[n] = d;
        }
        Object[] valueByOrdinal$iv2 = objectArray3;
        return new ValueByEnum(valueByOrdinal$iv2);
    }

    public static /* synthetic */ ValueByEnum computeNextReactiveArmorResonances$default(ValueByEnum valueByEnum, ValueByEnum valueByEnum2, double d, ValueByEnum valueByEnum3, int n, Object object) {
        if ((n & 8) != 0) {
            valueByEnum3 = MiscKt.getUNIFORM_DAMAGE_PATTERN();
        }
        return MechanicsKt.computeNextReactiveArmorResonances((ValueByEnum<DamageType, Double>)valueByEnum, (ValueByEnum<DamageType, Double>)valueByEnum2, d, (ValueByEnum<DamageType, Double>)valueByEnum3);
    }

    @Stable
    public static final double capBoostedPerSecond(double capacitorBonus, int chargeCount, double durationMs, double reloadTimeMs) {
        double timeBetweenReloadsMs = durationMs * (double)chargeCount + reloadTimeMs;
        double capBoostedBetweenReloads = (double)chargeCount * capacitorBonus;
        return capBoostedBetweenReloads / timeBetweenReloadsMs * (double)1000;
    }

    @Stable
    public static final double rechargeRate(double value, double maxValue, double rechargeTime) {
        double ratio = value / maxValue;
        double rechargeTimeSec = rechargeTime / (double)1000;
        return (double)10 * maxValue / rechargeTimeSec * (Math.sqrt(ratio) - ratio);
    }

    @Stable
    public static final double maxRechargeRate(double maxValue, double rechargeTime) {
        double rechargeTimeSec = rechargeTime / (double)1000;
        return (double)10 * maxValue / rechargeTimeSec * 0.25;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CapacitorSimulation capacitorSimulation(double totalCapacity, double rechargeTime, double energyNeutralizationResistance, @NotNull Collection<Module> localModules, @NotNull Collection<? extends ModuleOrDrone<?>> hostileItems, @NotNull Collection<Module> friendlyModules) {
        boolean bl;
        Map capacitorGivenByItem;
        block16: {
            void $this$associateWith$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$associateWith$iv2;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2;
            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000%\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"theorycrafter/fitting/MechanicsKt$capacitorSimulation$CapacitorGiven", "", "amount", "", "atEndOfCycle", "", "<init>", "(DZ)V", "getAmount", "()D", "getAtEndOfCycle", "()Z", "component1", "component2", "copy", "(DZ)Ltheorycrafter/fitting/MechanicsKt$capacitorSimulation$CapacitorGiven;", "equals", "other", "hashCode", "", "toString", "", "FittingEngine"})
            public final class CapacitorGiven {
                private final double amount;
                private final boolean atEndOfCycle;

                public CapacitorGiven(double amount, boolean atEndOfCycle) {
                    this.amount = amount;
                    this.atEndOfCycle = atEndOfCycle;
                }

                public /* synthetic */ CapacitorGiven(double d, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 2) != 0) {
                        bl = false;
                    }
                    this(d, bl);
                }

                public final double getAmount() {
                    return this.amount;
                }

                public final boolean getAtEndOfCycle() {
                    return this.atEndOfCycle;
                }

                public final double component1() {
                    return this.amount;
                }

                public final boolean component2() {
                    return this.atEndOfCycle;
                }

                public final CapacitorGiven copy(double amount, boolean atEndOfCycle) {
                    return new CapacitorGiven(amount, atEndOfCycle);
                }

                public static /* synthetic */ CapacitorGiven copy$default(CapacitorGiven capacitorGiven, double d, boolean bl, int n, Object object) {
                    if ((n & 1) != 0) {
                        d = capacitorGiven.amount;
                    }
                    if ((n & 2) != 0) {
                        bl = capacitorGiven.atEndOfCycle;
                    }
                    return capacitorGiven.copy(d, bl);
                }

                public String toString() {
                    return "CapacitorGiven(amount=" + this.amount + ", atEndOfCycle=" + this.atEndOfCycle + ")";
                }

                public int hashCode() {
                    int result = Double.hashCode(this.amount);
                    result = result * 31 + Boolean.hashCode(this.atEndOfCycle);
                    return result;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof CapacitorGiven)) {
                        return false;
                    }
                    CapacitorGiven capacitorGiven = (CapacitorGiven)other;
                    if (Double.compare(this.amount, capacitorGiven.amount) != 0) {
                        return false;
                    }
                    return this.atEndOfCycle == capacitorGiven.atEndOfCycle;
                }
            }
            CapacitorGiven capacitorGiven;
            Map map;
            Object object;
            void $this$associateWith$iv3;
            Module p0;
            void $this$filterTo$iv$iv3;
            Iterable $this$filter$iv3;
            Intrinsics.checkNotNullParameter(localModules, (String)"localModules");
            Intrinsics.checkNotNullParameter(hostileItems, (String)"hostileItems");
            Intrinsics.checkNotNullParameter(friendlyModules, (String)"friendlyModules");
            Iterable iterable = localModules;
            boolean $i$f$filter = false;
            void var12_9 = $this$filter$iv3;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                p0 = (Module)element$iv$iv;
                boolean $i$f$capacitorSimulation$stub_for_inlining = false;
                boolean bl2 = false;
                if (!MechanicsKt.isRelevantForCapacitorStabilityAsLocalModule(p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv3 = (List)destination$iv$iv;
            boolean $i$f$associateWith22 = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv3, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv3;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                CapacitorGiven capacitorGiven2;
                void module;
                p0 = (Module)element$iv$iv;
                object = element$iv$iv;
                map = result$iv;
                boolean bl3 = false;
                if (module.getCapacitorNeed() != null) {
                    boolean bl4 = false;
                    capacitorGiven2 = new CapacitorGiven(-((Number)it.getValue()).doubleValue(), false, 2, null);
                } else if (module.getEnergyTransferred() != null) {
                    boolean bl5 = false;
                    capacitorGiven2 = new CapacitorGiven(((Number)it.getValue()).doubleValue(), true);
                } else {
                    Charge charge = module.getLoadedCharge();
                    Intrinsics.checkNotNull((Object)charge);
                    Double d = ((ChargeType)charge.getType()).getCapacitorBonus();
                    Intrinsics.checkNotNull((Object)d);
                    capacitorGiven2 = new CapacitorGiven(d, false, 2, null);
                }
                capacitorGiven = capacitorGiven2;
                map.put(object, capacitorGiven);
            }
            Map capacitorGivenByLocalModule = result$iv;
            Iterable $i$f$associateWith22 = hostileItems;
            boolean $i$f$filter2 = false;
            $this$associateWithTo$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                ModuleOrDrone p02 = (ModuleOrDrone)element$iv$iv;
                boolean $i$f$capacitorSimulation$stub_for_inlining$8 = false;
                boolean bl6 = false;
                if (!MechanicsKt.isRelevantForCapacitorStabilityAsHostileItem(p02)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            boolean $i$f$associateWith32 = false;
            LinkedHashMap result$iv2 = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv2, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv2 = $this$associateWith$iv2;
            boolean $i$f$associateWithTo2 = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv2) {
                Pair pair;
                int amount;
                void it;
                ModuleOrDrone p02 = (ModuleOrDrone)element$iv$iv;
                object = element$iv$iv;
                map = result$iv2;
                boolean bl7 = false;
                DroneGroup droneGroup = it instanceof DroneGroup ? (DroneGroup)it : null;
                int n = amount = droneGroup != null ? droneGroup.getSize() : 1;
                if (it.getEnergyNeutralized() != null) {
                    AttributeProperty<Double> attributeProperty = it.getEnergyNeutralized();
                    Intrinsics.checkNotNull(attributeProperty);
                    pair = new Pair(attributeProperty, (Object)false);
                } else {
                    Module module = it instanceof Module ? (Module)it : null;
                    AttributeProperty<Double> attributeProperty = module != null ? module.getEnergyTransferred() : null;
                    Intrinsics.checkNotNull(attributeProperty);
                    pair = new Pair(attributeProperty, (Object)true);
                }
                Pair pair2 = pair;
                AttributeProperty neutralizedProperty = (AttributeProperty)pair2.component1();
                boolean atEndOfCycle = (Boolean)pair2.component2();
                capacitorGiven = new CapacitorGiven(-((Number)neutralizedProperty.getValue()).doubleValue() * (double)amount * energyNeutralizationResistance, atEndOfCycle);
                map.put(object, capacitorGiven);
            }
            Map capacitorGivenByHostileItem = result$iv2;
            Iterable $i$f$associateWith32 = friendlyModules;
            boolean $i$f$filter3 = false;
            $this$associateWithTo$iv$iv2 = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Module p03 = (Module)element$iv$iv;
                boolean $i$f$capacitorSimulation$stub_for_inlining$10 = false;
                boolean bl8 = false;
                if (!MechanicsKt.isRelevantForCapacitorStabilityAsFriendlyModule(p03)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv3;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv3 = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv3 = $this$associateWith$iv;
            boolean $i$f$associateWithTo3 = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv3) {
                void it;
                Module p03 = (Module)element$iv$iv;
                object = element$iv$iv;
                map = result$iv3;
                boolean bl9 = false;
                AttributeProperty<Double> attributeProperty = it.getEnergyTransferred();
                Intrinsics.checkNotNull(attributeProperty);
                capacitorGiven = new CapacitorGiven(((Number)attributeProperty.getValue()).doubleValue(), true);
                map.put(object, capacitorGiven);
            }
            Map capacitorGivenByFriendlyModule = result$iv3;
            Map $this$capacitorSimulation_u24lambda_u2412 = $i$f$associateWith = MapsKt.createMapBuilder();
            boolean bl10 = false;
            $this$capacitorSimulation_u24lambda_u2412.putAll(capacitorGivenByLocalModule);
            $this$capacitorSimulation_u24lambda_u2412.putAll(capacitorGivenByHostileItem);
            $this$capacitorSimulation_u24lambda_u2412.putAll(capacitorGivenByFriendlyModule);
            capacitorGivenByItem = MapsKt.build((Map)$i$f$associateWith);
            Iterable $this$all$iv = capacitorGivenByItem.values();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    CapacitorGiven it = (CapacitorGiven)element$iv;
                    boolean bl11 = false;
                    if (it.getAmount() >= 0.0) continue;
                    bl = false;
                    break block16;
                }
                bl = true;
            }
        }
        if (bl) {
            return new CapacitorStableAtFullSimulation(totalCapacity);
        }
        ItemActivationHeap moduleActivations = new ItemActivationHeap(capacitorGivenByItem.keySet(), (Function1<? super Module, Boolean>)((Function1)arg_0 -> MechanicsKt.capacitorSimulation$lambda$14(hostileItems, arg_0)));
        Set activeItemsWithCapGivenAtEndOfCycle = new LinkedHashSet();
        return new CapacitorSimulation(totalCapacity, moduleActivations, rechargeTime, capacitorGivenByItem, activeItemsWithCapGivenAtEndOfCycle){
            private double capacity;
            final /* synthetic */ double $totalCapacity;
            final /* synthetic */ ItemActivationHeap $moduleActivations;
            final /* synthetic */ double $rechargeTime;
            final /* synthetic */ Map<ModuleOrDrone<?>, CapacitorGiven> $capacitorGivenByItem;
            final /* synthetic */ Set<ModuleOrDrone<?>> $activeItemsWithCapGivenAtEndOfCycle;
            {
                this.$totalCapacity = $totalCapacity;
                this.$moduleActivations = $moduleActivations;
                this.$rechargeTime = $rechargeTime;
                this.$capacitorGivenByItem = $capacitorGivenByItem;
                this.$activeItemsWithCapGivenAtEndOfCycle = $activeItemsWithCapGivenAtEndOfCycle;
                this.capacity = $totalCapacity;
            }

            public boolean isStableAtFull() {
                return false;
            }

            public int getCurrentTimeMillis() {
                return this.$moduleActivations.getCurrentTime();
            }

            public double getCapacity() {
                return this.capacity;
            }

            public void setCapacity(double d) {
                this.capacity = d;
            }

            /*
             * WARNING - void declaration
             */
            public void advanceClock(int deltaMillis, Function3<? super ModuleOrDrone<?>, ? super Double, ? super Boolean, Boolean> onReadyToActivate) {
                void this_$iv;
                Intrinsics.checkNotNullParameter(onReadyToActivate, (String)"onReadyToActivate");
                if (this.getCapacity() < 0.0) {
                    throw new IllegalStateException("Can't advance clock with negative capacitor");
                }
                this.setCapacity(this.getCapacity() + (double)(deltaMillis / 1000) * MechanicsKt.rechargeRate(this.getCapacity(), this.$totalCapacity, this.$rechargeTime));
                ItemActivationHeap itemActivationHeap = this.$moduleActivations;
                Map<ModuleOrDrone<?>, CapacitorGiven> map = this.$capacitorGivenByItem;
                Set<ModuleOrDrone<?>> set = this.$activeItemsWithCapGivenAtEndOfCycle;
                boolean $i$f$advanceClock = false;
                ItemActivationHeap.access$setCurrentTime$p((ItemActivationHeap)this_$iv, this_$iv.getCurrentTime() + deltaMillis);
                while (!ItemActivationHeap.access$getQueue$p((ItemActivationHeap)this_$iv).isEmpty() && !(((ItemActivationHeap.Entry)ItemActivationHeap.access$getQueue$p((ItemActivationHeap)this_$iv).peek()).getNextActivationTime() > (double)this_$iv.getCurrentTime())) {
                    boolean activate;
                    CapacitorGiven capacitorGiven;
                    ItemActivationHeap.Entry entry$iv = (ItemActivationHeap.Entry)ItemActivationHeap.access$getQueue$p((ItemActivationHeap)this_$iv).poll();
                    ModuleOrDrone<?> item = entry$iv.getItem();
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)map.get(item));
                    double capDelta = capacitorGiven.component1();
                    boolean atEndOfCycle = capacitorGiven.component2();
                    if (set.remove(item)) {
                        this.setCapacity(this.getCapacity() + capDelta);
                    }
                    if (activate = ((Boolean)onReadyToActivate.invoke(item, (Object)capDelta, (Object)atEndOfCycle)).booleanValue()) {
                        if (atEndOfCycle) {
                            set.add(item);
                        } else {
                            this.setCapacity(this.getCapacity() + capDelta);
                        }
                    }
                    if (activate) {
                        Intrinsics.checkNotNull((Object)entry$iv);
                        ItemActivationHeap.access$onActivated((ItemActivationHeap)this_$iv, entry$iv);
                        continue;
                    }
                    List list = ItemActivationHeap.access$getReadyToActivate$p((ItemActivationHeap)this_$iv);
                    Intrinsics.checkNotNull((Object)entry$iv);
                    list.add(entry$iv);
                }
                this.setCapacity(RangesKt.coerceAtMost((double)this.getCapacity(), (double)this.$totalCapacity));
            }
        };
    }

    public static final boolean isRelevantForCapacitorStabilityAsLocalModule(@NotNull Module $this$isRelevantForCapacitorStabilityAsLocalModule) {
        Intrinsics.checkNotNullParameter((Object)$this$isRelevantForCapacitorStabilityAsLocalModule, (String)"<this>");
        if (!$this$isRelevantForCapacitorStabilityAsLocalModule.getActive() || $this$isRelevantForCapacitorStabilityAsLocalModule.getActivationDuration() == null) {
            return false;
        }
        return $this$isRelevantForCapacitorStabilityAsLocalModule.getCapacitorNeed() != null || $this$isRelevantForCapacitorStabilityAsLocalModule.getEnergyTransferred() != null || $this$isRelevantForCapacitorStabilityAsLocalModule.getCapacitorBoostedPerSecond() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isRelevantForCapacitorStabilityAsHostileItem(@NotNull ModuleOrDrone<?> $this$isRelevantForCapacitorStabilityAsHostileItem) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isRelevantForCapacitorStabilityAsHostileItem, (String)"<this>");
        ModuleOrDrone<?> moduleOrDrone = $this$isRelevantForCapacitorStabilityAsHostileItem;
        if (moduleOrDrone instanceof Module) {
            bl = ((Module)$this$isRelevantForCapacitorStabilityAsHostileItem).getActive();
        } else {
            if (!(moduleOrDrone instanceof DroneGroup)) throw new NoWhenBranchMatchedException();
            bl = ((DroneGroup)$this$isRelevantForCapacitorStabilityAsHostileItem).getActive();
        }
        boolean isActive = bl;
        if (!isActive) {
            return false;
        }
        if ($this$isRelevantForCapacitorStabilityAsHostileItem.getEnergyNeutralized() != null) return true;
        if (!($this$isRelevantForCapacitorStabilityAsHostileItem instanceof Module)) return false;
        Module module = (Module)$this$isRelevantForCapacitorStabilityAsHostileItem;
        if (module == null) return false;
        AttributeProperty<Double> attributeProperty = module.getEnergyTransferred();
        if (attributeProperty == null) return false;
        return true;
    }

    public static final boolean isRelevantForCapacitorStabilityAsFriendlyModule(@NotNull Module $this$isRelevantForCapacitorStabilityAsFriendlyModule) {
        Intrinsics.checkNotNullParameter((Object)$this$isRelevantForCapacitorStabilityAsFriendlyModule, (String)"<this>");
        if (!$this$isRelevantForCapacitorStabilityAsFriendlyModule.getActive()) {
            return false;
        }
        return $this$isRelevantForCapacitorStabilityAsFriendlyModule.getEnergyTransferred() != null;
    }

    @NotNull
    public static final CapacitorStability capacitorStability(double totalCapacity, double rechargeTime, double energyNeutralizationResistance, @NotNull Collection<Module> localModules, @NotNull Collection<? extends ModuleOrDrone<?>> hostileItems, @NotNull Collection<Module> friendlyModules) {
        Intrinsics.checkNotNullParameter(localModules, (String)"localModules");
        Intrinsics.checkNotNullParameter(hostileItems, (String)"hostileItems");
        Intrinsics.checkNotNullParameter(friendlyModules, (String)"friendlyModules");
        CapacitorSimulation simulation = MechanicsKt.capacitorSimulation(totalCapacity, rechargeTime, energyNeutralizationResistance, localModules, hostileItems, friendlyModules);
        if (simulation.isStableAtFull()) {
            return new CapacitorStability.Stable(totalCapacity, 1.0);
        }
        CapacitorSimulation $this$capacitorStability_u24lambda_u2416 = simulation;
        boolean bl = false;
        double minCapacity = totalCapacity;
        int minimumBrokenTime = 0;
        while ((long)$this$capacitorStability_u24lambda_u2416.getCurrentTimeMillis() <= CapacitorStabilityMaxSimulatedTimeMillis) {
            $this$capacitorStability_u24lambda_u2416.advanceClock(1000, MechanicsKt::capacitorStability$lambda$16$lambda$15);
            if ($this$capacitorStability_u24lambda_u2416.getCapacity() <= 0.0) {
                return new CapacitorStability.Unstable($this$capacitorStability_u24lambda_u2416.getCurrentTimeMillis() / 1000);
            }
            if ($this$capacitorStability_u24lambda_u2416.getCapacity() < minCapacity - 0.1) {
                minimumBrokenTime = $this$capacitorStability_u24lambda_u2416.getCurrentTimeMillis();
                minCapacity = $this$capacitorStability_u24lambda_u2416.getCapacity();
            }
            if ($this$capacitorStability_u24lambda_u2416.getCurrentTimeMillis() - minimumBrokenTime <= 120000) continue;
        }
        return new CapacitorStability.Stable(minCapacity, minCapacity / totalCapacity);
    }

    @Stable
    public static final int maxDroneGroupSize(@NotNull DroneType droneType, double fitBandwidth, int fitCapacity, int maxActiveDrones) {
        Intrinsics.checkNotNullParameter((Object)droneType, (String)"droneType");
        return Math.min((int)fitBandwidth / droneType.getBandwidthUsed(), Math.min(fitCapacity / (int)droneType.getVolume(), maxActiveDrones));
    }

    @Stable
    public static final boolean canDroneTypeBeFitted(@NotNull DroneType droneType, double fitBandwidth, int fitCapacity, int maxActiveDrones) {
        Intrinsics.checkNotNullParameter((Object)droneType, (String)"droneType");
        return MechanicsKt.maxDroneGroupSize(droneType, fitBandwidth, fitCapacity, maxActiveDrones) > 0;
    }

    public static final double jamChance(@NotNull SensorType sensorType, double sensorStrength, double ecmResistance, @NotNull Iterable<Module> ecmModules, @NotNull Function2<? super Module, ? super SensorType, Double> appliedModuleEcmStrength, @NotNull Iterable<DroneGroup> ecmDrones, @NotNull Function2<? super DroneGroup, ? super SensorType, Double> appliedDroneEcmStrength) {
        double ecmStrength;
        Intrinsics.checkNotNullParameter((Object)sensorType, (String)"sensorType");
        Intrinsics.checkNotNullParameter(ecmModules, (String)"ecmModules");
        Intrinsics.checkNotNullParameter(appliedModuleEcmStrength, (String)"appliedModuleEcmStrength");
        Intrinsics.checkNotNullParameter(ecmDrones, (String)"ecmDrones");
        Intrinsics.checkNotNullParameter(appliedDroneEcmStrength, (String)"appliedDroneEcmStrength");
        double unjammedChance = 1.0;
        for (Module module : ecmModules) {
            ecmStrength = ((Number)appliedModuleEcmStrength.invoke((Object)module, (Object)sensorType)).doubleValue() * ecmResistance;
            if (ecmStrength > sensorStrength) {
                return 1.0;
            }
            unjammedChance *= 1.0 - ecmStrength / sensorStrength;
        }
        for (DroneGroup droneGroup : ecmDrones) {
            ecmStrength = ((Number)appliedDroneEcmStrength.invoke((Object)droneGroup, (Object)sensorType)).doubleValue() * ecmResistance;
            if (ecmStrength > sensorStrength) {
                return 1.0;
            }
            unjammedChance *= Math.pow(1.0 - ecmStrength / sensorStrength, droneGroup.getSize());
        }
        return 1.0 - unjammedChance;
    }

    public static /* synthetic */ double jamChance$default(SensorType sensorType, double d, double d2, Iterable iterable, Function2 function2, Iterable iterable2, Function2 function22, int n, Object object) {
        if ((n & 4) != 0) {
            d2 = 1.0;
        }
        if ((n & 8) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            function2 = DefaultEcmStrength;
        }
        if ((n & 0x20) != 0) {
            iterable2 = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            function22 = DefaultEcmStrength;
        }
        return MechanicsKt.jamChance(sensorType, d, d2, iterable, function2, iterable2, function22);
    }

    public static final double jamChance(@NotNull Fit targetFit, @NotNull Iterable<Module> ecmModules, @NotNull Iterable<DroneGroup> ecmDrones) {
        Intrinsics.checkNotNullParameter((Object)targetFit, (String)"targetFit");
        Intrinsics.checkNotNullParameter(ecmModules, (String)"ecmModules");
        Intrinsics.checkNotNullParameter(ecmDrones, (String)"ecmDrones");
        return MechanicsKt.jamChance$default(targetFit.getTargeting().getSensors().getType(), ((Number)targetFit.getTargeting().getSensors().getStrength().getValue()).doubleValue(), ((Number)targetFit.getElectronicWarfare().getEcmResistance().getValue()).doubleValue(), ecmModules, null, ecmDrones, null, 80, null);
    }

    public static /* synthetic */ double jamChance$default(Fit fit, Iterable iterable, Iterable iterable2, int n, Object object) {
        if ((n & 2) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            iterable2 = CollectionsKt.emptyList();
        }
        return MechanicsKt.jamChance(fit, iterable, iterable2);
    }

    public static final double timeFractionJammed(@NotNull SensorType sensorType, double sensorStrength, double ecmResistance, @NotNull Iterable<Module> ecmModules, @NotNull Function2<? super Module, ? super SensorType, Double> appliedModuleEcmStrength, @NotNull Iterable<DroneGroup> ecmDrones, @NotNull Function2<? super DroneGroup, ? super SensorType, Double> appliedDroneEcmStrength) {
        double ecmStrength;
        double jamTimeFraction;
        double activationDuration;
        Double jamDuration;
        Intrinsics.checkNotNullParameter((Object)sensorType, (String)"sensorType");
        Intrinsics.checkNotNullParameter(ecmModules, (String)"ecmModules");
        Intrinsics.checkNotNullParameter(appliedModuleEcmStrength, (String)"appliedModuleEcmStrength");
        Intrinsics.checkNotNullParameter(ecmDrones, (String)"ecmDrones");
        Intrinsics.checkNotNullParameter(appliedDroneEcmStrength, (String)"appliedDroneEcmStrength");
        double unjammedTimeFraction = 1.0;
        for (Module module : ecmModules) {
            jamDuration = module.getEcmJamDuration();
            if (jamDuration == null || Intrinsics.areEqual((Double)jamDuration, (double)0.0)) continue;
            AttributeProperty<Double> attributeProperty = module.getActivationDuration();
            if (attributeProperty == null) {
                continue;
            }
            activationDuration = ((Number)attributeProperty.getValue()).doubleValue();
            jamTimeFraction = jamDuration / activationDuration;
            ecmStrength = ((Number)appliedModuleEcmStrength.invoke((Object)module, (Object)sensorType)).doubleValue() * ecmResistance;
            double jamChance = RangesKt.coerceAtMost((double)(ecmStrength / sensorStrength), (double)1.0);
            unjammedTimeFraction *= 1.0 - jamChance * jamTimeFraction;
        }
        for (DroneGroup droneGroup : ecmDrones) {
            jamDuration = droneGroup.getEcmJamDuration();
            if (jamDuration == null || Intrinsics.areEqual((Double)jamDuration, (double)0.0)) continue;
            activationDuration = ((Number)droneGroup.getActivationDuration().getValue()).doubleValue();
            jamTimeFraction = jamDuration / activationDuration;
            ecmStrength = ((Number)appliedDroneEcmStrength.invoke((Object)droneGroup, (Object)sensorType)).doubleValue() * ecmResistance;
            double unjammedChance = Math.pow(1.0 - ecmStrength / sensorStrength, droneGroup.getSize());
            double jamChance = 1.0 - unjammedChance;
            unjammedTimeFraction *= 1.0 - jamChance * jamTimeFraction;
        }
        return 1.0 - unjammedTimeFraction;
    }

    public static /* synthetic */ double timeFractionJammed$default(SensorType sensorType, double d, double d2, Iterable iterable, Function2 function2, Iterable iterable2, Function2 function22, int n, Object object) {
        if ((n & 4) != 0) {
            d2 = 1.0;
        }
        if ((n & 8) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            function2 = DefaultEcmStrength;
        }
        if ((n & 0x20) != 0) {
            iterable2 = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            function22 = DefaultEcmStrength;
        }
        return MechanicsKt.timeFractionJammed(sensorType, d, d2, iterable, function2, iterable2, function22);
    }

    @Stable
    public static final int crystalLifeExpectancyCycles(double volatilityChance, double volatilityDamage) {
        return MathKt.roundToInt((double)(1.0 / (volatilityChance * volatilityDamage)));
    }

    @Stable
    public static final double lockTime(double scanResolution, double signatureRadius) {
        return (double)40000000 / (scanResolution * Math.pow(MathKt.asinh((double)signatureRadius), 2));
    }

    @Stable
    private static final double chanceToHit(double angularVelocity, double trackingSpeed, double signatureRadius, double signatureResolution, double optimal, double falloff, double distance) {
        double distanceCoef = MechanicsKt.effectivenessAtDistance(distance, optimal, falloff);
        double trackingCoef = Math.pow(0.5, angularVelocity * signatureResolution / (trackingSpeed * signatureRadius));
        return distanceCoef * trackingCoef;
    }

    @Stable
    public static final double turretDamageCoefficient(double centersDistance, double angularVelocity, double signatureRadius, double trackingSpeed, double signatureResolution, double optimal, double falloff, boolean includeWreckingShots) {
        double hitChance = MechanicsKt.chanceToHit(angularVelocity, trackingSpeed, signatureRadius, signatureResolution, optimal, falloff, centersDistance);
        return includeWreckingShots ? 0.5 * Math.min(hitChance * (hitChance + 0.98) + 0.0501, (double)6 * hitChance) : hitChance;
    }

    @Stable
    public static final double angularVelocity(double centersDistance, double speed1, double direction1, double speed2, double direction2) {
        double transversal = Math.abs(speed1 * Math.sin(direction1) - speed2 * Math.sin(direction2));
        return centersDistance > 0.0 ? transversal / centersDistance : (transversal == 0.0 ? 0.0 : Double.POSITIVE_INFINITY);
    }

    @Stable
    public static final double missileDamageCoefficient(double explosionRadius, double explosionVelocity, double drf, double targetSpeed, double targetSignatureRadius) {
        double radiusFactor = targetSignatureRadius / explosionRadius;
        return RangesKt.coerceAtMost((double)Math.min(radiusFactor, Math.pow(radiusFactor * explosionVelocity / targetSpeed, drf)), (double)1.0);
    }

    @Stable
    public static final double bombDamageCoefficient(double explosionRadius, double targetSignatureRadius) {
        double radiusFactor = targetSignatureRadius / explosionRadius;
        return RangesKt.coerceAtMost((double)radiusFactor, (double)1.0);
    }

    @Stable
    @NotNull
    public static final Pair<Double, Double> orbitRadiusAndSpeed(double requestedRadius, double requestedSpeed, double mass, double inertiaModifier) {
        double inertia = MechanicsKt.inertia(mass, inertiaModifier);
        double requestedRadiusSquared = MathUtilsKt.sqr(requestedRadius);
        double radius = Math.sqrt(requestedRadiusSquared + Math.pow(inertia * requestedSpeed * requestedRadiusSquared, 0.6666666666666666));
        double speed = requestedSpeed * (requestedRadius / radius);
        return new Pair((Object)radius, (Object)speed);
    }

    private static final double missileRange$range(double $velocity, double $mass, double $inertiaModifier, double timeSec) {
        return $velocity * (timeSec - 0.5 * ($mass * $inertiaModifier) / 1000000.0);
    }

    private static final boolean capacitorSimulation$lambda$14(Collection $hostileItems, Module it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getCapacitorBoostedPerSecond() != null && !$hostileItems.contains(it);
    }

    private static final boolean capacitorStability$lambda$16$lambda$15(ModuleOrDrone moduleOrDrone, double d, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)moduleOrDrone, (String)"<unused var>");
        return true;
    }

    private static final double DefaultEcmStrength$lambda$17(ModuleOrDrone item, SensorType sensorType) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)sensorType, (String)"sensorType");
        AttributeProperty attributeProperty = (AttributeProperty)item.getEcmStrength().get((Enum)sensorType);
        return attributeProperty != null ? ((Number)attributeProperty.getValue()).doubleValue() : 0.0;
    }
}

