/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.fitting;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.internal.StabilityInferred;
import eve.data.Attribute;
import eve.data.ChargeType;
import eve.data.DamageType;
import eve.data.EveData;
import eve.data.ModuleOrDroneType;
import eve.data.ModuleType;
import eve.data.SensorType;
import eve.data.utils.ValueByEnum;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import theorycrafter.fitting.AttributeProperty;
import theorycrafter.fitting.Charge;
import theorycrafter.fitting.EnabledState;
import theorycrafter.fitting.Fit;
import theorycrafter.fitting.FitItemWithEnabledState;
import theorycrafter.fitting.FittingEngine;
import theorycrafter.fitting.MechanicsKt;
import theorycrafter.fitting.ModuleOrDrone;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b-\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0006\u00a6\u0001\u00a7\u0001\u00a8\u0001B!\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010i\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010j*\u000202J\u001c\u0010\u0099\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u009c\u0001\u001a\u000202R\u00030\u009b\u0001\u00a2\u0006\u0003\u0010\u009d\u0001R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR+\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108@@@X\u0080\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0011\u0010 \u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001dR\u001e\u0010\"\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010$\u0018\u00010#X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0013\u0010'\u001a\u0004\u0018\u00010$8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0019\u0010*\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010+8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0019\u0010/\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010+8F\u00a2\u0006\u0006\u001a\u0004\b0\u0010.R\u0019\u00101\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010.R\u0019\u00104\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+8F\u00a2\u0006\u0006\u001a\u0004\b5\u0010.R\u0019\u00106\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010+8F\u00a2\u0006\u0006\u001a\u0004\b7\u0010.R\u0019\u00108\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010.R/\u0010:\u001a\u0016\u0012\u0004\u0012\u00020<\u0012\f\u0012\n\u0012\u0004\u0012\u000202\u0018\u00010+0;8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b?\u0010@\u001a\u0004\b=\u0010>R\u0019\u0010A\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+8F\u00a2\u0006\u0006\u001a\u0004\bB\u0010.R\u0019\u0010C\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010.R\u0013\u0010E\u001a\u0004\u0018\u0001028F\u00a2\u0006\u0006\u001a\u0004\bF\u0010GR/\u0010H\u001a\u0016\u0012\u0004\u0012\u00020<\u0012\f\u0012\n\u0012\u0004\u0012\u000202\u0018\u00010+0;8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bJ\u0010@\u001a\u0004\bI\u0010>R/\u0010K\u001a\u0016\u0012\u0004\u0012\u00020<\u0012\f\u0012\n\u0012\u0004\u0012\u000202\u0018\u00010+0;8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bM\u0010@\u001a\u0004\bL\u0010>R/\u0010N\u001a\u0016\u0012\u0004\u0012\u00020<\u0012\f\u0012\n\u0012\u0004\u0012\u000202\u0018\u00010+0;8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bP\u0010@\u001a\u0004\bO\u0010>R\u0019\u0010Q\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010+8F\u00a2\u0006\u0006\u001a\u0004\bR\u0010.R\u0019\u0010S\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+8F\u00a2\u0006\u0006\u001a\u0004\bT\u0010.R\u0019\u0010U\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+8F\u00a2\u0006\u0006\u001a\u0004\bV\u0010.R\u0019\u0010W\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+8F\u00a2\u0006\u0006\u001a\u0004\bX\u0010.R\u0019\u0010Y\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+8F\u00a2\u0006\u0006\u001a\u0004\bZ\u0010.R\u0019\u0010[\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+8F\u00a2\u0006\u0006\u001a\u0004\b\\\u0010.R\u0019\u0010]\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+8F\u00a2\u0006\u0006\u001a\u0004\b^\u0010.R\u0019\u0010_\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+8F\u00a2\u0006\u0006\u001a\u0004\b`\u0010.R\u0019\u0010a\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+8F\u00a2\u0006\u0006\u001a\u0004\bb\u0010.R\u0013\u0010c\u001a\u0004\u0018\u0001028F\u00a2\u0006\u0006\u001a\u0004\bd\u0010GR\u0019\u0010e\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+\u00a2\u0006\b\n\u0000\u001a\u0004\bf\u0010.R\u0016\u0010g\u001a\u0004\u0018\u0001028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bh\u0010GR\u0019\u0010k\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010j8F\u00a2\u0006\u0006\u001a\u0004\bl\u0010mR\u0019\u0010n\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010j8F\u00a2\u0006\u0006\u001a\u0004\bo\u0010mR\u0019\u0010p\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+8F\u00a2\u0006\u0006\u001a\u0004\bq\u0010.R\u0013\u0010r\u001a\u0004\u0018\u0001028F\u00a2\u0006\u0006\u001a\u0004\bs\u0010GR/\u0010t\u001a\u0016\u0012\u0004\u0012\u00020u\u0012\f\u0012\n\u0012\u0004\u0012\u000202\u0018\u00010+0;8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bw\u0010@\u001a\u0004\bv\u0010>R\u001f\u0010x\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010+8F\u00a2\u0006\f\u0012\u0004\by\u0010z\u001a\u0004\b{\u0010.R\u001f\u0010|\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+8F\u00a2\u0006\f\u0012\u0004\b}\u0010z\u001a\u0004\b~\u0010.R\u0016\u0010\u007f\u001a\u0005\u0018\u00010\u0080\u00018F\u00a2\u0006\b\u001a\u0006\b\u0081\u0001\u0010\u0082\u0001R\u001b\u0010\u0083\u0001\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+8F\u00a2\u0006\u0007\u001a\u0005\b\u0084\u0001\u0010.R\u001b\u0010\u0085\u0001\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+8F\u00a2\u0006\u0007\u001a\u0005\b\u0086\u0001\u0010.R\u001b\u0010\u0087\u0001\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010+8F\u00a2\u0006\u0007\u001a\u0005\b\u0088\u0001\u0010.R\u001b\u0010\u0089\u0001\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+8F\u00a2\u0006\u0007\u001a\u0005\b\u008a\u0001\u0010.R\u001b\u0010\u008b\u0001\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+8F\u00a2\u0006\u0007\u001a\u0005\b\u008c\u0001\u0010.R\u001b\u0010\u008d\u0001\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010+8F\u00a2\u0006\u0007\u001a\u0005\b\u008e\u0001\u0010.R\u001b\u0010\u008f\u0001\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+8F\u00a2\u0006\u0007\u001a\u0005\b\u0090\u0001\u0010.R\u001b\u0010\u0091\u0001\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+8F\u00a2\u0006\u0007\u001a\u0005\b\u0092\u0001\u0010.R\u001b\u0010\u0093\u0001\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+8F\u00a2\u0006\u0007\u001a\u0005\b\u0094\u0001\u0010.R\u001b\u0010\u0095\u0001\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+8F\u00a2\u0006\u0007\u001a\u0005\b\u0096\u0001\u0010.R\u001b\u0010\u0097\u0001\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+8F\u00a2\u0006\u0007\u001a\u0005\b\u0098\u0001\u0010.R\u0015\u0010\u009e\u0001\u001a\u0004\u0018\u0001028F\u00a2\u0006\u0007\u001a\u0005\b\u009f\u0001\u0010GR\u0015\u0010\u00a0\u0001\u001a\u0004\u0018\u0001028F\u00a2\u0006\u0007\u001a\u0005\b\u00a1\u0001\u0010GR\u001b\u0010\u00a2\u0001\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+8F\u00a2\u0006\u0007\u001a\u0005\b\u00a3\u0001\u0010.R\u001b\u0010\u00a4\u0001\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010+8F\u00a2\u0006\u0007\u001a\u0005\b\u00a5\u0001\u0010.\u00a8\u0006\u00a9\u0001"}, d2={"Ltheorycrafter/fitting/Module;", "Ltheorycrafter/fitting/ModuleOrDrone;", "Leve/data/ModuleType;", "Ltheorycrafter/fitting/FitItemWithEnabledState;", "fit", "Ltheorycrafter/fitting/Fit;", "eveData", "Leve/data/EveData;", "type", "<init>", "(Ltheorycrafter/fitting/Fit;Leve/data/EveData;Leve/data/ModuleType;)V", "enabledState", "Ltheorycrafter/fitting/EnabledState;", "getEnabledState", "()Ltheorycrafter/fitting/EnabledState;", "<set-?>", "Ltheorycrafter/fitting/Module$State;", "mutableState", "getMutableState$FittingEngine", "()Ltheorycrafter/fitting/Module$State;", "setMutableState$FittingEngine", "(Ltheorycrafter/fitting/Module$State;)V", "mutableState$delegate", "Landroidx/compose/runtime/MutableState;", "state", "getState", "online", "", "getOnline", "()Z", "active", "getActive", "canLoadCharges", "getCanLoadCharges", "loadedChargeState", "Landroidx/compose/runtime/MutableState;", "Ltheorycrafter/fitting/Charge;", "getLoadedChargeState$FittingEngine", "()Landroidx/compose/runtime/MutableState;", "loadedCharge", "getLoadedCharge", "()Ltheorycrafter/fitting/Charge;", "maxGroupOnline", "Ltheorycrafter/fitting/AttributeProperty;", "", "getMaxGroupOnline", "()Ltheorycrafter/fitting/AttributeProperty;", "maxGroupActive", "getMaxGroupActive", "powerNeed", "", "getPowerNeed", "cpuNeed", "getCpuNeed", "calibrationNeed", "getCalibrationNeed", "capacitorNeed", "getCapacitorNeed", "volleyDamageByType", "Leve/data/utils/ValueByEnum;", "Leve/data/DamageType;", "getVolleyDamageByType", "()Leve/data/utils/ValueByEnum;", "volleyDamageByType$delegate", "Lkotlin/Lazy;", "reloadTime", "getReloadTime", "reactivationDelay", "getReactivationDelay", "dps", "getDps", "()Ljava/lang/Double;", "shieldResonanceBonus", "getShieldResonanceBonus", "shieldResonanceBonus$delegate", "armorResonanceBonus", "getArmorResonanceBonus", "armorResonanceBonus$delegate", "structureResonanceBonus", "getStructureResonanceBonus", "structureResonanceBonus$delegate", "warpDisruptionStrength", "getWarpDisruptionStrength", "missileVelocityBonus", "getMissileVelocityBonus", "missileFlightTimeBonus", "getMissileFlightTimeBonus", "explosionVelocityBonus", "getExplosionVelocityBonus", "explosionRadiusBonus", "getExplosionRadiusBonus", "explosionRadius", "getExplosionRadius", "explosionVelocity", "getExplosionVelocity", "damageReductionFactor", "getDamageReductionFactor", "maxTractorVelocity", "getMaxTractorVelocity", "capacitorBoostedPerSecond", "getCapacitorBoostedPerSecond", "unchargedArmorHpRepaired", "getUnchargedArmorHpRepaired", "armorHpRepairedValue", "getArmorHpRepairedValue", "perClip", "Ltheorycrafter/fitting/Module$ValuePerClip;", "shieldHpBoostedPerClip", "getShieldHpBoostedPerClip", "()Ltheorycrafter/fitting/Module$ValuePerClip;", "armorHpRepairedPerClip", "getArmorHpRepairedPerClip", "energyTransferred", "getEnergyTransferred", "energyTransferredPerSecond", "getEnergyTransferredPerSecond", "sensorStrengthBonus", "Leve/data/SensorType;", "getSensorStrengthBonus", "sensorStrengthBonus$delegate", "consumptionTypeId", "getConsumptionTypeId$annotations", "()V", "getConsumptionTypeId", "consumptionQuantity", "getConsumptionQuantity$annotations", "getConsumptionQuantity", "fuelConsumption", "Ltheorycrafter/fitting/Module$FuelConsumption;", "getFuelConsumption", "()Ltheorycrafter/fitting/Module$FuelConsumption;", "accessDifficultyBonus", "getAccessDifficultyBonus", "virusCoherence", "getVirusCoherence", "virusElementSlots", "getVirusElementSlots", "virusStrength", "getVirusStrength", "mjfgRadius", "getMjfgRadius", "mjdShipJumpCap", "getMjdShipJumpCap", "scanStrengthBonus", "getScanStrengthBonus", "literalDuration", "getLiteralDuration", "droneDamageBonus", "getDroneDamageBonus", "decloakTargetingDelay", "getDecloakTargetingDelay", "spoolupCycles", "getSpoolupCycles", "setSpoolupCycles", "", "Ltheorycrafter/fitting/FittingEngine$ModificationScope;", "cycleCount", "(Ltheorycrafter/fitting/FittingEngine$ModificationScope;D)V", "spoolupTime", "getSpoolupTime", "maxSpoolupCycles", "getMaxSpoolupCycles", "stabilizeCloakDuration", "getStabilizeCloakDuration", "buffDuration", "getBuffDuration", "State", "ValuePerClip", "FuelConsumption", "FittingEngine"})
@Stable
@SourceDebugExtension(value={"SMAP\nModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Module.kt\ntheorycrafter/fitting/Module\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 3 ValueByEnum.kt\neve/data/utils/ValueByEnumKt\n*L\n1#1,599:1\n81#2:600\n107#2,2:601\n39#3,3:603\n39#3,3:606\n39#3,3:609\n39#3,3:612\n39#3,3:615\n*S KotlinDebug\n*F\n+ 1 Module.kt\ntheorycrafter/fitting/Module\n*L\n76#1:600\n76#1:601,2\n172#1:603,3\n209#1:606,3\n219#1:609,3\n229#1:612,3\n420#1:615,3\n*E\n"})
public final class Module
extends ModuleOrDrone<ModuleType>
implements FitItemWithEnabledState {
    @NotNull
    private final EveData eveData;
    @NotNull
    private final EnabledState enabledState;
    @NotNull
    private final MutableState mutableState$delegate;
    @Nullable
    private final MutableState<Charge> loadedChargeState;
    @NotNull
    private final Lazy volleyDamageByType$delegate;
    @NotNull
    private final Lazy shieldResonanceBonus$delegate;
    @NotNull
    private final Lazy armorResonanceBonus$delegate;
    @NotNull
    private final Lazy structureResonanceBonus$delegate;
    @Nullable
    private final AttributeProperty<Double> unchargedArmorHpRepaired;
    @NotNull
    private final Lazy sensorStrengthBonus$delegate;
    public static final int $stable;

    public Module(@NotNull Fit fit, @NotNull EveData eveData, @NotNull ModuleType type) {
        Intrinsics.checkNotNullParameter((Object)fit, (String)"fit");
        Intrinsics.checkNotNullParameter((Object)eveData, (String)"eveData");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        super(fit, eveData.getAttributes(), (ModuleOrDroneType)type, null);
        this.eveData = eveData;
        this.enabledState = new EnabledState();
        this.mutableState$delegate = SnapshotStateKt.mutableStateOf$default((Object)((Object)State.OFFLINE), null, (int)2, null);
        this.loadedChargeState = this.getCanLoadCharges() ? SnapshotStateKt.mutableStateOf$default(null, null, (int)2, null) : null;
        this.volleyDamageByType$delegate = LazyKt.lazy(() -> Module.volleyDamageByType_delegate$lambda$1(this));
        this.shieldResonanceBonus$delegate = LazyKt.lazy(() -> Module.shieldResonanceBonus_delegate$lambda$3(this));
        this.armorResonanceBonus$delegate = LazyKt.lazy(() -> Module.armorResonanceBonus_delegate$lambda$5(this));
        this.structureResonanceBonus$delegate = LazyKt.lazy(() -> Module.structureResonanceBonus_delegate$lambda$7(this));
        this.unchargedArmorHpRepaired = this.propertyOrNull(this.getAttributes().getArmorRepairAmount());
        this.sensorStrengthBonus$delegate = LazyKt.lazy(() -> Module.sensorStrengthBonus_delegate$lambda$9(this));
    }

    @Override
    @NotNull
    public EnabledState getEnabledState() {
        return this.enabledState;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final State getMutableState$FittingEngine() {
        void $this$getValue$iv;
        androidx.compose.runtime.State state = (androidx.compose.runtime.State)this.mutableState$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (State)((Object)$this$getValue$iv.getValue());
    }

    /*
     * WARNING - void declaration
     */
    public final void setMutableState$FittingEngine(@NotNull State state) {
        void $this$setValue$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
        MutableState mutableState = this.mutableState$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)state);
    }

    @NotNull
    public final State getState() {
        return this.getMutableState$FittingEngine();
    }

    public final boolean getOnline() {
        return this.getState().isAtLeastOnline();
    }

    public final boolean getActive() {
        return this.getState().isAtLeastActive();
    }

    public final boolean getCanLoadCharges() {
        return ((ModuleType)this.getType()).getCanLoadCharges();
    }

    @Nullable
    public final MutableState<Charge> getLoadedChargeState$FittingEngine() {
        return this.loadedChargeState;
    }

    @Nullable
    public final Charge getLoadedCharge() {
        MutableState<Charge> mutableState = this.loadedChargeState;
        return mutableState != null ? (Charge)mutableState.getValue() : null;
    }

    @Nullable
    public final AttributeProperty<Integer> getMaxGroupOnline() {
        return this.propertyOrNull(this.getAttributes().getMaxGroupOnline());
    }

    @Nullable
    public final AttributeProperty<Integer> getMaxGroupActive() {
        return this.propertyOrNull(this.getAttributes().getMaxGroupActive());
    }

    @Nullable
    public final AttributeProperty<Double> getPowerNeed() {
        return this.propertyOrNull(this.getAttributes().getPower());
    }

    @Nullable
    public final AttributeProperty<Double> getCpuNeed() {
        return this.propertyOrNull(this.getAttributes().getCpu());
    }

    @Nullable
    public final AttributeProperty<Integer> getCalibrationNeed() {
        return this.propertyOrNull(this.getAttributes().getCalibrationNeed());
    }

    @Nullable
    public final AttributeProperty<Double> getCapacitorNeed() {
        return this.propertyOrNull(this.getAttributes().getCapacitorNeed());
    }

    @Override
    @NotNull
    public ValueByEnum<DamageType, AttributeProperty<Double>> getVolleyDamageByType() {
        Lazy lazy = this.volleyDamageByType$delegate;
        return (ValueByEnum)lazy.getValue();
    }

    @Nullable
    public final AttributeProperty<Double> getReloadTime() {
        return this.propertyOrNull(this.getAttributes().getReloadTime());
    }

    @Nullable
    public final AttributeProperty<Double> getReactivationDelay() {
        return this.propertyOrNull(this.getAttributes().getModuleReactivationDelay());
    }

    @Nullable
    public final Double getDps() {
        Double d = this.getVolleyDamage();
        if (d == null) {
            return null;
        }
        double volleyDamage = d;
        AttributeProperty<Double> attributeProperty = this.getActivationDuration();
        if (attributeProperty == null) {
            return null;
        }
        double duration = ((Number)attributeProperty.getValue()).doubleValue();
        AttributeProperty<Double> attributeProperty2 = this.getReactivationDelay();
        double reactivationDelay = attributeProperty2 != null ? ((Number)attributeProperty2.getValue()).doubleValue() : 0.0;
        return MechanicsKt.dps(volleyDamage, duration, reactivationDelay);
    }

    @NotNull
    public final ValueByEnum<DamageType, AttributeProperty<Double>> getShieldResonanceBonus() {
        Lazy lazy = this.shieldResonanceBonus$delegate;
        return (ValueByEnum)lazy.getValue();
    }

    @NotNull
    public final ValueByEnum<DamageType, AttributeProperty<Double>> getArmorResonanceBonus() {
        Lazy lazy = this.armorResonanceBonus$delegate;
        return (ValueByEnum)lazy.getValue();
    }

    @NotNull
    public final ValueByEnum<DamageType, AttributeProperty<Double>> getStructureResonanceBonus() {
        Lazy lazy = this.structureResonanceBonus$delegate;
        return (ValueByEnum)lazy.getValue();
    }

    @Nullable
    public final AttributeProperty<Integer> getWarpDisruptionStrength() {
        return this.propertyOrNull(this.getAttributes().getWarpDisruptionStrength());
    }

    @Nullable
    public final AttributeProperty<Double> getMissileVelocityBonus() {
        return this.propertyOrNull(this.getAttributes().getMissileVelocityBonus());
    }

    @Nullable
    public final AttributeProperty<Double> getMissileFlightTimeBonus() {
        return this.propertyOrNull(this.getAttributes().getMissileFlightTimeBonus());
    }

    @Nullable
    public final AttributeProperty<Double> getExplosionVelocityBonus() {
        return this.propertyOrNull(this.getAttributes().getExplosionVelocityBonus());
    }

    @Nullable
    public final AttributeProperty<Double> getExplosionRadiusBonus() {
        return this.propertyOrNull(this.getAttributes().getExplosionRadiusBonus());
    }

    @Nullable
    public final AttributeProperty<Double> getExplosionRadius() {
        return this.propertyOrNull(this.getAttributes().getAoeCloudSize());
    }

    @Nullable
    public final AttributeProperty<Double> getExplosionVelocity() {
        return this.propertyOrNull(this.getAttributes().getAoeVelocity());
    }

    @Nullable
    public final AttributeProperty<Double> getDamageReductionFactor() {
        return this.propertyOrNull(this.getAttributes().getAoeDamageReductionFactor());
    }

    @Nullable
    public final AttributeProperty<Double> getMaxTractorVelocity() {
        return this.propertyOrNull(this.getAttributes().getMaxTractorVelocity());
    }

    @Nullable
    public final Double getCapacitorBoostedPerSecond() {
        if (!((ModuleType)this.getType()).hasEffect(this.eveData.getEffects().getPowerBooster())) {
            return null;
        }
        Charge charge = this.getLoadedCharge();
        if (charge == null) {
            return null;
        }
        Charge loadedCharge = charge;
        Double d = ((ChargeType)loadedCharge.getType()).getCapacitorBonus();
        if (d == null) {
            return null;
        }
        double capacitorBonus = d;
        Integer n = MechanicsKt.maxLoadedChargeAmount((ModuleType)this.getType(), (ChargeType)loadedCharge.getType());
        if (n == null) {
            return null;
        }
        int chargeCount = n;
        AttributeProperty<Double> attributeProperty = this.getActivationDuration();
        if (attributeProperty == null) {
            return null;
        }
        double duration = ((Number)attributeProperty.getValue()).doubleValue();
        AttributeProperty<Double> attributeProperty2 = this.getReloadTime();
        double reloadTime = attributeProperty2 != null ? ((Number)attributeProperty2.getValue()).doubleValue() : 0.0;
        return MechanicsKt.capBoostedPerSecond(capacitorBonus, chargeCount, duration, reloadTime);
    }

    @Nullable
    public final AttributeProperty<Double> getUnchargedArmorHpRepaired() {
        return this.unchargedArmorHpRepaired;
    }

    @Override
    @Nullable
    public Double getArmorHpRepairedValue() {
        AttributeProperty attributeProperty = this.propertyOrNull(this.getAttributes().getArmorRepairAmount());
        if (attributeProperty == null) {
            return null;
        }
        double armorRepairAmount = ((Number)attributeProperty.getValue()).doubleValue();
        if (this.getLoadedCharge() == null) {
            return armorRepairAmount;
        }
        AttributeProperty attributeProperty2 = this.propertyOrNull(this.getAttributes().getChargedArmorDamageMultiplier());
        if (attributeProperty2 == null) {
            return armorRepairAmount;
        }
        double chargedMultiplier = ((Number)attributeProperty2.getValue()).doubleValue();
        return armorRepairAmount * chargedMultiplier;
    }

    @Nullable
    public final ValuePerClip<Double> perClip(double $this$perClip) {
        Charge charge = this.getLoadedCharge();
        if (charge == null) {
            return null;
        }
        Charge loadedCharge = charge;
        AttributeProperty<Double> attributeProperty = this.getActivationDuration();
        if (attributeProperty == null) {
            return null;
        }
        double duration = ((Number)attributeProperty.getValue()).doubleValue();
        Integer n = ((ModuleType)this.getType()).getChargesConsumed();
        if (n == null) {
            return null;
        }
        int chargesConsumedPerActivation = n;
        Integer n2 = MechanicsKt.maxLoadedChargeAmount((ModuleType)this.getType(), (ChargeType)loadedCharge.getType());
        if (n2 == null) {
            return null;
        }
        int chargeCount = n2;
        int activationCount = chargeCount / chargesConsumedPerActivation;
        return new ValuePerClip<Double>($this$perClip * (double)activationCount, (double)activationCount * duration, activationCount);
    }

    @Nullable
    public final ValuePerClip<Double> getShieldHpBoostedPerClip() {
        ValuePerClip<Double> valuePerClip;
        AttributeProperty<Double> attributeProperty = this.getShieldHpBoosted();
        if (attributeProperty != null) {
            double d = ((Number)attributeProperty.getValue()).doubleValue();
            valuePerClip = this.perClip(d);
        } else {
            valuePerClip = null;
        }
        return valuePerClip;
    }

    @Nullable
    public final ValuePerClip<Double> getArmorHpRepairedPerClip() {
        Double d = this.getArmorHpRepairedValue();
        return d != null ? this.perClip(d) : null;
    }

    @Nullable
    public final AttributeProperty<Double> getEnergyTransferred() {
        return this.propertyOrNull(this.getAttributes().getEnergyTransferAmount());
    }

    @Nullable
    public final Double getEnergyTransferredPerSecond() {
        Double d;
        AttributeProperty<Double> attributeProperty = this.getEnergyTransferred();
        if (attributeProperty != null) {
            double d2 = ((Number)attributeProperty.getValue()).doubleValue();
            d = this.perSecond(d2);
        } else {
            d = null;
        }
        return d;
    }

    @NotNull
    public final ValueByEnum<SensorType, AttributeProperty<Double>> getSensorStrengthBonus() {
        Lazy lazy = this.sensorStrengthBonus$delegate;
        return (ValueByEnum)lazy.getValue();
    }

    @Nullable
    public final AttributeProperty<Integer> getConsumptionTypeId() {
        return this.propertyOrNull(this.getAttributes().getConsumptionTypeId());
    }

    public static /* synthetic */ void getConsumptionTypeId$annotations() {
    }

    @Nullable
    public final AttributeProperty<Double> getConsumptionQuantity() {
        return this.propertyOrNull(this.getAttributes().getConsumptionQuantity());
    }

    public static /* synthetic */ void getConsumptionQuantity$annotations() {
    }

    @Nullable
    public final FuelConsumption getFuelConsumption() {
        AttributeProperty<Integer> attributeProperty = this.getConsumptionTypeId();
        if (attributeProperty == null) {
            return null;
        }
        int fuelType = ((Number)attributeProperty.getValue()).intValue();
        AttributeProperty<Double> attributeProperty2 = this.getConsumptionQuantity();
        if (attributeProperty2 == null) {
            return null;
        }
        double fuelQuantity = ((Number)attributeProperty2.getValue()).doubleValue();
        return new FuelConsumption(fuelType, fuelQuantity);
    }

    @Nullable
    public final AttributeProperty<Double> getAccessDifficultyBonus() {
        return this.propertyOrNull(this.getAttributes().getAccessDifficultyBonus());
    }

    @Nullable
    public final AttributeProperty<Double> getVirusCoherence() {
        return this.propertyOrNull(this.getAttributes().getVirusCoherence());
    }

    @Nullable
    public final AttributeProperty<Integer> getVirusElementSlots() {
        return this.propertyOrNull(this.getAttributes().getVirusElementSlots());
    }

    @Nullable
    public final AttributeProperty<Double> getVirusStrength() {
        return this.propertyOrNull(this.getAttributes().getVirusStrength());
    }

    @Nullable
    public final AttributeProperty<Double> getMjfgRadius() {
        return this.propertyOrNull(this.getAttributes().getMjfgRadius());
    }

    @Nullable
    public final AttributeProperty<Integer> getMjdShipJumpCap() {
        return this.propertyOrNull(this.getAttributes().getMjdShipJumpCap());
    }

    @Nullable
    public final AttributeProperty<Double> getScanStrengthBonus() {
        return this.propertyOrNull(this.getAttributes().getScanStrengthBonus());
    }

    @Nullable
    public final AttributeProperty<Double> getLiteralDuration() {
        return this.propertyOrNull(this.getAttributes().getDuration());
    }

    @Nullable
    public final AttributeProperty<Double> getDroneDamageBonus() {
        return this.propertyOrNull(this.getAttributes().getDroneDamageBonus());
    }

    @Nullable
    public final AttributeProperty<Double> getDecloakTargetingDelay() {
        return this.propertyOrNull(this.getAttributes().getDecloakTargetingDelay());
    }

    @Nullable
    public final AttributeProperty<Double> getSpoolupCycles() {
        return this.propertyOrNull(this.getAttributes().getSpoolupCycles());
    }

    public final void setSpoolupCycles(@NotNull FittingEngine.ModificationScope $context_receiver_0, double cycleCount) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        $context_receiver_0.setPinnedPropertyValue(this, this.getAttributes().getSpoolupCycles(), Double.valueOf(cycleCount));
    }

    @Nullable
    public final Double getSpoolupTime() {
        AttributeProperty<Double> attributeProperty = this.getSpoolupCycles();
        if (attributeProperty == null) {
            return null;
        }
        double spoolupCycles = ((Number)attributeProperty.getValue()).doubleValue();
        AttributeProperty<Double> attributeProperty2 = this.getActivationDuration();
        if (attributeProperty2 == null) {
            return null;
        }
        double activationDuration = ((Number)attributeProperty2.getValue()).doubleValue();
        return spoolupCycles * activationDuration;
    }

    @Nullable
    public final Double getMaxSpoolupCycles() {
        AttributeProperty attributeProperty = this.propertyOrNull(this.getAttributes().getDamageMultiplierBonusMax());
        if (attributeProperty == null && (attributeProperty = this.propertyOrNull(this.getAttributes().getRepairMultiplierBonusMax())) == null) {
            return null;
        }
        AttributeProperty maxBonus = attributeProperty;
        AttributeProperty attributeProperty2 = this.propertyOrNull(this.getAttributes().getDamageMultiplierBonusPerCycle());
        if (attributeProperty2 == null && (attributeProperty2 = this.propertyOrNull(this.getAttributes().getRepairMultiplierBonusPerCycle())) == null) {
            return null;
        }
        AttributeProperty cycleBonus = attributeProperty2;
        return ((Number)maxBonus.getValue()).doubleValue() / ((Number)cycleBonus.getValue()).doubleValue();
    }

    @Nullable
    public final AttributeProperty<Double> getStabilizeCloakDuration() {
        return this.propertyOrNull(this.getAttributes().getStabilizeCloakDuration());
    }

    @Nullable
    public final AttributeProperty<Double> getBuffDuration() {
        return this.propertyOrNull(this.getAttributes().getWarfare().getBuffDuration());
    }

    @Override
    public boolean getEnabled() {
        return FitItemWithEnabledState.DefaultImpls.getEnabled(this);
    }

    /*
     * WARNING - void declaration
     */
    private static final ValueByEnum volleyDamageByType_delegate$lambda$1(Module this$0) {
        boolean $i$f$valueByEnum = false;
        DamageType[] enumValues$iv = DamageType.values();
        int n = 0;
        int n2 = enumValues$iv.length;
        Object[] objectArray = new AttributeProperty[n2];
        while (n < n2) {
            void damageType;
            AttributeProperty attributeProperty;
            int n3 = n++;
            DamageType damageType2 = enumValues$iv[n3];
            int n4 = n3;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            objectArray2[n4] = attributeProperty = this$0.propertyOrNull((Attribute)this$0.getAttributes().getWeaponDamage().get((Enum)damageType));
        }
        Object[] valueByOrdinal$iv = objectArray;
        return new ValueByEnum(valueByOrdinal$iv);
    }

    /*
     * WARNING - void declaration
     */
    private static final ValueByEnum shieldResonanceBonus_delegate$lambda$3(Module this$0) {
        boolean $i$f$valueByEnum = false;
        DamageType[] enumValues$iv = DamageType.values();
        int n = 0;
        int n2 = enumValues$iv.length;
        Object[] objectArray = new AttributeProperty[n2];
        while (n < n2) {
            void damageType;
            AttributeProperty attributeProperty;
            int n3 = n++;
            DamageType damageType2 = enumValues$iv[n3];
            int n4 = n3;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            objectArray2[n4] = attributeProperty = this$0.propertyOrNull((Attribute)this$0.getAttributes().getShieldResonance().get((Enum)damageType));
        }
        Object[] valueByOrdinal$iv = objectArray;
        return new ValueByEnum(valueByOrdinal$iv);
    }

    /*
     * WARNING - void declaration
     */
    private static final ValueByEnum armorResonanceBonus_delegate$lambda$5(Module this$0) {
        boolean $i$f$valueByEnum = false;
        DamageType[] enumValues$iv = DamageType.values();
        int n = 0;
        int n2 = enumValues$iv.length;
        Object[] objectArray = new AttributeProperty[n2];
        while (n < n2) {
            void damageType;
            AttributeProperty attributeProperty;
            int n3 = n++;
            DamageType damageType2 = enumValues$iv[n3];
            int n4 = n3;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            objectArray2[n4] = attributeProperty = this$0.propertyOrNull((Attribute)this$0.getAttributes().getArmorResonance().get((Enum)damageType));
        }
        Object[] valueByOrdinal$iv = objectArray;
        return new ValueByEnum(valueByOrdinal$iv);
    }

    /*
     * WARNING - void declaration
     */
    private static final ValueByEnum structureResonanceBonus_delegate$lambda$7(Module this$0) {
        boolean $i$f$valueByEnum = false;
        DamageType[] enumValues$iv = DamageType.values();
        int n = 0;
        int n2 = enumValues$iv.length;
        Object[] objectArray = new AttributeProperty[n2];
        while (n < n2) {
            void damageType;
            AttributeProperty attributeProperty;
            int n3 = n++;
            DamageType damageType2 = enumValues$iv[n3];
            int n4 = n3;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            objectArray2[n4] = attributeProperty = this$0.propertyOrNull((Attribute)this$0.getAttributes().getStructureResonanceBonus().get((Enum)damageType));
        }
        Object[] valueByOrdinal$iv = objectArray;
        return new ValueByEnum(valueByOrdinal$iv);
    }

    /*
     * WARNING - void declaration
     */
    private static final ValueByEnum sensorStrengthBonus_delegate$lambda$9(Module this$0) {
        boolean $i$f$valueByEnum = false;
        SensorType[] enumValues$iv = SensorType.values();
        int n = 0;
        int n2 = enumValues$iv.length;
        Object[] objectArray = new AttributeProperty[n2];
        while (n < n2) {
            void sensorType;
            AttributeProperty attributeProperty;
            int n3 = n++;
            SensorType sensorType2 = enumValues$iv[n3];
            int n4 = n3;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            objectArray2[n4] = attributeProperty = this$0.propertyOrNull((Attribute)this$0.getAttributes().getSensorStrengthBonus().get((Enum)sensorType));
        }
        Object[] valueByOrdinal$iv = objectArray;
        return new ValueByEnum(valueByOrdinal$iv);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c7\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d7\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d7\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d7\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Ltheorycrafter/fitting/Module$FuelConsumption;", "", "fuelTypeId", "", "quantity", "", "<init>", "(ID)V", "getFuelTypeId", "()I", "getQuantity", "()D", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "FittingEngine"})
    @StabilityInferred(parameters=1)
    public static final class FuelConsumption {
        private final int fuelTypeId;
        private final double quantity;
        public static final int $stable;

        public FuelConsumption(int fuelTypeId, double quantity) {
            this.fuelTypeId = fuelTypeId;
            this.quantity = quantity;
        }

        public final int getFuelTypeId() {
            return this.fuelTypeId;
        }

        public final double getQuantity() {
            return this.quantity;
        }

        public final int component1() {
            return this.fuelTypeId;
        }

        public final double component2() {
            return this.quantity;
        }

        @NotNull
        public final FuelConsumption copy(int fuelTypeId, double quantity) {
            return new FuelConsumption(fuelTypeId, quantity);
        }

        public static /* synthetic */ FuelConsumption copy$default(FuelConsumption fuelConsumption, int n, double d, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = fuelConsumption.fuelTypeId;
            }
            if ((n2 & 2) != 0) {
                d = fuelConsumption.quantity;
            }
            return fuelConsumption.copy(n, d);
        }

        @NotNull
        public String toString() {
            return "FuelConsumption(fuelTypeId=" + this.fuelTypeId + ", quantity=" + this.quantity + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.fuelTypeId);
            result = result * 31 + Double.hashCode(this.quantity);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FuelConsumption)) {
                return false;
            }
            FuelConsumption fuelConsumption = (FuelConsumption)other;
            if (this.fuelTypeId != fuelConsumption.fuelTypeId) {
                return false;
            }
            return Double.compare(this.quantity, fuelConsumption.quantity) == 0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tj\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\u000b"}, d2={"Ltheorycrafter/fitting/Module$State;", "", "<init>", "(Ljava/lang/String;I)V", "OFFLINE", "ONLINE", "ACTIVE", "OVERLOADED", "isAtLeastOnline", "", "isAtLeastActive", "FittingEngine"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State OFFLINE = new State();
        public static final /* enum */ State ONLINE = new State();
        public static final /* enum */ State ACTIVE = new State();
        public static final /* enum */ State OVERLOADED = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public final boolean isAtLeastOnline() {
            return this.compareTo((Enum)ONLINE) >= 0;
        }

        public final boolean isAtLeastActive() {
            return this.compareTo((Enum)ACTIVE) >= 0;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.OFFLINE, State.ONLINE, State.ACTIVE, State.OVERLOADED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Ltheorycrafter/fitting/Module$ValuePerClip;", "T", "", "value", "clipTimeMillis", "", "activationCount", "", "<init>", "(Ljava/lang/Object;DI)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getClipTimeMillis", "()D", "getActivationCount", "()I", "FittingEngine"})
    @StabilityInferred(parameters=1)
    public static final class ValuePerClip<T> {
        private final T value;
        private final double clipTimeMillis;
        private final int activationCount;
        public static final int $stable;

        public ValuePerClip(T value, double clipTimeMillis, int activationCount) {
            this.value = value;
            this.clipTimeMillis = clipTimeMillis;
            this.activationCount = activationCount;
        }

        public final T getValue() {
            return this.value;
        }

        public final double getClipTimeMillis() {
            return this.clipTimeMillis;
        }

        public final int getActivationCount() {
            return this.activationCount;
        }
    }
}

