/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.fitting;

import androidx.compose.runtime.internal.StabilityInferred;
import eve.data.AttributeModifier;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import theorycrafter.fitting.AttributeProperty;
import theorycrafter.fitting.DroneGroup;
import theorycrafter.fitting.EffectActivator;
import theorycrafter.fitting.EveItem;
import theorycrafter.fitting.RemoteEffect;
import theorycrafter.fitting.StackingPenaltyKt;
import theorycrafter.fitting.utils.AppBugException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001:\u0001.BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\u0010\n\u001a\u00060\u000bj\u0002`\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000bJ\u0006\u0010\"\u001a\u00020\u001dJ\u0016\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020\u000bJ\u0018\u0010'\u001a\u00020!2\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000bH\u0002J\u0018\u0010)\u001a\u00020\u001d2\u0010\u0010*\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050+J\b\u0010,\u001a\u00020-H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0015\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0017\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\n\u001a\u00060\u000bj\u0002`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Ltheorycrafter/fitting/PropertyModifier;", "", "operation", "Leve/data/AttributeModifier$Operation;", "modifyingProperty", "Ltheorycrafter/fitting/AttributeProperty;", "modifiedProperty", "attenuatingProperty", "activator", "Ltheorycrafter/fitting/EffectActivator;", "stackingPenaltyGroup", "", "Ltheorycrafter/fitting/StackingPenaltyGroup;", "contextEffect", "Ltheorycrafter/fitting/RemoteEffect;", "<init>", "(Leve/data/AttributeModifier$Operation;Ltheorycrafter/fitting/AttributeProperty;Ltheorycrafter/fitting/AttributeProperty;Ltheorycrafter/fitting/AttributeProperty;Ltheorycrafter/fitting/EffectActivator;ILtheorycrafter/fitting/RemoteEffect;)V", "getOperation", "()Leve/data/AttributeModifier$Operation;", "getModifyingProperty", "()Ltheorycrafter/fitting/AttributeProperty;", "getModifiedProperty", "getAttenuatingProperty", "getStackingPenaltyGroup", "()I", "getContextEffect", "()Ltheorycrafter/fitting/RemoteEffect;", "applicationCount", "setDroneGroupSize", "", "size", "propertyValueRange", "Lkotlin/ranges/ClosedRange;", "", "isActive", "apply", "Ltheorycrafter/fitting/PropertyModifier$Application;", "originalValue", "stackingIndex", "modifyingValue", "applications", "areAllDependenciesClean", "dirtySet", "", "toString", "", "Application", "FittingEngine"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nFittingEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FittingEngine.kt\ntheorycrafter/fitting/PropertyModifier\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,5165:1\n1#2:5166\n*E\n"})
public final class PropertyModifier {
    @NotNull
    private final AttributeModifier.Operation operation;
    @NotNull
    private final AttributeProperty<?> modifyingProperty;
    @NotNull
    private final AttributeProperty<?> modifiedProperty;
    @Nullable
    private final AttributeProperty<?> attenuatingProperty;
    @NotNull
    private final EffectActivator activator;
    private final int stackingPenaltyGroup;
    @Nullable
    private final RemoteEffect contextEffect;
    private int applicationCount;
    @Nullable
    private final ClosedRange<Double> propertyValueRange;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public PropertyModifier(@NotNull AttributeModifier.Operation operation, @NotNull AttributeProperty<?> modifyingProperty, @NotNull AttributeProperty<?> modifiedProperty, @Nullable AttributeProperty<?> attenuatingProperty, @NotNull EffectActivator activator, int stackingPenaltyGroup, @Nullable RemoteEffect contextEffect) {
        void affectingItem;
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter(modifyingProperty, (String)"modifyingProperty");
        Intrinsics.checkNotNullParameter(modifiedProperty, (String)"modifiedProperty");
        Intrinsics.checkNotNullParameter((Object)activator, (String)"activator");
        this.operation = operation;
        this.modifyingProperty = modifyingProperty;
        this.modifiedProperty = modifiedProperty;
        this.attenuatingProperty = attenuatingProperty;
        this.activator = activator;
        this.stackingPenaltyGroup = stackingPenaltyGroup;
        this.contextEffect = contextEffect;
        EveItem<?> eveItem = this.modifyingProperty.getItem$FittingEngine();
        PropertyModifier propertyModifier = this;
        boolean bl = false;
        int n = !(affectingItem instanceof DroneGroup) ? 1 : (Intrinsics.areEqual((Object)affectingItem, this.modifiedProperty.getItem$FittingEngine()) ? -1 : ((DroneGroup)affectingItem).getSize());
        propertyModifier.applicationCount = n;
        this.propertyValueRange = this.modifiedProperty.getAttribute$FittingEngine().getPropertyRange();
    }

    @NotNull
    public final AttributeModifier.Operation getOperation() {
        return this.operation;
    }

    @NotNull
    public final AttributeProperty<?> getModifyingProperty() {
        return this.modifyingProperty;
    }

    @NotNull
    public final AttributeProperty<?> getModifiedProperty() {
        return this.modifiedProperty;
    }

    @Nullable
    public final AttributeProperty<?> getAttenuatingProperty() {
        return this.attenuatingProperty;
    }

    public final int getStackingPenaltyGroup() {
        return this.stackingPenaltyGroup;
    }

    @Nullable
    public final RemoteEffect getContextEffect() {
        return this.contextEffect;
    }

    public final boolean setDroneGroupSize(int size) {
        if (this.applicationCount == -1) {
            return false;
        }
        this.applicationCount = size;
        return true;
    }

    public final boolean isActive() {
        return this.activator.isActive();
    }

    @NotNull
    public final Application apply(double originalValue, int stackingIndex) {
        Application application;
        int applications = Math.abs(this.applicationCount);
        double modifyingValue = this.modifyingValue(stackingIndex, applications);
        double it = switch (WhenMappings.$EnumSwitchMapping$0[this.operation.ordinal()]) {
            case 1, 2 -> originalValue * modifyingValue;
            case 3 -> originalValue + modifyingValue;
            case 4 -> originalValue - modifyingValue;
            case 5 -> originalValue * (1.0 + modifyingValue / (double)100);
            case 6 -> originalValue * modifyingValue / (double)100;
            case 7 -> originalValue / modifyingValue;
            case 8 -> modifyingValue;
            case 9 -> {
                if (Math.abs(modifyingValue) > Math.abs(originalValue)) {
                    yield modifyingValue;
                }
                yield originalValue;
            }
            case 10 -> RangesKt.coerceAtLeast((double)originalValue, (double)modifyingValue);
            case 11 -> RangesKt.coerceAtMost((double)originalValue, (double)modifyingValue);
            case 12 -> originalValue;
            default -> throw new NoWhenBranchMatchedException();
        };
        boolean bl = false;
        double newValue = this.propertyValueRange != null ? ((Number)((Object)RangesKt.coerceIn((Comparable)Double.valueOf(it), this.propertyValueRange))).doubleValue() : it;
        Application it2 = application = (switch (WhenMappings.$EnumSwitchMapping$0[this.operation.ordinal()]) {
            case 8 -> new Application(modifyingValue, newValue, true, 0, 8, null);
            case 9 -> {
                if (Math.abs(modifyingValue) > Math.abs(originalValue)) {
                    yield new Application(modifyingValue, newValue, true, 0, 8, null);
                }
                yield new Application(Double.NEGATIVE_INFINITY, newValue, false, 0, 8, null);
            }
            case 12 -> new Application(Double.NEGATIVE_INFINITY, newValue, false, 0, 12, null);
            default -> new Application(modifyingValue, newValue, false, 0, 12, null);
        });
        boolean bl2 = false;
        it2.setStackingIndexIncrease(applications);
        return application;
    }

    private final double modifyingValue(int stackingIndex, int applications) {
        AttributeProperty<?> attributeProperty = this.attenuatingProperty;
        double attenuatingFactor = attributeProperty != null ? attributeProperty.getComputedValue$FittingEngine() : 1.0;
        double singleModifyingValue = this.modifyingProperty.getComputedValue$FittingEngine() * attenuatingFactor;
        if (this.stackingPenaltyGroup == 0 && applications == 1) {
            return singleModifyingValue;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.operation.ordinal()]) {
            case 3: 
            case 4: {
                return singleModifyingValue * (double)applications;
            }
            case 7: {
                return Math.pow(singleModifyingValue, applications);
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return singleModifyingValue;
            }
        }
        if (this.stackingPenaltyGroup == 0) {
            if (this.operation == AttributeModifier.Operation.PRE_MULTIPLY || this.operation == AttributeModifier.Operation.POST_MULTIPLY) {
                return Math.pow(singleModifyingValue, applications);
            }
            if (this.operation == AttributeModifier.Operation.ADD_PERCENT) {
                return singleModifyingValue * (double)applications;
            }
        }
        double modifyingValue = switch (WhenMappings.$EnumSwitchMapping$0[this.operation.ordinal()]) {
            case 1, 2 -> 1.0;
            case 5 -> 0.0;
            default -> throw new AppBugException("Unexpected operation: " + this.operation);
        };
        block13: for (int applicationIndex = 0; applicationIndex < applications; ++applicationIndex) {
            double penaltyFactor = StackingPenaltyKt.stackingPenaltyFactor(stackingIndex + applicationIndex);
            switch (WhenMappings.$EnumSwitchMapping$0[this.operation.ordinal()]) {
                case 1: 
                case 2: {
                    modifyingValue *= 1.0 + (singleModifyingValue - 1.0) * penaltyFactor;
                    continue block13;
                }
                case 5: {
                    modifyingValue += singleModifyingValue * penaltyFactor * (1.0 + modifyingValue / (double)100);
                    continue block13;
                }
                default: {
                    throw new AppBugException("Unexpected operation: " + this.operation);
                }
            }
        }
        return modifyingValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean areAllDependenciesClean(@NotNull Set<AttributeProperty<?>> dirtySet) {
        Intrinsics.checkNotNullParameter(dirtySet, (String)"dirtySet");
        if (dirtySet.contains(this.modifyingProperty)) return false;
        if (this.activator.dependsOnAny(dirtySet)) return false;
        AttributeProperty<?> attributeProperty = this.attenuatingProperty;
        if (attributeProperty == null) return true;
        AttributeProperty<?> it = attributeProperty;
        boolean bl = false;
        if (!dirtySet.contains(it)) return true;
        return false;
    }

    @NotNull
    public String toString() {
        return "PropertyModifier(by=" + this.modifyingProperty.getName$FittingEngine() + ", op=" + this.operation + ", count=" + this.applicationCount + ")";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c7\u0001J\u0013\u0010\u0019\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d7\u0003J\t\u0010\u001b\u001a\u00020\bH\u00d7\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d7\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Ltheorycrafter/fitting/PropertyModifier$Application;", "", "modifyingValue", "", "newValue", "overwrites", "", "stackingIndexIncrease", "", "<init>", "(DDZI)V", "getModifyingValue", "()D", "getNewValue", "getOverwrites", "()Z", "getStackingIndexIncrease", "()I", "setStackingIndexIncrease", "(I)V", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "", "FittingEngine"})
    @StabilityInferred(parameters=0)
    public static final class Application {
        private final double modifyingValue;
        private final double newValue;
        private final boolean overwrites;
        private int stackingIndexIncrease;
        public static final int $stable = 8;

        public Application(double modifyingValue, double newValue, boolean overwrites, int stackingIndexIncrease) {
            this.modifyingValue = modifyingValue;
            this.newValue = newValue;
            this.overwrites = overwrites;
            this.stackingIndexIncrease = stackingIndexIncrease;
        }

        public /* synthetic */ Application(double d, double d2, boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                bl = false;
            }
            if ((n2 & 8) != 0) {
                n = 1;
            }
            this(d, d2, bl, n);
        }

        public final double getModifyingValue() {
            return this.modifyingValue;
        }

        public final double getNewValue() {
            return this.newValue;
        }

        public final boolean getOverwrites() {
            return this.overwrites;
        }

        public final int getStackingIndexIncrease() {
            return this.stackingIndexIncrease;
        }

        public final void setStackingIndexIncrease(int n) {
            this.stackingIndexIncrease = n;
        }

        public final double component1() {
            return this.modifyingValue;
        }

        public final double component2() {
            return this.newValue;
        }

        public final boolean component3() {
            return this.overwrites;
        }

        public final int component4() {
            return this.stackingIndexIncrease;
        }

        @NotNull
        public final Application copy(double modifyingValue, double newValue, boolean overwrites, int stackingIndexIncrease) {
            return new Application(modifyingValue, newValue, overwrites, stackingIndexIncrease);
        }

        public static /* synthetic */ Application copy$default(Application application, double d, double d2, boolean bl, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                d = application.modifyingValue;
            }
            if ((n2 & 2) != 0) {
                d2 = application.newValue;
            }
            if ((n2 & 4) != 0) {
                bl = application.overwrites;
            }
            if ((n2 & 8) != 0) {
                n = application.stackingIndexIncrease;
            }
            return application.copy(d, d2, bl, n);
        }

        @NotNull
        public String toString() {
            return "Application(modifyingValue=" + this.modifyingValue + ", newValue=" + this.newValue + ", overwrites=" + this.overwrites + ", stackingIndexIncrease=" + this.stackingIndexIncrease + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.modifyingValue);
            result = result * 31 + Double.hashCode(this.newValue);
            result = result * 31 + Boolean.hashCode(this.overwrites);
            result = result * 31 + Integer.hashCode(this.stackingIndexIncrease);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Application)) {
                return false;
            }
            Application application = (Application)other;
            if (Double.compare(this.modifyingValue, application.modifyingValue) != 0) {
                return false;
            }
            if (Double.compare(this.newValue, application.newValue) != 0) {
                return false;
            }
            if (this.overwrites != application.overwrites) {
                return false;
            }
            return this.stackingIndexIncrease == application.stackingIndexIncrease;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AttributeModifier.Operation.values().length];
            try {
                nArray[AttributeModifier.Operation.PRE_MULTIPLY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeModifier.Operation.POST_MULTIPLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeModifier.Operation.ADD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeModifier.Operation.SUBTRACT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeModifier.Operation.ADD_PERCENT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeModifier.Operation.MULTIPLY_PERCENT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeModifier.Operation.POST_DIVIDE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeModifier.Operation.SET.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeModifier.Operation.SET_MAX_ABS.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeModifier.Operation.COERCE_AT_LEAST.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeModifier.Operation.COERCE_AT_MOST.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeModifier.Operation.UNHANDLED.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

