/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.fitting;

import eve.data.Attribute;
import eve.data.AttributeModifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import theorycrafter.fitting.AttributeProperty;
import theorycrafter.fitting.DroneGroup;
import theorycrafter.fitting.EveItem;
import theorycrafter.fitting.Module;
import theorycrafter.fitting.PropertyModifier;
import theorycrafter.fitting.WarfareBuffs;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u001a\u000e\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005\u001a$\u0010\n\u001a\u00060\u0005j\u0002`\b2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0000\u001a,\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0001H\u0002\u001a\u001c\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0002\u001a*\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00010\u00182\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0001H\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0012\u0010\u0007\u001a\u00060\u0005j\u0002`\bX\u0080T\u00a2\u0006\u0002\n\u0000\"\u0012\u0010\t\u001a\u00060\u0005j\u0002`\bX\u0082T\u00a2\u0006\u0002\n\u0000*\f\b\u0000\u0010\u0006\"\u00020\u00052\u00020\u0005\u00a8\u0006\u0019"}, d2={"STACKING_PENALTY", "", "", "stackingPenaltyFactor", "n", "", "StackingPenaltyGroup", "NonPenalized", "Ltheorycrafter/fitting/StackingPenaltyGroup;", "SignPenalized", "stackingPenaltyGroup", "affectingItem", "Ltheorycrafter/fitting/EveItem;", "modifiedAttribute", "Leve/data/Attribute;", "stackingPenaltySort", "Ltheorycrafter/fitting/PropertyModifier;", "operation", "Leve/data/AttributeModifier$Operation;", "modifiers", "effectSign", "modifyingProperty", "Ltheorycrafter/fitting/AttributeProperty;", "stackingPenaltySplitAndSort", "", "FittingEngine"})
@SourceDebugExtension(value={"SMAP\nStackingPenalty.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StackingPenalty.kt\ntheorycrafter/fitting/StackingPenaltyKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,131:1\n1062#2:132\n1062#2:133\n1485#2:134\n1510#2,3:135\n1513#2,3:145\n1246#2,4:150\n1557#2:154\n1628#2,3:155\n381#3,7:138\n462#3:148\n412#3:149\n*S KotlinDebug\n*F\n+ 1 StackingPenalty.kt\ntheorycrafter/fitting/StackingPenaltyKt\n*L\n79#1:132\n82#1:133\n121#1:134\n121#1:135,3\n121#1:145,3\n128#1:150,4\n19#1:154\n19#1:155,3\n121#1:138,7\n128#1:148\n128#1:149\n*E\n"})
public final class StackingPenaltyKt {
    @NotNull
    private static final List<Double> STACKING_PENALTY;
    public static final int NonPenalized = 0;
    private static final int SignPenalized = 1;

    public static final double stackingPenaltyFactor(int n) {
        return n == 0 ? 1.0 : (n > CollectionsKt.getLastIndex(STACKING_PENALTY) ? 0.0 : ((Number)STACKING_PENALTY.get(n)).doubleValue());
    }

    public static final int stackingPenaltyGroup(@NotNull EveItem<?> affectingItem, @NotNull Attribute<?> modifiedAttribute) {
        Intrinsics.checkNotNullParameter(affectingItem, (String)"affectingItem");
        Intrinsics.checkNotNullParameter(modifiedAttribute, (String)"modifiedAttribute");
        return !modifiedAttribute.isStackingPenalized() ? 0 : (affectingItem instanceof Module || affectingItem instanceof WarfareBuffs || affectingItem instanceof DroneGroup ? 1 : 0);
    }

    private static final List<PropertyModifier> stackingPenaltySort(AttributeModifier.Operation operation, int stackingPenaltyGroup, List<PropertyModifier> modifiers) {
        if (stackingPenaltyGroup == 0) {
            return modifiers;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[operation.ordinal()]) {
            case 1 -> {
                Iterable $this$sortedByDescending$iv = modifiers;
                boolean $i$f$sortedByDescending = false;
                yield CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        PropertyModifier it = (PropertyModifier)b;
                        boolean bl = false;
                        Comparable comparable = Double.valueOf(Math.abs(it.getModifyingProperty().getComputedValue$FittingEngine()));
                        it = (PropertyModifier)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(Math.abs(it.getModifyingProperty().getComputedValue$FittingEngine())));
                    }
                });
            }
            case 2, 3 -> {
                Iterable $this$sortedByDescending$iv = modifiers;
                boolean $i$f$sortedByDescending = false;
                yield CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        PropertyModifier it = (PropertyModifier)b;
                        boolean bl = false;
                        Comparable comparable = Double.valueOf(Math.abs(Math.abs(it.getModifyingProperty().getComputedValue$FittingEngine()) - 1.0));
                        it = (PropertyModifier)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(Math.abs(Math.abs(it.getModifyingProperty().getComputedValue$FittingEngine()) - 1.0)));
                    }
                });
            }
            default -> modifiers;
        };
    }

    private static final int effectSign(AttributeModifier.Operation operation, AttributeProperty<?> modifyingProperty) {
        double value = modifyingProperty.getComputedValue$FittingEngine();
        return switch (WhenMappings.$EnumSwitchMapping$0[operation.ordinal()]) {
            case 1 -> (int)Math.signum(value);
            case 2, 3 -> (int)Math.signum(value - 1.0);
            default -> 0;
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<List<PropertyModifier>> stackingPenaltySplitAndSort(@NotNull AttributeModifier.Operation operation, @NotNull List<PropertyModifier> modifiers) {
        void $this$mapValuesTo$iv$iv;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
        if (modifiers.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (modifiers.size() == 1) {
            return CollectionsKt.listOf(modifiers);
        }
        Iterable $this$groupBy$iv = modifiers;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv = iterator.next();
            PropertyModifier it = (PropertyModifier)element$iv$iv;
            boolean bl = false;
            int group = it.getStackingPenaltyGroup();
            Integer key$iv$iv = switch (group) {
                case 0 -> 0;
                case 1 -> StackingPenaltyKt.effectSign(operation, it.getModifyingProperty());
                default -> throw new IllegalStateException("Unknown stacking penalty group: " + group);
            };
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry group = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Map.Entry $i$f$getOrPut = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl3 = false;
            List<PropertyModifier> list = StackingPenaltyKt.stackingPenaltySort(operation, ((Number)it.getKey()).intValue(), (List)it.getValue());
            map2.put(k, list);
        }
        return destination$iv$iv.values();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)24);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Math.exp(-Math.pow((double)it / 2.67, 2.0)));
        }
        STACKING_PENALTY = (List)var3_3;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AttributeModifier.Operation.values().length];
            try {
                nArray[AttributeModifier.Operation.ADD_PERCENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeModifier.Operation.POST_MULTIPLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeModifier.Operation.PRE_MULTIPLY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

