/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.snapshots;

import androidx.compose.runtime.snapshots.SnapshotStateList;
import androidx.compose.runtime.snapshots.SnapshotStateListKt;
import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableListIterator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010+\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u0011\u001a\u00020\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u000e\u0010\u0014\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0006H\u0016J\r\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0018\u001a\u00020\u0006H\u0016J\b\u0010\u0019\u001a\u00020\u000eH\u0016J\u0015\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u001b\u001a\u00020\u000eH\u0002R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Landroidx/compose/runtime/snapshots/StateListIterator;", "T", "", "list", "Landroidx/compose/runtime/snapshots/SnapshotStateList;", "offset", "", "(Landroidx/compose/runtime/snapshots/SnapshotStateList;I)V", "index", "lastRequested", "getList", "()Landroidx/compose/runtime/snapshots/SnapshotStateList;", "structure", "add", "", "element", "(Ljava/lang/Object;)V", "hasNext", "", "hasPrevious", "next", "()Ljava/lang/Object;", "nextIndex", "previous", "previousIndex", "remove", "set", "validateModification", "runtime"})
@SourceDebugExtension(value={"SMAP\nSnapshotStateList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnapshotStateList.kt\nandroidx/compose/runtime/snapshots/StateListIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,485:1\n1#2:486\n*E\n"})
final class StateListIterator<T>
implements ListIterator<T>,
KMutableListIterator {
    @NotNull
    private final SnapshotStateList<T> list;
    private int index;
    private int lastRequested;
    private int structure;

    public StateListIterator(@NotNull SnapshotStateList<T> list, int offset) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        this.list = list;
        this.index = offset - 1;
        this.lastRequested = -1;
        this.structure = this.list.getStructure$runtime();
    }

    @NotNull
    public final SnapshotStateList<T> getList() {
        return this.list;
    }

    @Override
    public boolean hasPrevious() {
        return this.index >= 0;
    }

    @Override
    public int nextIndex() {
        return this.index + 1;
    }

    @Override
    public T previous() {
        T t;
        this.validateModification();
        SnapshotStateListKt.access$validateRange(this.index, this.list.size());
        this.lastRequested = this.index;
        T it = t = this.list.get(this.index);
        boolean bl = false;
        int n = this.index;
        this.index = n + -1;
        return t;
    }

    @Override
    public int previousIndex() {
        return this.index;
    }

    @Override
    public void add(T element) {
        this.validateModification();
        this.list.add(this.index + 1, element);
        this.lastRequested = -1;
        int n = this.index;
        this.index = n + 1;
        this.structure = this.list.getStructure$runtime();
    }

    @Override
    public boolean hasNext() {
        return this.index < this.list.size() - 1;
    }

    @Override
    public T next() {
        T t;
        int newIndex;
        this.validateModification();
        this.lastRequested = newIndex = this.index + 1;
        SnapshotStateListKt.access$validateRange(newIndex, this.list.size());
        T it = t = this.list.get(newIndex);
        boolean bl = false;
        this.index = newIndex;
        return t;
    }

    @Override
    public void remove() {
        this.validateModification();
        this.list.remove(this.index);
        int n = this.index;
        this.index = n + -1;
        this.lastRequested = -1;
        this.structure = this.list.getStructure$runtime();
    }

    @Override
    public void set(T element) {
        this.validateModification();
        if (this.lastRequested < 0) {
            SnapshotStateListKt.access$invalidIteratorSet();
            throw new KotlinNothingValueException();
        }
        this.list.set(this.lastRequested, element);
        this.structure = this.list.getStructure$runtime();
    }

    private final void validateModification() {
        if (this.list.getStructure$runtime() != this.structure) {
            throw new ConcurrentModificationException();
        }
    }
}

