/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.fitting;

import androidx.compose.runtime.IntState;
import androidx.compose.runtime.MutableIntState;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotIntStateKt;
import androidx.compose.runtime.SnapshotMutationPolicy;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.State;
import androidx.compose.runtime.internal.StabilityInferred;
import eve.data.Attribute;
import eve.data.Attributes;
import eve.data.EveData;
import eve.data.ModuleSlot;
import eve.data.ModuleSlotType;
import eve.data.ModuleType;
import eve.data.SensorType;
import eve.data.ShipType;
import eve.data.SubsystemType;
import eve.data.typeid.ModuleIdentificationKt;
import eve.data.utils.ValueByEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import theorycrafter.fitting.AttributeProperty;
import theorycrafter.fitting.Booster;
import theorycrafter.fitting.CapacitorSimulation;
import theorycrafter.fitting.CapacitorStability;
import theorycrafter.fitting.CargoItem;
import theorycrafter.fitting.Character;
import theorycrafter.fitting.DroneGroup;
import theorycrafter.fitting.Environment;
import theorycrafter.fitting.Fit;
import theorycrafter.fitting.FitKt;
import theorycrafter.fitting.Implant;
import theorycrafter.fitting.ItemDefenses;
import theorycrafter.fitting.MechanicsKt;
import theorycrafter.fitting.Module;
import theorycrafter.fitting.ModuleOrDrone;
import theorycrafter.fitting.RemoteEffect;
import theorycrafter.fitting.Ship;
import theorycrafter.fitting.Subsystem;
import theorycrafter.fitting.TacticalMode;
import theorycrafter.fitting.WarfareBuffs;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0010\b\u0007\u0018\u00002\u00020\u0001:\u001a\u009d\u0001\u009e\u0001\u009f\u0001\u00a0\u0001\u00a1\u0001\u00a2\u0001\u00a3\u0001\u00a4\u0001\u00a5\u0001\u00a6\u0001\u00a7\u0001\u00a8\u0001\u00a9\u0001B3\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u008e\u0001\u001a\u00030\u008f\u0001H\u0000\u00a2\u0006\u0003\b\u0090\u0001J9\u0010\u0091\u0001\u001a\n\u0012\u0005\u0012\u00030\u0093\u00010\u0092\u00012\u000f\u0010\u0094\u0001\u001a\n\u0012\u0005\u0012\u00030\u0093\u00010\u0095\u00012\u000f\u0010\u0096\u0001\u001a\n\u0012\u0005\u0012\u00030\u0093\u00010\u0097\u0001H\u0000\u00a2\u0006\u0003\b\u0098\u0001J9\u0010\u0099\u0001\u001a\n\u0012\u0005\u0012\u00030\u009a\u00010\u0092\u00012\u000f\u0010\u0094\u0001\u001a\n\u0012\u0005\u0012\u00030\u009a\u00010\u0095\u00012\u000f\u0010\u0096\u0001\u001a\n\u0012\u0005\u0012\u00030\u009a\u00010\u0097\u0001H\u0000\u00a2\u0006\u0003\b\u009b\u0001J\n\u0010\u009c\u0001\u001a\u00030\u0084\u0001H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u001a\u001a\u00060\u001bR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0015\u0010\"\u001a\u00060#R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0015\u0010&\u001a\u00060'R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0015\u0010*\u001a\u00060+R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0015\u0010.\u001a\u00060/R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0015\u00102\u001a\u000603R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0015\u00106\u001a\u000607R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0015\u0010:\u001a\u00060;R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u0015\u0010>\u001a\u00060?R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u0015\u0010B\u001a\u00060CR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u0015\u0010F\u001a\u00060GR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010IR\u0015\u0010J\u001a\u00060KR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010MR\u0011\u0010N\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\bO\u0010\u0017R$\u0010P\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010R\u0018\u00010QX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010T\"\u0004\bU\u0010VR\u0013\u0010W\u001a\u0004\u0018\u00010R8F\u00a2\u0006\u0006\u001a\u0004\bX\u0010YR*\u0010Z\u001a\u0018\u0012\u0004\u0012\u00020\\\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010]0Q\u0018\u00010[X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u0010_R!\u0010`\u001a\u0012\u0012\u0004\u0012\u00020\\\u0012\u0006\u0012\u0004\u0018\u00010]\u0018\u00010[8F\u00a2\u0006\u0006\u001a\u0004\ba\u0010_R7\u0010e\u001a\b\u0012\u0004\u0012\u00020d0c2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0c8F@@X\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bj\u0010k\u001a\u0004\bf\u0010g\"\u0004\bh\u0010iR7\u0010l\u001a\b\u0012\u0004\u0012\u00020d0c2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0c8F@@X\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bo\u0010k\u001a\u0004\bm\u0010g\"\u0004\bn\u0010iR\u0017\u0010p\u001a\b\u0012\u0004\u0012\u00020d0c8F\u00a2\u0006\u0006\u001a\u0004\bq\u0010gR7\u0010r\u001a\b\u0012\u0004\u0012\u00020d0c2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0c8F@@X\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bu\u0010k\u001a\u0004\bs\u0010g\"\u0004\bt\u0010iR\u0017\u0010v\u001a\b\u0012\u0004\u0012\u00020d0c8F\u00a2\u0006\u0006\u001a\u0004\bw\u0010gR/\u0010x\u001a\u0004\u0018\u00010\u00002\b\u0010b\u001a\u0004\u0018\u00010\u00008F@@X\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b|\u0010k\u001a\u0004\by\u0010\u0014\"\u0004\bz\u0010{R9\u0010~\u001a\b\u0012\u0004\u0012\u00020}0c2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020}0c8F@@X\u0086\u008e\u0002\u00a2\u0006\u0014\n\u0005\b\u0081\u0001\u0010k\u001a\u0004\b\u007f\u0010g\"\u0005\b\u0080\u0001\u0010iR\"\u0010\u0082\u0001\u001a\u0010\u0012\u0005\u0012\u00030\u0084\u0001\u0012\u0004\u0012\u00020\u00010\u0083\u0001\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0085\u0001\u0010\u0086\u0001R\u0010\u0010\u0087\u0001\u001a\u00030\u0088\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0089\u0001\u001a\u00020\u00018FX\u0086\u0084\u0002\u00a2\u0006\u0010\u001a\u0006\b\u008c\u0001\u0010\u008d\u0001*\u0006\b\u008a\u0001\u0010\u008b\u0001\u00a8\u0006\u00aa\u0001"}, d2={"Ltheorycrafter/fitting/Fit;", "", "eveData", "Leve/data/EveData;", "character", "Ltheorycrafter/fitting/Character;", "ship", "Ltheorycrafter/fitting/Ship;", "warfareBuffs", "Ltheorycrafter/fitting/WarfareBuffs;", "auxiliaryFitOf", "<init>", "(Leve/data/EveData;Ltheorycrafter/fitting/Character;Ltheorycrafter/fitting/Ship;Ltheorycrafter/fitting/WarfareBuffs;Ltheorycrafter/fitting/Fit;)V", "getCharacter", "()Ltheorycrafter/fitting/Character;", "getShip", "()Ltheorycrafter/fitting/Ship;", "getWarfareBuffs", "()Ltheorycrafter/fitting/WarfareBuffs;", "getAuxiliaryFitOf", "()Ltheorycrafter/fitting/Fit;", "isAuxiliary", "", "()Z", "attributes", "Leve/data/Attributes;", "fitting", "Ltheorycrafter/fitting/Fit$Fitting;", "getFitting", "()Ltheorycrafter/fitting/Fit$Fitting;", "defenses", "Ltheorycrafter/fitting/ItemDefenses;", "getDefenses", "()Ltheorycrafter/fitting/ItemDefenses;", "capacitor", "Ltheorycrafter/fitting/Fit$Capacitor;", "getCapacitor", "()Ltheorycrafter/fitting/Fit$Capacitor;", "targeting", "Ltheorycrafter/fitting/Fit$Targeting;", "getTargeting", "()Ltheorycrafter/fitting/Fit$Targeting;", "propulsion", "Ltheorycrafter/fitting/Fit$Propulsion;", "getPropulsion", "()Ltheorycrafter/fitting/Fit$Propulsion;", "drones", "Ltheorycrafter/fitting/Fit$Drones;", "getDrones", "()Ltheorycrafter/fitting/Fit$Drones;", "electronicWarfare", "Ltheorycrafter/fitting/Fit$ElectronicWarfare;", "getElectronicWarfare", "()Ltheorycrafter/fitting/Fit$ElectronicWarfare;", "modules", "Ltheorycrafter/fitting/Fit$Modules;", "getModules", "()Ltheorycrafter/fitting/Fit$Modules;", "cargohold", "Ltheorycrafter/fitting/Fit$Cargohold;", "getCargohold", "()Ltheorycrafter/fitting/Fit$Cargohold;", "implants", "Ltheorycrafter/fitting/Fit$Implants;", "getImplants", "()Ltheorycrafter/fitting/Fit$Implants;", "boosters", "Ltheorycrafter/fitting/Fit$Boosters;", "getBoosters", "()Ltheorycrafter/fitting/Fit$Boosters;", "firepower", "Ltheorycrafter/fitting/Fit$Firepower;", "getFirepower", "()Ltheorycrafter/fitting/Fit$Firepower;", "remoteRepairs", "Ltheorycrafter/fitting/Fit$RemoteRepairs;", "getRemoteRepairs", "()Ltheorycrafter/fitting/Fit$RemoteRepairs;", "hasTacticalModes", "getHasTacticalModes", "tacticalModeState", "Landroidx/compose/runtime/MutableState;", "Ltheorycrafter/fitting/TacticalMode;", "getTacticalModeState$FittingEngine", "()Landroidx/compose/runtime/MutableState;", "setTacticalModeState$FittingEngine", "(Landroidx/compose/runtime/MutableState;)V", "tacticalMode", "getTacticalMode", "()Ltheorycrafter/fitting/TacticalMode;", "subsystemStateByKind", "Leve/data/utils/ValueByEnum;", "Leve/data/SubsystemType$Kind;", "Ltheorycrafter/fitting/Subsystem;", "getSubsystemStateByKind$FittingEngine", "()Leve/data/utils/ValueByEnum;", "subsystemByKind", "getSubsystemByKind", "<set-?>", "", "Ltheorycrafter/fitting/RemoteEffect;", "commandEffects", "getCommandEffects", "()Ljava/util/List;", "setCommandEffects$FittingEngine", "(Ljava/util/List;)V", "commandEffects$delegate", "Landroidx/compose/runtime/MutableState;", "hostileEffects", "getHostileEffects", "setHostileEffects$FittingEngine", "hostileEffects$delegate", "activeHostileEffects", "getActiveHostileEffects", "friendlyEffects", "getFriendlyEffects", "setFriendlyEffects$FittingEngine", "friendlyEffects$delegate", "activeFriendlyEffects", "getActiveFriendlyEffects", "auxiliaryFit", "getAuxiliaryFit", "setAuxiliaryFit$FittingEngine", "(Ltheorycrafter/fitting/Fit;)V", "auxiliaryFit$delegate", "Ltheorycrafter/fitting/Environment;", "environments", "getEnvironments", "setEnvironments$FittingEngine", "environments$delegate", "extras", "", "", "getExtras", "()Ljava/util/Map;", "changeKeyState", "Landroidx/compose/runtime/MutableIntState;", "changeKey", "getChangeKey$delegate", "(Ltheorycrafter/fitting/Fit;)Ljava/lang/Object;", "getChangeKey", "()Ljava/lang/Object;", "onChanged", "", "onChanged$FittingEngine", "IntResource", "Ltheorycrafter/fitting/Fit$Resource;", "", "totalProperty", "Ltheorycrafter/fitting/AttributeProperty;", "usedGetter", "Lkotlin/Function0;", "IntResource$FittingEngine", "DoubleResource", "", "DoubleResource$FittingEngine", "toString", "Resource", "Fitting", "Firepower", "Capacitor", "Targeting", "Propulsion", "RemoteRepairs", "Drones", "ElectronicWarfare", "Modules", "Cargohold", "Implants", "Boosters", "FittingEngine"})
@Stable
@SourceDebugExtension(value={"SMAP\nFit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fit.kt\ntheorycrafter/fitting/Fit\n+ 2 ValueByEnum.kt\neve/data/utils/ValueByEnumKt\n+ 3 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 SnapshotIntState.kt\nandroidx/compose/runtime/SnapshotIntStateKt__SnapshotIntStateKt\n*L\n1#1,1195:1\n40#2,3:1196\n51#2:1199\n40#2,3:1200\n81#3:1203\n107#3,2:1204\n81#3:1206\n107#3,2:1207\n81#3:1212\n107#3,2:1213\n81#3:1218\n107#3,2:1219\n81#3:1221\n107#3,2:1222\n774#4:1209\n865#4,2:1210\n774#4:1215\n865#4,2:1216\n78#5:1224\n*S KotlinDebug\n*F\n+ 1 Fit.kt\ntheorycrafter/fitting/Fit\n*L\n180#1:1196,3\n189#1:1199\n189#1:1200,3\n195#1:1203\n195#1:1204,2\n202#1:1206\n202#1:1207,2\n216#1:1212\n216#1:1213,2\n230#1:1218\n230#1:1219,2\n237#1:1221\n237#1:1222,2\n210#1:1209\n210#1:1210,2\n224#1:1215\n224#1:1216,2\n257#1:1224\n*E\n"})
public final class Fit {
    @NotNull
    private final EveData eveData;
    @NotNull
    private final Character character;
    @NotNull
    private final Ship ship;
    @NotNull
    private final WarfareBuffs warfareBuffs;
    @Nullable
    private final Fit auxiliaryFitOf;
    @NotNull
    private final Attributes attributes;
    @NotNull
    private final Fitting fitting;
    @NotNull
    private final ItemDefenses defenses;
    @NotNull
    private final Capacitor capacitor;
    @NotNull
    private final Targeting targeting;
    @NotNull
    private final Propulsion propulsion;
    @NotNull
    private final Drones drones;
    @NotNull
    private final ElectronicWarfare electronicWarfare;
    @NotNull
    private final Modules modules;
    @NotNull
    private final Cargohold cargohold;
    @NotNull
    private final Implants implants;
    @NotNull
    private final Boosters boosters;
    @NotNull
    private final Firepower firepower;
    @NotNull
    private final RemoteRepairs remoteRepairs;
    @Nullable
    private MutableState<TacticalMode> tacticalModeState;
    @Nullable
    private final ValueByEnum<SubsystemType.Kind, MutableState<Subsystem>> subsystemStateByKind;
    @NotNull
    private final MutableState commandEffects$delegate;
    @NotNull
    private final MutableState hostileEffects$delegate;
    @NotNull
    private final MutableState friendlyEffects$delegate;
    @NotNull
    private final MutableState auxiliaryFit$delegate;
    @NotNull
    private final MutableState environments$delegate;
    @NotNull
    private final Map<String, Object> extras;
    @NotNull
    private final MutableIntState changeKeyState;
    public static final int $stable;

    public Fit(@NotNull EveData eveData, @NotNull Character character, @NotNull Ship ship, @NotNull WarfareBuffs warfareBuffs, @Nullable Fit auxiliaryFitOf) {
        ValueByEnum valueByEnum;
        Intrinsics.checkNotNullParameter((Object)eveData, (String)"eveData");
        Intrinsics.checkNotNullParameter((Object)character, (String)"character");
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        Intrinsics.checkNotNullParameter((Object)warfareBuffs, (String)"warfareBuffs");
        this.eveData = eveData;
        this.character = character;
        this.ship = ship;
        this.warfareBuffs = warfareBuffs;
        this.auxiliaryFitOf = auxiliaryFitOf;
        this.attributes = this.eveData.getAttributes();
        this.fitting = new Fitting();
        this.defenses = new ItemDefenses(this.ship, this.attributes, (Function0<? extends Iterable<Module>>)((Function0)() -> Fit.defenses$lambda$0(this)), (Function0<? extends Iterable<RemoteEffect>>)((Function0)new PropertyReference0Impl(this){

            public Object get() {
                return ((Fit)this.receiver).getActiveFriendlyEffects();
            }
        }));
        this.capacitor = new Capacitor();
        this.targeting = new Targeting();
        this.propulsion = new Propulsion();
        this.drones = new Drones();
        this.electronicWarfare = new ElectronicWarfare();
        this.modules = new Modules();
        this.cargohold = new Cargohold();
        this.implants = new Implants();
        this.boosters = new Boosters();
        this.firepower = new Firepower();
        this.remoteRepairs = new RemoteRepairs();
        this.tacticalModeState = this.getHasTacticalModes() ? SnapshotStateKt.mutableStateOf$default(null, null, (int)2, null) : null;
        Fit fit = this;
        if (((ShipType)this.ship.getType()).getUsesSubsystems()) {
            Fit fit2 = fit;
            boolean $i$f$valueByEnum = false;
            SubsystemType.Kind[] enumValues$iv = SubsystemType.Kind.values();
            int n = 0;
            int n2 = enumValues$iv.length;
            Object[] objectArray = new MutableState[n2];
            while (n < n2) {
                int n3 = n++;
                SubsystemType.Kind kind = enumValues$iv[n3];
                int n4 = n3;
                Object[] objectArray2 = objectArray;
                boolean bl = false;
                MutableState mutableState = SnapshotStateKt.mutableStateOf$default(null, null, (int)2, null);
                objectArray2[n4] = mutableState;
            }
            Object[] valueByOrdinal$iv = objectArray;
            valueByEnum = new ValueByEnum(valueByOrdinal$iv);
            fit = fit2;
        } else {
            valueByEnum = null;
        }
        fit.subsystemStateByKind = valueByEnum;
        this.commandEffects$delegate = SnapshotStateKt.mutableStateOf$default((Object)CollectionsKt.emptyList(), null, (int)2, null);
        this.hostileEffects$delegate = SnapshotStateKt.mutableStateOf$default((Object)CollectionsKt.emptyList(), null, (int)2, null);
        this.friendlyEffects$delegate = SnapshotStateKt.mutableStateOf$default((Object)CollectionsKt.emptyList(), null, (int)2, null);
        this.auxiliaryFit$delegate = SnapshotStateKt.mutableStateOf$default(null, null, (int)2, null);
        this.environments$delegate = SnapshotStateKt.mutableStateOf$default((Object)CollectionsKt.emptyList(), null, (int)2, null);
        this.extras = (Map)SnapshotStateKt.mutableStateMapOf();
        this.changeKeyState = SnapshotIntStateKt.mutableIntStateOf((int)0);
    }

    @NotNull
    public final Character getCharacter() {
        return this.character;
    }

    @NotNull
    public final Ship getShip() {
        return this.ship;
    }

    @NotNull
    public final WarfareBuffs getWarfareBuffs() {
        return this.warfareBuffs;
    }

    @Nullable
    public final Fit getAuxiliaryFitOf() {
        return this.auxiliaryFitOf;
    }

    public final boolean isAuxiliary() {
        return this.auxiliaryFitOf != null;
    }

    @NotNull
    public final Fitting getFitting() {
        return this.fitting;
    }

    @NotNull
    public final ItemDefenses getDefenses() {
        return this.defenses;
    }

    @NotNull
    public final Capacitor getCapacitor() {
        return this.capacitor;
    }

    @NotNull
    public final Targeting getTargeting() {
        return this.targeting;
    }

    @NotNull
    public final Propulsion getPropulsion() {
        return this.propulsion;
    }

    @NotNull
    public final Drones getDrones() {
        return this.drones;
    }

    @NotNull
    public final ElectronicWarfare getElectronicWarfare() {
        return this.electronicWarfare;
    }

    @NotNull
    public final Modules getModules() {
        return this.modules;
    }

    @NotNull
    public final Cargohold getCargohold() {
        return this.cargohold;
    }

    @NotNull
    public final Implants getImplants() {
        return this.implants;
    }

    @NotNull
    public final Boosters getBoosters() {
        return this.boosters;
    }

    @NotNull
    public final Firepower getFirepower() {
        return this.firepower;
    }

    @NotNull
    public final RemoteRepairs getRemoteRepairs() {
        return this.remoteRepairs;
    }

    public final boolean getHasTacticalModes() {
        return ((ShipType)this.ship.getType()).getHasTacticalModes();
    }

    @Nullable
    public final MutableState<TacticalMode> getTacticalModeState$FittingEngine() {
        return this.tacticalModeState;
    }

    public final void setTacticalModeState$FittingEngine(@Nullable MutableState<TacticalMode> mutableState) {
        this.tacticalModeState = mutableState;
    }

    @Nullable
    public final TacticalMode getTacticalMode() {
        MutableState<TacticalMode> mutableState = this.tacticalModeState;
        return mutableState != null ? (TacticalMode)mutableState.getValue() : null;
    }

    @Nullable
    public final ValueByEnum<SubsystemType.Kind, MutableState<Subsystem>> getSubsystemStateByKind$FittingEngine() {
        return this.subsystemStateByKind;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ValueByEnum<SubsystemType.Kind, Subsystem> getSubsystemByKind() {
        ValueByEnum valueByEnum;
        ValueByEnum<SubsystemType.Kind, MutableState<Subsystem>> valueByEnum2 = this.subsystemStateByKind;
        if (valueByEnum2 != null) {
            ValueByEnum<SubsystemType.Kind, MutableState<Subsystem>> $this$mapValues$iv = valueByEnum2;
            boolean $i$f$mapValues = false;
            boolean $i$f$valueByEnum = false;
            SubsystemType.Kind[] enumValues$iv$iv = SubsystemType.Kind.values();
            int n = 0;
            int n2 = enumValues$iv$iv.length;
            Object[] objectArray = new Subsystem[n2];
            while (n < n2) {
                void key$iv;
                int n3 = n++;
                Enum enum_ = (Enum)enumValues$iv$iv[n3];
                int n4 = n3;
                Object[] objectArray2 = objectArray;
                boolean bl = false;
                MutableState it = (MutableState)$this$mapValues$iv.get((Enum)key$iv);
                boolean bl2 = false;
                Subsystem subsystem = (Subsystem)it.getValue();
                objectArray2[n4] = subsystem;
            }
            Object[] valueByOrdinal$iv$iv = objectArray;
            valueByEnum = new ValueByEnum(valueByOrdinal$iv$iv);
        } else {
            valueByEnum = null;
        }
        return valueByEnum;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RemoteEffect> getCommandEffects() {
        void $this$getValue$iv;
        State state = (State)this.commandEffects$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (List)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setCommandEffects$FittingEngine(@NotNull List<RemoteEffect> list) {
        void $this$setValue$iv;
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        MutableState mutableState = this.commandEffects$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RemoteEffect> getHostileEffects() {
        void $this$getValue$iv;
        State state = (State)this.hostileEffects$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (List)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setHostileEffects$FittingEngine(@NotNull List<RemoteEffect> list) {
        void $this$setValue$iv;
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        MutableState mutableState = this.hostileEffects$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RemoteEffect> getActiveHostileEffects() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getHostileEffects();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RemoteEffect it = (RemoteEffect)element$iv$iv;
            boolean bl = false;
            if (!it.getEnabled()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RemoteEffect> getFriendlyEffects() {
        void $this$getValue$iv;
        State state = (State)this.friendlyEffects$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (List)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setFriendlyEffects$FittingEngine(@NotNull List<RemoteEffect> list) {
        void $this$setValue$iv;
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        MutableState mutableState = this.friendlyEffects$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RemoteEffect> getActiveFriendlyEffects() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getFriendlyEffects();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RemoteEffect it = (RemoteEffect)element$iv$iv;
            boolean bl = false;
            if (!it.getEnabled()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Fit getAuxiliaryFit() {
        void $this$getValue$iv;
        State state = (State)this.auxiliaryFit$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Fit)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setAuxiliaryFit$FittingEngine(@Nullable Fit fit) {
        void $this$setValue$iv;
        MutableState mutableState = this.auxiliaryFit$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)fit);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Environment> getEnvironments() {
        void $this$getValue$iv;
        State state = (State)this.environments$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (List)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setEnvironments$FittingEngine(@NotNull List<Environment> list) {
        void $this$setValue$iv;
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        MutableState mutableState = this.environments$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(list);
    }

    @NotNull
    public final Map<String, Object> getExtras() {
        return this.extras;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Object getChangeKey() {
        void $this$getValue$iv;
        IntState intState = (IntState)this.changeKeyState;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getIntValue();
    }

    private static Object getChangeKey$delegate(Fit fit) {
        return fit.changeKeyState;
    }

    public final void onChanged$FittingEngine() {
        MutableIntState mutableIntState = this.changeKeyState;
        mutableIntState.setValue(mutableIntState.getValue() + 1);
    }

    @NotNull
    public final Resource<Integer> IntResource$FittingEngine(@NotNull AttributeProperty<Integer> totalProperty, @NotNull Function0<Integer> usedGetter) {
        Intrinsics.checkNotNullParameter(totalProperty, (String)"totalProperty");
        Intrinsics.checkNotNullParameter(usedGetter, (String)"usedGetter");
        return new Resource<Integer>(totalProperty, usedGetter, IntResource.1.INSTANCE);
    }

    @NotNull
    public final Resource<Double> DoubleResource$FittingEngine(@NotNull AttributeProperty<Double> totalProperty, @NotNull Function0<Double> usedGetter) {
        Intrinsics.checkNotNullParameter(totalProperty, (String)"totalProperty");
        Intrinsics.checkNotNullParameter(usedGetter, (String)"usedGetter");
        return new Resource<Double>(totalProperty, usedGetter, DoubleResource.1.INSTANCE);
    }

    @NotNull
    public String toString() {
        Object object;
        block3: {
            block2: {
                object = this.auxiliaryFitOf;
                if (object == null) break block2;
                Fit it = object;
                boolean bl = false;
                String string = "Auxiliary fit of " + it.ship;
                object = string;
                if (string != null) break block3;
            }
            object = "Fit of " + this.ship;
        }
        return object;
    }

    private static final Iterable defenses$lambda$0(Fit this$0) {
        return this$0.modules.getActive();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0010R\"\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\t\u00a8\u0006\u0013"}, d2={"Ltheorycrafter/fitting/Fit$Boosters;", "", "<init>", "(Ltheorycrafter/fitting/Fit;)V", "mutableSlots", "", "Landroidx/compose/runtime/MutableState;", "Ltheorycrafter/fitting/Booster;", "getMutableSlots$FittingEngine", "()Ljava/util/List;", "slots", "", "getSlots", "()Ljava/lang/Iterable;", "inSlot", "slotIndex", "", "fitted", "getFitted", "FittingEngine"})
    @SourceDebugExtension(value={"SMAP\nFit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fit.kt\ntheorycrafter/fitting/Fit$Boosters\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1195:1\n1#2:1196\n1#2:1207\n1611#3,9:1197\n1863#3:1206\n1864#3:1208\n1620#3:1209\n*S KotlinDebug\n*F\n+ 1 Fit.kt\ntheorycrafter/fitting/Fit$Boosters\n*L\n1174#1:1207\n1174#1:1197,9\n1174#1:1206\n1174#1:1208\n1174#1:1209\n*E\n"})
    public final class Boosters {
        @NotNull
        private final List<MutableState<Booster>> mutableSlots;

        public Boosters() {
            int n = Fit.this.eveData.getBoosterSlotCount();
            Boosters boosters = this;
            ArrayList<MutableState> arrayList = new ArrayList<MutableState>(n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n3 = n2++;
                ArrayList<MutableState> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(SnapshotStateKt.mutableStateOf$default(null, null, (int)2, null));
            }
            boosters.mutableSlots = arrayList;
        }

        @NotNull
        public final List<MutableState<Booster>> getMutableSlots$FittingEngine() {
            return this.mutableSlots;
        }

        @NotNull
        public final Iterable<Booster> getSlots() {
            return FitKt.access$currentValues(this.mutableSlots);
        }

        @Nullable
        public final Booster inSlot(int slotIndex) {
            return (Booster)this.mutableSlots.get(slotIndex).getValue();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Booster> getFitted() {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = this.mutableSlots;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Booster it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                MutableState it = (MutableState)element$iv$iv;
                boolean bl2 = false;
                if ((Booster)it.getValue() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u001b\u001a\u00020\u001cR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0015\u001a\u00020\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001d"}, d2={"Ltheorycrafter/fitting/Fit$Capacitor;", "", "<init>", "(Ltheorycrafter/fitting/Fit;)V", "capacity", "Ltheorycrafter/fitting/AttributeProperty;", "", "getCapacity", "()Ltheorycrafter/fitting/AttributeProperty;", "rechargeTime", "getRechargeTime", "peakRechargeRate", "getPeakRechargeRate", "()D", "localModulesRelevantForCapacitorStability", "Landroidx/compose/runtime/State;", "", "Ltheorycrafter/fitting/Module;", "hostileItemsRelevantForCapacitorStability", "Ltheorycrafter/fitting/ModuleOrDrone;", "friendlyModulesRelevantForCapacitorStability", "stability", "Ltheorycrafter/fitting/CapacitorStability;", "getStability", "()Ltheorycrafter/fitting/CapacitorStability;", "stability$delegate", "Landroidx/compose/runtime/State;", "simulation", "Ltheorycrafter/fitting/CapacitorSimulation;", "FittingEngine"})
    @SourceDebugExtension(value={"SMAP\nFit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fit.kt\ntheorycrafter/fitting/Fit$Capacitor\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1195:1\n81#2:1196\n774#3:1197\n865#3,2:1198\n1368#3:1200\n1454#3,5:1201\n774#3:1206\n865#3,2:1207\n1368#3:1209\n1454#3,5:1210\n774#3:1215\n865#3,2:1216\n*S KotlinDebug\n*F\n+ 1 Fit.kt\ntheorycrafter/fitting/Fit$Capacitor\n*L\n536#1:1196\n507#1:1197\n507#1:1198,2\n516#1:1200\n516#1:1201,5\n519#1:1206\n519#1:1207,2\n528#1:1209\n528#1:1210,5\n529#1:1215\n529#1:1216,2\n*E\n"})
    public final class Capacitor {
        @NotNull
        private final State<List<Module>> localModulesRelevantForCapacitorStability = SnapshotStateKt.derivedStateOf((SnapshotMutationPolicy)SnapshotStateKt.structuralEqualityPolicy(), () -> Capacitor.localModulesRelevantForCapacitorStability$lambda$0(Fit.this));
        @NotNull
        private final State<List<ModuleOrDrone<?>>> hostileItemsRelevantForCapacitorStability = SnapshotStateKt.derivedStateOf((SnapshotMutationPolicy)SnapshotStateKt.structuralEqualityPolicy(), () -> Capacitor.hostileItemsRelevantForCapacitorStability$lambda$3(Fit.this));
        @NotNull
        private final State<List<Module>> friendlyModulesRelevantForCapacitorStability = SnapshotStateKt.derivedStateOf((SnapshotMutationPolicy)SnapshotStateKt.structuralEqualityPolicy(), () -> Capacitor.friendlyModulesRelevantForCapacitorStability$lambda$6(Fit.this));
        @NotNull
        private final State stability$delegate = SnapshotStateKt.derivedStateOf(() -> Capacitor.stability_delegate$lambda$7(this, Fit.this));

        @NotNull
        public final AttributeProperty<Double> getCapacity() {
            return Fit.this.getShip().property(Fit.this.attributes.getCapacitorCapacity());
        }

        @NotNull
        public final AttributeProperty<Double> getRechargeTime() {
            return Fit.this.getShip().property(Fit.this.attributes.getCapacitorRechargeTime());
        }

        public final double getPeakRechargeRate() {
            return MechanicsKt.maxRechargeRate(((Number)this.getCapacity().getValue()).doubleValue(), ((Number)this.getRechargeTime().getValue()).doubleValue());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final CapacitorStability getStability() {
            void $this$getValue$iv;
            State state = this.stability$delegate;
            Object property$iv = null;
            boolean $i$f$getValue = false;
            return (CapacitorStability)$this$getValue$iv.getValue();
        }

        @NotNull
        public final CapacitorSimulation simulation() {
            return MechanicsKt.capacitorSimulation(((Number)this.getCapacity().getValue()).doubleValue(), ((Number)this.getRechargeTime().getValue()).doubleValue(), ((Number)Fit.this.getElectronicWarfare().getEnergyNeutralizationResistance().getValue()).doubleValue(), (Collection)this.localModulesRelevantForCapacitorStability.getValue(), (Collection)this.hostileItemsRelevantForCapacitorStability.getValue(), (Collection)this.friendlyModulesRelevantForCapacitorStability.getValue());
        }

        /*
         * WARNING - void declaration
         */
        private static final List localModulesRelevantForCapacitorStability$lambda$0(Fit this$0) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this$0.getModules().getActive();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Module p0 = (Module)element$iv$iv;
                boolean bl = false;
                boolean $i$f$localModulesRelevantForCapacitorStability$lambda$0$stub_for_inlining = false;
                if (!MechanicsKt.isRelevantForCapacitorStabilityAsLocalModule(p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private static final List hostileItemsRelevantForCapacitorStability$lambda$3(Fit this$0) {
            void $this$filterTo$iv$iv;
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = this$0.getActiveHostileEffects();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                RemoteEffect it = (RemoteEffect)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = SetsKt.plus(it.getAffectingModules(), (Iterable)it.getAffectingDrones());
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ModuleOrDrone p0 = (ModuleOrDrone)element$iv$iv;
                boolean bl = false;
                boolean $i$f$hostileItemsRelevantForCapacitorStability$lambda$3$stub_for_inlining$2 = false;
                if (!MechanicsKt.isRelevantForCapacitorStabilityAsHostileItem(p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private static final List friendlyModulesRelevantForCapacitorStability$lambda$6(Fit this$0) {
            void $this$filterTo$iv$iv;
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = this$0.getActiveFriendlyEffects();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                RemoteEffect it = (RemoteEffect)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getAffectingModules();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Module p0 = (Module)element$iv$iv;
                boolean bl = false;
                boolean $i$f$friendlyModulesRelevantForCapacitorStability$lambda$6$stub_for_inlining$5 = false;
                if (!MechanicsKt.isRelevantForCapacitorStabilityAsFriendlyModule(p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private static final CapacitorStability stability_delegate$lambda$7(Capacitor this$0, Fit this$1) {
            return MechanicsKt.capacitorStability(((Number)this$0.getCapacity().getValue()).doubleValue(), ((Number)this$0.getRechargeTime().getValue()).doubleValue(), ((Number)this$1.getElectronicWarfare().getEnergyNeutralizationResistance().getValue()).doubleValue(), (Collection)this$0.localModulesRelevantForCapacitorStability.getValue(), (Collection)this$0.hostileItemsRelevantForCapacitorStability.getValue(), (Collection)this$0.friendlyModulesRelevantForCapacitorStability.getValue());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R7\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F@@X\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Ltheorycrafter/fitting/Fit$Cargohold;", "", "<init>", "(Ltheorycrafter/fitting/Fit;)V", "<set-?>", "", "Ltheorycrafter/fitting/CargoItem;", "contents", "getContents", "()Ljava/util/List;", "setContents$FittingEngine", "(Ljava/util/List;)V", "contents$delegate", "Landroidx/compose/runtime/MutableState;", "capacity", "Ltheorycrafter/fitting/Fit$Resource;", "", "getCapacity", "()Ltheorycrafter/fitting/Fit$Resource;", "FittingEngine"})
    @SourceDebugExtension(value={"SMAP\nFit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fit.kt\ntheorycrafter/fitting/Fit$Cargohold\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 3 Collections.kt\ntheorycrafter/fitting/utils/CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1195:1\n81#2:1196\n107#2,2:1197\n101#3:1199\n1#4:1200\n*S KotlinDebug\n*F\n+ 1 Fit.kt\ntheorycrafter/fitting/Fit$Cargohold\n*L\n1089#1:1196\n1089#1:1197,2\n1098#1:1199\n1098#1:1200\n*E\n"})
    public final class Cargohold {
        @NotNull
        private final MutableState contents$delegate = SnapshotStateKt.mutableStateOf$default((Object)CollectionsKt.emptyList(), null, (int)2, null);
        @NotNull
        private final Resource<Double> capacity = Fit.this.DoubleResource$FittingEngine(Fit.this.getShip().getCargoCapacity(), (Function0<Double>)((Function0)() -> Cargohold.capacity$lambda$0(this)));

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<CargoItem> getContents() {
            void $this$getValue$iv;
            State state = (State)this.contents$delegate;
            Object property$iv = null;
            boolean $i$f$getValue = false;
            return (List)$this$getValue$iv.getValue();
        }

        /*
         * WARNING - void declaration
         */
        public final void setContents$FittingEngine(@NotNull List<CargoItem> list) {
            void $this$setValue$iv;
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            MutableState mutableState = this.contents$delegate;
            Object property$iv = null;
            boolean $i$f$setValue = false;
            $this$setValue$iv.setValue(list);
        }

        @NotNull
        public final Resource<Double> getCapacity() {
            return this.capacity;
        }

        /*
         * WARNING - void declaration
         */
        private static final double capacity$lambda$0(Cargohold this$0) {
            Iterable $this$sumOfNullable$iv = this$0.getContents();
            boolean $i$f$sumOfNullable = false;
            Iterable iterable = $this$sumOfNullable$iv;
            double d = 0.0;
            Iterator iterator2 = iterable.iterator();
            while (iterator2.hasNext()) {
                void it$iv;
                Object t;
                Object t2 = t = iterator2.next();
                double d2 = d;
                boolean bl = false;
                CargoItem p0 = (CargoItem)it$iv;
                boolean bl2 = false;
                boolean $i$f$capacity$lambda$0$stub_for_inlining = false;
                double d3 = p0.getVolume();
                d = d2 + d3;
            }
            return d;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e*\u0004\b\u000b\u0010\fR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Ltheorycrafter/fitting/Fit$Drones;", "", "<init>", "(Ltheorycrafter/fitting/Fit;)V", "allDronesState", "Landroidx/compose/runtime/MutableState;", "", "Ltheorycrafter/fitting/DroneGroup;", "getAllDronesState$FittingEngine", "()Landroidx/compose/runtime/MutableState;", "all", "getAll$delegate", "(Ltheorycrafter/fitting/Fit$Drones;)Ljava/lang/Object;", "getAll", "()Ljava/util/List;", "active", "getActive", "activeCount", "Ltheorycrafter/fitting/Fit$Resource;", "", "getActiveCount", "()Ltheorycrafter/fitting/Fit$Resource;", "capacity", "getCapacity", "bandwidth", "", "getBandwidth", "controlRange", "Ltheorycrafter/fitting/AttributeProperty;", "getControlRange", "()Ltheorycrafter/fitting/AttributeProperty;", "canFitDrones", "", "getCanFitDrones", "()Z", "FittingEngine"})
    @SourceDebugExtension(value={"SMAP\nFit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fit.kt\ntheorycrafter/fitting/Fit$Drones\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1195:1\n81#2:1196\n774#3:1197\n865#3,2:1198\n1#4:1200\n*S KotlinDebug\n*F\n+ 1 Fit.kt\ntheorycrafter/fitting/Fit$Drones\n*L\n806#1:1196\n813#1:1197\n813#1:1198,2\n*E\n"})
    public final class Drones {
        @NotNull
        private final MutableState<List<DroneGroup>> allDronesState = SnapshotStateKt.mutableStateOf$default((Object)CollectionsKt.emptyList(), null, (int)2, null);
        @NotNull
        private final Resource<Integer> activeCount = Fit.this.IntResource$FittingEngine(Fit.this.getCharacter().getMaxActiveDrones(), (Function0<Integer>)((Function0)() -> Drones.activeCount$lambda$2(this)));
        @NotNull
        private final Resource<Integer> capacity = Fit.this.IntResource$FittingEngine(Fit.this.getShip().getDroneCapacity(), (Function0<Integer>)((Function0)() -> Drones.capacity$lambda$4(this)));
        @NotNull
        private final Resource<Double> bandwidth = Fit.this.DoubleResource$FittingEngine(Fit.this.getShip().getDroneBandwidth(), (Function0<Double>)((Function0)() -> Drones.bandwidth$lambda$6(this)));

        @NotNull
        public final MutableState<List<DroneGroup>> getAllDronesState$FittingEngine() {
            return this.allDronesState;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<DroneGroup> getAll() {
            void $this$getValue$iv;
            State state = (State)this.allDronesState;
            Object property$iv = null;
            boolean $i$f$getValue = false;
            return (List)$this$getValue$iv.getValue();
        }

        private static Object getAll$delegate(Drones drones) {
            return drones.allDronesState;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<DroneGroup> getActive() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.getAll();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DroneGroup it = (DroneGroup)element$iv$iv;
                boolean bl = false;
                if (!it.getActive()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final Resource<Integer> getActiveCount() {
            return this.activeCount;
        }

        @NotNull
        public final Resource<Integer> getCapacity() {
            return this.capacity;
        }

        @NotNull
        public final Resource<Double> getBandwidth() {
            return this.bandwidth;
        }

        @NotNull
        public final AttributeProperty<Double> getControlRange() {
            return Fit.this.getCharacter().property(Fit.this.attributes.getDroneControlRange());
        }

        public final boolean getCanFitDrones() {
            return this.capacity.getTotal() > 0 && this.bandwidth.getTotal() > 0.0;
        }

        /*
         * WARNING - void declaration
         */
        private static final int activeCount$lambda$2(Drones this$0) {
            Iterable iterable = this$0.getAll();
            int n = 0;
            for (Object t : iterable) {
                void droneGroup;
                DroneGroup droneGroup2 = (DroneGroup)t;
                int n2 = n;
                boolean bl = false;
                int n3 = droneGroup.getActive() ? droneGroup.getSize() : 0;
                n = n2 + n3;
            }
            return n;
        }

        /*
         * WARNING - void declaration
         */
        private static final int capacity$lambda$4(Drones this$0) {
            Iterable iterable = this$0.getAll();
            int n = 0;
            for (Object t : iterable) {
                void it;
                DroneGroup droneGroup = (DroneGroup)t;
                int n2 = n;
                boolean bl = false;
                int n3 = it.getTotalVolume();
                n = n2 + n3;
            }
            return n;
        }

        /*
         * WARNING - void declaration
         */
        private static final double bandwidth$lambda$6(Drones this$0) {
            Iterable iterable = this$0.getAll();
            int n = 0;
            for (Object t : iterable) {
                void it;
                DroneGroup droneGroup = (DroneGroup)t;
                int n2 = n;
                boolean bl = false;
                int n3 = it.getTotalUsedBandwidth();
                n = n2 + n3;
            }
            return n;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u000b\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\b\u00a8\u0006\u0011"}, d2={"Ltheorycrafter/fitting/Fit$ElectronicWarfare;", "", "<init>", "(Ltheorycrafter/fitting/Fit;)V", "energyNeutralizationResistance", "Ltheorycrafter/fitting/AttributeProperty;", "", "getEnergyNeutralizationResistance", "()Ltheorycrafter/fitting/AttributeProperty;", "weaponDisruptionResistance", "getWeaponDisruptionResistance", "sensorDampenerResistance", "getSensorDampenerResistance", "targetPainterResistance", "getTargetPainterResistance", "ecmResistance", "getEcmResistance", "FittingEngine"})
    public final class ElectronicWarfare {
        @NotNull
        public final AttributeProperty<Double> getEnergyNeutralizationResistance() {
            return Fit.this.getShip().property(Fit.this.attributes.getEnergyWarfareResistance());
        }

        @NotNull
        public final AttributeProperty<Double> getWeaponDisruptionResistance() {
            return Fit.this.getShip().property(Fit.this.attributes.getWeaponDisruptionResistance());
        }

        @NotNull
        public final AttributeProperty<Double> getSensorDampenerResistance() {
            return Fit.this.getShip().property(Fit.this.attributes.getSensorDampenerResistance());
        }

        @NotNull
        public final AttributeProperty<Double> getTargetPainterResistance() {
            return Fit.this.getShip().property(Fit.this.attributes.getTargetPainterResistance());
        }

        @NotNull
        public final AttributeProperty<Double> getEcmResistance() {
            return Fit.this.getShip().property(Fit.this.attributes.getEcmResistance());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000b\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006\u0010"}, d2={"Ltheorycrafter/fitting/Fit$Firepower;", "", "<init>", "(Ltheorycrafter/fitting/Fit;)V", "weaponVolleyDamage", "", "getWeaponVolleyDamage", "()D", "weaponDps", "getWeaponDps", "droneVolleyDamage", "getDroneVolleyDamage", "droneDps", "getDroneDps", "totalDps", "getTotalDps", "FittingEngine"})
    @SourceDebugExtension(value={"SMAP\nFit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fit.kt\ntheorycrafter/fitting/Fit$Firepower\n+ 2 Collections.kt\ntheorycrafter/fitting/utils/CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1195:1\n101#2:1196\n101#2:1198\n101#2:1200\n101#2:1202\n1#3:1197\n1#3:1199\n1#3:1201\n1#3:1203\n*S KotlinDebug\n*F\n+ 1 Fit.kt\ntheorycrafter/fitting/Fit$Firepower\n*L\n434#1:1196\n445#1:1198\n456#1:1200\n463#1:1202\n434#1:1197\n445#1:1199\n456#1:1201\n463#1:1203\n*E\n"})
    public final class Firepower {
        /*
         * WARNING - void declaration
         */
        public final double getWeaponVolleyDamage() {
            void $this$sumOfNullable$iv;
            Iterable iterable = Fit.this.getModules().getAll();
            Fit fit = Fit.this;
            boolean $i$f$sumOfNullable = false;
            void var4_4 = $this$sumOfNullable$iv;
            double d = 0.0;
            Iterator iterator2 = var4_4.iterator();
            while (iterator2.hasNext()) {
                void it$iv;
                Object t;
                Object t2 = t = iterator2.next();
                double d2 = d;
                boolean bl = false;
                Module it = (Module)it$iv;
                boolean bl2 = false;
                EveData $this$_get_weaponVolleyDamage__u24lambda_u241_u24lambda_u240 = fit.eveData;
                boolean bl3 = false;
                Double d3 = ModuleIdentificationKt.isDefenderMissileLauncher((EveData)$this$_get_weaponVolleyDamage__u24lambda_u241_u24lambda_u240, (ModuleType)((ModuleType)it.getType())) ? Double.valueOf(0.0) : it.getVolleyDamage();
                double d4 = d3 != null ? d3 : 0.0;
                d = d2 + d4;
            }
            return d;
        }

        /*
         * WARNING - void declaration
         */
        public final double getWeaponDps() {
            void $this$sumOfNullable$iv;
            Iterable iterable = Fit.this.getModules().getAll();
            Fit fit = Fit.this;
            boolean $i$f$sumOfNullable = false;
            void var4_4 = $this$sumOfNullable$iv;
            double d = 0.0;
            Iterator iterator2 = var4_4.iterator();
            while (iterator2.hasNext()) {
                void it$iv;
                Object t;
                Object t2 = t = iterator2.next();
                double d2 = d;
                boolean bl = false;
                Module it = (Module)it$iv;
                boolean bl2 = false;
                EveData $this$_get_weaponDps__u24lambda_u243_u24lambda_u242 = fit.eveData;
                boolean bl3 = false;
                Double d3 = ModuleIdentificationKt.isDefenderMissileLauncher((EveData)$this$_get_weaponDps__u24lambda_u243_u24lambda_u242, (ModuleType)((ModuleType)it.getType())) ? Double.valueOf(0.0) : it.getDps();
                double d4 = d3 != null ? d3 : 0.0;
                d = d2 + d4;
            }
            return d;
        }

        /*
         * WARNING - void declaration
         */
        public final double getDroneVolleyDamage() {
            Iterable $this$sumOfNullable$iv = Fit.this.getDrones().getAll();
            boolean $i$f$sumOfNullable = false;
            Iterable iterable = $this$sumOfNullable$iv;
            double d = 0.0;
            Iterator iterator2 = iterable.iterator();
            while (iterator2.hasNext()) {
                void it$iv;
                Object t;
                Object t2 = t = iterator2.next();
                double d2 = d;
                boolean bl = false;
                DroneGroup it = (DroneGroup)it$iv;
                boolean bl2 = false;
                Double d3 = it.getTotalVolleyDamage();
                double d4 = d3 != null ? d3 : 0.0;
                d = d2 + d4;
            }
            return d;
        }

        /*
         * WARNING - void declaration
         */
        public final double getDroneDps() {
            Iterable $this$sumOfNullable$iv = Fit.this.getDrones().getAll();
            boolean $i$f$sumOfNullable = false;
            Iterable iterable = $this$sumOfNullable$iv;
            double d = 0.0;
            Iterator iterator2 = iterable.iterator();
            while (iterator2.hasNext()) {
                void it$iv;
                Object t;
                Object t2 = t = iterator2.next();
                double d2 = d;
                boolean bl = false;
                DroneGroup it = (DroneGroup)it$iv;
                boolean bl2 = false;
                Double d3 = it.getTotalDps();
                double d4 = d3 != null ? d3 : 0.0;
                d = d2 + d4;
            }
            return d;
        }

        public final double getTotalDps() {
            return this.getDroneDps() + this.getWeaponDps();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\n0\u0005R\u00060\u0000R\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\rR\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\r\u00a8\u0006\u0018"}, d2={"Ltheorycrafter/fitting/Fit$Fitting;", "", "<init>", "(Ltheorycrafter/fitting/Fit;)V", "slots", "Ltheorycrafter/fitting/Fit$Fitting$Slots;", "Ltheorycrafter/fitting/Fit;", "getSlots", "()Ltheorycrafter/fitting/Fit$Fitting$Slots;", "cpu", "Ltheorycrafter/fitting/Fit$Resource;", "", "getCpu", "()Ltheorycrafter/fitting/Fit$Resource;", "power", "getPower", "calibration", "", "getCalibration", "turretHardpoints", "getTurretHardpoints", "launcherHardpoints", "getLauncherHardpoints", "Slots", "FittingEngine"})
    @SourceDebugExtension(value={"SMAP\nFit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fit.kt\ntheorycrafter/fitting/Fit$Fitting\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1195:1\n1#2:1196\n1782#3,4:1197\n1782#3,4:1201\n*S KotlinDebug\n*F\n+ 1 Fit.kt\ntheorycrafter/fitting/Fit$Fitting\n*L\n360#1:1197,4\n369#1:1201,4\n*E\n"})
    public final class Fitting {
        @NotNull
        private final Slots slots = new Slots();
        @NotNull
        private final Resource<Double> cpu = Fit.this.DoubleResource$FittingEngine(Fit.this.getShip().getCpuOutput(), (Function0<Double>)((Function0)() -> Fitting.cpu$lambda$1(Fit.this)));
        @NotNull
        private final Resource<Double> power = Fit.this.DoubleResource$FittingEngine(Fit.this.getShip().getPowerOutput(), (Function0<Double>)((Function0)() -> Fitting.power$lambda$3(Fit.this)));
        @NotNull
        private final Resource<Integer> calibration = Fit.this.IntResource$FittingEngine(Fit.this.getShip().getCalibration(), (Function0<Integer>)((Function0)() -> Fitting.calibration$lambda$5(Fit.this)));
        @NotNull
        private final Resource<Integer> turretHardpoints = Fit.this.IntResource$FittingEngine(Fit.this.getShip().getTurretHardpoints(), (Function0<Integer>)((Function0)() -> Fitting.turretHardpoints$lambda$7(Fit.this)));
        @NotNull
        private final Resource<Integer> launcherHardpoints = Fit.this.IntResource$FittingEngine(Fit.this.getShip().getLauncherHardpoints(), (Function0<Integer>)((Function0)() -> Fitting.launcherHardpoints$lambda$9(Fit.this)));

        @NotNull
        public final Slots getSlots() {
            return this.slots;
        }

        @NotNull
        public final Resource<Double> getCpu() {
            return this.cpu;
        }

        @NotNull
        public final Resource<Double> getPower() {
            return this.power;
        }

        @NotNull
        public final Resource<Integer> getCalibration() {
            return this.calibration;
        }

        @NotNull
        public final Resource<Integer> getTurretHardpoints() {
            return this.turretHardpoints;
        }

        @NotNull
        public final Resource<Integer> getLauncherHardpoints() {
            return this.launcherHardpoints;
        }

        /*
         * WARNING - void declaration
         */
        private static final double cpu$lambda$1(Fit this$0) {
            Iterable iterable = this$0.getModules().getOnline();
            double d = 0.0;
            for (Object t : iterable) {
                void it;
                Module module = (Module)t;
                double d2 = d;
                boolean bl = false;
                AttributeProperty<Double> attributeProperty = it.getCpuNeed();
                double d3 = attributeProperty != null ? ((Number)attributeProperty.getValue()).doubleValue() : 0.0;
                d = d2 + d3;
            }
            return d;
        }

        /*
         * WARNING - void declaration
         */
        private static final double power$lambda$3(Fit this$0) {
            Iterable iterable = this$0.getModules().getOnline();
            double d = 0.0;
            for (Object t : iterable) {
                void it;
                Module module = (Module)t;
                double d2 = d;
                boolean bl = false;
                AttributeProperty<Double> attributeProperty = it.getPowerNeed();
                double d3 = attributeProperty != null ? ((Number)attributeProperty.getValue()).doubleValue() : 0.0;
                d = d2 + d3;
            }
            return d;
        }

        /*
         * WARNING - void declaration
         */
        private static final int calibration$lambda$5(Fit this$0) {
            Iterable iterable = this$0.getModules().getRigs();
            int n = 0;
            for (Object t : iterable) {
                void it;
                Module module = (Module)t;
                int n2 = n;
                boolean bl = false;
                AttributeProperty<Integer> attributeProperty = it.getCalibrationNeed();
                int n3 = attributeProperty != null ? ((Number)attributeProperty.getValue()).intValue() : 0;
                n = n2 + n3;
            }
            return n;
        }

        /*
         * WARNING - void declaration
         */
        private static final int turretHardpoints$lambda$7(Fit this$0) {
            int n;
            Iterable $this$count$iv = this$0.getModules().getHigh();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                void var3_3;
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Module it = (Module)element$iv;
                    boolean bl = false;
                    if (!((ModuleType)it.getType()).getTakesTurretHardpoint() || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = var3_3;
            }
            return n;
        }

        /*
         * WARNING - void declaration
         */
        private static final int launcherHardpoints$lambda$9(Fit this$0) {
            int n;
            Iterable $this$count$iv = this$0.getModules().getHigh();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                void var3_3;
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Module it = (Module)element$iv;
                    boolean bl = false;
                    if (!((ModuleType)it.getType()).getTakesLauncherHardpoint() || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = var3_3;
            }
            return n;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u0012"}, d2={"Ltheorycrafter/fitting/Fit$Fitting$Slots;", "", "<init>", "(Ltheorycrafter/fitting/Fit$Fitting;)V", "high", "Ltheorycrafter/fitting/AttributeProperty;", "", "getHigh", "()Ltheorycrafter/fitting/AttributeProperty;", "medium", "getMedium", "low", "getLow", "rig", "getRig", "get", "moduleSlotType", "Leve/data/ModuleSlotType;", "FittingEngine"})
        public final class Slots {
            @NotNull
            public final AttributeProperty<Integer> getHigh() {
                return Fit.this.getShip().property(Fit.this.attributes.getHighSlots());
            }

            @NotNull
            public final AttributeProperty<Integer> getMedium() {
                return Fit.this.getShip().property(Fit.this.attributes.getMedSlots());
            }

            @NotNull
            public final AttributeProperty<Integer> getLow() {
                return Fit.this.getShip().property(Fit.this.attributes.getLowSlots());
            }

            @NotNull
            public final AttributeProperty<Integer> getRig() {
                return Fit.this.getShip().property(Fit.this.attributes.getRigSlots());
            }

            public final int get(@NotNull ModuleSlotType moduleSlotType) {
                Intrinsics.checkNotNullParameter((Object)moduleSlotType, (String)"moduleSlotType");
                return switch (WhenMappings.$EnumSwitchMapping$0[moduleSlotType.ordinal()]) {
                    case 1 -> ((Number)this.getHigh().getValue()).intValue();
                    case 2 -> ((Number)this.getMedium().getValue()).intValue();
                    case 3 -> ((Number)this.getLow().getValue()).intValue();
                    case 4 -> ((Number)this.getRig().getValue()).intValue();
                    default -> throw new NoWhenBranchMatchedException();
                };
            }

            @Metadata(mv={2, 0, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[ModuleSlotType.values().length];
                    try {
                        nArray[ModuleSlotType.HIGH.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[ModuleSlotType.MEDIUM.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[ModuleSlotType.LOW.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[ModuleSlotType.RIG.ordinal()] = 4;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0010R\"\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\t\u00a8\u0006\u0013"}, d2={"Ltheorycrafter/fitting/Fit$Implants;", "", "<init>", "(Ltheorycrafter/fitting/Fit;)V", "mutableSlots", "", "Landroidx/compose/runtime/MutableState;", "Ltheorycrafter/fitting/Implant;", "getMutableSlots$FittingEngine", "()Ljava/util/List;", "slots", "", "getSlots", "()Ljava/lang/Iterable;", "inSlot", "slotIndex", "", "fitted", "getFitted", "FittingEngine"})
    @SourceDebugExtension(value={"SMAP\nFit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fit.kt\ntheorycrafter/fitting/Fit$Implants\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1195:1\n1#2:1196\n1#2:1207\n1611#3,9:1197\n1863#3:1206\n1864#3:1208\n1620#3:1209\n*S KotlinDebug\n*F\n+ 1 Fit.kt\ntheorycrafter/fitting/Fit$Implants\n*L\n1137#1:1207\n1137#1:1197,9\n1137#1:1206\n1137#1:1208\n1137#1:1209\n*E\n"})
    public final class Implants {
        @NotNull
        private final List<MutableState<Implant>> mutableSlots;

        public Implants() {
            int n = Fit.this.eveData.getImplantTypes().getSlotCount();
            Implants implants = this;
            ArrayList<MutableState> arrayList = new ArrayList<MutableState>(n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n3 = n2++;
                ArrayList<MutableState> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(SnapshotStateKt.mutableStateOf$default(null, null, (int)2, null));
            }
            implants.mutableSlots = arrayList;
        }

        @NotNull
        public final List<MutableState<Implant>> getMutableSlots$FittingEngine() {
            return this.mutableSlots;
        }

        @NotNull
        public final Iterable<Implant> getSlots() {
            return FitKt.access$currentValues(this.mutableSlots);
        }

        @Nullable
        public final Implant inSlot(int slotIndex) {
            return (Implant)this.mutableSlots.get(slotIndex).getValue();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Implant> getFitted() {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = this.mutableSlots;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Implant it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                MutableState it = (MutableState)element$iv$iv;
                boolean bl2 = false;
                if ((Implant)it.getValue() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u000e\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\r2\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0006J\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\r2\u0006\u0010\u000e\u001a\u00020\u0006J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0010J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\u0018J \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u00072\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001c0\u001bJ\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\t0!2\u0006\u0010\u000e\u001a\u00020\u0006R.\u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b0\u00070\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00120\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\t0!8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010#R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0!8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010#R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020\t0!8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010#R\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020\t0!8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010#R\u0017\u0010-\u001a\b\u0012\u0004\u0012\u00020\t0!8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010#\u00a8\u0006/"}, d2={"Ltheorycrafter/fitting/Fit$Modules;", "", "<init>", "(Ltheorycrafter/fitting/Fit;)V", "slotsByTypeStates", "Leve/data/utils/ValueByEnum;", "Leve/data/ModuleSlotType;", "", "Landroidx/compose/runtime/MutableState;", "Ltheorycrafter/fitting/Module;", "getSlotsByTypeStates$FittingEngine", "()Leve/data/utils/ValueByEnum;", "slotsInRack", "", "slotType", "slotsInRackCount", "", "relevantSlotCountStateBySlotType", "Landroidx/compose/runtime/State;", "relevantSlotCount", "slotsLimitedByRackSize", "inSlot", "slotIndex", "slot", "Leve/data/ModuleSlot;", "filtered", "filter", "Lkotlin/Function1;", "", "all", "getAll", "()Ljava/util/List;", "online", "", "getOnline", "()Ljava/util/Collection;", "active", "getActive", "inRack", "high", "getHigh", "medium", "getMedium", "low", "getLow", "rigs", "getRigs", "FittingEngine"})
    @SourceDebugExtension(value={"SMAP\nFit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fit.kt\ntheorycrafter/fitting/Fit$Modules\n+ 2 ValueByEnum.kt\neve/data/utils/ValueByEnumKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1195:1\n40#2,3:1196\n40#2,3:1199\n1611#3,9:1202\n1863#3:1211\n1864#3:1213\n1620#3:1214\n388#3,7:1215\n1#4:1212\n*S KotlinDebug\n*F\n+ 1 Fit.kt\ntheorycrafter/fitting/Fit$Modules\n*L\n925#1:1196,3\n956#1:1199,3\n1045#1:1202,9\n1045#1:1211\n1045#1:1213\n1045#1:1214\n964#1:1215,7\n1045#1:1212\n*E\n"})
    public final class Modules {
        @NotNull
        private final ValueByEnum<ModuleSlotType, List<MutableState<Module>>> slotsByTypeStates;
        @NotNull
        private final ValueByEnum<ModuleSlotType, State<Integer>> relevantSlotCountStateBySlotType;

        public Modules() {
            State state;
            ModuleSlotType slotType;
            Object[] objectArray;
            int n;
            int n2;
            int n3;
            Fit fit = Fit.this;
            Modules modules = this;
            boolean $i$f$valueByEnum = false;
            ModuleSlotType[] enumValues$iv = ModuleSlotType.values();
            int n4 = enumValues$iv.length;
            Object[] objectArray2 = new List[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = n3;
                ModuleSlotType moduleSlotType = enumValues$iv[n2];
                n = n2;
                objectArray = objectArray2;
                boolean bl = false;
                int slotCount = fit.isAuxiliary() && (slotType == ModuleSlotType.MEDIUM || slotType == ModuleSlotType.HIGH) ? 20 : slotType.getMaxSlotCount();
                int n5 = 0;
                Object[] objectArray3 = new MutableState[slotCount];
                while (n5 < slotCount) {
                    int n6 = n5++;
                    objectArray3[n6] = SnapshotStateKt.mutableStateOf$default(null, null, (int)2, null);
                }
                objectArray[n] = state = Collections.unmodifiableList(ArraysKt.asList((Object[])objectArray3));
            }
            Object[] valueByOrdinal$iv = objectArray2;
            modules.slotsByTypeStates = new ValueByEnum(valueByOrdinal$iv);
            fit = Fit.this;
            modules = this;
            $i$f$valueByEnum = false;
            enumValues$iv = ModuleSlotType.values();
            n3 = 0;
            n4 = enumValues$iv.length;
            objectArray2 = new State[n4];
            while (n3 < n4) {
                n2 = n3++;
                slotType = enumValues$iv[n2];
                n = n2;
                objectArray = objectArray2;
                boolean bl = false;
                state = SnapshotStateKt.derivedStateOf((SnapshotMutationPolicy)SnapshotStateKt.structuralEqualityPolicy(), () -> Modules.relevantSlotCountStateBySlotType$lambda$4$lambda$3(fit, slotType, this));
                objectArray[n] = state;
            }
            Object[] valueByOrdinal$iv2 = objectArray2;
            modules.relevantSlotCountStateBySlotType = new ValueByEnum(valueByOrdinal$iv2);
        }

        @NotNull
        public final ValueByEnum<ModuleSlotType, List<MutableState<Module>>> getSlotsByTypeStates$FittingEngine() {
            return this.slotsByTypeStates;
        }

        @NotNull
        public final Iterable<Module> slotsInRack(@NotNull ModuleSlotType slotType) {
            Intrinsics.checkNotNullParameter((Object)slotType, (String)"slotType");
            return FitKt.access$currentValues((List)this.slotsByTypeStates.get((Enum)slotType));
        }

        public final int slotsInRackCount(@NotNull ModuleSlotType slotType) {
            Intrinsics.checkNotNullParameter((Object)slotType, (String)"slotType");
            return ((List)this.slotsByTypeStates.get((Enum)slotType)).size();
        }

        public final int relevantSlotCount(@NotNull ModuleSlotType slotType) {
            Intrinsics.checkNotNullParameter((Object)slotType, (String)"slotType");
            return ((Number)((State)this.relevantSlotCountStateBySlotType.get((Enum)slotType)).getValue()).intValue();
        }

        @NotNull
        public final Iterable<Module> slotsLimitedByRackSize(@NotNull ModuleSlotType slotType) {
            Intrinsics.checkNotNullParameter((Object)slotType, (String)"slotType");
            int slotCount = Fit.this.getFitting().getSlots().get(slotType);
            return FitKt.access$currentValues(((List)this.slotsByTypeStates.get((Enum)slotType)).subList(0, slotCount));
        }

        @Nullable
        public final Module inSlot(@NotNull ModuleSlotType slotType, int slotIndex) {
            Intrinsics.checkNotNullParameter((Object)slotType, (String)"slotType");
            return (Module)((MutableState)((List)this.slotsByTypeStates.get((Enum)slotType)).get(slotIndex)).getValue();
        }

        @Nullable
        public final Module inSlot(@NotNull ModuleSlot slot) {
            Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
            return this.inSlot(slot.getType(), slot.getIndex());
        }

        @NotNull
        public final List<Module> filtered(@NotNull Function1<? super Module, Boolean> filter) {
            List list;
            Intrinsics.checkNotNullParameter(filter, (String)"filter");
            List $this$filtered_u24lambda_u245 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            for (ModuleSlotType slotType : ModuleSlotType.getEntries()) {
                for (MutableState moduleState : (List)this.slotsByTypeStates.get((Enum)slotType)) {
                    Module module;
                    if ((Module)moduleState.getValue() == null || !((Boolean)filter.invoke((Object)module)).booleanValue()) continue;
                    $this$filtered_u24lambda_u245.add(module);
                }
            }
            return CollectionsKt.build((List)list);
        }

        @NotNull
        public final List<Module> getAll() {
            return this.filtered((Function1<? super Module, Boolean>)((Function1)Modules::_get_all_$lambda$6));
        }

        @NotNull
        public final Collection<Module> getOnline() {
            return this.filtered((Function1<? super Module, Boolean>)((Function1)Modules::_get_online_$lambda$7));
        }

        @NotNull
        public final Collection<Module> getActive() {
            return this.filtered((Function1<? super Module, Boolean>)((Function1)Modules::_get_active_$lambda$8));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<Module> inRack(@NotNull ModuleSlotType slotType) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)slotType, (String)"slotType");
            Iterable $this$mapNotNull$iv = (Iterable)this.slotsByTypeStates.get((Enum)slotType);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Module it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                MutableState it = (MutableState)element$iv$iv;
                boolean bl2 = false;
                if ((Module)it.getValue() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final Collection<Module> getHigh() {
            return this.inRack(ModuleSlotType.HIGH);
        }

        @NotNull
        public final Collection<Module> getMedium() {
            return this.inRack(ModuleSlotType.MEDIUM);
        }

        @NotNull
        public final Collection<Module> getLow() {
            return this.inRack(ModuleSlotType.LOW);
        }

        @NotNull
        public final Collection<Module> getRigs() {
            return this.inRack(ModuleSlotType.RIG);
        }

        private static final int relevantSlotCountStateBySlotType$lambda$4$lambda$3(Fit this$0, ModuleSlotType $slotType, Modules this$1) {
            int n;
            int fittingSlots;
            block1: {
                List extraSlots;
                fittingSlots = this$0.getFitting().getSlots().get($slotType);
                List it = (List)this$1.slotsByTypeStates.get((Enum)$slotType);
                boolean bl = false;
                List $this$indexOfLast$iv = extraSlots = it.subList(fittingSlots, it.size());
                boolean $i$f$indexOfLast = false;
                ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    MutableState it2 = (MutableState)iterator$iv.previous();
                    boolean bl2 = false;
                    if (!(it2.getValue() != null)) continue;
                    n = iterator$iv.nextIndex();
                    break block1;
                }
                n = -1;
            }
            int lastFittedIndexInExtraSlots = n;
            return fittingSlots + lastFittedIndexInExtraSlots + 1;
        }

        private static final boolean _get_all_$lambda$6(Module it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return true;
        }

        private static final boolean _get_online_$lambda$7(Module it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getOnline();
        }

        private static final boolean _get_active_$lambda$8(Module it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getActive();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0014\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR\u0011\u0010\u0013\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015\u00a8\u0006\u001a"}, d2={"Ltheorycrafter/fitting/Fit$Propulsion;", "", "<init>", "(Ltheorycrafter/fitting/Fit;)V", "mass", "Ltheorycrafter/fitting/AttributeProperty;", "", "getMass", "()Ltheorycrafter/fitting/AttributeProperty;", "inertiaModifier", "getInertiaModifier", "baseMaxVelocity", "getBaseMaxVelocity", "propulsionModuleSpeedFactor", "getPropulsionModuleSpeedFactor", "propulsionModuleThrust", "getPropulsionModuleThrust", "speedLimit", "getSpeedLimit", "maxVelocity", "getMaxVelocity", "()D", "alignTime", "getAlignTime", "warpSpeed", "getWarpSpeed", "FittingEngine"})
    public final class Propulsion {
        @NotNull
        public final AttributeProperty<Double> getMass() {
            return Fit.this.getShip().getMass();
        }

        @NotNull
        public final AttributeProperty<Double> getInertiaModifier() {
            return Fit.this.getShip().getInertiaModifier();
        }

        @NotNull
        public final AttributeProperty<Double> getBaseMaxVelocity() {
            return Fit.this.getShip().property(Fit.this.attributes.getMaxVelocity());
        }

        @NotNull
        public final AttributeProperty<Double> getPropulsionModuleSpeedFactor() {
            return Fit.this.getShip().property(Fit.this.attributes.getPropulsionModuleSpeedFactor());
        }

        @NotNull
        public final AttributeProperty<Double> getPropulsionModuleThrust() {
            return Fit.this.getShip().property(Fit.this.attributes.getPropulsionModuleThrust());
        }

        @NotNull
        public final AttributeProperty<Double> getSpeedLimit() {
            return Fit.this.getShip().property(Fit.this.attributes.getSpeedLimit());
        }

        public final double getMaxVelocity() {
            double maxVelocity = MechanicsKt.maxVelocity(((Number)this.getBaseMaxVelocity().getValue()).doubleValue(), ((Number)this.getMass().getValue()).doubleValue(), ((Number)this.getPropulsionModuleSpeedFactor().getValue()).doubleValue(), ((Number)this.getPropulsionModuleThrust().getValue()).doubleValue());
            double limit = ((Number)this.getSpeedLimit().getValue()).doubleValue();
            return limit >= 0.0 ? RangesKt.coerceAtMost((double)maxVelocity, (double)limit) : maxVelocity;
        }

        public final double getAlignTime() {
            return MechanicsKt.alignTime(((Number)this.getInertiaModifier().getValue()).doubleValue(), ((Number)this.getMass().getValue()).doubleValue());
        }

        public final double getWarpSpeed() {
            return ((Number)Fit.this.getShip().getWarpSpeed().getValue()).doubleValue();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\n0\u0005R\u00060\u0000R\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\n0\u0005R\u00060\u0000R\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Ltheorycrafter/fitting/Fit$RemoteRepairs;", "", "<init>", "(Ltheorycrafter/fitting/Fit;)V", "modules", "Ltheorycrafter/fitting/Fit$RemoteRepairs$Source;", "Ltheorycrafter/fitting/Fit;", "getModules", "()Ltheorycrafter/fitting/Fit$RemoteRepairs$Source;", "drones", "getDrones", "total", "", "getTotal", "()D", "Source", "FittingEngine"})
    @SourceDebugExtension(value={"SMAP\nFit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fit.kt\ntheorycrafter/fitting/Fit$RemoteRepairs\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1195:1\n774#2:1196\n865#2,2:1197\n*S KotlinDebug\n*F\n+ 1 Fit.kt\ntheorycrafter/fitting/Fit$RemoteRepairs\n*L\n720#1:1196\n720#1:1197,2\n*E\n"})
    public final class RemoteRepairs {
        @NotNull
        private final Source modules = new Source(() -> RemoteRepairs.modules$lambda$1(Fit.this));
        @NotNull
        private final Source drones = new Source(() -> RemoteRepairs.drones$lambda$2(Fit.this));

        @NotNull
        public final Source getModules() {
            return this.modules;
        }

        @NotNull
        public final Source getDrones() {
            return this.drones;
        }

        public final double getTotal() {
            double d;
            DroneGroup it;
            double d2;
            Iterable iterable = Fit.this.getModules().getActive();
            double d3 = 0.0;
            for (Object t : iterable) {
                double d4;
                Module module = (Module)t;
                d2 = d3;
                boolean bl = false;
                if (((ModuleType)it.getType()).isProjected()) {
                    Double d5 = it.getShieldHpBoostedPerSecond();
                    Double d6 = it.getArmorHpRepairedPerSecond();
                    Double d7 = it.getStructureHpRepairedPerSecond();
                    d4 = (d5 != null ? d5 : 0.0) + (d6 != null ? d6 : 0.0) + (d7 != null ? d7 : 0.0);
                } else {
                    d4 = 0.0;
                }
                d = d4;
                d3 = d2 + d;
            }
            iterable = Fit.this.getDrones().getActive();
            d2 = d3;
            d3 = 0.0;
            for (Object t : iterable) {
                it = (DroneGroup)t;
                d = d3;
                boolean bl = false;
                Double d8 = it.getShieldHpBoostedPerSecond();
                Double d9 = it.getArmorHpRepairedPerSecond();
                Double d10 = it.getStructureHpRepairedPerSecond();
                double d11 = (d8 != null ? d8 : 0.0) + (d9 != null ? d9 : 0.0) + (d10 != null ? d10 : 0.0);
                d3 = d + d11;
            }
            d = d3;
            return d2 + d;
        }

        /*
         * WARNING - void declaration
         */
        private static final Iterable modules$lambda$1(Fit this$0) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this$0.getModules().getActive();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Module it = (Module)element$iv$iv;
                boolean bl = false;
                if (!((ModuleType)it.getType()).isProjected()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private static final Iterable drones$lambda$2(Fit this$0) {
            return this$0.getDrones().getActive();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J1\u0010\u0010\u001a\u00020\t*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00042\u0018\u0010\u0011\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0012H\u0082\bR\u001e\u0010\u0002\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0013"}, d2={"Ltheorycrafter/fitting/Fit$RemoteRepairs$Source;", "", "sources", "Lkotlin/Function0;", "", "Ltheorycrafter/fitting/ModuleOrDrone;", "<init>", "(Ltheorycrafter/fitting/Fit$RemoteRepairs;Lkotlin/jvm/functions/Function0;)V", "shieldHpBoostedPerSecond", "", "getShieldHpBoostedPerSecond", "()D", "armorHpRepairedPerSecond", "getArmorHpRepairedPerSecond", "structureHpRepairedPerSecond", "getStructureHpRepairedPerSecond", "sumOfProperty", "selector", "Lkotlin/Function1;", "FittingEngine"})
        @SourceDebugExtension(value={"SMAP\nFit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fit.kt\ntheorycrafter/fitting/Fit$RemoteRepairs$Source\n*L\n1#1,1195:1\n775#1,8:1196\n775#1,8:1204\n775#1,8:1212\n*S KotlinDebug\n*F\n+ 1 Fit.kt\ntheorycrafter/fitting/Fit$RemoteRepairs$Source\n*L\n755#1:1196,8\n762#1:1204,8\n769#1:1212,8\n*E\n"})
        public final class Source {
            @NotNull
            private final Function0<Iterable<ModuleOrDrone<?>>> sources;

            public Source(Function0<? extends Iterable<? extends ModuleOrDrone<?>>> sources) {
                Intrinsics.checkNotNullParameter(sources, (String)"sources");
                this.sources = sources;
            }

            /*
             * WARNING - void declaration
             */
            public final double getShieldHpBoostedPerSecond() {
                Source source = this;
                Iterable $this$sumOfProperty$iv = (Iterable)this.sources.invoke();
                boolean $i$f$sumOfProperty = false;
                Iterable iterable = $this$sumOfProperty$iv;
                double d = 0.0;
                for (Object t : iterable) {
                    void it$iv;
                    ModuleOrDrone moduleOrDrone = (ModuleOrDrone)t;
                    double d2 = d;
                    boolean bl = false;
                    void p0 = it$iv;
                    boolean $i$f$_get_shieldHpBoostedPerSecond_$stub_for_inlining = false;
                    boolean bl2 = false;
                    Double value$iv = p0.getShieldHpBoostedPerSecond();
                    double d3 = value$iv == null ? 0.0 : (it$iv instanceof DroneGroup ? value$iv * (double)((DroneGroup)it$iv).getSize() : value$iv);
                    d = d2 + d3;
                }
                return d;
            }

            /*
             * WARNING - void declaration
             */
            public final double getArmorHpRepairedPerSecond() {
                Source source = this;
                Iterable $this$sumOfProperty$iv = (Iterable)this.sources.invoke();
                boolean $i$f$sumOfProperty = false;
                Iterable iterable = $this$sumOfProperty$iv;
                double d = 0.0;
                for (Object t : iterable) {
                    void it$iv;
                    ModuleOrDrone moduleOrDrone = (ModuleOrDrone)t;
                    double d2 = d;
                    boolean bl = false;
                    void p0 = it$iv;
                    boolean $i$f$_get_armorHpRepairedPerSecond_$stub_for_inlining$0 = false;
                    boolean bl2 = false;
                    Double value$iv = p0.getArmorHpRepairedPerSecond();
                    double d3 = value$iv == null ? 0.0 : (it$iv instanceof DroneGroup ? value$iv * (double)((DroneGroup)it$iv).getSize() : value$iv);
                    d = d2 + d3;
                }
                return d;
            }

            /*
             * WARNING - void declaration
             */
            public final double getStructureHpRepairedPerSecond() {
                Source source = this;
                Iterable $this$sumOfProperty$iv = (Iterable)this.sources.invoke();
                boolean $i$f$sumOfProperty = false;
                Iterable iterable = $this$sumOfProperty$iv;
                double d = 0.0;
                for (Object t : iterable) {
                    void it$iv;
                    ModuleOrDrone moduleOrDrone = (ModuleOrDrone)t;
                    double d2 = d;
                    boolean bl = false;
                    void p0 = it$iv;
                    boolean $i$f$_get_structureHpRepairedPerSecond_$stub_for_inlining$1 = false;
                    boolean bl2 = false;
                    Double value$iv = p0.getStructureHpRepairedPerSecond();
                    double d3 = value$iv == null ? 0.0 : (it$iv instanceof DroneGroup ? value$iv * (double)((DroneGroup)it$iv).getSize() : value$iv);
                    d = d2 + d3;
                }
                return d;
            }

            /*
             * WARNING - void declaration
             */
            private final double sumOfProperty(Iterable<? extends ModuleOrDrone<?>> $this$sumOfProperty, Function1<? super ModuleOrDrone<?>, Double> selector) {
                boolean $i$f$sumOfProperty = false;
                Iterable<ModuleOrDrone<?>> iterable = $this$sumOfProperty;
                double d = 0.0;
                Iterator<ModuleOrDrone<?>> iterator2 = iterable.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    ModuleOrDrone<?> moduleOrDrone;
                    ModuleOrDrone<?> moduleOrDrone2 = moduleOrDrone = iterator2.next();
                    double d2 = d;
                    boolean bl = false;
                    Double value = (Double)selector.invoke((Object)it);
                    double d3 = value == null ? 0.0 : (it instanceof DroneGroup ? value * (double)((DroneGroup)it).getSize() : value);
                    d = d2 + d3;
                }
                return d;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B?\b\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0015\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012\u00a8\u0006\u0017"}, d2={"Ltheorycrafter/fitting/Fit$Resource;", "T", "", "", "totalProperty", "Ltheorycrafter/fitting/AttributeProperty;", "usedGetter", "Lkotlin/Function0;", "minus", "Lkotlin/Function2;", "<init>", "(Ltheorycrafter/fitting/AttributeProperty;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function2;)V", "getTotalProperty", "()Ltheorycrafter/fitting/AttributeProperty;", "getMinus", "()Lkotlin/jvm/functions/Function2;", "total", "getTotal", "()Ljava/lang/Number;", "used", "getUsed", "available", "getAvailable", "FittingEngine"})
    @StabilityInferred(parameters=0)
    public static final class Resource<T extends Number> {
        @NotNull
        private final AttributeProperty<T> totalProperty;
        @NotNull
        private final Function0<T> usedGetter;
        @NotNull
        private final Function2<T, T, T> minus;
        public static final int $stable = 8;

        public Resource(@NotNull AttributeProperty<T> totalProperty, @NotNull Function0<? extends T> usedGetter, @NotNull Function2<? super T, ? super T, ? extends T> minus) {
            Intrinsics.checkNotNullParameter(totalProperty, (String)"totalProperty");
            Intrinsics.checkNotNullParameter(usedGetter, (String)"usedGetter");
            Intrinsics.checkNotNullParameter(minus, (String)"minus");
            this.totalProperty = totalProperty;
            this.usedGetter = usedGetter;
            this.minus = minus;
        }

        @NotNull
        public final AttributeProperty<T> getTotalProperty() {
            return this.totalProperty;
        }

        @NotNull
        public final Function2<T, T, T> getMinus() {
            return this.minus;
        }

        @NotNull
        public final T getTotal() {
            return (T)((Number)this.totalProperty.getValue());
        }

        @NotNull
        public final T getUsed() {
            return (T)((Number)this.usedGetter.invoke());
        }

        @NotNull
        public final T getAvailable() {
            return (T)((Number)this.minus.invoke(this.getTotal(), this.getUsed()));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u000f\u001a\n0\u0010R\u00060\u0000R\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Ltheorycrafter/fitting/Fit$Targeting;", "", "<init>", "(Ltheorycrafter/fitting/Fit;)V", "targetingRange", "Ltheorycrafter/fitting/AttributeProperty;", "", "getTargetingRange", "()Ltheorycrafter/fitting/AttributeProperty;", "scanResolution", "getScanResolution", "maxLockedTargets", "", "getMaxLockedTargets", "()I", "sensors", "Ltheorycrafter/fitting/Fit$Targeting$Sensors;", "Ltheorycrafter/fitting/Fit;", "getSensors", "()Ltheorycrafter/fitting/Fit$Targeting$Sensors;", "Sensors", "FittingEngine"})
    public final class Targeting {
        @NotNull
        private final Sensors sensors = new Sensors();

        @NotNull
        public final AttributeProperty<Double> getTargetingRange() {
            return Fit.this.getShip().property(Fit.this.attributes.getTargetingRange());
        }

        @NotNull
        public final AttributeProperty<Double> getScanResolution() {
            return Fit.this.getShip().property(Fit.this.attributes.getScanResolution());
        }

        public final int getMaxLockedTargets() {
            return Integer.min(((Number)Fit.this.getShip().getMaxLockedTargets().getValue()).intValue(), ((Number)Fit.this.getCharacter().getMaxLockedTargets().getValue()).intValue());
        }

        @NotNull
        public final Sensors getSensors() {
            return this.sensors;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ltheorycrafter/fitting/Fit$Targeting$Sensors;", "", "<init>", "(Ltheorycrafter/fitting/Fit$Targeting;)V", "type", "Leve/data/SensorType;", "getType", "()Leve/data/SensorType;", "strength", "Ltheorycrafter/fitting/AttributeProperty;", "", "getStrength", "()Ltheorycrafter/fitting/AttributeProperty;", "FittingEngine"})
        public final class Sensors {
            @NotNull
            public final SensorType getType() {
                return ((ShipType)Fit.this.getShip().getType()).getTargeting().getSensors().getType();
            }

            @NotNull
            public final AttributeProperty<Double> getStrength() {
                return Fit.this.getShip().property((Attribute)Fit.this.attributes.getSensorStrength().get((Enum)this.getType()));
            }
        }
    }
}

