/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.fitting;

import androidx.compose.runtime.Stable;
import eve.data.Attributes;
import eve.data.EveItemType;
import eve.data.ModuleType;
import eve.data.ShipType;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import theorycrafter.fitting.AttributeProperty;
import theorycrafter.fitting.EveItem;
import theorycrafter.fitting.Fit;
import theorycrafter.fitting.FitItem;
import theorycrafter.fitting.FittingEngine;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b \n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0019\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010:\u001a\u00020;2\u0006\u0010=\u001a\u00020\u0012R\u00020<\u00a2\u0006\u0002\u0010>J\u000e\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@PX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0014R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0014R\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0014R\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0014R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00118F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0014R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0014R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0014R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0014R\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0014R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0014R\u0017\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00118F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0014R\u0019\u00100\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0014R\u0017\u00102\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0014R\u0017\u00104\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0014R\u0017\u00106\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0014R\u0019\u00108\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u0014R\u0017\u0010C\u001a\b\u0012\u0004\u0012\u00020E0D8F\u00a2\u0006\u0006\u001a\u0004\bF\u0010G\u00a8\u0006H"}, d2={"Ltheorycrafter/fitting/Ship;", "Ltheorycrafter/fitting/EveItem;", "Leve/data/ShipType;", "Ltheorycrafter/fitting/FitItem;", "attributes", "Leve/data/Attributes;", "type", "<init>", "(Leve/data/Attributes;Leve/data/ShipType;)V", "value", "Ltheorycrafter/fitting/Fit;", "fit", "getFit", "()Ltheorycrafter/fitting/Fit;", "setFit$FittingEngine", "(Ltheorycrafter/fitting/Fit;)V", "signatureRadius", "Ltheorycrafter/fitting/AttributeProperty;", "", "getSignatureRadius", "()Ltheorycrafter/fitting/AttributeProperty;", "cpuOutput", "getCpuOutput", "powerOutput", "getPowerOutput", "calibration", "", "getCalibration", "turretHardpoints", "getTurretHardpoints", "launcherHardpoints", "getLauncherHardpoints", "cargoCapacity", "getCargoCapacity", "droneCapacity", "getDroneCapacity", "droneBandwidth", "getDroneBandwidth", "mass", "getMass", "inertiaModifier", "getInertiaModifier", "radius", "getRadius", "warpCapacitorNeed", "getWarpCapacitorNeed", "maxLockedTargets", "getMaxLockedTargets", "jumpDriveConsumptionAmount", "getJumpDriveConsumptionAmount", "warpSpeed", "getWarpSpeed", "remoteRepairEffectiveness", "getRemoteRepairEffectiveness", "remoteAssistanceEffectiveness", "getRemoteAssistanceEffectiveness", "pilotSecurityStatus", "getPilotSecurityStatus", "setPilotSecurityStatus", "", "Ltheorycrafter/fitting/FittingEngine$ModificationScope;", "securityStatus", "(Ltheorycrafter/fitting/FittingEngine$ModificationScope;D)V", "canFit", "", "moduleType", "Leve/data/ModuleType;", "canFitModuleKeys", "", "", "getCanFitModuleKeys", "()Ljava/util/Collection;", "FittingEngine"})
@Stable
public final class Ship
extends EveItem<ShipType>
implements FitItem {
    public Fit fit;
    public static final int $stable;

    public Ship(@NotNull Attributes attributes, @NotNull ShipType type) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        super(attributes, (EveItemType)type, null);
    }

    @Override
    @NotNull
    public Fit getFit() {
        Fit fit = this.fit;
        if (fit != null) {
            return fit;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"fit");
        return null;
    }

    public void setFit$FittingEngine(@NotNull Fit fit) {
        Intrinsics.checkNotNullParameter((Object)fit, (String)"<set-?>");
        this.fit = fit;
    }

    @NotNull
    public final AttributeProperty<Double> getSignatureRadius() {
        return this.property(this.getAttributes().getSignatureRadius());
    }

    @NotNull
    public final AttributeProperty<Double> getCpuOutput() {
        return this.property(this.getAttributes().getCpuOutput());
    }

    @NotNull
    public final AttributeProperty<Double> getPowerOutput() {
        return this.property(this.getAttributes().getPowerOutput());
    }

    @NotNull
    public final AttributeProperty<Integer> getCalibration() {
        return this.property(this.getAttributes().getCalibration());
    }

    @NotNull
    public final AttributeProperty<Integer> getTurretHardpoints() {
        return this.property(this.getAttributes().getTurretHardpoints());
    }

    @NotNull
    public final AttributeProperty<Integer> getLauncherHardpoints() {
        return this.property(this.getAttributes().getLauncherHardpoints());
    }

    @NotNull
    public final AttributeProperty<Double> getCargoCapacity() {
        return this.property(this.getAttributes().getCapacity());
    }

    @NotNull
    public final AttributeProperty<Integer> getDroneCapacity() {
        return this.property(this.getAttributes().getDroneCapacity());
    }

    @NotNull
    public final AttributeProperty<Double> getDroneBandwidth() {
        return this.property(this.getAttributes().getDroneBandwidth());
    }

    @NotNull
    public final AttributeProperty<Double> getMass() {
        return this.property(this.getAttributes().getMass());
    }

    @NotNull
    public final AttributeProperty<Double> getInertiaModifier() {
        return this.property(this.getAttributes().getInertiaModifier());
    }

    @NotNull
    public final AttributeProperty<Double> getRadius() {
        return this.property(this.getAttributes().getRadius());
    }

    @NotNull
    public final AttributeProperty<Double> getWarpCapacitorNeed() {
        return this.property(this.getAttributes().getWarpCapacitorNeed());
    }

    @NotNull
    public final AttributeProperty<Integer> getMaxLockedTargets() {
        return this.property(this.getAttributes().getMaxLockedTargets());
    }

    @Nullable
    public final AttributeProperty<Double> getJumpDriveConsumptionAmount() {
        return this.propertyOrNull(this.getAttributes().getJumpDriveConsumptionAmount());
    }

    @NotNull
    public final AttributeProperty<Double> getWarpSpeed() {
        return this.property(this.getAttributes().getWarpSpeedMultiplier());
    }

    @NotNull
    public final AttributeProperty<Double> getRemoteRepairEffectiveness() {
        return this.property(this.getAttributes().getRemoteRepairImpedance());
    }

    @NotNull
    public final AttributeProperty<Double> getRemoteAssistanceEffectiveness() {
        return this.property(this.getAttributes().getRemoteAssistanceImpedance());
    }

    @Nullable
    public final AttributeProperty<Double> getPilotSecurityStatus() {
        return this.propertyOrNull(this.getAttributes().getPilotSecurityStatus());
    }

    public final void setPilotSecurityStatus(@NotNull FittingEngine.ModificationScope $context_receiver_0, double securityStatus) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        $context_receiver_0.setPinnedPropertyValue(this, this.getAttributes().getPilotSecurityStatus(), Double.valueOf(securityStatus));
    }

    public final boolean canFit(@NotNull ModuleType moduleType) {
        Intrinsics.checkNotNullParameter((Object)moduleType, (String)"moduleType");
        ShipType shipType = (ShipType)this.getType();
        if (!shipType.canFit(moduleType)) {
            return false;
        }
        if (moduleType.getTakesTurretHardpoint() && ((Number)this.getTurretHardpoints().getValue()).intValue() == 0) {
            return false;
        }
        return !moduleType.getTakesLauncherHardpoint() || ((Number)this.getLauncherHardpoints().getValue()).intValue() != 0;
    }

    @NotNull
    public final Collection<Object> getCanFitModuleKeys() {
        Object[] objectArray = new Integer[]{this.getTurretHardpoints().getValue(), this.getLauncherHardpoints().getValue()};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

