/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.compose.runtime.Applier;
import androidx.compose.runtime.PreconditionsKt;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\b'\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u000fH$J\b\u0010\u0013\u001a\u00020\u000fH\u0016J*\u0010\u0014\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0004J\"\u0010\u0019\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0004R&\u0010\u0006\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00028\u0000@TX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\n\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0004R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u000b\u0010\bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/compose/runtime/AbstractApplier;", "T", "Landroidx/compose/runtime/Applier;", "root", "(Ljava/lang/Object;)V", "<set-?>", "current", "getCurrent", "()Ljava/lang/Object;", "setCurrent", "Ljava/lang/Object;", "getRoot", "stack", "", "clear", "", "down", "node", "onClear", "up", "move", "from", "", "to", "count", "remove", "index", "runtime"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nApplier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Applier.kt\nandroidx/compose/runtime/AbstractApplier\n+ 2 Preconditions.kt\nandroidx/compose/runtime/PreconditionsKt\n*L\n1#1,289:1\n50#2,7:290\n*S KotlinDebug\n*F\n+ 1 Applier.kt\nandroidx/compose/runtime/AbstractApplier\n*L\n206#1:290,7\n*E\n"})
public abstract class AbstractApplier<T>
implements Applier<T> {
    private final T root;
    @NotNull
    private final List<T> stack;
    private T current;
    public static final int $stable = 8;

    public AbstractApplier(T root) {
        this.root = root;
        this.stack = new ArrayList();
        this.current = this.root;
    }

    public final T getRoot() {
        return this.root;
    }

    @Override
    public T getCurrent() {
        return this.current;
    }

    protected void setCurrent(T t) {
        this.current = t;
    }

    @Override
    public void down(T node) {
        this.stack.add(this.getCurrent());
        this.setCurrent(node);
    }

    @Override
    public void up() {
        boolean value$iv = !((Collection)this.stack).isEmpty();
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            PreconditionsKt.throwIllegalStateException("empty stack");
        }
        this.setCurrent(this.stack.remove(this.stack.size() - 1));
    }

    @Override
    public final void clear() {
        this.stack.clear();
        this.setCurrent(this.root);
        this.onClear();
    }

    protected abstract void onClear();

    protected final void remove(@NotNull List<T> $this$remove, int index, int count) {
        Intrinsics.checkNotNullParameter($this$remove, (String)"<this>");
        if (count == 1) {
            $this$remove.remove(index);
        } else {
            $this$remove.subList(index, index + count).clear();
        }
    }

    protected final void move(@NotNull List<T> $this$move, int from, int to, int count) {
        int dest;
        Intrinsics.checkNotNullParameter($this$move, (String)"<this>");
        int n = dest = from > to ? to : to - count;
        if (count == 1) {
            if (from == to + 1 || from == to - 1) {
                T fromEl = $this$move.get(from);
                T toEl = $this$move.set(to, fromEl);
                $this$move.set(from, toEl);
            } else {
                T fromEl = $this$move.remove(from);
                $this$move.add(dest, fromEl);
            }
        } else {
            List<T> subView = $this$move.subList(from, from + count);
            List subCopy = CollectionsKt.toMutableList((Collection)subView);
            subView.clear();
            $this$move.addAll(dest, subCopy);
        }
    }
}

