/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.internal;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0012"}, d2={"Landroidx/compose/runtime/internal/ThreadMap;", "", "size", "", "keys", "", "values", "", "(I[J[Ljava/lang/Object;)V", "[Ljava/lang/Object;", "find", "key", "", "get", "newWith", "value", "trySet", "", "runtime"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nThreadMap.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadMap.jvm.kt\nandroidx/compose/runtime/internal/ThreadMap\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,112:1\n12634#2,3:113\n*S KotlinDebug\n*F\n+ 1 ThreadMap.jvm.kt\nandroidx/compose/runtime/internal/ThreadMap\n*L\n42#1:113,3\n*E\n"})
public final class ThreadMap {
    private final int size;
    @NotNull
    private final long[] keys;
    @NotNull
    private final Object[] values;
    public static final int $stable = 8;

    public ThreadMap(int size, @NotNull long[] keys, @NotNull Object[] values) {
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.size = size;
        this.keys = keys;
        this.values = values;
    }

    @Nullable
    public final Object get(long key) {
        int index = this.find(key);
        return index >= 0 ? this.values[index] : null;
    }

    public final boolean trySet(long key, @Nullable Object value) {
        int index = this.find(key);
        if (index < 0) {
            return false;
        }
        this.values[index] = value;
        return true;
    }

    @NotNull
    public final ThreadMap newWith(long key, @Nullable Object value) {
        int size = this.size;
        Object[] $this$count$iv = this.values;
        boolean $i$f$count = false;
        int count$iv = 0;
        int n = $this$count$iv.length;
        for (int i = 0; i < n; ++i) {
            Object element$iv;
            Object it = element$iv = $this$count$iv[i];
            boolean bl = false;
            if (!(it != null)) continue;
            ++count$iv;
        }
        int newSize = count$iv + 1;
        long[] newKeys = new long[newSize];
        Object[] newValues = new Object[newSize];
        if (newSize > 1) {
            Object oldValue;
            int source;
            int dest = 0;
            for (source = 0; dest < newSize && source < size; ++source) {
                long oldKey = this.keys[source];
                oldValue = this.values[source];
                if (oldKey > key) {
                    newKeys[dest] = key;
                    newValues[dest] = value;
                    ++dest;
                    break;
                }
                if (oldValue == null) continue;
                newKeys[dest] = oldKey;
                newValues[dest] = oldValue;
                ++dest;
            }
            if (source == size) {
                newKeys[newSize - 1] = key;
                newValues[newSize - 1] = value;
            } else {
                while (dest < newSize) {
                    long oldKey = this.keys[source];
                    oldValue = this.values[source];
                    if (oldValue != null) {
                        newKeys[dest] = oldKey;
                        newValues[dest] = oldValue;
                        ++dest;
                    }
                    ++source;
                }
            }
        } else {
            newKeys[0] = key;
            newValues[0] = value;
        }
        return new ThreadMap(newSize, newKeys, newValues);
    }

    private final int find(long key) {
        int high = this.size - 1;
        switch (high) {
            case -1: {
                return -1;
            }
            case 0: {
                return this.keys[0] == key ? 0 : (this.keys[0] > key ? -2 : -1);
            }
        }
        int low = 0;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = this.keys[mid];
            long comparison = midVal - key;
            if (comparison < 0L) {
                low = mid + 1;
                continue;
            }
            if (comparison > 0L) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }
}

