/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter;

import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.snapshots.SnapshotStateMap;
import eve.data.ChargeType;
import eve.data.EveItemType;
import eve.data.ModuleSlotType;
import eve.data.ModuleType;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import theorycrafter.ItemsPriceInfo;
import theorycrafter.fitting.EveItem;
import theorycrafter.fitting.Fit;
import theorycrafter.fitting.MechanicsKt;
import theorycrafter.fitting.Module;
import theorycrafter.fitting.utils.CollectionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001BS\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012 \b\u0002\u0010\u0007\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\u0002\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fJ\n\u0010\u001a\u001a\u00020\u001b*\u00020\u000fJ\u000e\u0010\u001a\u001a\u00020\u001b*\u0006\u0012\u0002\b\u00030\u001cJ\u000e\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u001d\u001a\u00020\u001b2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001cJ\u0016\u0010\u001d\u001a\u00020\u001b2\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0 J\u0016\u0010\u001a\u001a\u00020\u001b*\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u001c0 J\u000e\u0010\u001a\u001a\u00020\u001b*\u00060!R\u00020\"J\u000e\u0010#\u001a\u00020\u001b*\u00060!R\u00020\"J\f\u0010$\u001a\u0004\u0018\u00010\u001b*\u00020\"J\u000e\u0010\u001a\u001a\u00020\u001b*\u00060%R\u00020\"J\u000e\u0010\u001a\u001a\u00020\u001b*\u00060&R\u00020\"J\u000e\u0010\u001a\u001a\u00020\u001b*\u00060'R\u00020\"J\u000e\u0010\u001a\u001a\u00020\u001b*\u00060(R\u00020\"J\u0012\u0010\u001a\u001a\u00020\u001b*\u00020\"2\u0006\u0010)\u001a\u00020\u0015J\u0012\u0010\u0012\u001a\u00020\u0005*\u00020\"2\u0006\u0010)\u001a\u00020\u0015R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u0005*\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0010\u00a8\u0006*"}, d2={"Ltheorycrafter/EveItemPrices;", "", "priceByItemId", "", "", "", "overrideByItemId", "onOverridesChanged", "Lkotlin/Function1;", "", "<init>", "(Ljava/util/Map;Ljava/util/Map;Lkotlin/jvm/functions/Function1;)V", "Landroidx/compose/runtime/snapshots/SnapshotStateMap;", "get", "itemType", "Leve/data/EveItemType;", "(Leve/data/EveItemType;)Ljava/lang/Double;", "setOverride", "price", "removeOverride", "isOverriden", "", "overrides", "getOverrides", "()Ljava/util/Map;", "getPrice", "priceInfo", "Ltheorycrafter/ItemsPriceInfo;", "Ltheorycrafter/fitting/EveItem;", "priceInfoOf", "item", "items", "", "Ltheorycrafter/fitting/Fit$Modules;", "Ltheorycrafter/fitting/Fit;", "chargesPrice", "subsystemsPrice", "Ltheorycrafter/fitting/Fit$Drones;", "Ltheorycrafter/fitting/Fit$Implants;", "Ltheorycrafter/fitting/Fit$Boosters;", "Ltheorycrafter/fitting/Fit$Cargohold;", "includeCharges", "Theorycrafter"})
@StabilityInferred(parameters=0)
public final class EveItemPrices {
    @NotNull
    private final Map<Integer, Double> priceByItemId;
    @NotNull
    private final Function1<Map<Integer, Double>, Unit> onOverridesChanged;
    @NotNull
    private final SnapshotStateMap<Integer, Double> overrideByItemId;
    public static final int $stable = 8;

    public EveItemPrices(@NotNull Map<Integer, Double> priceByItemId, @NotNull Map<Integer, Double> overrideByItemId, @NotNull Function1<? super Map<Integer, Double>, Unit> onOverridesChanged2) {
        Intrinsics.checkNotNullParameter(priceByItemId, (String)"priceByItemId");
        Intrinsics.checkNotNullParameter(overrideByItemId, (String)"overrideByItemId");
        Intrinsics.checkNotNullParameter(onOverridesChanged2, (String)"onOverridesChanged");
        this.priceByItemId = priceByItemId;
        this.onOverridesChanged = onOverridesChanged2;
        this.overrideByItemId = SnapshotStateKt.toMutableStateMap((Iterable)MapsKt.toList(overrideByItemId));
    }

    public /* synthetic */ EveItemPrices(Map map, Map map2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map2 = new LinkedHashMap();
        }
        if ((n & 4) != 0) {
            function1 = EveItemPrices::_init_$lambda$0;
        }
        this(map, map2, (Function1<? super Map<Integer, Double>, Unit>)function1);
    }

    @Nullable
    public final Double get(@NotNull EveItemType itemType) {
        Intrinsics.checkNotNullParameter((Object)itemType, (String)"itemType");
        Double d = (Double)this.overrideByItemId.get((Object)itemType.getItemId());
        if (d == null) {
            d = this.priceByItemId.get(itemType.getItemId());
        }
        return d;
    }

    public final void setOverride(@NotNull EveItemType itemType, double price) {
        Intrinsics.checkNotNullParameter((Object)itemType, (String)"itemType");
        Double d = price;
        ((Map)this.overrideByItemId).put(itemType.getItemId(), d);
        this.onOverridesChanged.invoke(this.overrideByItemId);
    }

    public final void removeOverride(@NotNull EveItemType itemType) {
        Intrinsics.checkNotNullParameter((Object)itemType, (String)"itemType");
        this.overrideByItemId.remove((Object)itemType.getItemId());
        this.onOverridesChanged.invoke(this.overrideByItemId);
    }

    public final boolean isOverriden(@NotNull EveItemType itemType) {
        Intrinsics.checkNotNullParameter((Object)itemType, (String)"itemType");
        return ((Map)this.overrideByItemId).containsKey(itemType.getItemId());
    }

    @NotNull
    public final Map<Integer, Double> getOverrides() {
        return (Map)this.overrideByItemId;
    }

    @Nullable
    public final Double getPrice(@NotNull EveItemType $this$price) {
        Intrinsics.checkNotNullParameter((Object)$this$price, (String)"<this>");
        return this.get($this$price);
    }

    @NotNull
    public final ItemsPriceInfo priceInfo(@NotNull EveItemType $this$priceInfo) {
        Double price;
        Intrinsics.checkNotNullParameter((Object)$this$priceInfo, (String)"<this>");
        Double d = price = this.get($this$priceInfo);
        return new ItemsPriceInfo(d != null ? d : 0.0, price == null, this.isOverriden($this$priceInfo));
    }

    @NotNull
    public final ItemsPriceInfo priceInfo(@NotNull EveItem<?> $this$priceInfo) {
        Intrinsics.checkNotNullParameter($this$priceInfo, (String)"<this>");
        return this.priceInfo($this$priceInfo.getType());
    }

    @NotNull
    public final ItemsPriceInfo priceInfoOf(@NotNull EveItemType itemType) {
        Intrinsics.checkNotNullParameter((Object)itemType, (String)"itemType");
        return this.priceInfo(itemType);
    }

    @NotNull
    public final ItemsPriceInfo priceInfoOf(@NotNull EveItem<?> item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        return this.priceInfo(item.getType());
    }

    @NotNull
    public final ItemsPriceInfo priceInfoOf(@NotNull Iterable<? extends EveItemType> items2) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        double sum = 0.0;
        boolean anyPriceIsUnknown = false;
        boolean anyPriceIsOverride = false;
        for (EveItemType eveItemType : items2) {
            Double price;
            if (eveItemType == null) continue;
            Double d = price = this.get(eveItemType);
            sum += d != null ? d : 0.0;
            anyPriceIsUnknown = anyPriceIsUnknown || price == null;
            anyPriceIsOverride = anyPriceIsOverride || this.isOverriden(eveItemType);
        }
        return new ItemsPriceInfo(sum, anyPriceIsUnknown, anyPriceIsOverride);
    }

    @NotNull
    public final ItemsPriceInfo priceInfo(@NotNull Iterable<? extends EveItem<?>> $this$priceInfo) {
        Intrinsics.checkNotNullParameter($this$priceInfo, (String)"<this>");
        return this.priceInfoOf(CollectionsKt.mapEach($this$priceInfo, EveItemPrices::priceInfo$lambda$1));
    }

    @NotNull
    public final ItemsPriceInfo priceInfo(@NotNull Fit.Modules $this$priceInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$priceInfo, (String)"<this>");
        double sum = 0.0;
        boolean anyPriceIsUnknown = false;
        boolean anyPriceIsOverride = false;
        for (ModuleSlotType slotType : ModuleSlotType.getEntries()) {
            ItemsPriceInfo priceInfo = this.priceInfo($this$priceInfo.slotsInRack(slotType));
            sum += priceInfo.getPrice();
            anyPriceIsUnknown = anyPriceIsUnknown || priceInfo.getPriceIsUnknown();
            anyPriceIsOverride = anyPriceIsOverride || priceInfo.getPriceIsOverride();
        }
        return new ItemsPriceInfo(sum, anyPriceIsUnknown, anyPriceIsOverride);
    }

    @NotNull
    public final ItemsPriceInfo chargesPrice(@NotNull Fit.Modules $this$chargesPrice) {
        Intrinsics.checkNotNullParameter((Object)$this$chargesPrice, (String)"<this>");
        double sum = 0.0;
        boolean anyPriceIsUnknown = false;
        boolean anyPriceIsOverride = false;
        for (ModuleSlotType slotType : ModuleSlotType.getEntries()) {
            for (Module module : $this$chargesPrice.slotsInRack(slotType)) {
                Module module2 = module;
                if (module2 == null || (module2 = module2.getLoadedCharge()) == null) continue;
                Module charge = module2;
                Integer n = MechanicsKt.maxLoadedChargeAmount((ModuleType)((ModuleType)module.getType()), (ChargeType)((ChargeType)charge.getType()));
                if (n == null) {
                    continue;
                }
                int amount2 = n;
                ItemsPriceInfo priceInfo = this.priceInfo(charge.getType());
                sum += priceInfo.getPrice() * (double)amount2;
                anyPriceIsUnknown = anyPriceIsUnknown || priceInfo.getPriceIsUnknown();
                anyPriceIsOverride = anyPriceIsOverride || priceInfo.getPriceIsOverride();
            }
        }
        return new ItemsPriceInfo(sum, anyPriceIsUnknown, anyPriceIsOverride);
    }

    @Nullable
    public final ItemsPriceInfo subsystemsPrice(@NotNull Fit $this$subsystemsPrice) {
        Intrinsics.checkNotNullParameter((Object)$this$subsystemsPrice, (String)"<this>");
        Object object = $this$subsystemsPrice.getSubsystemByKind();
        return object != null && (object = object.getValues()) != null ? this.priceInfo((Iterable)object) : null;
    }

    @NotNull
    public final ItemsPriceInfo priceInfo(@NotNull Fit.Drones $this$priceInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$priceInfo, (String)"<this>");
        return this.priceInfo($this$priceInfo.getAll());
    }

    @NotNull
    public final ItemsPriceInfo priceInfo(@NotNull Fit.Implants $this$priceInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$priceInfo, (String)"<this>");
        return this.priceInfo($this$priceInfo.getSlots());
    }

    @NotNull
    public final ItemsPriceInfo priceInfo(@NotNull Fit.Boosters $this$priceInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$priceInfo, (String)"<this>");
        return this.priceInfo($this$priceInfo.getSlots());
    }

    @NotNull
    public final ItemsPriceInfo priceInfo(@NotNull Fit.Cargohold $this$priceInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$priceInfo, (String)"<this>");
        return this.priceInfo($this$priceInfo.getContents());
    }

    @NotNull
    public final ItemsPriceInfo priceInfo(@NotNull Fit $this$priceInfo, boolean includeCharges) {
        Intrinsics.checkNotNullParameter((Object)$this$priceInfo, (String)"<this>");
        return this.priceInfo($this$priceInfo.getShip().getType()).plus(this.subsystemsPrice($this$priceInfo)).plus(this.priceInfo($this$priceInfo.getModules())).plus(includeCharges ? this.chargesPrice($this$priceInfo.getModules()) : null).plus(this.priceInfo($this$priceInfo.getDrones())).plus(this.priceInfo($this$priceInfo.getImplants())).plus(this.priceInfo($this$priceInfo.getBoosters())).plus(this.priceInfo($this$priceInfo.getCargohold()));
    }

    public final double price(@NotNull Fit $this$price, boolean includeCharges) {
        Intrinsics.checkNotNullParameter((Object)$this$price, (String)"<this>");
        return this.priceInfo($this$price, includeCharges).getPrice();
    }

    private static final Unit _init_$lambda$0(Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final EveItemType priceInfo$lambda$1(EveItem it) {
        EveItem eveItem = it;
        return eveItem != null ? eveItem.getType() : null;
    }
}

