/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.optimizer;

import androidx.compose.foundation.layout.ColumnScope;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.ComposableTarget;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import compose.utils.ComposeKt;
import eve.data.DamageType;
import eve.data.EveData;
import eve.data.ModuleType;
import eve.data.ValueFormatsKt;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import theorycrafter.fitting.Fit;
import theorycrafter.fitting.MechanicsKt;
import theorycrafter.optimizer.FitOptimizerDialogKt;
import theorycrafter.optimizer.OptimizationGoal;
import theorycrafter.optimizer.ScoreFunction;
import theorycrafter.utils.MiscKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B\u0096\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012!\b\u0002\u0010\b\u001a\u001b\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\t\u00a2\u0006\u0002\b\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\f\u0012\b\b\u0002\u0010\u000f\u001a\u00020\f\u0012 \b\u0002\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0005\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u0013\u0012\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00150\u0005\u00a2\u0006\u0004\b\u0016\u0010\u0017B\u008c\u0001\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012!\b\u0002\u0010\b\u001a\u001b\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\t\u00a2\u0006\u0002\b\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\f\u0012\b\b\u0002\u0010\u000f\u001a\u00020\f\u0012 \b\u0002\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0005\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u0013\u0012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0018J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0006H\u0016J\b\u0010(\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR*\u0010\b\u001a\u001b\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\t\u00a2\u0006\u0002\b\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u000e\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010 R+\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0005\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u0013\u00a2\u0006\n\n\u0002\u0010$\u001a\u0004\b\"\u0010#R#\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00150\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001c\u00a8\u0006*"}, d2={"Ltheorycrafter/optimizer/OptimizationGoal;", "Ltheorycrafter/optimizer/ScoreFunction;", "name", "", "score", "Lkotlin/Function1;", "Ltheorycrafter/fitting/Fit;", "", "moduleFilter", "Lkotlin/Function2;", "Leve/data/EveData;", "Leve/data/ModuleType;", "", "Lkotlin/ExtensionFunctionType;", "activeModulesInclusionChoice", "rahInclusionChoice", "extraUi", "Landroidx/compose/foundation/layout/ColumnScope;", "", "Landroidx/compose/runtime/Composable;", "defaultTempRange", "Lkotlin/ranges/ClosedFloatingPointRange;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;ZZLkotlin/jvm/functions/Function3;Lkotlin/jvm/functions/Function1;)V", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;ZZLkotlin/jvm/functions/Function3;Lkotlin/ranges/ClosedFloatingPointRange;)V", "getName", "()Ljava/lang/String;", "getScore", "()Lkotlin/jvm/functions/Function1;", "getModuleFilter", "()Lkotlin/jvm/functions/Function2;", "getActiveModulesInclusionChoice", "()Z", "getRahInclusionChoice", "getExtraUi", "()Lkotlin/jvm/functions/Function3;", "Lkotlin/jvm/functions/Function3;", "getDefaultTempRange", "eval", "fit", "toString", "Companion", "Theorycrafter"})
final class OptimizationGoal
implements ScoreFunction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final Function1<Fit, Double> score;
    @Nullable
    private final Function2<EveData, ModuleType, Boolean> moduleFilter;
    private final boolean activeModulesInclusionChoice;
    private final boolean rahInclusionChoice;
    @Nullable
    private final Function3<ColumnScope, Composer, Integer, Unit> extraUi;
    @NotNull
    private final Function1<Fit, ClosedFloatingPointRange<Double>> defaultTempRange;
    @NotNull
    private static final ClosedFloatingPointRange<Double> ResistanceOptimizationDefaultTempRange = RangesKt.rangeTo((double)0.01, (double)100.0);
    @NotNull
    private static final OptimizationGoal TotalEhp = new OptimizationGoal("Total EHP", OptimizationGoal::TotalEhp$lambda$1, (Function2)Companion.TotalEhp.2.INSTANCE, true, true, null, OptimizationGoal::TotalEhp$lambda$2, 32, null);
    @NotNull
    private static final OptimizationGoal ShieldEhp = new OptimizationGoal("Shield EHP", OptimizationGoal::ShieldEhp$lambda$3, (Function2)Companion.ShieldEhp.2.INSTANCE, true, false, null, OptimizationGoal::ShieldEhp$lambda$4, 48, null);
    @NotNull
    private static final OptimizationGoal ArmorEhp = new OptimizationGoal("Armor EHP", OptimizationGoal::ArmorEhp$lambda$5, (Function2)Companion.ArmorEhp.2.INSTANCE, true, true, null, OptimizationGoal::ArmorEhp$lambda$6, 32, null);
    @NotNull
    private static final OptimizationGoal LowestShieldResistance = new OptimizationGoal("Lowest resistance", OptimizationGoal::LowestShieldResistance$lambda$8, (Function2)Companion.LowestShieldResistance.2.INSTANCE, true, false, null, ResistanceOptimizationDefaultTempRange, 48, null);
    @NotNull
    private static final OptimizationGoal LowestArmorResistance = new OptimizationGoal("Lowest resistance", OptimizationGoal::LowestArmorResistance$lambda$10, (Function2)Companion.LowestArmorResistance.2.INSTANCE, true, true, null, ResistanceOptimizationDefaultTempRange, 32, null);
    @NotNull
    private static final OptimizationGoal ShieldResistanceFactor = new OptimizationGoal("Average resistance", OptimizationGoal::ShieldResistanceFactor$lambda$11, (Function2)Companion.ShieldResistanceFactor.2.INSTANCE, true, false, null, ResistanceOptimizationDefaultTempRange, 48, null);
    @NotNull
    private static final OptimizationGoal ArmorResistanceFactor = new OptimizationGoal("Average resistance", OptimizationGoal::ArmorResistanceFactor$lambda$12, (Function2)Companion.ArmorResistanceFactor.2.INSTANCE, true, true, null, ResistanceOptimizationDefaultTempRange, 32, null);

    public OptimizationGoal(@NotNull String name2, @NotNull Function1<? super Fit, Double> score, @Nullable Function2<? super EveData, ? super ModuleType, Boolean> moduleFilter, boolean activeModulesInclusionChoice, boolean rahInclusionChoice, @Nullable Function3<? super ColumnScope, ? super Composer, ? super Integer, Unit> extraUi, @NotNull Function1<? super Fit, ? extends ClosedFloatingPointRange<Double>> defaultTempRange) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(score, (String)"score");
        Intrinsics.checkNotNullParameter(defaultTempRange, (String)"defaultTempRange");
        this.name = name2;
        this.score = score;
        this.moduleFilter = moduleFilter;
        this.activeModulesInclusionChoice = activeModulesInclusionChoice;
        this.rahInclusionChoice = rahInclusionChoice;
        this.extraUi = extraUi;
        this.defaultTempRange = defaultTempRange;
    }

    public /* synthetic */ OptimizationGoal(String string2, Function1 function1, Function2 function2, boolean bl, boolean bl2, Function3 function3, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function2 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            function3 = null;
        }
        this(string2, (Function1<? super Fit, Double>)function1, (Function2<? super EveData, ? super ModuleType, Boolean>)function2, bl, bl2, (Function3<? super ColumnScope, ? super Composer, ? super Integer, Unit>)function3, (Function1<? super Fit, ? extends ClosedFloatingPointRange<Double>>)function12);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Function1<Fit, Double> getScore() {
        return this.score;
    }

    @Nullable
    public final Function2<EveData, ModuleType, Boolean> getModuleFilter() {
        return this.moduleFilter;
    }

    public final boolean getActiveModulesInclusionChoice() {
        return this.activeModulesInclusionChoice;
    }

    public final boolean getRahInclusionChoice() {
        return this.rahInclusionChoice;
    }

    @Nullable
    public final Function3<ColumnScope, Composer, Integer, Unit> getExtraUi() {
        return this.extraUi;
    }

    @NotNull
    public final Function1<Fit, ClosedFloatingPointRange<Double>> getDefaultTempRange() {
        return this.defaultTempRange;
    }

    public OptimizationGoal(@NotNull String name2, @NotNull Function1<? super Fit, Double> score, @Nullable Function2<? super EveData, ? super ModuleType, Boolean> moduleFilter, boolean activeModulesInclusionChoice, boolean rahInclusionChoice, @Nullable Function3<? super ColumnScope, ? super Composer, ? super Integer, Unit> extraUi, @NotNull ClosedFloatingPointRange<Double> defaultTempRange) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(score, (String)"score");
        Intrinsics.checkNotNullParameter(defaultTempRange, (String)"defaultTempRange");
        this(name2, score, moduleFilter, activeModulesInclusionChoice, rahInclusionChoice, extraUi, (Function1<? super Fit, ? extends ClosedFloatingPointRange<Double>>)((Function1)arg_0 -> OptimizationGoal._init_$lambda$0(defaultTempRange, arg_0)));
    }

    public /* synthetic */ OptimizationGoal(String string2, Function1 function1, Function2 function2, boolean bl, boolean bl2, Function3 function3, ClosedFloatingPointRange closedFloatingPointRange, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function2 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            function3 = null;
        }
        this(string2, (Function1<? super Fit, Double>)function1, (Function2<? super EveData, ? super ModuleType, Boolean>)function2, bl, bl2, (Function3<? super ColumnScope, ? super Composer, ? super Integer, Unit>)function3, (ClosedFloatingPointRange<Double>)closedFloatingPointRange);
    }

    @Override
    public double eval(@NotNull Fit fit2) {
        Intrinsics.checkNotNullParameter((Object)fit2, (String)"fit");
        return ((Number)this.score.invoke((Object)fit2)).doubleValue();
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    private static final ClosedFloatingPointRange _init_$lambda$0(ClosedFloatingPointRange $defaultTempRange, Fit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $defaultTempRange;
    }

    private static final double TotalEhp$lambda$1(Fit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDefenses().getEhp();
    }

    private static final ClosedFloatingPointRange TotalEhp$lambda$2(Fit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        double baseEhp = it.getDefenses().getEhp();
        return RangesKt.rangeTo((double)(baseEhp / (double)100), (double)(baseEhp * (double)100));
    }

    private static final double ShieldEhp$lambda$3(Fit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDefenses().getShield().getEhp();
    }

    private static final ClosedFloatingPointRange ShieldEhp$lambda$4(Fit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        double baseEhp = it.getDefenses().getShield().getEhp();
        return RangesKt.rangeTo((double)(baseEhp / (double)100), (double)(baseEhp * (double)100));
    }

    private static final double ArmorEhp$lambda$5(Fit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDefenses().getArmor().getEhp();
    }

    private static final ClosedFloatingPointRange ArmorEhp$lambda$6(Fit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        double baseEhp = it.getDefenses().getArmor().getEhp();
        return RangesKt.rangeTo((double)(baseEhp / (double)100), (double)(baseEhp * (double)100));
    }

    private static final double LowestShieldResistance$lambda$8(Fit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterator iterator = ((Iterable)DamageType.getEntries()).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        DamageType damageType = (DamageType)iterator.next();
        boolean bl = false;
        double d = MechanicsKt.resistFactor((double)((Number)it.getDefenses().getShield().getResonances().get(damageType).getValue()).doubleValue());
        while (iterator.hasNext()) {
            DamageType damageType2 = (DamageType)iterator.next();
            $i$a$-minOf-OptimizationGoal$Companion$LowestShieldResistance$1$1 = false;
            double d2 = MechanicsKt.resistFactor((double)((Number)it.getDefenses().getShield().getResonances().get(damageType2).getValue()).doubleValue());
            d = Math.min(d, d2);
        }
        return d;
    }

    private static final double LowestArmorResistance$lambda$10(Fit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterator iterator = ((Iterable)DamageType.getEntries()).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        DamageType damageType = (DamageType)iterator.next();
        boolean bl = false;
        double d = MechanicsKt.resistFactor((double)((Number)it.getDefenses().getArmor().getResonances().get(damageType).getValue()).doubleValue());
        while (iterator.hasNext()) {
            DamageType damageType2 = (DamageType)iterator.next();
            $i$a$-minOf-OptimizationGoal$Companion$LowestArmorResistance$1$1 = false;
            double d2 = MechanicsKt.resistFactor((double)((Number)it.getDefenses().getArmor().getResonances().get(damageType2).getValue()).doubleValue());
            d = Math.min(d, d2);
        }
        return d;
    }

    private static final double ShieldResistanceFactor$lambda$11(Fit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDefenses().getShield().getResistFactor();
    }

    private static final double ArmorResistanceFactor$lambda$12(Fit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDefenses().getArmor().getResistFactor();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bJ\u001e\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001bJ(\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\bH\u0002Jc\u0010$\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020!2!\u0010)\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b+\u0012\b\b \u0012\u0004\b\b(,\u0012\u0004\u0012\u00020!0*2\b\b\u0002\u0010-\u001a\u00020\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0011\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0011\u0010\u0013\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0011\u0010\u0015\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\n\u00a8\u0006."}, d2={"Ltheorycrafter/optimizer/OptimizationGoal$Companion;", "", "<init>", "()V", "ResistanceOptimizationDefaultTempRange", "Lkotlin/ranges/ClosedFloatingPointRange;", "", "TotalEhp", "Ltheorycrafter/optimizer/OptimizationGoal;", "getTotalEhp", "()Ltheorycrafter/optimizer/OptimizationGoal;", "ShieldEhp", "getShieldEhp", "ArmorEhp", "getArmorEhp", "LowestShieldResistance", "getLowestShieldResistance", "LowestArmorResistance", "getLowestArmorResistance", "ShieldResistanceFactor", "getShieldResistanceFactor", "ArmorResistanceFactor", "getArmorResistanceFactor", "ehpAndShieldResistance", "originalFit", "Ltheorycrafter/fitting/Fit;", "useLowestResistance", "", "useShieldEhp", "ehpAndArmorResistance", "useArmorEhp", "ehpAndResistance", "name", "", "resistanceGoal", "ehpGoal", "dualOptimizationGoal", "goal1", "goal1Label", "goal2", "goal2Label", "balanceText", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "scaledWeightRatio", "defaultWeight", "Theorycrafter"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OptimizationGoal getTotalEhp() {
            return TotalEhp;
        }

        @NotNull
        public final OptimizationGoal getShieldEhp() {
            return ShieldEhp;
        }

        @NotNull
        public final OptimizationGoal getArmorEhp() {
            return ArmorEhp;
        }

        @NotNull
        public final OptimizationGoal getLowestShieldResistance() {
            return LowestShieldResistance;
        }

        @NotNull
        public final OptimizationGoal getLowestArmorResistance() {
            return LowestArmorResistance;
        }

        @NotNull
        public final OptimizationGoal getShieldResistanceFactor() {
            return ShieldResistanceFactor;
        }

        @NotNull
        public final OptimizationGoal getArmorResistanceFactor() {
            return ArmorResistanceFactor;
        }

        @NotNull
        public final OptimizationGoal ehpAndShieldResistance(@NotNull Fit originalFit, boolean useLowestResistance, boolean useShieldEhp) {
            Intrinsics.checkNotNullParameter((Object)originalFit, (String)"originalFit");
            return this.ehpAndResistance(originalFit, (useShieldEhp ? "Shield EHP" : "Total EHP") + " & " + (useLowestResistance ? "lowest" : "average") + " resistance", useLowestResistance ? this.getLowestShieldResistance() : this.getShieldResistanceFactor(), useShieldEhp ? this.getShieldEhp() : this.getTotalEhp());
        }

        @NotNull
        public final OptimizationGoal ehpAndArmorResistance(@NotNull Fit originalFit, boolean useLowestResistance, boolean useArmorEhp) {
            Intrinsics.checkNotNullParameter((Object)originalFit, (String)"originalFit");
            return this.ehpAndResistance(originalFit, (useArmorEhp ? "Armor EHP" : "Total EHP") + " & " + (useLowestResistance ? "lowest" : "average") + " resistance", useLowestResistance ? this.getLowestArmorResistance() : this.getArmorResistanceFactor(), useArmorEhp ? this.getArmorEhp() : this.getTotalEhp());
        }

        private final OptimizationGoal ehpAndResistance(Fit originalFit, String name2, OptimizationGoal resistanceGoal, OptimizationGoal ehpGoal) {
            return theorycrafter.optimizer.OptimizationGoal$Companion.dualOptimizationGoal$default(this, originalFit, name2, ehpGoal, "EHP", resistanceGoal, "Resistance", arg_0 -> Companion.ehpAndResistance$lambda$0(ehpGoal, originalFit, arg_0), 0.0, 128, null);
        }

        @NotNull
        public final OptimizationGoal dualOptimizationGoal(@NotNull Fit originalFit, @NotNull String name2, @NotNull OptimizationGoal goal1, @NotNull String goal1Label, @NotNull OptimizationGoal goal2, @NotNull String goal2Label, @NotNull Function1<? super Double, String> balanceText, double defaultWeight) {
            Intrinsics.checkNotNullParameter((Object)originalFit, (String)"originalFit");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)goal1, (String)"goal1");
            Intrinsics.checkNotNullParameter((Object)goal1Label, (String)"goal1Label");
            Intrinsics.checkNotNullParameter((Object)goal2, (String)"goal2");
            Intrinsics.checkNotNullParameter((Object)goal2Label, (String)"goal2Label");
            Intrinsics.checkNotNullParameter(balanceText, (String)"balanceText");
            double goal1Scale = ((Number)goal1.getScore().invoke((Object)originalFit)).doubleValue();
            double goal2Scale = ((Number)goal2.getScore().invoke((Object)originalFit)).doubleValue();
            MutableState weight = SnapshotStateKt.mutableStateOf$default((Object)defaultWeight, null, (int)2, null);
            Companion companion = this;
            Function1 function1 = arg_0 -> Companion.dualOptimizationGoal$lambda$1(goal1, goal2Scale, goal2, goal1Scale, weight, arg_0);
            String string2 = name2;
            boolean bl = false;
            Function2<EveData, ModuleType, Boolean> filter1 = goal1.getModuleFilter();
            Function2 filter2 = goal2.getModuleFilter();
            Function2 function2 = filter1 == null ? filter2 : (filter2 == null ? filter1 : (arg_0, arg_1) -> Companion.dualOptimizationGoal$lambda$3$lambda$2(filter1, filter2, arg_0, arg_1));
            Function1 function12 = arg_0 -> Companion.dualOptimizationGoal$lambda$4(goal1, goal2, goal2Scale, goal1Scale, weight, arg_0);
            Function3 function3 = (Function3)ComposableLambdaKt.composableLambdaInstance((int)181558469, (boolean)true, (Object)new Function3<ColumnScope, Composer, Integer, Unit>((MutableState<Double>)weight, defaultWeight, goal1Label, goal2Label, balanceText, goal2Scale, goal1Scale){
                final /* synthetic */ MutableState<Double> $weight;
                final /* synthetic */ double $defaultWeight;
                final /* synthetic */ String $goal1Label;
                final /* synthetic */ String $goal2Label;
                final /* synthetic */ Function1<Double, String> $balanceText;
                final /* synthetic */ double $goal2Scale;
                final /* synthetic */ double $goal1Scale;
                {
                    this.$weight = $weight;
                    this.$defaultWeight = $defaultWeight;
                    this.$goal1Label = $goal1Label;
                    this.$goal2Label = $goal2Label;
                    this.$balanceText = $balanceText;
                    this.$goal2Scale = $goal2Scale;
                    this.$goal1Scale = $goal1Scale;
                }

                /*
                 * WARNING - void declaration
                 */
                @Composable
                @ComposableTarget(applier="androidx.compose.ui.UiComposable")
                public final void invoke(ColumnScope $this$OptimizationGoal, Composer $composer, int $changed) {
                    Intrinsics.checkNotNullParameter((Object)$this$OptimizationGoal, (String)"$this$OptimizationGoal");
                    if (($changed & 0x11) != 16 || !$composer.getSkipping()) {
                        void this_$iv;
                        if (ComposerKt.isTraceInProgress()) {
                            ComposerKt.traceEventStart((int)181558469, (int)$changed, (int)-1, (String)"theorycrafter.optimizer.OptimizationGoal.Companion.dualOptimizationGoal.<anonymous> (FitOptimizerDialog.kt:1216)");
                        }
                        String string2 = (String)this.$balanceText.invoke((Object)(this.$goal2Scale * ((Number)this.$weight.getValue()).doubleValue() / (this.$goal1Scale * (1.0 - ((Number)this.$weight.getValue()).doubleValue()))));
                        CompositionLocal compositionLocal = (CompositionLocal)ComposeKt.getLocalEnabled();
                        boolean $changed$iv = false;
                        boolean $i$f$getCurrent = false;
                        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)2023513938, (String)"CC:CompositionLocal.kt#9igjgp");
                        Object object = $composer.consume((CompositionLocal)this_$iv);
                        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
                        FitOptimizerDialogKt.access$BiWeightSlider(this.$weight, this.$defaultWeight, this.$goal1Label, this.$goal2Label, string2, (Boolean)object, $composer, 0);
                        if (ComposerKt.isTraceInProgress()) {
                            ComposerKt.traceEventEnd();
                        }
                    } else {
                        $composer.skipToGroupEnd();
                    }
                }
            });
            boolean bl2 = goal1.getRahInclusionChoice() || goal2.getRahInclusionChoice();
            boolean bl3 = goal1.getActiveModulesInclusionChoice() || goal2.getActiveModulesInclusionChoice();
            Function2 function22 = function2;
            Function1 function13 = function1;
            String string3 = string2;
            return new OptimizationGoal(string3, (Function1<? super Fit, Double>)function13, (Function2<? super EveData, ? super ModuleType, Boolean>)function22, bl3, bl2, (Function3<? super ColumnScope, ? super Composer, ? super Integer, Unit>)function3, (Function1<? super Fit, ? extends ClosedFloatingPointRange<Double>>)function12);
        }

        public static /* synthetic */ OptimizationGoal dualOptimizationGoal$default(Companion companion, Fit fit2, String string2, OptimizationGoal optimizationGoal, String string3, OptimizationGoal optimizationGoal2, String string4, Function1 function1, double d, int n, Object object) {
            if ((n & 0x80) != 0) {
                d = 0.5;
            }
            return companion.dualOptimizationGoal(fit2, string2, optimizationGoal, string3, optimizationGoal2, string4, (Function1<? super Double, String>)function1, d);
        }

        private static final String ehpAndResistance$lambda$0(OptimizationGoal $ehpGoal, Fit $originalFit, double ratio) {
            Object object;
            if (Double.isInfinite(ratio)) {
                object = "EHP only";
            } else if (ratio == 0.0) {
                object = "Resistance only";
            } else {
                int ehpDigits = (int)Math.log10(((Number)$ehpGoal.getScore().invoke((Object)$originalFit)).doubleValue());
                double ehpValue = Math.pow(10.0, ehpDigits);
                object = ValueFormatsKt.asHitPoints$default((double)ehpValue, (boolean)true, (boolean)false, (boolean)false, (int)6, null) + " = " + ValueFormatsKt.toDecimalWithSignificantDigitsAtMost((double)(ehpValue * ratio), (int)2) + " of resistance factor";
            }
            return object;
        }

        private static final double dualOptimizationGoal$lambda$1(OptimizationGoal $goal1, double $goal2Scale, OptimizationGoal $goal2, double $goal1Scale, MutableState $weight, Fit fit2) {
            Intrinsics.checkNotNullParameter((Object)fit2, (String)"fit");
            return MiscKt.weightedAverage(((Number)$goal1.getScore().invoke((Object)fit2)).doubleValue() * $goal2Scale, ((Number)$goal2.getScore().invoke((Object)fit2)).doubleValue() * $goal1Scale, ((Number)$weight.getValue()).doubleValue());
        }

        private static final boolean dualOptimizationGoal$lambda$3$lambda$2(Function2 $filter1, Function2 $filter2, EveData $this$run, ModuleType moduleType2) {
            Intrinsics.checkNotNullParameter((Object)$this$run, (String)"$this$run");
            Intrinsics.checkNotNullParameter((Object)moduleType2, (String)"moduleType");
            return (Boolean)$filter1.invoke((Object)$this$run, (Object)moduleType2) != false || (Boolean)$filter2.invoke((Object)$this$run, (Object)moduleType2) != false;
        }

        private static final ClosedFloatingPointRange dualOptimizationGoal$lambda$4(OptimizationGoal $goal1, OptimizationGoal $goal2, double $goal2Scale, double $goal1Scale, MutableState $weight, Fit it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ClosedFloatingPointRange goal1Range = (ClosedFloatingPointRange)$goal1.getDefaultTempRange().invoke((Object)it);
            ClosedFloatingPointRange goal2Range = (ClosedFloatingPointRange)$goal2.getDefaultTempRange().invoke((Object)it);
            double start = MiscKt.weightedAverage(((Number)((Object)goal1Range.getStart())).doubleValue() * $goal2Scale, ((Number)((Object)goal2Range.getStart())).doubleValue() * $goal1Scale, ((Number)$weight.getValue()).doubleValue());
            double end = MiscKt.weightedAverage(((Number)((Object)goal1Range.getEndInclusive())).doubleValue() * $goal2Scale, ((Number)((Object)goal2Range.getEndInclusive())).doubleValue() * $goal1Scale, ((Number)$weight.getValue()).doubleValue());
            return RangesKt.rangeTo((double)start, (double)end);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

