/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.tournaments;

import androidx.compose.runtime.internal.StabilityInferred;
import eve.data.EveData;
import eve.data.ShipType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import theorycrafter.tournaments.Composition;
import theorycrafter.tournaments.PointsCompositionRules;
import theorycrafter.tournaments.PointsTournamentRulesKt;
import theorycrafter.tournaments.TournamentRulesKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0016J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u001bH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u001bH\u0016J\u0018\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010!0\u001b2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u001b2\u0006\u0010\"\u001a\u00020#H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ltheorycrafter/tournaments/BasicPointsCompositionRules;", "Ltheorycrafter/tournaments/PointsCompositionRules;", "eveData", "Leve/data/EveData;", "maxCompositionSize", "", "maxCompositionCost", "shipCostByType", "", "Leve/data/ShipType;", "<init>", "(Leve/data/EveData;IILjava/util/Map;)V", "getEveData", "()Leve/data/EveData;", "getMaxCompositionSize", "()I", "getMaxCompositionCost", "getShipCostByType", "()Ljava/util/Map;", "isShipLegal", "", "shipType", "legalShips", "", "getLegalShips", "()Ljava/util/Collection;", "shipsCost", "", "shipTypes", "marginalShipCostComputation", "Ltheorycrafter/tournaments/PointsCompositionRules$MarginalShipCostComputation;", "usedShipTypes", "compositionShipsIllegalityReason", "", "composition", "Ltheorycrafter/tournaments/Composition;", "compositionIconShipTypes", "Theorycrafter"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPointsTournamentRules.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PointsTournamentRules.kt\ntheorycrafter/tournaments/BasicPointsCompositionRules\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Grouping.kt\nkotlin/collections/GroupingKt__GroupingKt\n*L\n1#1,178:1\n1557#2:179\n1628#2,3:180\n1557#2:183\n1628#2,3:184\n3193#2,4:187\n3197#2,6:192\n1557#2:198\n1628#2,3:199\n1544#2:202\n1#3:191\n164#4:203\n53#4:204\n80#4,6:205\n*S KotlinDebug\n*F\n+ 1 PointsTournamentRules.kt\ntheorycrafter/tournaments/BasicPointsCompositionRules\n*L\n84#1:179\n84#1:180,3\n110#1:183\n110#1:184,3\n119#1:187,4\n119#1:192,6\n122#1:198\n122#1:199,3\n124#1:202\n125#1:203\n125#1:204\n125#1:205,6\n*E\n"})
public abstract class BasicPointsCompositionRules
implements PointsCompositionRules {
    @NotNull
    private final EveData eveData;
    private final int maxCompositionSize;
    private final int maxCompositionCost;
    @NotNull
    private final Map<ShipType, Integer> shipCostByType;
    @NotNull
    private final Collection<ShipType> legalShips;
    @NotNull
    private final PointsCompositionRules.MarginalShipCostComputation marginalShipCostComputation;
    public static final int $stable = 8;

    public BasicPointsCompositionRules(@NotNull EveData eveData, int maxCompositionSize, int maxCompositionCost, @NotNull Map<ShipType, Integer> shipCostByType) {
        Intrinsics.checkNotNullParameter((Object)eveData, (String)"eveData");
        Intrinsics.checkNotNullParameter(shipCostByType, (String)"shipCostByType");
        this.eveData = eveData;
        this.maxCompositionSize = maxCompositionSize;
        this.maxCompositionCost = maxCompositionCost;
        this.shipCostByType = shipCostByType;
        this.legalShips = this.shipCostByType.keySet();
        this.marginalShipCostComputation = PointsTournamentRulesKt.regularMarginalShipCostComputation(this.shipCostByType);
    }

    @NotNull
    protected final EveData getEveData() {
        return this.eveData;
    }

    @Override
    public int getMaxCompositionSize() {
        return this.maxCompositionSize;
    }

    @Override
    public int getMaxCompositionCost() {
        return this.maxCompositionCost;
    }

    @NotNull
    public final Map<ShipType, Integer> getShipCostByType() {
        return this.shipCostByType;
    }

    @Override
    public boolean isShipLegal(@NotNull ShipType shipType) {
        Intrinsics.checkNotNullParameter((Object)shipType, (String)"shipType");
        return this.shipCostByType.containsKey(shipType);
    }

    @Override
    @NotNull
    public Collection<ShipType> getLegalShips() {
        return this.legalShips;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Integer> shipsCost(@NotNull List<ShipType> shipTypes2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(shipTypes2, (String)"shipTypes");
        Iterable $this$map$iv = shipTypes2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            int n;
            void it;
            ShipType shipType = (ShipType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (it == null) {
                n = 0;
            } else {
                Integer n2 = this.shipCostByType.get(it);
                n = n2 != null ? n2 : 0;
            }
            collection.add(n);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public PointsCompositionRules.MarginalShipCostComputation marginalShipCostComputation(@NotNull List<ShipType> usedShipTypes) {
        Intrinsics.checkNotNullParameter(usedShipTypes, (String)"usedShipTypes");
        return this.marginalShipCostComputation;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> compositionShipsIllegalityReason(@NotNull Composition composition) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)composition, (String)"composition");
        Iterable $this$map$iv = composition.getShips();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Composition.Ship ship = (Composition.Ship)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it == null || this.isShipLegal(it.getShipType()) ? null : "Illegal ship type");
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ShipType> compositionIconShipTypes(@NotNull Composition composition) {
        Object v0;
        void destination$iv$iv$iv;
        void $this$aggregateTo$iv$iv$iv;
        void $this$fold$iv;
        Grouping $this$groupingBy$iv;
        void it;
        Collection<ShipType> collection;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        Object element$iv2;
        Intrinsics.checkNotNullParameter((Object)composition, (String)"composition");
        Iterable $this$partition$iv = CollectionsKt.filterNotNull((Iterable)composition.getShips());
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        Iterable second$iv = new ArrayList();
        for (Object element$iv2 : $this$partition$iv) {
            Composition.Ship it2 = (Composition.Ship)element$iv2;
            boolean bl = false;
            EveData $this$compositionIconShipTypes_u24lambda_u243_u24lambda_u242 = this.eveData;
            boolean bl2 = false;
            if (TournamentRulesKt.isLogistics($this$compositionIconShipTypes_u24lambda_u243_u24lambda_u242, it2.getShipType())) {
                first$iv.add(element$iv2);
                continue;
            }
            ((ArrayList)second$iv).add(element$iv2);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List logiShips = (List)pair.component1();
        List nonLogiShips = (List)pair.component2();
        second$iv = nonLogiShips;
        BasicPointsCompositionRules basicPointsCompositionRules = this;
        Iterable iterable = nonLogiShips;
        boolean $i$f$map22 = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Composition.Ship ship = (Composition.Ship)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getShipType());
        }
        collection = (List)destination$iv$iv;
        List nonLogiShipAndCost = CollectionsKt.zip((Iterable)iterable, (Iterable)basicPointsCompositionRules.shipsCost((List<ShipType>)collection));
        $this$mapTo$iv$iv = nonLogiShipAndCost;
        boolean $i$f$groupingBy = false;
        $this$groupingBy$iv = (Grouping)new Grouping<Pair<? extends Composition.Ship, ? extends Integer>, ShipType>((Iterable)$this$groupingBy$iv){
            final /* synthetic */ Iterable $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            public Iterator<Pair<? extends Composition.Ship, ? extends Integer>> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public Object keyOf(Object element) {
                Pair it = (Pair)element;
                boolean bl = false;
                return ((Composition.Ship)it.getFirst()).getShipType();
            }
        };
        Integer initialValue$iv = 0;
        boolean $i$f$fold = false;
        void $this$aggregate$iv$iv = $this$fold$iv;
        boolean $i$f$aggregate = false;
        it = $this$aggregate$iv$iv;
        Map bl = new LinkedHashMap();
        boolean $i$f$aggregateTo = false;
        Iterator iterator = $this$aggregateTo$iv$iv$iv.sourceIterator();
        while (iterator.hasNext()) {
            void acc$iv;
            void first$iv2;
            void e$iv;
            Object e$iv$iv$iv = iterator.next();
            Object key$iv$iv$iv = $this$aggregateTo$iv$iv$iv.keyOf(e$iv$iv$iv);
            Object accumulator$iv$iv$iv = destination$iv$iv$iv.get(key$iv$iv$iv);
            boolean bl3 = accumulator$iv$iv$iv == null && !destination$iv$iv$iv.containsKey(key$iv$iv$iv);
            Object e = e$iv$iv$iv;
            Object v = accumulator$iv$iv$iv;
            Object object = key$iv$iv$iv;
            void var24_42 = destination$iv$iv$iv;
            boolean bl4 = false;
            Pair pair2 = (Pair)e$iv;
            int acc = ((Number)(first$iv2 != false ? initialValue$iv : acc$iv)).intValue();
            boolean bl5 = false;
            int cost = ((Number)pair2.component2()).intValue();
            Integer n = acc + cost;
            var24_42.put(object, n);
        }
        Iterable iterable2 = destination$iv$iv$iv.entrySet();
        Iterator iterator2 = iterable2.iterator();
        if (!iterator2.hasNext()) {
            v0 = null;
        } else {
            Object t = iterator2.next();
            if (!iterator2.hasNext()) {
                v0 = t;
            } else {
                Map.Entry it3 = (Map.Entry)t;
                boolean bl6 = false;
                int n = ((Number)it3.getValue()).intValue();
                do {
                    Object t2 = iterator2.next();
                    Map.Entry it4 = (Map.Entry)t2;
                    $i$a$-maxByOrNull-BasicPointsCompositionRules$compositionIconShipTypes$mainNonLogiShipType$3 = false;
                    int n2 = ((Number)it4.getValue()).intValue();
                    if (n >= n2) continue;
                    t = t2;
                    n = n2;
                } while (iterator2.hasNext());
                v0 = t;
            }
        }
        Map.Entry $i$f$map22 = v0;
        ShipType mainNonLogiShipType = $i$f$map22 != null ? (ShipType)$i$f$map22.getKey() : null;
        Composition.Ship ship = (Composition.Ship)CollectionsKt.firstOrNull((List)logiShips);
        ShipType logi = ship != null ? ship.getShipType() : null;
        Object[] objectArray = new ShipType[]{mainNonLogiShipType, logi};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<Integer> shipsCost(@NotNull Composition composition) {
        return PointsCompositionRules.DefaultImpls.shipsCost(this, composition);
    }
}

