/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.ui.fitstats;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.ComposableTarget;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.RecomposeScopeImplKt;
import androidx.compose.runtime.ScopeUpdateScope;
import eve.data.SensorType;
import eve.data.ValueFormatsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import theorycrafter.fitting.DroneGroup;
import theorycrafter.fitting.Fit;
import theorycrafter.fitting.MechanicsKt;
import theorycrafter.fitting.Module;
import theorycrafter.fitting.RemoteEffect;
import theorycrafter.ui.fiteditor.ValueWithDescription;
import theorycrafter.ui.fitstats.FitStatsKt;
import theorycrafter.ui.fitstats.Stat;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u0015\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\u0010\u0004\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0003H\u0002\"(\u0010\u0007\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"TargetingStats", "", "fit", "Ltheorycrafter/fitting/Fit;", "(Ltheorycrafter/fitting/Fit;Landroidx/compose/runtime/Composer;I)V", "jammedChance", "", "TargetingTimeTooltipExamples", "", "Lkotlin/Triple;", "", "Theorycrafter"})
@SourceDebugExtension(value={"SMAP\nTargetingStats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetingStats.kt\ntheorycrafter/ui/fitstats/TargetingStatsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n774#2:137\n865#2,2:138\n1368#2:140\n1454#2,2:141\n774#2:143\n865#2,2:144\n1456#2,3:146\n1368#2:149\n1454#2,2:150\n774#2:152\n865#2,2:153\n1456#2,3:155\n*S KotlinDebug\n*F\n+ 1 TargetingStats.kt\ntheorycrafter/ui/fitstats/TargetingStatsKt\n*L\n106#1:137\n106#1:138,2\n107#1:140\n107#1:141,2\n108#1:143\n108#1:144,2\n107#1:146,3\n110#1:149\n110#1:150,2\n111#1:152\n111#1:153,2\n110#1:155,3\n*E\n"})
public final class TargetingStatsKt {
    @NotNull
    private static final List<Triple<String, Double, Double>> TargetingTimeTooltipExamples;

    @Composable
    @ComposableTarget(applier="androidx.compose.ui.UiComposable")
    public static final void TargetingStats(@NotNull Fit fit2, @Nullable Composer $composer, int $changed) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)fit2, (String)"fit");
            $composer = $composer.startRestartGroup(-305627315);
            int $dirty = $changed;
            if (($changed & 6) == 0) {
                $dirty |= $composer.changed((Object)fit2) ? 4 : 2;
            }
            if (($dirty & 3) != 2 || !$composer.getSkipping()) {
                Stat[] statArray;
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventStart((int)-305627315, (int)$dirty, (int)-1, (String)"theorycrafter.ui.fitstats.TargetingStats (TargetingStats.kt:18)");
                }
                Fit.Targeting $this$TargetingStats_u24lambda_u241 = fit2.getTargeting();
                boolean bl = false;
                double range = ((Number)$this$TargetingStats_u24lambda_u241.getTargetingRange().getValue()).doubleValue();
                int maxTargets = $this$TargetingStats_u24lambda_u241.getMaxLockedTargets();
                double sensorStrength = ((Number)$this$TargetingStats_u24lambda_u241.getSensors().getStrength().getValue()).doubleValue();
                SensorType sensorType = $this$TargetingStats_u24lambda_u241.getSensors().getType();
                double jamChance = TargetingStatsKt.jammedChance(fit2);
                double scanRes = ((Number)$this$TargetingStats_u24lambda_u241.getScanResolution().getValue()).doubleValue();
                double sensorDampeningResonance = ((Number)fit2.getElectronicWarfare().getSensorDampenerResistance().getValue()).doubleValue();
                double ecmResonance = ((Number)fit2.getElectronicWarfare().getEcmResistance().getValue()).doubleValue();
                ValueWithDescription resistanceToDampeningTooltip = !(sensorDampeningResonance == 1.0) ? new ValueWithDescription(ValueFormatsKt.resonanceAsResistancePercentageWithPrecisionAtMost((double)sensorDampeningResonance, (int)0), "resistance to sensor dampening") : null;
                ValueWithDescription resistanceToEcmTooltip = !(ecmResonance == 1.0) ? new ValueWithDescription(ValueFormatsKt.resonanceAsResistancePercentageWithPrecisionAtMost((double)ecmResonance, (int)0), "resistance to ECM") : null;
                Stat[] $this$TargetingStats_u24lambda_u241_u24lambda_u240 = statArray = CollectionsKt.createListBuilder();
                boolean bl2 = false;
                $this$TargetingStats_u24lambda_u241_u24lambda_u240.add(new ValueWithDescription("Lock", "Times"));
                for (Triple<String, Double, Double> triple : TargetingTimeTooltipExamples) {
                    String name2 = (String)triple.component1();
                    double sigRadius = ((Number)triple.component2()).doubleValue();
                    Double mwdFactor = (Double)triple.component3();
                    $this$TargetingStats_u24lambda_u241_u24lambda_u240.add(new ValueWithDescription(ValueFormatsKt.millisAsTimeSec$default((double)MechanicsKt.lockTime((double)scanRes, (double)sigRadius), (boolean)false, (boolean)false, (String)"s", (int)3, null), name2 + " (" + ValueFormatsKt.asSignatureRadius$default((double)sigRadius, (boolean)false, (boolean)false, (int)3, null) + ")"));
                    if (mwdFactor == null) continue;
                    double sigRadiusWithMwd = sigRadius * mwdFactor;
                    $this$TargetingStats_u24lambda_u241_u24lambda_u240.add(new ValueWithDescription(ValueFormatsKt.millisAsTimeSec$default((double)MechanicsKt.lockTime((double)scanRes, (double)sigRadiusWithMwd), (boolean)false, (boolean)false, (String)"s", (int)3, null), name2 + " with MWD (" + ValueFormatsKt.asSignatureRadius$default((double)sigRadiusWithMwd, (boolean)false, (boolean)false, (int)3, null) + ")"));
                }
                List targetingTimes = CollectionsKt.build((List)statArray);
                statArray = new Stat[3];
                Object[] objectArray = new ValueWithDescription[]{new ValueWithDescription(ValueFormatsKt.asDistance$default((double)range, (boolean)true, (boolean)false, (int)Integer.MAX_VALUE, (int)2, null), "targeting range"), new ValueWithDescription(String.valueOf(maxTargets), "max. locked targets"), resistanceToDampeningTooltip};
                statArray[0] = new Stat("Targeting Range", ValueFormatsKt.asDistance$default((double)range, (boolean)true, (boolean)false, (int)0, (int)6, null), CollectionsKt.listOfNotNull((Object[])objectArray), null, 8, null);
                objectArray = new ValueWithDescription[]{new ValueWithDescription(ValueFormatsKt.fractionAsPercentageWithPrecisionAtMost$default((double)jamChance, (int)1, (boolean)false, (int)2, null), "chance of being jammed"), resistanceToEcmTooltip};
                statArray[1] = new Stat(sensorType.getShortDisplayName() + " Sensors", ValueFormatsKt.asSensorStrength$default((double)sensorStrength, (boolean)true, (boolean)false, (int)2, null) + (String)(jamChance > 0.0 ? " (" + ValueFormatsKt.fractionAsPercentage$default((double)jamChance, (int)0, (boolean)false, (int)2, null) + ")" : ""), CollectionsKt.listOfNotNull((Object[])objectArray), null, 8, null);
                statArray[2] = new Stat("Scan Resolution", ValueFormatsKt.asScanResolution$default((double)scanRes, (boolean)true, (boolean)false, (int)2, null), CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)resistanceToDampeningTooltip), (Iterable)targetingTimes), null, 8, null);
                FitStatsKt.StatsTable(3, statArray, $composer, 6);
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventEnd();
                }
            } else {
                $composer.skipToGroupEnd();
            }
            ScopeUpdateScope scopeUpdateScope = $composer.endRestartGroup();
            if (scopeUpdateScope == null) break block6;
            scopeUpdateScope.updateScope((arg_0, arg_1) -> TargetingStatsKt.TargetingStats$lambda$2(fit2, $changed, arg_0, arg_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final double jammedChance(Fit $this$jammedChance) {
        void $this$flatMapTo$iv$iv;
        Iterable destination$iv$iv;
        void $this$flatMapTo$iv$iv2;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$jammedChance.getHostileEffects();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RemoteEffect it = (RemoteEffect)element$iv$iv;
            boolean bl = false;
            if (!it.getEnabled()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List enabledEffects = (List)destination$iv$iv2;
        Iterable $this$flatMap$iv = enabledEffects;
        boolean $i$f$flatMap = false;
        destination$iv$iv2 = $this$flatMap$iv;
        Iterable destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            void $this$filterTo$iv$iv2;
            RemoteEffect effect = (RemoteEffect)element$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv2 = effect.getAffectingModules();
            boolean $i$f$filter2 = false;
            Iterable iterable2 = $this$filter$iv2;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                Module it = (Module)element$iv$iv2;
                boolean bl2 = false;
                if (!it.getActive()) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        List ecmModules = (List)destination$iv$iv3;
        Iterable $this$flatMap$iv2 = enabledEffects;
        boolean $i$f$flatMap2 = false;
        destination$iv$iv3 = $this$flatMap$iv2;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$filterTo$iv$iv3;
            RemoteEffect effect = (RemoteEffect)element$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv3 = effect.getAffectingDrones();
            boolean $i$f$filter3 = false;
            destination$iv$iv = $this$filter$iv3;
            Collection destination$iv$iv5 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv3 : $this$filterTo$iv$iv3) {
                DroneGroup it = (DroneGroup)element$iv$iv3;
                boolean bl3 = false;
                if (!it.getActive()) continue;
                destination$iv$iv5.add(element$iv$iv3);
            }
            Iterable list$iv$iv = (List)destination$iv$iv5;
            CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
        }
        List ecmDrones = (List)destination$iv$iv4;
        return MechanicsKt.jamChance$default((SensorType)$this$jammedChance.getTargeting().getSensors().getType(), (double)((Number)$this$jammedChance.getTargeting().getSensors().getStrength().getValue()).doubleValue(), (double)((Number)$this$jammedChance.getElectronicWarfare().getEcmResistance().getValue()).doubleValue(), (Iterable)ecmModules, null, (Iterable)ecmDrones, null, (int)80, null);
    }

    private static final Unit TargetingStats$lambda$2(Fit $fit, int $$changed, Composer $composer, int $force) {
        TargetingStatsKt.TargetingStats($fit, $composer, RecomposeScopeImplKt.updateChangedFlags((int)($$changed | 1)));
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new Triple[]{new Triple((Object)"Pod", (Object)25.0, null), new Triple((Object)"Interceptor", (Object)35.0, (Object)2.25), new Triple((Object)"Frigate", (Object)40.0, (Object)6.0), new Triple((Object)"Destroyer", (Object)80.0, (Object)6.0), new Triple((Object)"Cruiser", (Object)130.0, (Object)6.0), new Triple((Object)"Battlecruiser", (Object)300.0, (Object)6.0), new Triple((Object)"Battleship", (Object)400.0, (Object)6.0)};
        TargetingTimeTooltipExamples = CollectionsKt.listOf((Object[])objectArray);
    }
}

