/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.annotation.VisibleForTesting;
import androidx.compose.foundation.text.Handle;
import androidx.compose.foundation.text.selection.Selectable;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionManager;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RectKt;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.unit.IntSize;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u001a\"\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b\b\u0010\t\u001a*\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\r\u0010\u000e\u001a*\u0010\u000f\u001a\u00020\u00012\u0018\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00120\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0001\u001a\u001e\u0010\u0017\u001a\u00020\u0018*\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0003H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0011\"\u0004\b\u0000\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u001d0\u0011H\u0002\u001a\f\u0010\u001e\u001a\u00020\u0001*\u00020\u0016H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001f"}, d2={"invertedInfiniteRect", "Landroidx/compose/ui/geometry/Rect;", "calculateSelectionMagnifierCenterAndroid", "Landroidx/compose/ui/geometry/Offset;", "manager", "Landroidx/compose/foundation/text/selection/SelectionManager;", "magnifierSize", "Landroidx/compose/ui/unit/IntSize;", "calculateSelectionMagnifierCenterAndroid-O0kMr_c", "(Landroidx/compose/foundation/text/selection/SelectionManager;J)J", "getMagnifierCenter", "anchor", "Landroidx/compose/foundation/text/selection/Selection$AnchorInfo;", "getMagnifierCenter-JVtK1S4", "(Landroidx/compose/foundation/text/selection/SelectionManager;JLandroidx/compose/foundation/text/selection/Selection$AnchorInfo;)J", "getSelectedRegionRect", "selectableSubSelectionPairs", "", "Lkotlin/Pair;", "Landroidx/compose/foundation/text/selection/Selectable;", "Landroidx/compose/foundation/text/selection/Selection;", "containerCoordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "containsInclusive", "", "offset", "containsInclusive-Uv8p0NA", "(Landroidx/compose/ui/geometry/Rect;J)Z", "firstAndLast", "T", "visibleBounds", "foundation"})
@SourceDebugExtension(value={"SMAP\nSelectionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionManager.kt\nandroidx/compose/foundation/text/selection/SelectionManagerKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,1127:1\n33#2,6:1128\n*S KotlinDebug\n*F\n+ 1 SelectionManager.kt\nandroidx/compose/foundation/text/selection/SelectionManagerKt\n*L\n996#1:1128,6\n*E\n"})
public final class SelectionManagerKt {
    @NotNull
    private static final Rect invertedInfiniteRect = new Rect(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);

    private static final <T> List<T> firstAndLast(List<? extends T> $this$firstAndLast) {
        List list;
        switch ($this$firstAndLast.size()) {
            case 0: 
            case 1: {
                list = $this$firstAndLast;
                break;
            }
            default: {
                Object[] objectArray = new Object[]{CollectionsKt.first($this$firstAndLast), CollectionsKt.last($this$firstAndLast)};
                list = CollectionsKt.listOf((Object[])objectArray);
            }
        }
        return list;
    }

    @VisibleForTesting
    @NotNull
    public static final Rect getSelectedRegionRect(@NotNull List<? extends Pair<? extends Selectable, Selection>> selectableSubSelectionPairs, @NotNull LayoutCoordinates containerCoordinates) {
        Intrinsics.checkNotNullParameter(selectableSubSelectionPairs, (String)"selectableSubSelectionPairs");
        Intrinsics.checkNotNullParameter((Object)containerCoordinates, (String)"containerCoordinates");
        if (selectableSubSelectionPairs.isEmpty()) {
            return invertedInfiniteRect;
        }
        Rect rect = invertedInfiniteRect;
        float containerLeft = 0.0f;
        containerLeft = rect.component1();
        float containerTop = 0.0f;
        containerTop = rect.component2();
        float containerRight = 0.0f;
        containerRight = rect.component3();
        float containerBottom = 0.0f;
        containerBottom = rect.component4();
        List<? extends Pair<? extends Selectable, Selection>> $this$fastForEach$iv = selectableSubSelectionPairs;
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            LayoutCoordinates localCoordinates;
            int[] nArray;
            Object object;
            int maxOffset;
            int endOffset;
            Pair<? extends Selectable, Selection> item$iv;
            Pair<? extends Selectable, Selection> pair = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            Selectable selectable2 = (Selectable)pair.component1();
            Selection subSelection = (Selection)pair.component2();
            int startOffset = subSelection.getStart().getOffset();
            if (startOffset == (endOffset = subSelection.getEnd().getOffset()) || selectable2.getLayoutCoordinates() == null) continue;
            int minOffset = Math.min(startOffset, endOffset);
            if (minOffset == (maxOffset = Math.max(startOffset, endOffset)) - 1) {
                object = new int[]{minOffset};
                nArray = object;
            } else {
                object = new int[]{minOffset, maxOffset - 1};
                nArray = object;
            }
            int[] offsets = nArray;
            object = invertedInfiniteRect;
            float left = object.component1();
            float top = object.component2();
            float right = object.component3();
            float bottom = object.component4();
            for (int i : offsets) {
                Rect rect2 = selectable2.getBoundingBox(i);
                left = Math.min(left, rect2.getLeft());
                top = Math.min(top, rect2.getTop());
                right = Math.max(right, rect2.getRight());
                bottom = Math.max(bottom, rect2.getBottom());
            }
            long localTopLeft = OffsetKt.Offset((float)left, (float)top);
            long localBottomRight = OffsetKt.Offset((float)right, (float)bottom);
            long containerTopLeft = containerCoordinates.localPositionOf-R5De75A(localCoordinates, localTopLeft);
            long containerBottomRight = containerCoordinates.localPositionOf-R5De75A(localCoordinates, localBottomRight);
            containerLeft = Math.min(containerLeft, Offset.getX-impl((long)containerTopLeft));
            containerTop = Math.min(containerTop, Offset.getY-impl((long)containerTopLeft));
            containerRight = Math.max(containerRight, Offset.getX-impl((long)containerBottomRight));
            containerBottom = Math.max(containerBottom, Offset.getY-impl((long)containerBottomRight));
        }
        return new Rect(containerLeft, containerTop, containerRight, containerBottom);
    }

    public static final long calculateSelectionMagnifierCenterAndroid-O0kMr_c(@NotNull SelectionManager manager, long magnifierSize) {
        long l;
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Selection selection = manager.getSelection();
        if (selection == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        Selection selection2 = selection;
        Handle handle = manager.getDraggingHandle();
        switch (handle == null ? -1 : WhenMappings.$EnumSwitchMapping$0[handle.ordinal()]) {
            case -1: {
                return Offset.Companion.getUnspecified-F1C5BW0();
            }
            case 1: {
                l = SelectionManagerKt.getMagnifierCenter-JVtK1S4(manager, magnifierSize, selection2.getStart());
                break;
            }
            case 2: {
                l = SelectionManagerKt.getMagnifierCenter-JVtK1S4(manager, magnifierSize, selection2.getEnd());
                break;
            }
            case 3: {
                throw new IllegalStateException("SelectionContainer does not support cursor".toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return l;
    }

    private static final long getMagnifierCenter-JVtK1S4(SelectionManager manager, long magnifierSize, Selection.AnchorInfo anchor) {
        float textConstrainedX;
        float f;
        Selectable selectable2 = manager.getAnchorSelectable$foundation(anchor);
        if (selectable2 == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        Selectable selectable3 = selectable2;
        LayoutCoordinates layoutCoordinates = manager.getContainerLayoutCoordinates();
        if (layoutCoordinates == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        LayoutCoordinates containerCoordinates = layoutCoordinates;
        LayoutCoordinates layoutCoordinates2 = selectable3.getLayoutCoordinates();
        if (layoutCoordinates2 == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        LayoutCoordinates selectableCoordinates = layoutCoordinates2;
        int offset = anchor.getOffset();
        if (offset > selectable3.getLastVisibleOffset()) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        Offset offset2 = manager.getCurrentDragPosition-_m7T9-E();
        Intrinsics.checkNotNull((Object)offset2);
        long localDragPosition = selectableCoordinates.localPositionOf-R5De75A(containerCoordinates, offset2.unbox-impl());
        float dragX = Offset.getX-impl((long)localDragPosition);
        long lineRange = selectable3.getRangeOfLineContaining--jx7JFs(offset);
        if (TextRange.getCollapsed-impl((long)lineRange)) {
            f = selectable3.getLineLeft(offset);
        } else {
            float lineStartX = selectable3.getLineLeft(TextRange.getStart-impl((long)lineRange));
            float lineEndX = selectable3.getLineRight(TextRange.getEnd-impl((long)lineRange) - 1);
            float minX = Math.min(lineStartX, lineEndX);
            float maxX = Math.max(lineStartX, lineEndX);
            f = textConstrainedX = RangesKt.coerceIn((float)dragX, (float)minX, (float)maxX);
        }
        if (textConstrainedX == -1.0f) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        if (!IntSize.equals-impl0((long)magnifierSize, (long)IntSize.Companion.getZero-YbymL2g()) && Math.abs(dragX - textConstrainedX) > (float)(IntSize.getWidth-impl((long)magnifierSize) / 2)) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        float lineCenterY = selectable3.getCenterYForOffset(offset);
        if (lineCenterY == -1.0f) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        return containerCoordinates.localPositionOf-R5De75A(selectableCoordinates, OffsetKt.Offset((float)textConstrainedX, (float)lineCenterY));
    }

    @NotNull
    public static final Rect visibleBounds(@NotNull LayoutCoordinates $this$visibleBounds) {
        Intrinsics.checkNotNullParameter((Object)$this$visibleBounds, (String)"<this>");
        Rect boundsInWindow = LayoutCoordinatesKt.boundsInWindow((LayoutCoordinates)$this$visibleBounds);
        return RectKt.Rect-0a9Yr6o((long)$this$visibleBounds.windowToLocal-MK-Hz9U(boundsInWindow.getTopLeft-F1C5BW0()), (long)$this$visibleBounds.windowToLocal-MK-Hz9U(boundsInWindow.getBottomRight-F1C5BW0()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean containsInclusive-Uv8p0NA(@NotNull Rect $this$containsInclusive_u2dUv8p0NA, long offset) {
        Intrinsics.checkNotNullParameter((Object)$this$containsInclusive_u2dUv8p0NA, (String)"$this$containsInclusive");
        float f = $this$containsInclusive_u2dUv8p0NA.getLeft();
        float f2 = $this$containsInclusive_u2dUv8p0NA.getRight();
        float f3 = Offset.getX-impl((long)offset);
        if (!(f <= f3)) return false;
        if (!(f3 <= f2)) return false;
        boolean bl = true;
        if (!bl) return false;
        f = $this$containsInclusive_u2dUv8p0NA.getTop();
        f2 = $this$containsInclusive_u2dUv8p0NA.getBottom();
        f3 = Offset.getY-impl((long)offset);
        if (!(f <= f3)) return false;
        if (!(f3 <= f2)) return false;
        return true;
    }

    public static final /* synthetic */ List access$firstAndLast(List $receiver) {
        return SelectionManagerKt.firstAndLast($receiver);
    }

    public static final /* synthetic */ Rect access$getInvertedInfiniteRect$p() {
        return invertedInfiniteRect;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Handle.values().length];
            try {
                nArray[Handle.SelectionStart.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Handle.SelectionEnd.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Handle.Cursor.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

