/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010%\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\t\b\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J%\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u001b\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0013J%\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\u0006\u0010\u0017\u001a\u00020\u000eR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ltheorycrafter/utils/SearchTrie;", "T", "", "<init>", "()V", "searchItems", "", "children", "", "", "add", "", "item", "text", "", "minQueryLength", "", "(Ljava/lang/Object;Ljava/lang/String;I)V", "remove", "(Ljava/lang/Object;Ljava/lang/String;)V", "index", "search", "", "word", "Theorycrafter"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSearchTrie.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchTrie.kt\ntheorycrafter/utils/SearchTrie\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,86:1\n381#2,7:87\n*S KotlinDebug\n*F\n+ 1 SearchTrie.kt\ntheorycrafter/utils/SearchTrie\n*L\n39#1:87,7\n*E\n"})
public final class SearchTrie<T> {
    @NotNull
    private final List<T> searchItems = new ArrayList();
    @NotNull
    private final Map<Character, SearchTrie<T>> children = new LinkedHashMap();
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public final void add(T item, @NotNull String text, int minQueryLength) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        SearchTrie node = this;
        int remainingQueryLength = minQueryLength;
        int n = ((CharSequence)text).length();
        for (int index = 0; index < n; ++index) {
            Object object;
            void $this$getOrPut$iv;
            if (remainingQueryLength <= 0) {
                node.searchItems.add(item);
            }
            --remainingQueryLength;
            Map<Character, SearchTrie<T>> map = node.children;
            Character key$iv = Character.valueOf(text.charAt(index));
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean $i$f$add$stub_for_inlining = false;
                boolean bl = false;
                SearchTrie<T> answer$iv = new SearchTrie<T>();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            node = (SearchTrie)object;
        }
        if (remainingQueryLength <= 0) {
            node.searchItems.add(item);
        }
    }

    public static /* synthetic */ void add$default(SearchTrie searchTrie, Object object, String string2, int n, int n2, Object object2) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        searchTrie.add(object, string2, n);
    }

    public final void remove(T item, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.remove(item, text, 0);
    }

    private final void remove(T item, String text, int index) {
        this.searchItems.remove(item);
        if (index == text.length()) {
            return;
        }
        SearchTrie<T> searchTrie = this.children.get(Character.valueOf(text.charAt(index)));
        if (searchTrie == null) {
            throw new IllegalArgumentException("Text \"" + text + "\" is not in this SearchTrie");
        }
        SearchTrie<T> child = searchTrie;
        super.remove(item, text, index + 1);
        if (child.searchItems.isEmpty()) {
            this.children.remove(Character.valueOf(text.charAt(index)));
        }
    }

    @NotNull
    public final Iterable<T> search(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        SearchTrie<T> tree = this;
        int n = word.length();
        for (int i = 0; i < n; ++i) {
            char c = word.charAt(i);
            if (tree.children.get(Character.valueOf(c)) != null) continue;
            return SetsKt.emptySet();
        }
        return tree.searchItems;
    }
}

