/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.fitting;

import androidx.compose.runtime.internal.StabilityInferred;
import eve.data.Attributes;
import eve.data.DamagePattern;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import theorycrafter.fitting.EveItem;
import theorycrafter.fitting.ItemArmor;
import theorycrafter.fitting.ItemShield;
import theorycrafter.fitting.ItemStructure;
import theorycrafter.fitting.Module;
import theorycrafter.fitting.RemoteEffect;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001BQ\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0007\u0012\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\n0\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001fR\u0011\u0010\"\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001fR\u0011\u0010$\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001f\u00a8\u0006&"}, d2={"Ltheorycrafter/fitting/ItemDefenses;", "", "item", "Ltheorycrafter/fitting/EveItem;", "attributes", "Leve/data/Attributes;", "damagePattern", "Lkotlin/Function0;", "Leve/data/DamagePattern;", "localModules", "", "Ltheorycrafter/fitting/Module;", "friendlyEffects", "Ltheorycrafter/fitting/RemoteEffect;", "<init>", "(Ltheorycrafter/fitting/EveItem;Leve/data/Attributes;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "shield", "Ltheorycrafter/fitting/ItemShield;", "getShield", "()Ltheorycrafter/fitting/ItemShield;", "armor", "Ltheorycrafter/fitting/ItemArmor;", "getArmor", "()Ltheorycrafter/fitting/ItemArmor;", "structure", "Ltheorycrafter/fitting/ItemStructure;", "getStructure", "()Ltheorycrafter/fitting/ItemStructure;", "hp", "", "getHp", "()D", "ehp", "getEhp", "ehpRepairedLocally", "getEhpRepairedLocally", "ehpRepairedByRemoteEffects", "getEhpRepairedByRemoteEffects", "FittingEngine"})
@StabilityInferred(parameters=0)
public final class ItemDefenses {
    @NotNull
    private final ItemShield shield;
    @NotNull
    private final ItemArmor armor;
    @NotNull
    private final ItemStructure structure;
    public static final int $stable = 8;

    public ItemDefenses(@NotNull EveItem<?> item, @NotNull Attributes attributes, @NotNull Function0<DamagePattern> damagePattern, @NotNull Function0<? extends Iterable<Module>> localModules, @NotNull Function0<? extends Iterable<? extends RemoteEffect>> friendlyEffects) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(damagePattern, (String)"damagePattern");
        Intrinsics.checkNotNullParameter(localModules, (String)"localModules");
        Intrinsics.checkNotNullParameter(friendlyEffects, (String)"friendlyEffects");
        this.shield = new ItemShield(item, attributes, damagePattern, localModules, friendlyEffects);
        this.armor = new ItemArmor(item, attributes, damagePattern, localModules, friendlyEffects);
        this.structure = new ItemStructure(item, attributes, damagePattern, localModules, friendlyEffects);
    }

    @NotNull
    public final ItemShield getShield() {
        return this.shield;
    }

    @NotNull
    public final ItemArmor getArmor() {
        return this.armor;
    }

    @NotNull
    public final ItemStructure getStructure() {
        return this.structure;
    }

    public final double getHp() {
        return this.shield.getHp().getDoubleValue() + this.armor.getHp().getDoubleValue() + this.structure.getHp().getDoubleValue();
    }

    public final double getEhp() {
        return this.shield.getEhp() + this.armor.getEhp() + this.structure.getEhp();
    }

    public final double getEhpRepairedLocally() {
        return this.shield.getEhpRepairedLocally() + this.armor.getEhpRepairedLocally() + this.structure.getEhpRepairedLocally();
    }

    public final double getEhpRepairedByRemoteEffects() {
        return this.shield.getEhpRepairedRemotely() + this.armor.getEhpRepairedRemotely() + this.structure.getEhpRepairedRemotely();
    }
}

