/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.utils;

import androidx.compose.ui.graphics.ColorKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0002\b\b\u001a'\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u001b\u0010\u000e\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a\u001b\u0010\u0012\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0011\u00a8\u0006\u0014"}, d2={"adjustLightness", "Landroidx/compose/ui/graphics/Color;", "adjuster", "Lkotlin/Function1;", "", "adjustLightness-DxMtmZc", "(JLkotlin/jvm/functions/Function1;)J", "rgbToHsl", "", "rgb", "", "hsl", "", "hslToRgb", "darker", "factor", "darker-DxMtmZc", "(JF)J", "lighter", "lighter-DxMtmZc", "SharedApp"})
public final class ColorUtilsKt {
    private static final long adjustLightness-DxMtmZc(long $this$adjustLightness_u2dDxMtmZc, Function1<? super Float, Float> adjuster) {
        int argb = ColorKt.toArgb-8_81llA((long)$this$adjustLightness_u2dDxMtmZc);
        int alpha = argb >> 24 & 0xFF;
        float[] hsl = new float[3];
        ColorUtilsKt.rgbToHsl(argb, hsl);
        hsl[2] = RangesKt.coerceIn((float)((Number)adjuster.invoke((Object)Float.valueOf(hsl[2]))).floatValue(), (float)0.0f, (float)1.0f);
        int rgb = ColorUtilsKt.hslToRgb(hsl);
        return ColorKt.Color((int)(alpha << 24 | rgb));
    }

    public static final void rgbToHsl(int rgb, @NotNull float[] hsl) {
        Intrinsics.checkNotNullParameter((Object)hsl, (String)"hsl");
        float rNorm = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float gNorm = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float bNorm = (float)(rgb & 0xFF) / 255.0f;
        float cMax = Math.max(rNorm, Math.max(gNorm, bNorm));
        float cMin = Math.min(rNorm, Math.min(gNorm, bNorm));
        float delta = cMax - cMin;
        float hue = 0.0f;
        float saturation = 0.0f;
        float lightness = (cMax + cMin) / 2.0f;
        if (!(delta == 0.0f)) {
            saturation = lightness < 0.5f ? delta / (cMax + cMin) : delta / (2.0f - cMax - cMin);
            float f = cMax;
            if (f == rNorm) {
                hue = (gNorm - bNorm) / delta % 6.0f;
            } else if (f == gNorm) {
                hue = (bNorm - rNorm) / delta + 2.0f;
            } else if (f == bNorm) {
                hue = (rNorm - gNorm) / delta + 4.0f;
            }
            hue *= 60.0f;
            if ((double)hue < 0.0) {
                hue += 360.0f;
            }
        }
        hsl[0] = hue;
        hsl[1] = saturation;
        hsl[2] = lightness;
    }

    public static final int hslToRgb(@NotNull float[] hsl) {
        Intrinsics.checkNotNullParameter((Object)hsl, (String)"hsl");
        float h = hsl[0];
        float s = hsl[1];
        float l = hsl[2];
        float c = (1.0f - Math.abs(2.0f * l - 1.0f)) * s;
        float x = c * (1.0f - Math.abs(h / 60.0f % 2.0f - 1.0f));
        float m = l - c / 2.0f;
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if ((double)h < 60.0) {
            r = c;
            g = x;
            b = 0.0f;
        } else if ((double)h < 120.0) {
            r = x;
            g = c;
            b = 0.0f;
        } else if ((double)h < 180.0) {
            r = 0.0f;
            g = c;
            b = x;
        } else if ((double)h < 240.0) {
            r = 0.0f;
            g = x;
            b = c;
        } else if ((double)h < 300.0) {
            r = x;
            g = 0.0f;
            b = c;
        } else {
            r = c;
            g = 0.0f;
            b = x;
        }
        return (int)((r + m) * 255.0f) << 16 | (int)((g + m) * 255.0f) << 8 | (int)((b + m) * 255.0f);
    }

    public static final long darker-DxMtmZc(long $this$darker_u2dDxMtmZc, float factor) {
        return ColorUtilsKt.adjustLightness-DxMtmZc($this$darker_u2dDxMtmZc, (Function1<? super Float, Float>)((Function1)arg_0 -> ColorUtilsKt.darker_DxMtmZc$lambda$0(factor, arg_0)));
    }

    public static /* synthetic */ long darker-DxMtmZc$default(long l, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = 0.1f;
        }
        return ColorUtilsKt.darker-DxMtmZc(l, f);
    }

    public static final long lighter-DxMtmZc(long $this$lighter_u2dDxMtmZc, float factor) {
        return ColorUtilsKt.adjustLightness-DxMtmZc($this$lighter_u2dDxMtmZc, (Function1<? super Float, Float>)((Function1)arg_0 -> ColorUtilsKt.lighter_DxMtmZc$lambda$0(factor, arg_0)));
    }

    public static /* synthetic */ long lighter-DxMtmZc$default(long l, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = 0.1f;
        }
        return ColorUtilsKt.lighter-DxMtmZc(l, f);
    }

    private static final float darker_DxMtmZc$lambda$0(float $factor, float it) {
        return it * RangesKt.coerceAtLeast((float)(1.0f - $factor), (float)0.0f);
    }

    private static final float lighter_DxMtmZc$lambda$0(float $factor, float lightness) {
        return 1.0f - (1.0f - lightness) * RangesKt.coerceAtLeast((float)(1.0f - $factor), (float)0.0f);
    }
}

