/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import theorycrafter.utils.CollectionsKt;
import theorycrafter.utils.Entry;
import theorycrafter.utils.Metadata;
import theorycrafter.utils.OutputBuffer;
import theorycrafter.utils.PositionDataInputStream;
import theorycrafter.utils.PositionDataOutputStream;
import theorycrafter.utils.StoredCollectionKt;

@kotlin.Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 :*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u00029:B\u0096\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012Q\u0010\n\u001aM\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00010\u0011\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00028\u00000\u000b\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0013\u0010%\u001a\u00020&2\u0006\u0010\u000e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010'J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011J\u0014\u0010(\u001a\u00020&2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011J\u001f\u0010(\u001a\u00020&2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010)\"\u00028\u0001\u00a2\u0006\u0002\u0010*J$\u0010+\u001a\u00020\u000f2\b\b\u0002\u0010,\u001a\u00020\u000f2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020/0.J\u0013\u00100\u001a\u00020/2\u0006\u00101\u001a\u00028\u0001\u00a2\u0006\u0002\u00102J\u0006\u00103\u001a\u00020&J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u001fH\u0002J\u0010\u00107\u001a\u0002082\u0006\u00106\u001a\u00020\u001fH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001a\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00028\u0000@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Ltheorycrafter/utils/StoredCollection;", "M", "T", "", "storageFile", "Ljava/io/File;", "userMetadataSerializer", "Ltheorycrafter/utils/StoredCollection$Serializer;", "initialUserMetadata", "Lkotlin/Function0;", "userMetadataUpgrader", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "metadata", "", "version", "Lkotlin/sequences/Sequence;", "items", "itemSerializer", "typicalMaxItemSizeBytes", "<init>", "(Ljava/io/File;Ltheorycrafter/utils/StoredCollection$Serializer;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function3;Ltheorycrafter/utils/StoredCollection$Serializer;I)V", "file", "Ljava/io/RandomAccessFile;", "value", "userMetadata", "getUserMetadata", "()Ljava/lang/Object;", "Ljava/lang/Object;", "dataPosition", "", "entries", "", "Ltheorycrafter/utils/Entry;", "buffer", "Ltheorycrafter/utils/OutputBuffer;", "setUserMetadata", "", "(Ljava/lang/Object;)V", "add", "", "([Ljava/lang/Object;)V", "removeMatching", "maxRemoveCount", "predicate", "Lkotlin/Function1;", "", "remove", "item", "(Ljava/lang/Object;)Z", "close", "outputAt", "Ltheorycrafter/utils/PositionDataOutputStream;", "position", "inputAt", "Ltheorycrafter/utils/PositionDataInputStream;", "Serializer", "Companion", "SharedApp"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nStoredCollection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StoredCollection.kt\ntheorycrafter/utils/StoredCollection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,840:1\n1807#2,3:841\n391#2,7:844\n*S KotlinDebug\n*F\n+ 1 StoredCollection.kt\ntheorycrafter/utils/StoredCollection\n*L\n425#1:841,3\n538#1:844,7\n*E\n"})
public final class StoredCollection<M, T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Serializer<M> userMetadataSerializer;
    @NotNull
    private final Serializer<T> itemSerializer;
    @NotNull
    private final RandomAccessFile file;
    private M userMetadata;
    private long dataPosition;
    @NotNull
    private final List<Entry<T>> entries;
    @NotNull
    private final OutputBuffer buffer;
    public static final int $stable = 8;
    @NotNull
    private static final Serializer<Unit> UnitSerializer = new Serializer<Unit>(){
        private final int itemFormatVersion;

        public int getItemFormatVersion() {
            return this.itemFormatVersion;
        }

        public void readItem(DataInput input, int formatVersion) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        }

        public void writeItem(DataOutput output, Unit item) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        }
    };

    public StoredCollection(@NotNull File storageFile, @NotNull Serializer<M> userMetadataSerializer, @NotNull Function0<? extends M> initialUserMetadata, @NotNull Function3<? super M, ? super Integer, ? super Sequence<? extends T>, ? extends M> userMetadataUpgrader, @NotNull Serializer<T> itemSerializer, int typicalMaxItemSizeBytes) {
        boolean entriesDeleted;
        boolean itemFormatChanged;
        boolean userMetadataFormatChanged;
        Metadata metadata;
        block9: {
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            Intrinsics.checkNotNullParameter(userMetadataSerializer, (String)"userMetadataSerializer");
            Intrinsics.checkNotNullParameter(initialUserMetadata, (String)"initialUserMetadata");
            Intrinsics.checkNotNullParameter(userMetadataUpgrader, (String)"userMetadataUpgrader");
            Intrinsics.checkNotNullParameter(itemSerializer, (String)"itemSerializer");
            this.userMetadataSerializer = userMetadataSerializer;
            this.itemSerializer = itemSerializer;
            this.file = new RandomAccessFile(storageFile, "rw");
            this.buffer = StoredCollectionKt.access$outputBuffer(typicalMaxItemSizeBytes);
            if (this.file.length() == 0L) {
                StoredCollectionKt.access$initializeFile(this.file, this.itemSerializer.getItemFormatVersion(), initialUserMetadata.invoke(), this.userMetadataSerializer);
            }
            if ((metadata = StoredCollectionKt.access$readMetadata(this.file)).getStorageFormatVersion() < 2) {
                String string2 = "Upgrading stored collection at " + storageFile + " from version " + metadata.getStorageFormatVersion() + " to 2";
                System.out.println((Object)string2);
                StoredCollectionKt.access$upgrade(this.file, metadata.getStorageFormatVersion(), metadata, initialUserMetadata, this.userMetadataSerializer);
            }
            this.userMetadata = this.userMetadataSerializer.readItem(this.file, metadata.getUserMetadataFormatVersion());
            this.dataPosition = this.file.getFilePointer();
            PositionDataInputStream input = this.inputAt(this.dataPosition);
            this.entries = new ArrayList(metadata.getEntryCount());
            int n = metadata.getEntryCount();
            for (int i = 0; i < n; ++i) {
                ((ArrayList)this.entries).add(StoredCollectionKt.access$readEntry(input, this.itemSerializer, metadata.getItemFormatVersion()));
            }
            userMetadataFormatChanged = metadata.getUserMetadataFormatVersion() != this.userMetadataSerializer.getItemFormatVersion();
            itemFormatChanged = metadata.getItemFormatVersion() != this.itemSerializer.getItemFormatVersion();
            Iterable $this$any$iv = this.entries;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Entry p0 = (Entry)element$iv;
                    boolean bl = false;
                    if (!p0.isDeleted()) continue;
                    v0 = true;
                    break block9;
                }
                v0 = entriesDeleted = false;
            }
        }
        if (userMetadataFormatChanged || itemFormatChanged || entriesDeleted) {
            if (userMetadataFormatChanged) {
                this.userMetadata = userMetadataUpgrader.invoke(this.userMetadata, (Object)metadata.getUserMetadataFormatVersion(), this.items());
                this.file.seek(16L);
                this.userMetadataSerializer.writeItem(this.file, this.userMetadata);
                this.dataPosition = this.file.getFilePointer();
            }
            PositionDataOutputStream output = this.outputAt(this.dataPosition);
            int remainingEntryCount = 0;
            int n = ((Collection)this.entries).size();
            for (int index = 0; index < n; ++index) {
                Object item;
                if (((Entry)((ArrayList)this.entries).get(index)).getItem() == null) continue;
                ((ArrayList)this.entries).set(remainingEntryCount++, StoredCollectionKt.access$writeEntry(output, item, this.itemSerializer, this.buffer));
            }
            output.flush();
            this.file.setLength(this.file.getFilePointer());
            CollectionsKt.removeTailFrom(this.entries, remainingEntryCount);
            StoredCollectionKt.access$writeMetadata(this.file, new Metadata(2, this.itemSerializer.getItemFormatVersion(), ((ArrayList)this.entries).size(), this.userMetadataSerializer.getItemFormatVersion()));
            this.file.getFD().sync();
        }
    }

    public /* synthetic */ StoredCollection(File file, Serializer serializer, Function0 function0, Function3 function3, Serializer serializer2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            n = 8192;
        }
        this(file, serializer, function0, function3, serializer2, n);
    }

    public final M getUserMetadata() {
        return this.userMetadata;
    }

    public final void setUserMetadata(M metadata) {
        this.userMetadata = metadata;
        this.file.seek(16L);
        this.userMetadataSerializer.writeItem(this.file, metadata);
    }

    @NotNull
    public final Sequence<T> items() {
        return SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)this.entries), StoredCollection::items$lambda$0));
    }

    public final void add(@NotNull Sequence<? extends T> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        PositionDataOutputStream output = this.outputAt(this.file.length());
        for (Object item : items) {
            Entry entry = StoredCollectionKt.access$writeEntry(output, item, this.itemSerializer, this.buffer);
            this.entries.add(entry);
        }
        output.flush();
        StoredCollectionKt.access$writeEntryCount(this.file, this.entries.size());
        this.file.getFD().sync();
    }

    public final void add(T ... items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.add(ArraysKt.asSequence((Object[])items));
    }

    public final int removeMatching(int maxRemoveCount, @NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Sequence matchingIndices2 = SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Integer>, Continuation<? super Unit>, Object>(this, predicate, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ StoredCollection<M, T> this$0;
            final /* synthetic */ Function1<T, Boolean> $predicate;
            {
                this.this$0 = $receiver;
                this.$predicate = $predicate;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Object invokeSuspend(Object $result) {
                Object object;
                Entry entry;
                Object item;
                int index;
                int n;
                Iterator iterator;
                SequenceScope sequenceScope = (SequenceScope)this.L$0;
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        iterator = ((Iterable)StoredCollection.access$getEntries$p(this.this$0)).iterator();
                        n = 0;
                        break;
                    }
                    case 1: {
                        index = this.I$1;
                        n = this.I$0;
                        item = this.L$3;
                        entry = (Entry)this.L$2;
                        iterator = (Iterator)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        object = $result;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                while (iterator.hasNext()) {
                    void $this$sequence;
                    index = n++;
                    entry = (Entry)iterator.next();
                    if (entry.getItem() == null || !((Boolean)this.$predicate.invoke(item)).booleanValue()) continue;
                    this.L$0 = $this$sequence;
                    this.L$1 = iterator;
                    this.L$2 = SpillingKt.nullOutSpilledVariable((Object)entry);
                    this.L$3 = SpillingKt.nullOutSpilledVariable((Object)item);
                    this.I$0 = n;
                    this.I$1 = index;
                    this.label = 1;
                    object = $this$sequence.yield((Object)Boxing.boxInt((int)index), (Continuation)this);
                    if (object != object2) continue;
                    return object2;
                }
                return Unit.INSTANCE;
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super Integer> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        int deletedCount = 0;
        Iterator iterator = matchingIndices2.iterator();
        while (iterator.hasNext()) {
            int index = ((Number)iterator.next()).intValue();
            if (deletedCount >= maxRemoveCount) break;
            Entry<T> entry = this.entries.get(index);
            this.entries.set(index, entry.deleted());
            this.file.seek(this.dataPosition + entry.getPosition());
            StoredCollectionKt.access$markEntryDeleted(this.file);
            ++deletedCount;
        }
        if (!((Collection)this.entries).isEmpty()) {
            int n;
            block4: {
                List<Entry<T>> $this$indexOfLast$iv = this.entries;
                boolean $i$f$indexOfLast = false;
                ListIterator<Entry<T>> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Entry<T> it = iterator$iv.previous();
                    boolean bl = false;
                    if (!(!it.isDeleted())) continue;
                    n = iterator$iv.nextIndex();
                    break block4;
                }
                n = -1;
            }
            int firstTailIndex = n + 1;
            if (firstTailIndex < this.entries.size()) {
                Entry<T> firstTailEntry = this.entries.get(firstTailIndex);
                this.file.setLength(this.dataPosition + firstTailEntry.getPosition());
                CollectionsKt.removeTailFrom(this.entries, firstTailIndex);
                StoredCollectionKt.access$writeEntryCount(this.file, this.entries.size());
            }
        }
        this.file.getFD().sync();
        return deletedCount;
    }

    public static /* synthetic */ int removeMatching$default(StoredCollection storedCollection, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = Integer.MAX_VALUE;
        }
        return storedCollection.removeMatching(n, function1);
    }

    public final boolean remove(T item) {
        int count = this.removeMatching(1, arg_0 -> StoredCollection.remove$lambda$0(item, arg_0));
        return count == 1;
    }

    public final void close() {
        this.file.close();
    }

    private final PositionDataOutputStream outputAt(long position) {
        this.file.seek(position);
        OutputStream outputStream = Channels.newOutputStream(this.file.getChannel());
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        OutputStream outputStream2 = outputStream;
        int n = 8192;
        return StoredCollectionKt.access$dataWithPosition(outputStream2 instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream2 : new BufferedOutputStream(outputStream2, n), position - this.dataPosition);
    }

    private final PositionDataInputStream inputAt(long position) {
        this.file.seek(position);
        InputStream inputStream = Channels.newInputStream(this.file.getChannel());
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        InputStream inputStream2 = inputStream;
        int n = 8192;
        return StoredCollectionKt.access$dataWithPosition(inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n), this.file.getFilePointer() - this.dataPosition);
    }

    private static final Object items$lambda$0(Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getItem();
    }

    private static final boolean remove$lambda$0(Object $item, Object it) {
        return Intrinsics.areEqual((Object)it, (Object)$item);
    }

    public static final /* synthetic */ List access$getEntries$p(StoredCollection $this) {
        return $this.entries;
    }

    @kotlin.Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ltheorycrafter/utils/StoredCollection$Companion;", "", "<init>", "()V", "UnitSerializer", "Ltheorycrafter/utils/StoredCollection$Serializer;", "", "getUnitSerializer", "()Ltheorycrafter/utils/StoredCollection$Serializer;", "SharedApp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Serializer<Unit> getUnitSerializer() {
            return UnitSerializer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @kotlin.Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000*\u0004\b\u0002\u0010\u00012\u00020\u0002J\u001d\u0010\u0007\u001a\u00028\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H&\u00a2\u0006\u0002\u0010\u000bJ\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0002H&\u00a2\u0006\u0002\u0010\u0011R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012\u00c0\u0006\u0003"}, d2={"Ltheorycrafter/utils/StoredCollection$Serializer;", "T", "", "itemFormatVersion", "", "getItemFormatVersion", "()I", "readItem", "input", "Ljava/io/DataInput;", "formatVersion", "(Ljava/io/DataInput;I)Ljava/lang/Object;", "writeItem", "", "output", "Ljava/io/DataOutput;", "item", "(Ljava/io/DataOutput;Ljava/lang/Object;)V", "SharedApp"})
    public static interface Serializer<T> {
        public int getItemFormatVersion();

        public T readItem(@NotNull DataInput var1, int var2);

        public void writeItem(@NotNull DataOutput var1, T var2);
    }
}

