/*
 * Decompiled with CFR 0.152.
 */
package eve.data.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\u0007H\u0016J \u0010\t\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u0007H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Leve/data/utils/UnsyncByteArrayInputStream;", "Ljava/io/InputStream;", "buf", "", "<init>", "([B)V", "position", "", "size", "read", "offset", "length", "readAllBytes", "readNBytes", "transferTo", "", "out", "Ljava/io/OutputStream;", "skip", "n", "available", "markSupported", "", "EveData"})
@StabilityInferred(parameters=0)
public final class UnsyncByteArrayInputStream
extends InputStream {
    @NotNull
    private final byte[] buf;
    private int position;
    private final int size;
    public static final int $stable = 8;

    public UnsyncByteArrayInputStream(@NotNull byte[] buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        this.buf = buf;
        this.size = this.buf.length;
    }

    @Override
    public int read() {
        if (this.position >= this.size) {
            return -1;
        }
        int n = this.position;
        this.position = n + 1;
        return this.buf[n] & 0xFF;
    }

    @Override
    public int read(@NotNull byte[] buf, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        if (this.position >= this.size) {
            return -1;
        }
        int count = RangesKt.coerceAtMost((int)length, (int)(this.size - this.position));
        if (count <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.position, buf, offset, count);
        this.position += count;
        return count;
    }

    @Override
    @NotNull
    public byte[] readAllBytes() {
        byte[] byArray;
        byte[] it = byArray = ArraysKt.copyOfRange((byte[])this.buf, (int)this.position, (int)this.size);
        boolean bl = false;
        this.position = this.size;
        return byArray;
    }

    @Override
    public int readNBytes(@NotNull byte[] buf, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        int count = this.read(buf, offset, length);
        boolean bl = false;
        return count == -1 ? 0 : count;
    }

    @Override
    public long transferTo(@NotNull OutputStream out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int length = this.size - this.position;
        out.write(this.buf, this.position, length);
        this.position = this.size;
        return length;
    }

    @Override
    public long skip(long n) {
        long actualSkip = RangesKt.coerceIn((long)n, (ClosedRange)((ClosedRange)new LongRange(0L, (long)(this.size - this.position))));
        this.position += (int)actualSkip;
        return actualSkip;
    }

    @Override
    public int available() {
        return this.size - this.position;
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

