/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter;

import androidx.compose.runtime.internal.StabilityInferred;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.FileLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import theorycrafter.utils.MiscKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\u00020\u00102\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\tH\u0002J\b\u0010\u001b\u001a\u00020\u0010H\u0002J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\b\u0010\u001d\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ltheorycrafter/SingleAppInstanceManager;", "", "<init>", "()V", "LOCK_FILE_MAGIC_NUMBER", "", "PROTOCOL_VERSION", "COMMAND_BRING_TO_FRONT", "lockFile", "Ljava/io/RandomAccessFile;", "lock", "Ljava/nio/channels/FileLock;", "serverSocket", "Ljava/net/ServerSocket;", "bringToFront", "Lkotlin/Function0;", "", "closed", "", "ensureFirstAppInstance", "applicationName", "", "setBringToFrontCallback", "writePortToLockFile", "file", "port", "readPortFromLockFile", "listenToIncomingCommands", "signalExistingInstance", "close", "DesktopApp"})
@StabilityInferred(parameters=0)
public final class SingleAppInstanceManager {
    @NotNull
    public static final SingleAppInstanceManager INSTANCE = new SingleAppInstanceManager();
    private static final int LOCK_FILE_MAGIC_NUMBER = 49374;
    private static final int PROTOCOL_VERSION = 1;
    private static final int COMMAND_BRING_TO_FRONT = 1;
    @Nullable
    private static RandomAccessFile lockFile;
    @Nullable
    private static FileLock lock;
    @Nullable
    private static ServerSocket serverSocket;
    @Nullable
    private static Function0<Unit> bringToFront;
    private static volatile boolean closed;
    public static final int $stable;

    private SingleAppInstanceManager() {
    }

    public final boolean ensureFirstAppInstance(@NotNull String applicationName) {
        RandomAccessFile raf;
        Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
        File file = new File(System.getProperty("java.io.tmpdir"), applicationName + ".lock");
        lockFile = raf = new RandomAccessFile(file, "rw");
        lock = raf.getChannel().tryLock();
        if (lock == null) {
            try {
                RandomAccessFile randomAccessFile = lockFile;
                Intrinsics.checkNotNull((Object)randomAccessFile);
                int port = this.readPortFromLockFile(randomAccessFile);
                RandomAccessFile randomAccessFile2 = lockFile;
                if (randomAccessFile2 != null) {
                    randomAccessFile2.close();
                }
                this.signalExistingInstance(port);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }
        ThreadsKt.thread$default((boolean)false, (boolean)true, null, null, (int)0, SingleAppInstanceManager::ensureFirstAppInstance$lambda$0, (int)29, null);
        Runtime.getRuntime().addShutdownHook(ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, SingleAppInstanceManager::ensureFirstAppInstance$lambda$1, (int)30, null));
        return true;
    }

    public final void setBringToFrontCallback(@NotNull Function0<Unit> bringToFront) {
        Intrinsics.checkNotNullParameter(bringToFront, (String)"bringToFront");
        SingleAppInstanceManager.bringToFront = bringToFront;
    }

    private final void writePortToLockFile(RandomAccessFile file, int port) {
        file.setLength(0L);
        file.writeInt(49374);
        file.writeInt(port);
        file.getFD().sync();
    }

    private final int readPortFromLockFile(RandomAccessFile file) {
        file.seek(0L);
        if (file.readInt() != 49374) {
            throw new IllegalStateException("Corrupt lock file");
        }
        return file.readInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void listenToIncomingCommands() {
        while (!closed) {
            try {
                Closeable closeable = serverSocket;
                if (closeable == null || (closeable = closeable.accept()) == null) break;
                Closeable socket = closeable;
                Closeable closeable2 = socket;
                Throwable throwable = null;
                try {
                    Socket it = (Socket)closeable2;
                    boolean bl = false;
                    InputStream inputStream = it.getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                    DataInputStream $this$listenToIncomingCommands_u24lambda_u240_u240 = MiscKt.data(inputStream);
                    boolean bl2 = false;
                    int version = $this$listenToIncomingCommands_u24lambda_u240_u240.readInt();
                    if (version != 1) {
                        System.err.println("Received unexpected version number via socket: " + version);
                    } else {
                        int command = $this$listenToIncomingCommands_u24lambda_u240_u240.readInt();
                        if (command == 1) {
                            Function0<Unit> function0 = bringToFront;
                            if (function0 != null) {
                                function0.invoke();
                            }
                        } else {
                            System.err.println("Received unknown command via socket: " + command);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                if (closed) continue;
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void signalExistingInstance(int port) {
        Closeable closeable = new Socket(InetAddress.getLoopbackAddress(), port);
        Throwable throwable = null;
        try {
            Socket it = (Socket)closeable;
            boolean bl = false;
            OutputStream outputStream = it.getOutputStream();
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
            DataOutputStream $this$signalExistingInstance_u24lambda_u240_u240 = MiscKt.data(outputStream);
            boolean bl2 = false;
            $this$signalExistingInstance_u24lambda_u240_u240.writeInt(1);
            $this$signalExistingInstance_u24lambda_u240_u240.writeInt(1);
            $this$signalExistingInstance_u24lambda_u240_u240.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void close() {
        if (closed) {
            return;
        }
        try {
            closed = true;
            ServerSocket serverSocket = SingleAppInstanceManager.serverSocket;
            if (serverSocket != null) {
                serverSocket.close();
            }
            FileLock fileLock = lock;
            if (fileLock != null) {
                fileLock.release();
            }
            RandomAccessFile randomAccessFile = lockFile;
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final Unit ensureFirstAppInstance$lambda$0() {
        ServerSocket serverSocket = SingleAppInstanceManager.serverSocket = new ServerSocket(0, 10, InetAddress.getLoopbackAddress());
        Intrinsics.checkNotNull((Object)serverSocket);
        int port = serverSocket.getLocalPort();
        RandomAccessFile randomAccessFile = lockFile;
        Intrinsics.checkNotNull((Object)randomAccessFile);
        INSTANCE.writePortToLockFile(randomAccessFile, port);
        INSTANCE.listenToIncomingCommands();
        return Unit.INSTANCE;
    }

    private static final Unit ensureFirstAppInstance$lambda$1() {
        INSTANCE.close();
        return Unit.INSTANCE;
    }

    static {
        $stable = 8;
    }
}

