/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.storage;

import androidx.compose.runtime.internal.StabilityInferred;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import theorycrafter.esi.EveSsoTokens;
import theorycrafter.storage.EveSsoTokensSerializer;
import theorycrafter.utils.StoredCollection;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0017\b\u0007\u0018\u00002\u00020\u0001:\u0001!BG\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJC\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\t2\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00072\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u001fJ\n\u0010 \u001a\u00020\u0005H\u0096\u0080\u0004R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0015\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R*\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001c\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\""}, d2={"Ltheorycrafter/storage/StoredSkillSet;", "", "id", "", "name", "", "levelBySkillId", "", "ssoTokens", "Ltheorycrafter/esi/EveSsoTokens;", "lastUpdateTimeUtcMillis", "", "<init>", "(Ljava/lang/Integer;Ljava/lang/String;Ljava/util/Map;Ltheorycrafter/esi/EveSsoTokens;Ljava/lang/Long;)V", "getName", "()Ljava/lang/String;", "getLevelBySkillId", "()Ljava/util/Map;", "getSsoTokens", "()Ltheorycrafter/esi/EveSsoTokens;", "getLastUpdateTimeUtcMillis", "()Ljava/lang/Long;", "Ljava/lang/Long;", "value", "getId", "()Ljava/lang/Integer;", "setId", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "copy", "eveSsoTokens", "(Ljava/lang/String;Ltheorycrafter/esi/EveSsoTokens;Ljava/util/Map;Ljava/lang/Long;)Ltheorycrafter/storage/StoredSkillSet;", "toString", "Serializer", "DesktopApp"})
@StabilityInferred(parameters=0)
public final class StoredSkillSet {
    @NotNull
    private final String name;
    @NotNull
    private final Map<Integer, Integer> levelBySkillId;
    @Nullable
    private final EveSsoTokens ssoTokens;
    @Nullable
    private final Long lastUpdateTimeUtcMillis;
    @Nullable
    private Integer id;
    public static final int $stable = 8;

    public StoredSkillSet(@Nullable Integer id, @NotNull String name2, @NotNull Map<Integer, Integer> levelBySkillId, @Nullable EveSsoTokens ssoTokens, @Nullable Long lastUpdateTimeUtcMillis) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(levelBySkillId, (String)"levelBySkillId");
        this.name = name2;
        this.levelBySkillId = levelBySkillId;
        this.ssoTokens = ssoTokens;
        this.lastUpdateTimeUtcMillis = lastUpdateTimeUtcMillis;
        if (id != null && id < 0) {
            throw new IllegalArgumentException("Stored skill sets must have non-negative ids");
        }
        this.id = id;
    }

    public /* synthetic */ StoredSkillSet(Integer n, String string2, Map map, EveSsoTokens eveSsoTokens, Long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        if ((n2 & 8) != 0) {
            eveSsoTokens = null;
        }
        if ((n2 & 0x10) != 0) {
            l = null;
        }
        this(n, string2, map, eveSsoTokens, l);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Map<Integer, Integer> getLevelBySkillId() {
        return this.levelBySkillId;
    }

    @Nullable
    public final EveSsoTokens getSsoTokens() {
        return this.ssoTokens;
    }

    @Nullable
    public final Long getLastUpdateTimeUtcMillis() {
        return this.lastUpdateTimeUtcMillis;
    }

    @Nullable
    public final Integer getId() {
        return this.id;
    }

    public final void setId(@Nullable Integer value) {
        if (this.id != null) {
            throw new IllegalArgumentException("SkillSet " + this + " already has an id");
        }
        this.id = value;
    }

    @NotNull
    public final StoredSkillSet copy(@NotNull String name2, @Nullable EveSsoTokens eveSsoTokens, @NotNull Map<Integer, Integer> levelBySkillId, @Nullable Long lastUpdateTimeUtcMillis) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(levelBySkillId, (String)"levelBySkillId");
        return new StoredSkillSet(this.id, name2, levelBySkillId, eveSsoTokens, lastUpdateTimeUtcMillis);
    }

    public static /* synthetic */ StoredSkillSet copy$default(StoredSkillSet storedSkillSet, String string2, EveSsoTokens eveSsoTokens, Map map, Long l, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = storedSkillSet.name;
        }
        if ((n & 2) != 0) {
            eveSsoTokens = storedSkillSet.ssoTokens;
        }
        if ((n & 4) != 0) {
            map = storedSkillSet.levelBySkillId;
        }
        if ((n & 8) != 0) {
            l = storedSkillSet.lastUpdateTimeUtcMillis;
        }
        return storedSkillSet.copy(string2, eveSsoTokens, map, l);
    }

    @NotNull
    public String toString() {
        return "StoredSkillSet(" + this.name + ", id=" + this.id + ")";
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\t\u001a\u00020\n*\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0016\u0010\u000e\u001a\u0004\u0018\u00010\r*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Ltheorycrafter/storage/StoredSkillSet$Serializer;", "Ltheorycrafter/utils/StoredCollection$Serializer;", "Ltheorycrafter/storage/StoredSkillSet;", "<init>", "()V", "itemFormatVersion", "", "getItemFormatVersion", "()Ljava/lang/Void;", "writeOptionalSsoTokens", "", "Ljava/io/DataOutput;", "eveSsoTokens", "Ltheorycrafter/esi/EveSsoTokens;", "readOptionalSsoTokens", "Ljava/io/DataInput;", "formatVersion", "", "readItem", "input", "writeItem", "output", "item", "DesktopApp"})
    @StabilityInferred(parameters=1)
    @SourceDebugExtension(value={"SMAP\nStoredSkillSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StoredSkillSet.kt\ntheorycrafter/storage/StoredSkillSet$Serializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n1#2:180\n*E\n"})
    public static final class Serializer
    implements StoredCollection.Serializer<StoredSkillSet> {
        @NotNull
        public static final Serializer INSTANCE = new Serializer();
        public static final int $stable;

        private Serializer() {
        }

        @NotNull
        public Void getItemFormatVersion() {
            throw new IllegalStateException("StoredSkillSet format version is determined by the FitRepoItem serializer".toString());
        }

        private final void writeOptionalSsoTokens(DataOutput $this$writeOptionalSsoTokens, EveSsoTokens eveSsoTokens) {
            $this$writeOptionalSsoTokens.writeBoolean(eveSsoTokens != null);
            if (eveSsoTokens != null) {
                $this$writeOptionalSsoTokens.writeInt(EveSsoTokensSerializer.INSTANCE.getItemFormatVersion());
                EveSsoTokensSerializer.INSTANCE.writeItem($this$writeOptionalSsoTokens, eveSsoTokens);
            }
        }

        private final EveSsoTokens readOptionalSsoTokens(DataInput $this$readOptionalSsoTokens, int formatVersion) {
            if (!$this$readOptionalSsoTokens.readBoolean()) {
                return null;
            }
            if (formatVersion == 1) {
                return EveSsoTokensSerializer.INSTANCE.readItem($this$readOptionalSsoTokens, 1);
            }
            int ssoTokensFormatVersion = $this$readOptionalSsoTokens.readInt();
            return EveSsoTokensSerializer.INSTANCE.readItem($this$readOptionalSsoTokens, ssoTokensFormatVersion);
        }

        @NotNull
        public StoredSkillSet readItem(@NotNull DataInput input, int formatVersion) {
            Map map;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            DataInput $this$readItem_u24lambda_u240 = input;
            boolean bl = false;
            int id = $this$readItem_u24lambda_u240.readInt();
            String name2 = $this$readItem_u24lambda_u240.readUTF();
            EveSsoTokens eveSsoTokens = INSTANCE.readOptionalSsoTokens($this$readItem_u24lambda_u240, formatVersion);
            Long l = $this$readItem_u24lambda_u240.readLong();
            long it = ((Number)l).longValue();
            boolean bl2 = false;
            Long lastUpdateTimeUtcMillis = it >= 0L ? l : null;
            int count = $this$readItem_u24lambda_u240.readUnsignedShort();
            Map $this$readItem_u24lambda_u240_u241 = map = MapsKt.createMapBuilder();
            boolean bl3 = false;
            int n = 0;
            while (n < count) {
                int it2 = n++;
                boolean bl4 = false;
                int skillId = $this$readItem_u24lambda_u240.readInt();
                int level = $this$readItem_u24lambda_u240.readUnsignedByte();
                $this$readItem_u24lambda_u240_u241.put(skillId, level);
            }
            Map levelBySkillId = MapsKt.build((Map)map);
            Integer n2 = id;
            Intrinsics.checkNotNull((Object)name2);
            return new StoredSkillSet(n2, name2, levelBySkillId, eveSsoTokens, lastUpdateTimeUtcMillis);
        }

        public void writeItem(@NotNull DataOutput output, @NotNull StoredSkillSet item) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            if (item.getId() == null) {
                throw new IllegalArgumentException("Can't write skill set without an id");
            }
            DataOutput $this$writeItem_u24lambda_u240 = output;
            boolean bl = false;
            Integer n = item.getId();
            Intrinsics.checkNotNull((Object)n);
            $this$writeItem_u24lambda_u240.writeInt(n);
            $this$writeItem_u24lambda_u240.writeUTF(item.getName());
            INSTANCE.writeOptionalSsoTokens($this$writeItem_u24lambda_u240, item.getSsoTokens());
            Long l = item.getLastUpdateTimeUtcMillis();
            $this$writeItem_u24lambda_u240.writeLong(l != null ? l : -1L);
            $this$writeItem_u24lambda_u240.writeShort(item.getLevelBySkillId().size());
            for (Map.Entry<Integer, Integer> entry : item.getLevelBySkillId().entrySet()) {
                int skillId = ((Number)entry.getKey()).intValue();
                int level = ((Number)entry.getValue()).intValue();
                $this$writeItem_u24lambda_u240.writeInt(skillId);
                $this$writeItem_u24lambda_u240.writeByte(level);
            }
        }
    }
}

