/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.ui.fiteditor.effectcolumn;

import eve.data.Attribute;
import eve.data.Attributes;
import eve.data.EveData;
import eve.data.ValueFormatsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import theorycrafter.TheorycrafterContext;
import theorycrafter.fitting.StackingPenaltyKt;
import theorycrafter.ui.fiteditor.effectcolumn.CumulativeEffect;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0016\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Ltheorycrafter/ui/fiteditor/effectcolumn/MultiplicativePercent;", "Ltheorycrafter/ui/fiteditor/effectcolumn/CumulativeEffect;", "", "modifiedAttribute", "Lkotlin/Function1;", "Leve/data/Attributes;", "Leve/data/Attribute;", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "getModifiedAttribute", "()Lkotlin/jvm/functions/Function1;", "effectText", "", "singleDroneValue", "droneCount", "", "isCellDisplay", "", "DesktopApp"})
final class MultiplicativePercent
implements CumulativeEffect<Double> {
    @NotNull
    private final Function1<Attributes, Attribute<?>> modifiedAttribute;

    public MultiplicativePercent(@NotNull Function1<? super Attributes, ? extends Attribute<?>> modifiedAttribute) {
        Intrinsics.checkNotNullParameter(modifiedAttribute, (String)"modifiedAttribute");
        this.modifiedAttribute = modifiedAttribute;
    }

    @NotNull
    public final Function1<Attributes, Attribute<?>> getModifiedAttribute() {
        return this.modifiedAttribute;
    }

    @Override
    @NotNull
    public String effectText(double singleDroneValue, int droneCount, boolean isCellDisplay) {
        double d;
        EveData eveData = TheorycrafterContext.INSTANCE.getEveData();
        Attribute attribute = (Attribute)this.modifiedAttribute.invoke((Object)eveData.getAttributes());
        if (attribute.isStackingPenalized()) {
            double stackingPenalizedEffect = 1.0;
            for (int n = 0; n < droneCount; ++n) {
                stackingPenalizedEffect *= 1.0 + singleDroneValue * StackingPenaltyKt.stackingPenaltyFactor((int)n) / 100.0;
            }
            d = stackingPenalizedEffect;
        } else {
            d = Math.pow(1.0 + singleDroneValue / (double)100, droneCount);
        }
        double cumulativeEffect = d;
        return ValueFormatsKt.fractionAsPercentage((double)(cumulativeEffect - 1.0), (int)(isCellDisplay ? 0 : 1), (boolean)true);
    }
}

