/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.ui.widgets;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import theorycrafter.ui.widgets.SpinnerModel;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u0085\u0001\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\b\u0012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\b\u0012\u0019\u0010\n\u001a\u0015\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000b\u00a2\u0006\u0002\b\r\u0012\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\b\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\fH\u0016J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\fH\u0016J\u0010\u0010 \u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\fH\u0016J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\fH\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R#\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R#\u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R$\u0010\n\u001a\u0015\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000b\u00a2\u0006\u0002\b\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\"\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\b\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001a\u00a8\u0006\""}, d2={"Ltheorycrafter/ui/widgets/DiscreteRangeSpinnerModel;", "T", "", "Ltheorycrafter/ui/widgets/SpinnerModel;", "range", "Lkotlin/ranges/ClosedRange;", "step", "add", "Lkotlin/Function2;", "subtract", "parseValue", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "displayValue", "<init>", "(Lkotlin/ranges/ClosedRange;Ljava/lang/Comparable;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getRange", "()Lkotlin/ranges/ClosedRange;", "getStep", "()Ljava/lang/Comparable;", "Ljava/lang/Comparable;", "getAdd", "()Lkotlin/jvm/functions/Function2;", "getSubtract", "getParseValue", "()Lkotlin/jvm/functions/Function1;", "getDisplayValue", "hasUpValue", "", "value", "hasDownValue", "upValue", "downValue", "DesktopApp"})
@StabilityInferred(parameters=2)
public final class DiscreteRangeSpinnerModel<T extends Comparable<? super T>>
implements SpinnerModel {
    @NotNull
    private final ClosedRange<T> range;
    @NotNull
    private final T step;
    @NotNull
    private final Function2<T, T, T> add;
    @NotNull
    private final Function2<T, T, T> subtract;
    @NotNull
    private final Function1<String, T> parseValue;
    @NotNull
    private final Function1<T, String> displayValue;
    public static final int $stable;

    public DiscreteRangeSpinnerModel(@NotNull ClosedRange<T> range, @NotNull T step, @NotNull Function2<? super T, ? super T, ? extends T> add2, @NotNull Function2<? super T, ? super T, ? extends T> subtract, @NotNull Function1<? super String, ? extends T> parseValue, @NotNull Function1<? super T, String> displayValue) {
        Intrinsics.checkNotNullParameter(range, (String)"range");
        Intrinsics.checkNotNullParameter(step, (String)"step");
        Intrinsics.checkNotNullParameter(add2, (String)"add");
        Intrinsics.checkNotNullParameter(subtract, (String)"subtract");
        Intrinsics.checkNotNullParameter(parseValue, (String)"parseValue");
        Intrinsics.checkNotNullParameter(displayValue, (String)"displayValue");
        this.range = range;
        this.step = step;
        this.add = add2;
        this.subtract = subtract;
        this.parseValue = parseValue;
        this.displayValue = displayValue;
    }

    @NotNull
    public final ClosedRange<T> getRange() {
        return this.range;
    }

    @NotNull
    public final T getStep() {
        return this.step;
    }

    @NotNull
    public final Function2<T, T, T> getAdd() {
        return this.add;
    }

    @NotNull
    public final Function2<T, T, T> getSubtract() {
        return this.subtract;
    }

    @NotNull
    public final Function1<String, T> getParseValue() {
        return this.parseValue;
    }

    @NotNull
    public final Function1<T, String> getDisplayValue() {
        return this.displayValue;
    }

    @Override
    public boolean hasUpValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Comparable comparable = (Comparable)this.parseValue.invoke((Object)value);
        if (comparable == null) {
            return false;
        }
        Comparable number = comparable;
        return number.compareTo(this.range.getEndInclusive()) < 0;
    }

    @Override
    public boolean hasDownValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Comparable comparable = (Comparable)this.parseValue.invoke((Object)value);
        if (comparable == null) {
            return false;
        }
        Comparable number = comparable;
        return number.compareTo(this.range.getStart()) > 0;
    }

    @Override
    @NotNull
    public String upValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Comparable comparable = (Comparable)this.parseValue.invoke((Object)value);
        if (comparable == null) {
            return value;
        }
        Comparable number = comparable;
        return (String)this.displayValue.invoke((Object)RangesKt.coerceIn((Comparable)((Comparable)this.add.invoke((Object)number, this.step)), this.range));
    }

    @Override
    @NotNull
    public String downValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Comparable comparable = (Comparable)this.parseValue.invoke((Object)value);
        if (comparable == null) {
            return value;
        }
        Comparable number = comparable;
        return (String)this.displayValue.invoke((Object)RangesKt.coerceIn((Comparable)((Comparable)this.subtract.invoke((Object)number, this.step)), this.range));
    }
}

