/**
 * Methods for identifying implants.
 */

package eve.data.typeid

import eve.data.EveData
import eve.data.ImplantType


/**
 * Returns whether the given implant is a mindlink.
 */
context(EveData)
fun ImplantType.isMindlinkImplant() = group == groups.mindlinks


/**
 * Returns whether the given implant is a "Repair Systems" implant.
 */
context(EveData)
fun ImplantType.isRepairSystemsImplant() = variationParentTypeId == 3291


/**
 * Returns whether the given implant is a "Numon Family Heirloom" implant.
 */
context(EveData)
fun ImplantType.isNumonFamilyHeirloomImplant() = itemId == 20358


/**
 * Returns whether the given implant is a "Remote Armor Repair Systems" implant.
 */
context(EveData)
fun ImplantType.isRemoteArmorRepairSystemsImplant() = variationParentTypeId == 3414


/**
 * Returns whether the given implant is a "Mechanic" implant.
 */
context(EveData)
fun ImplantType.isMechanicImplant() = variationParentTypeId == 3471


/**
 * Returns whether the given implant is a "Repair Proficiency" implant.
 */
context(EveData)
fun ImplantType.isRepairProficiencyImplant() = variationParentTypeId == 3476


/**
 * Returns whether the given implant is a "Hull Upgrades" implant.
 */
context(EveData)
fun ImplantType.isHullUpgradesImplant() = variationParentTypeId == 3479


/**
 * Returns whether the given implant is an "Imperial Navy Modified 'Noble' Implant" implant.
 */
context(EveData)
fun ImplantType.isImperialNavyNobleImplant() = itemId == 32254


/**
 * Returns whether the given implant is a "Drone Navigation" implant.
 */
context(EveData)
fun ImplantType.isDroneNavigationImplant() = variationParentTypeId == 54534


/**
 * Returns whether the given implant is the "Overmind 'Goliath' Drone Tuner T25-10S" implant.
 */
context(EveData)
fun ImplantType.isGoliathDroneTunerImplant() = itemId == 48746


/**
 * Returns whether the given implant is the "Overmind 'Hawkmoth' Drone Tuner S10-25T" implant.
 */
context(EveData)
fun ImplantType.isHawkmothDroneTunerImplant() = itemId == 48747


/**
 * Returns whether the given implant is the "Creodron 'Bumblebee' Drone Tuner T10-5D" implant.
 */
context(EveData)
fun ImplantType.isBumblebeeDroneTunerImplant() = itemId == 48149


/**
 * Returns whether the given implant is the "Creodron 'Yellowjacket' Drone Tuner D5-10T" implant.
 */
context(EveData)
fun ImplantType.isYellowjacketDroneTunerImplant() = itemId == 48148


/**
 * Returns whether the given implant is a "Drone Sharpshooting" implant.
 */
context(EveData)
fun ImplantType.isDroneSharpshootingImplant() = variationParentTypeId == 54537


/**
 * Returns whether the given implant is a "Repair Drone Operation" implant.
 */
context(EveData)
fun ImplantType.isRepairDroneOperationImplant() = variationParentTypeId == 54540


/**
 * Returns whether the given implant is a "Drone Durability" implant.
 */
context(EveData)
fun ImplantType.isDroneDurabilityImplant() = variationParentTypeId == 54543


/**
 * Returns whether the given implant is a "Stasis Webifier" implant.
 */
context(EveData)
fun ImplantType.isStasisWebifierImplant() = variationParentTypeId == 47261


/**
 * Returns whether the given implant is an "Entanglement Optimizer" implant.
 */
context(EveData)
fun ImplantType.isEntanglementOptimizerImplant() = variationParentTypeId == 50053


/**
 * Returns whether the given implant is a "Propulsion Jamming" implant.
 */
context(EveData)
fun ImplantType.isPropulsionJammingImplant() = variationParentTypeId == 3277


/**
 * Returns whether the given implant is an "Electronic Warfare" implant.
 */
context(EveData)
fun ImplantType.isElectronicWarfareImplant() = variationParentTypeId == 3271


/**
 * Returns whether the given implant is a "Sensor Linking" implant.
 */
context(EveData)
fun ImplantType.isSensorLinkingImplant() = variationParentTypeId == 3280


/**
 * Returns whether the given implant is a "Target Painting" implant.
 */
context(EveData)
fun ImplantType.isTargetPaintingImplant() = variationParentTypeId == 3288


/**
 * Returns whether the given implant is a "Weapon Disruption" implant.
 */
context(EveData)
fun ImplantType.isWeaponDisruptionImplant() = variationParentTypeId == 3283


/**
 * Returns whether the given implant is a "Capacitor Systems Operation" implant.
 */
context(EveData)
fun ImplantType.isCapacitorSystemsOperationImplant() = variationParentTypeId == 3240


/**
 * Returns whether the given implant is a "Power Grid Management" implant.
 */
context(EveData)
fun ImplantType.isPowerGridManagementImplant() = variationParentTypeId == 3256


/**
 * Returns whether the given implant is a "CPU Management" implant.
 */
context(EveData)
fun ImplantType.isCpuManagementImplant() = variationParentTypeId == 3265


/**
 * Returns whether the given implant is an "Electronics Upgrades" implant.
 */
context(EveData)
fun ImplantType.isElectronicsUpgradesImplant() = variationParentTypeId == 3262


/**
 * Returns whether the given implant is a "Capacitor Emission Systems" implant.
 */
context(EveData)
fun ImplantType.isCapacitorEmissionSystemsImplant() = variationParentTypeId == 3247


/**
 * Returns whether the given implant is an "Energy Grid Upgrades" implant.
 */
context(EveData)
fun ImplantType.isEnergyGridUpgradesImplant() = variationParentTypeId == 3253


/**
 * Returns whether the given implant is an "Energy Pulse Weapons" implant.
 */
context(EveData)
fun ImplantType.isEnergyPulseWeaponsImplant() = variationParentTypeId == 3250


/**
 * Returns whether the given implant is a "Capacitor Management" implant.
 */
context(EveData)
fun ImplantType.isCapacitorManagementImplant() = variationParentTypeId == 3237


/**
 * Returns whether the given implant is a "Small Projectile Turret" implant.
 */
context(EveData)
fun ImplantType.isSmallProjectileTurretImplant() = variationParentTypeId == 3199


/**
 * Returns whether the given implant is a "Small Energy Turret" implant.
 */
context(EveData)
fun ImplantType.isSmallEnergyTurretImplant() = variationParentTypeId == 3202


/**
 * Returns whether the given implant is a "Small Hybrid Turret" implant.
 */
context(EveData)
fun ImplantType.isSmallHybridTurretImplant() = variationParentTypeId == 3225


/**
 * Returns whether the given implant is a "Motion Prediction" implant.
 */
context(EveData)
fun ImplantType.isMotionPredictionTurretImplant() = variationParentTypeId == 3190


/**
 * Returns whether the given implant is an "Ogdin's Eye Coordination Enhancer" implant.
 */
context(EveData)
fun ImplantType.isOgdinsEyeCoordinationEnhancerImplant() = itemId == 20443


/**
 * Returns whether the given implant is a "Controlled Bursts" implant.
 */
context(EveData)
fun ImplantType.isControlledBurstsImplant() = variationParentTypeId == 3203


/**
 * Returns whether the given implant is a "Trajectory Analysis" implant.
 */
context(EveData)
fun ImplantType.isTrajectoryAnalysisImplant() = variationParentTypeId == 3220


/**
 * Returns whether the given implant is a "Medium Projectile Turret" implant.
 */
context(EveData)
fun ImplantType.isMediumProjectileTurretImplant() = variationParentTypeId == 3185


/**
 * Returns whether the given implant is a "Medium Energy Turret" implant.
 */
context(EveData)
fun ImplantType.isMediumEnergyTurretImplant() = variationParentTypeId == 3206


/**
 * Returns whether the given implant is a "Medium Hybrid Turret" implant.
 */
context(EveData)
fun ImplantType.isMediumHybridTurretImplant() = variationParentTypeId == 3231


/**
 * Returns whether the given implant is a "Surgical Strike" implant.
 */
context(EveData)
fun ImplantType.isSurgicalStrikeImplant() = variationParentTypeId == 3193


/**
 * Returns whether the given implant is a "Gunnery" implant.
 */
context(EveData)
fun ImplantType.isGunneryImplant() = variationParentTypeId == 3204


/**
 * Returns whether the given implant is a "Pashan's Turret Customization Mindlink" implant.
 */
context(EveData)
fun ImplantType.isPashansTurretCustomizationMindlinkImplant() = itemId == 25868


/**
 * Returns whether the given implant is a "Turret Sharpshooter" implant.
 */
context(EveData)
fun ImplantType.isTurretSharpshooterImplant() = variationParentTypeId == 3217


/**
 * Returns whether the given implant is a "Large Projectile Turret" implant.
 */
context(EveData)
fun ImplantType.isLargeProjectileTurretImplant() = variationParentTypeId == 3196


/**
 * Returns whether the given implant is a "Large Energy Turret" implant.
 */
context(EveData)
fun ImplantType.isLargeEnergyTurretImplant() = variationParentTypeId == 3205


/**
 * Returns whether the given implant is a "Pashan's Turret Handling Mindlink" implant.
 */
context(EveData)
fun ImplantType.isPashansTurretHandlingMindlinkImplant() = itemId == 25867


/**
 * Returns whether the given implant is a "Large Hybrid Turret" implant.
 */
context(EveData)
fun ImplantType.isLargeHybridTurretImplant() = variationParentTypeId == 3222


/**
 * Returns whether the given implant is a "Weapon Upgrades" implant.
 */
context(EveData)
fun ImplantType.isWeaponUpgradesImplant() = variationParentTypeId == 3228


/**
 * Returns whether the given implant is a "Xl Torpedo Sharpshooter" implant.
 */
context(EveData)
fun ImplantType.isXlTorpedoSharpshooterImplant() = variationParentTypeId == 3149


/**
 * Returns whether the given implant is a "Launcher CPU Efficiency" implant.
 */
context(EveData)
fun ImplantType.isLauncherCpuEfficiencyImplant() = variationParentTypeId == 3144


/**
 * Returns whether the given implant is a "Cruise Missiles" implant.
 */
context(EveData)
fun ImplantType.isCruiseMissilesImplant() = variationParentTypeId == 3181


/**
 * Returns whether the given implant is a "Torpedoes" implant.
 */
context(EveData)
fun ImplantType.isTorpedoesImplant() = variationParentTypeId == 3176


/**
 * Returns whether the given implant is a "Missile Bombardment" implant.
 */
context(EveData)
fun ImplantType.isMissileBombardmentImplant() = variationParentTypeId == 3128


/**
 * Returns whether the given implant is a "Missile Projection" implant.
 */
context(EveData)
fun ImplantType.isMissileProjectionImplant() = variationParentTypeId == 3133


/**
 * Returns whether the given implant is a "Heavy Assault Missiles" implant.
 */
context(EveData)
fun ImplantType.isHeavyAssaultMissilesImplant() = variationParentTypeId == 3157


/**
 * Returns whether the given implant is a "Heavy Missiles" implant.
 */
context(EveData)
fun ImplantType.isHeavyMissilesImplant() = variationParentTypeId == 3165


/**
 * Returns whether the given implant is a "Guided Missile Precision" implant.
 */
context(EveData)
fun ImplantType.isGuidedMissilePrecisionImplant() = variationParentTypeId == 3125


/**
 * Returns whether the given implant is a "Defender Missiles" implant.
 */
context(EveData)
fun ImplantType.isDefenderMissilesImplant() = variationParentTypeId == 3152


/**
 * Returns whether the given implant is a "Target Navigation Prediction" implant.
 */
context(EveData)
fun ImplantType.isTargetNavigationPredictionImplant() = variationParentTypeId == 3141


/**
 * Returns whether the given implant is a "Light Missiles" implant.
 */
context(EveData)
fun ImplantType.isLightMissilesImplant() = variationParentTypeId == 3168


/**
 * Returns whether the given implant is a "Rockets" implant.
 */
context(EveData)
fun ImplantType.isRocketsImplant() = variationParentTypeId == 3173


/**
 * Returns whether the given implant is the "Whelan Machorin's Ballistic Smartlink" implant.
 */
context(EveData)
fun ImplantType.isWhelanMachorinsBallisticSmartlinkImplant() = itemId == 20371


/**
 * Returns whether the given implant is a "Rapid Launch" implant.
 */
context(EveData)
fun ImplantType.isRapidLaunchImplant() = variationParentTypeId == 3136


/**
 * Returns whether the given implant is an "Auto Targeting Explosion Radius" implant.
 */
context(EveData)
fun ImplantType.isAutoTargetingExplosionRadiusImplant() = variationParentTypeId == 3160


/**
 * Returns whether the given implant is an "Acceleration Control" implant.
 */
context(EveData)
fun ImplantType.isAccelerationControlImplant() = variationParentTypeId == 3120


/**
 * Returns whether the given implant is the "Zor's Custom Navigation Hyper-Link" implant.
 */
context(EveData)
fun ImplantType.isZorsCustomNavigationHyperLinkImplant() = itemId == 24663


/**
 * Returns whether the given implant is an "Afterburner" implant.
 */
context(EveData)
fun ImplantType.isAfterburnerImplant() = variationParentTypeId == 3104


/**
 * Returns whether the given implant is the "Zor's Custom Navigation Link" implant.
 */
context(EveData)
fun ImplantType.isZorsCustomNavigationLinkImplant() = itemId == 19500


/**
 * Returns whether the given implant is a "Navigation" implant.
 */
context(EveData)
fun ImplantType.isNavigationImplant() = variationParentTypeId == 3096


/**
 * Returns whether the given implant is the "Shaqil's Speed Enhancer" implant.
 */
context(EveData)
fun ImplantType.isShaqilsSpeedEnhancerImplant() = itemId == 24669


/**
 * Returns whether the given implant is a "Warp Drive Operation" implant.
 */
context(EveData)
fun ImplantType.isWarpDriveOperationImplant() = variationParentTypeId == 3109


/**
 * Returns whether the given implant is a "Warp Drive Speed" implant.
 */
context(EveData)
fun ImplantType.isWarpDriveSpeedImplant() = variationParentTypeId == 3117


/**
 * Returns whether the given implant is an "Evasive Maneuvering" implant.
 */
context(EveData)
fun ImplantType.isEvasiveManeuveringImplant() = variationParentTypeId == 3093


/**
 * Returns whether the given implant is a "Fuel Conservation" implant.
 */
context(EveData)
fun ImplantType.isFuelConservationImplant() = variationParentTypeId == 3101


/**
 * Returns whether the given implant is a "High Speed Maneuvering" implant.
 */
context(EveData)
fun ImplantType.isHighSpeedManeuveringImplant() = variationParentTypeId == 3112


/**
 * Returns whether the given implant is an "Astrometric Pinpointing" implant.
 */
context(EveData)
fun ImplantType.isAstrometricPinpointingImplant() = variationParentTypeId == 27186


/**
 * Returns whether the given implant is an "Astrometric Acquisition" implant.
 */
context(EveData)
fun ImplantType.isAstrometricAcquisitionImplant() = variationParentTypeId == 27187


/**
 * Returns whether the given implant is an "Astrometric Rangefinding" implant.
 */
context(EveData)
fun ImplantType.isAstrometricRangefindingImplant() = variationParentTypeId == 27188


/**
 * Returns whether the given implant is a "Net Intrusion" implant.
 */
context(EveData)
fun ImplantType.isNetIntrusionImplant() = variationParentTypeId == 47028


/**
 * Returns whether the given implant is an "Archaeology" implant.
 */
context(EveData)
fun ImplantType.isArchaeologyImplant() = variationParentTypeId == 27196


/**
 * Returns whether the given implant is a "Hacking" implant.
 */
context(EveData)
fun ImplantType.isHackingImplant() = variationParentTypeId == 27197


/**
 * Returns whether the given implant is a "Salvaging" implant.
 */
context(EveData)
fun ImplantType.isSalvagingImplant() = variationParentTypeId == 27198


/**
 * Returns whether the given implant is an "Environmental Analysis" implant.
 */
context(EveData)
fun ImplantType.isEnvironmentalAnalysisImplant() = variationParentTypeId == 27260


/**
 * Returns whether the given implant is a "Shield Upgrades" implant.
 */
context(EveData)
fun ImplantType.isShieldUpgradesImplant() = variationParentTypeId == 3077


/**
 * Returns whether the given implant is a "Sansha Modified Gnome" implant.
 */
context(EveData)
fun ImplantType.isSanshaModifiedGnomeImplant() = variationParentTypeId == 32255


/**
 * Returns whether the given implant is a "Shield Management" implant.
 */
context(EveData)
fun ImplantType.isShieldManagementImplant() = variationParentTypeId == 3080


/**
 * Returns whether the given implant is a "Shield Emission Systems" implant.
 */
context(EveData)
fun ImplantType.isShieldEmissionSystemsImplant() = variationParentTypeId == 3085


/**
 * Returns whether the given implant is a "Shield Operation" implant.
 */
context(EveData)
fun ImplantType.isShieldOperationImplant() = variationParentTypeId == 3088


/**
 * Returns whether the given implant is a "Signature Analysis" implant.
 */
context(EveData)
fun ImplantType.isSignatureAnalysisImplant() = variationParentTypeId == 3268


/**
 * Returns whether the given implant is a "Long Range Targeting" implant.
 */
context(EveData)
fun ImplantType.isLongRangeTargetingImplant() = variationParentTypeId == 3274
