/**
 * The UI showing a fit's mobility stats.
 */

package theorycrafter.ui.fitstats

import androidx.compose.runtime.Composable
import eve.data.asAlignTime
import eve.data.asSpeed
import eve.data.asWarpSpeed
import theorycrafter.fitting.Fit
import theorycrafter.ui.fiteditor.ValueWithDescription


/**
 * UI showing the mobility stats (speed etc.)
 */
@Composable
fun MobilityStats(fit: Fit) = with(fit.propulsion){
    val maxVelocity = maxVelocity

    StatsTable(
        columns = 3,
        Stat(
            label = "Maximum Velocity",
            value = maxVelocity.asSpeed(withUnits = true),
            tooltipValues = listOf(
                ValueWithDescription(
                    value = maxVelocity.asSpeed(withUnits = true, kmsThreshold = Int.MAX_VALUE),
                    description = "maximum velocity"
                )
            )
        ),
        Stat(
            label = "Align Time",
            value = alignTime.asAlignTime(withUnits = true, units = "s")
        ),
        Stat(
            label = "Warp Speed",
            value = warpSpeed.asWarpSpeed(withUnits = true),
        )
    )
}
