package theorycrafter.ui.settings

import androidx.compose.foundation.layout.*
import androidx.compose.material.ProvideTextStyle
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import theorycrafter.AnalyticsConsent
import theorycrafter.CollectedInformationDescription
import theorycrafter.Theorycrafter
import theorycrafter.TheorycrafterContext
import theorycrafter.ui.TheorycrafterTheme
import theorycrafter.ui.widgets.RadioButtonWithText

/**
 * The settings pane for configuring tracking consent.
 */
@Composable
fun AnalyticsConsentSettingsPane() {
    Column(
        verticalArrangement = Arrangement.spacedBy(TheorycrafterTheme.spacing.medium),
        modifier = Modifier.padding(TheorycrafterTheme.spacing.edgeMargins)
    ) {
        Text(
            text = "Allow analytics tracking of your use of ${Theorycrafter.AppName}?",
            style = TheorycrafterTheme.textStyles.mediumHeading
        )

        var consent by TheorycrafterContext.settings.analytics::consent
        Column(Modifier.width(IntrinsicSize.Max)) {
            RadioButtonWithText(
                text = "Consent",
                selected = consent == AnalyticsConsent.Yes,
                onClick = { consent = AnalyticsConsent.Yes },
                modifier = Modifier.fillMaxWidth()
            )

            RadioButtonWithText(
                text = "Decline",
                selected = consent == AnalyticsConsent.No,
                onClick = { consent = AnalyticsConsent.No },
                modifier = Modifier.fillMaxWidth()
            )
        }

        ProvideTextStyle(TheorycrafterTheme.textStyles.detailedText()) {
            when (consent) {
                AnalyticsConsent.Yes -> CollectedInformationDescription()
                AnalyticsConsent.No -> Text("No information, other than your declining, is collected.")
                AnalyticsConsent.Undecided -> {
                    Text("If you consent, anonymous usage data will be collected to help improve ${Theorycrafter.AppName}.")
                    CollectedInformationDescription()
                }

            }
        }
    }
}