package theorycrafter.ui.fiteditor

import androidx.compose.ui.test.hasTestTag
import eve.data.ModuleSlotType
import eve.data.SubsystemType
import theorycrafter.TestTags


/**
 * Matchers for various nodes in the fit editor window.
 */
@Suppress("unused")
object Nodes {


    /**
     * The matchers for the fit editor.
     */
    object FitEditor {


        /**
         * The matcher for the key events receiver of the fit editor.
         */
        val KeyEventsReceiver = hasTestTag(TestTags.FitEditor.KeyEventsReceiver)


        /**
        * The matcher for the tactical mode slot.
         */
        val TacticalModeSlot = hasTestTag(TestTags.FitEditor.TacticalModeSlot)


        /**
         * The matcher for the subsystem row of the given kind.
         */
        fun subsystemRow(subsystemKind: SubsystemType.Kind) =
            hasTestTag(TestTags.FitEditor.subsystemRow(subsystemKind))


        /**
         * The matcher for the module row of the given slot type, at the given index inside its section.
         */
        fun moduleRow(slotType: ModuleSlotType, index: Int) =
            hasTestTag(TestTags.FitEditor.moduleRow(slotType, index))


        /**
         * The matcher for the charge row of the module of the given slot type, at the given index inside its section.
         */
        fun chargeRow(slotType: ModuleSlotType, index: Int) =
            hasTestTag(TestTags.FitEditor.chargeRow(slotType, index))


        /**
         * The matcher for the drone row at the given index inside its section.
         */
        fun droneRow(index: Int) = hasTestTag(TestTags.FitEditor.droneRow(index))


        /**
         * The matcher for the empty drone row.
         */
        val EmptyDroneRow = hasTestTag(TestTags.FitEditor.EmptyDroneRow)


        /**
         * The matcher for the cargohold row at the given index inside its section.
         */
        fun cargoholdRow(index: Int) = hasTestTag(TestTags.FitEditor.cargoholdRow(index))


        /**
         * The matcher for the empty cargohold row.
         */
        val EmptyCargoholdRow = hasTestTag(TestTags.FitEditor.EmptyCargoholdRow)


        /**
         * The matcher for the implant row at the given index inside its section.
         */
        fun implantRow(index: Int) = hasTestTag(TestTags.FitEditor.implantRow(index))


        /**
         * The matcher for the empty implant row.
         */
        val EmptyImplantRow = hasTestTag(TestTags.FitEditor.EmptyImplantRow)


        /**
         * The matcher for the booster row at the given index inside its section.
         */
        fun boosterRow(index: Int) = hasTestTag(TestTags.FitEditor.boosterRow(index))


        /**
         * The matcher for the empty booster row.
         */
        val EmptyBoosterRow = hasTestTag(TestTags.FitEditor.EmptyBoosterRow)


        /**
         * The matcher for the command effect row at the given index inside its section.
         */
        fun commandEffectRow(index: Int) = hasTestTag(TestTags.FitEditor.commandEffectRow(index))


        /**
         * The matcher for the empty command effect row.
         */
        val EmptyCommandEffectRow = hasTestTag(TestTags.FitEditor.EmptyCommandEffectRow)


        /**
         * The matcher for the hostile module effect row at the given index inside its section.
         */
        fun hostileModuleEffectRow(index: Int) = hasTestTag(TestTags.FitEditor.hostileModuleEffectRow(index))


        /**
         * The matcher for the empty hostile effect row.
         */
        val EmptyHostileEffectRow = hasTestTag(TestTags.FitEditor.EmptyHostileEffectRow)


        /**
         * The matcher for the friendly module effect row at the given index inside its section.
         */
        fun friendlyModuleEffectRow(index: Int) = hasTestTag(TestTags.FitEditor.friendlyModuleEffectRow(index))


        /**
         * The matcher for the empty friendly effect row.
         */
        val EmptyFriedlyEffectRow = hasTestTag(TestTags.FitEditor.EmptyFriendlyEffectRow)


    }


    /**
     * The matchers for the fit list.
     */
    object FitList {


        /**
         * The fit list itself.
         */
        val FitList = hasTestTag(TestTags.FitList.FitList)


        /**
         * The matcher for the search field.
         */
        val SearchField = hasTestTag(TestTags.FitList.SearchField)


        /**
         * The matchers for nodes inside a fit list item.
         */
        object Item {


            /**
             * The item itself.
             */
            val Item = hasTestTag(TestTags.FitList.Item.Item)



        }
    }


}