package compose.widgets

import androidx.compose.animation.AnimatedVisibility
import androidx.compose.foundation.ExperimentalFoundationApi
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.onClick
import androidx.compose.runtime.*
import androidx.compose.ui.Modifier


/**
 * A label that reveals/hides content below it.
 */
@OptIn(ExperimentalFoundationApi::class)
@Composable
fun Disclosure(
    modifier: Modifier = Modifier,
    label: @Composable (expanded: Boolean) -> Unit,
    content: @Composable () -> Unit
) {
    var expanded by remember { mutableStateOf(false) }
    Column(modifier = modifier) {
        Box(Modifier.onClick { expanded = !expanded }) {
            label(expanded)
        }
        AnimatedVisibility(visible = expanded) {
            content()
        }
    }
}