package theorycrafter.ui.fitstats

import androidx.compose.foundation.layout.Row
import androidx.compose.runtime.Composable
import eve.data.asHitPoints
import eve.data.asHitpointsPerSecond
import theorycrafter.fitting.Fit
import theorycrafter.ui.fiteditor.ValueWithDescription


/**
 * The remote repairs stats panel.
 */
@Composable
fun RemoteRepairStats(fit: Fit) {

    @Composable
    fun repairStat(title: String, hpPerSecond: Double) =
        Stat(
            label = title,
            value = hpPerSecond.asHitpointsPerSecond(withUnits = true),
            tooltipValues = buildList {
                add(ValueWithDescription(hpPerSecond.asHitPoints(withUnits = false), "hitpoints per second"))
            }
        )

    Row {
        with(fit.remoteRepairs) {
            val fromModules = with(modules) {
                shieldHpBoostedPerSecond + armorHpRepairedPerSecond + structureHpRepairedPerSecond
            }
            val fromDrones = with(drones) {
                shieldHpBoostedPerSecond + armorHpRepairedPerSecond + structureHpRepairedPerSecond
            }

            StatsTable(
                columns = 3,
                repairStat(title = "Modules", hpPerSecond = fromModules),
                repairStat(title = "Drones", hpPerSecond = fromDrones),
                repairStat(title = "Combined", hpPerSecond = fromModules + fromDrones),
            )
        }
    }
}
