package compose.widgets

import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.material.*
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.TextStyle


/**
 * The contents of a text button.
 */
@Composable
private fun TextButtonContent(
    text: String,
    style: TextStyle = LocalTextStyle.current
){
    SingleLineText(
        text = text,
        style = style,
    )
}


/**
 * A button with an elevation, filled with color, displaying text.
 */
@Composable
fun RaisedButtonWithText(
    text: String,
    style: TextStyle = LocalTextStyle.current,
    contentPadding: PaddingValues = ButtonDefaults.ContentPadding,
    modifier: Modifier = Modifier,
    enabled: Boolean = true,
    colors: ButtonColors = ButtonDefaults.buttonColors(),
    onClick: () -> Unit
) {
    Button(
        modifier = modifier,
        contentPadding = contentPadding,
        enabled = enabled,
        onClick = onClick,
        colors = colors,
    ){
        TextButtonContent(text, style)
    }
}


/**
 * A button with an outline, displaying text.
 */
@Composable
fun OutlinedButtonWithText(
    text: String,
    style: TextStyle = LocalTextStyle.current,
    contentPadding: PaddingValues = ButtonDefaults.ContentPadding,
    modifier: Modifier = Modifier,
    enabled: Boolean = true,
    colors: ButtonColors = ButtonDefaults.outlinedButtonColors(),
    onClick: () -> Unit
) {
    OutlinedButton(
        modifier = modifier,
        contentPadding = contentPadding,
        enabled = enabled,
        onClick = onClick,
        colors = colors,
    ){
        TextButtonContent(text, style)
    }
}


/**
 * A flat button, displaying text.
 */
@Composable
fun FlatButtonWithText(
    text: String,
    style: TextStyle = LocalTextStyle.current,
    contentPadding: PaddingValues = ButtonDefaults.TextButtonContentPadding,
    modifier: Modifier = Modifier,
    enabled: Boolean = true,
    colors: ButtonColors = ButtonDefaults.textButtonColors(),
    onClick: () -> Unit
) {
    TextButton(
        modifier = modifier,
        contentPadding = contentPadding,
        enabled = enabled,
        onClick = onClick,
        colors = colors,
    ){
        TextButtonContent(text, style)
    }
}
