package theorycrafter.fitting

import androidx.compose.runtime.Stable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableIntStateOf
import androidx.compose.runtime.setValue
import eve.data.Attributes
import eve.data.EveItemType


/**
 * A group of items (of the same type) in a ship's cargohold.
 */
@Stable
class CargoItem internal constructor(


    /**
     * The fit this cargo item is part of.
     */
    override val fit: Fit,


    /**
     * The context [Attributes].
     */
    attributes: Attributes,


    /**
     * The type of the items.
     */
    type: EveItemType,


    /**
     * The number of items in the group.
     */
    amount: Int


) : EveItem<EveItemType>(attributes, type), FitItem {


    /**
     * The number of items in the group.
     */
    var amount: Int by mutableIntStateOf(amount)
        internal set


    /**
     * The total volume of this item.
     */
    val volume: Double
        get() = amount * type.volume


    override fun toString(): String {
        return "$amount x ${super.toString()}"
    }


}