package theorycrafter.tournaments.impl

import eve.data.EveData
import eve.data.NNBSP
import theorycrafter.generated.resources.Res
import theorycrafter.generated.resources.atxxi
import theorycrafter.tournaments.TournamentDescriptor
import theorycrafter.tournaments.TournamentRules


/**
 * The descriptor for Alliance Tournament XXI (2025).
 */
val AllianceTournamentXXI = TournamentDescriptor(
    id = "atxxi",
    name = "Alliance Tournament XXI",
    shortName = "AT${NNBSP}XXI",
    icon = Res.drawable.atxxi,
    rulesFactory = ::allianceTournamentXXIRules,
    winner = "The Tuskers Co."
)


/**
 * Maps ship type names to their point values.
 */
private val ShipCostByName = mapOf(
    "Impairor" to 1,
    "Ibis" to 1,
    "Velator" to 1,
    "Reaper" to 1,
    "Executioner" to 4,
    "Tormentor" to 4,
    "Punisher" to 6,
    "Magnate" to 4,
    "Condor" to 4,
    "Kestrel" to 4,
    "Merlin" to 4,
    "Heron" to 4,
    "Atron" to 4,
    "Tristan" to 4,
    "Incursus" to 4,
    "Imicus" to 4,
    "Slasher" to 4,
    "Breacher" to 4,
    "Rifter" to 4,
    "Probe" to 4,
    "Inquisitor" to 3,
    "Bantam" to 3,
    "Navitas" to 3,
    "Burst" to 3,
    "Crucifier" to 8,
    "Griffin" to 7,
    "Maulus" to 7,
    "Vigil" to 6,
    "Imperial Navy Slicer" to 6,
    "Crucifier Navy Issue" to 6,
    "Caldari Navy Hookbill" to 5,
    "Griffin Navy Issue" to 5,
    "Federation Navy Comet" to 6,
    "Maulus Navy Issue" to 6,
    "Republic Fleet Firetail" to 6,
    "Vigil Fleet Issue" to 6,
    "Vengeance" to 9,
    "Retribution" to 9,
    "Hawk" to 9,
    "Harpy" to 9,
    "Ishkur" to 9,
    "Enyo" to 9,
    "Wolf" to 9,
    "Jaguar" to 9,
    "Anathema" to 4,
    "Buzzard" to 4,
    "Helios" to 4,
    "Cheetah" to 4,
    "Purifier" to 7,
    "Manticore" to 7,
    "Nemesis" to 7,
    "Hound" to 7,
    "Sentinel" to 11,
    "Kitsune" to 10,
    "Keres" to 12,
    "Hyena" to 11,
    "Crusader" to 6,
    "Malediction" to 6,
    "Crow" to 6,
    "Raptor" to 6,
    "Taranis" to 6,
    "Ares" to 6,
    "Claw" to 6,
    "Stiletto" to 6,
    "Deacon" to 10,
    "Kirin" to 10,
    "Thalia" to 10,
    "Scalpel" to 10,
    "Coercer" to 5,
    "Dragoon" to 5,
    "Cormorant" to 5,
    "Corax" to 5,
    "Catalyst" to 5,
    "Algos" to 5,
    "Thrasher" to 5,
    "Talwar" to 5,
    "Pontifex" to 12,
    "Stork" to 12,
    "Magus" to 12,
    "Bifrost" to 12,
    "Heretic" to 9,
    "Flycatcher" to 9,
    "Eris" to 9,
    "Sabre" to 9,
    "Confessor" to 10,
    "Jackdaw" to 9,
    "Hecate" to 10,
    "Svipul" to 10,
    "Arbitrator" to 12,
    "Blackbird" to 13,
    "Celestis" to 13,
    "Bellicose" to 10,
    "Augoror" to 19,
    "Osprey" to 19,
    "Exequror" to 19,
    "Scythe" to 19,
    "Maller" to 10,
    "Omen" to 9,
    "Moa" to 9,
    "Caracal" to 8,
    "Vexor" to 9,
    "Thorax" to 9,
    "Stabber" to 9,
    "Rupture" to 9,
    "Augoror Navy Issue" to 17,
    "Omen Navy Issue" to 16,
    "Caracal Navy Issue" to 14,
    "Osprey Navy Issue" to 14,
    "Exequror Navy Issue" to 16,
    "Vexor Navy Issue" to 16,
    "Scythe Fleet Issue" to 16,
    "Stabber Fleet Issue" to 16,
    "Zealot" to 22,
    "Sacrilege" to 23,
    "Eagle" to 16,
    "Cerberus" to 21,
    "Ishtar" to 22,
    "Deimos" to 21,
    "Vagabond" to 23,
    "Muninn" to 22,
    "Devoter" to 24,
    "Onyx" to 24,
    "Phobos" to 24,
    "Broadsword" to 24,
    "Guardian" to 32,
    "Basilisk" to 32,
    "Oneiros" to 32,
    "Scimitar" to 32,
    "Curse" to 30,
    "Pilgrim" to 25,
    "Falcon" to 28,
    "Rook" to 28,
    "Arazu" to 28,
    "Lachesis" to 28,
    "Huginn" to 25,
    "Rapier" to 25,
    "Legion" to 30,
    "Tengu" to 30,
    "Proteus" to 30,
    "Loki" to 30,
    "Oracle" to 21,
    "Naga" to 20,
    "Talos" to 21,
    "Tornado" to 21,
    "Prophecy" to 27,
    "Harbinger" to 27,
    "Drake" to 27,
    "Ferox" to 27,
    "Brutix" to 27,
    "Myrmidon" to 27,
    "Hurricane" to 27,
    "Cyclone" to 27,
    "Harbinger Navy Issue" to 30,
    "Drake Navy Issue" to 28,
    "Brutix Navy Issue" to 30,
    "Hurricane Fleet Issue" to 30,
    "Damnation" to 34,
    "Absolution" to 34,
    "Vulture" to 34,
    "Nighthawk" to 34,
    "Astarte" to 34,
    "Eos" to 34,
    "Claymore" to 34,
    "Sleipnir" to 34,
    "Abaddon" to 37,
    "Apocalypse" to 37,
    "Armageddon" to 37,
    "Scorpion" to 37,
    "Raven" to 35,
    "Rokh" to 35,
    "Hyperion" to 37,
    "Megathron" to 36,
    "Dominix" to 37,
    "Tempest" to 37,
    "Typhoon" to 37,
    "Maelstrom" to 34,
    "Praxis" to 35,
    "Apocalypse Navy Issue" to 40,
    "Armageddon Navy Issue" to 42,
    "Scorpion Navy Issue" to 42,
    "Raven Navy Issue" to 38,
    "Megathron Navy Issue" to 39,
    "Dominix Navy Issue" to 43,
    "Tempest Fleet Issue" to 40,
    "Typhoon Fleet Issue" to 44,
    "Redeemer" to 41,
    "Widow" to 48,
    "Sin" to 41,
    "Panther" to 41,
    "Paladin" to 47,
    "Golem" to 45,
    "Kronos" to 46,
    "Vargur" to 47,
    "Babaroga" to 48,
    "Bestower" to 3,
    "Sigil" to 3,
    "Badger" to 3,
    "Tayra" to 3,
    "Nereus" to 3,
    "Kryos" to 3,
    "Epithal" to 3,
    "Miasmos" to 3,
    "Iteron Mark V" to 3,
    "Hoarder" to 3,
    "Mammoth" to 3,
    "Wreathe" to 3,
    "Dramiel" to 8,
    "Cruor" to 9,
    "Worm" to 10,
    "Garmur" to 8,
    "Succubus" to 8,
    "Astero" to 8,
    "Daredevil" to 8,
    "Cynabal" to 15,
    "Ashimmu" to 18,
    "Gila" to 24,
    "Orthrus" to 19,
    "Phantasm" to 18,
    "Stratios" to 18,
    "Vigilant" to 18,
    "Machariel" to 45,
    "Bhaalgorn" to 50,
    "Rattlesnake" to 50,
    "Barghest" to 50,
    "Nightmare" to 49,
    "Vindicator" to 47,
    "Gnosis" to 27,
    "Sunesis" to 5,
    "Thunderchild" to 35,
    "Stormbringer" to 14,
    "Skybreaker" to 5,
    "Leshak" to 47,
    "Zarmazd" to 32,
    "Drekavac" to 32,
    "Ikitursa" to 26,
    "Rodiva" to 22,
    "Draugur" to 14,
    "Vedmak" to 19,
    "Kikimora" to 12,
    "Nergal" to 10,
    "Damavik" to 8,
    "Echo" to 2,
    "Hematos" to 2,
    "Immolator" to 2,
    "Taipan" to 2,
    "Violator" to 2,
    "Magnate Navy Issue" to 4,
    "Heron Navy Issue" to 3,
    "Imicus Navy Issue" to 4,
    "Probe Fleet Issue" to 4,
    "Thrasher Fleet Issue" to 9,
    "Cormorant Navy Issue" to 7,
    "Coercer Navy Issue" to 9,
    "Catalyst Navy Issue" to 9,
    "Cyclone Fleet Issue" to 30,
    "Ferox Navy Issue" to 26,
    "Prophecy Navy Issue" to 30,
    "Myrmidon Navy Issue" to 30,
    "Metamorphosis" to 5,
    "Khizriel" to 33,
    "Alligator" to 34,
    "Mamba" to 10,
    "Mekubal" to 9,
    "Squall" to 7,
    "Deluge" to 10,
    "Geri" to 27,
    "Bestla" to 39,
    "Laelaps" to 41,
    "Raiju" to 32,
    "Shapash" to 30,
    "Cybele" to 40,
    "Cenotaph" to 35,
    "Sidewinder" to 31,
    "Cobra" to 36,
    "Tholos" to 14,
)


/**
 * The list of non-Battleship ships that can be a flagship.
 */
private val nonBattleshipFlagships = setOf(
    "Geri",
    "Bestla",
    "Laelaps",
    "Raiju",
    "Shapash",
    "Cybele",
    "Sidewinder",
    "Cobra"
)


/**
 * The composition rules for Alliance Tournament XXI.
 */
private fun AtXXICompositionRules(eveData: EveData) = AllianceTournamentCompositionRules(
    eveData = eveData,
    maxCompositionSize = 10,
    maxCompositionCost = 200,
    shipCostByName = ShipCostByName,
    maxShipsInSizeClass = 3,
    nonBattleshipFlagships = nonBattleshipFlagships
)


/**
 * The fitting rules for Alliance Tournament XXI.
 */
private fun AtXXIFittingRules(eveData: EveData) = AllianceTournamentFittingRules(eveData, nonBattleshipFlagships)


/**
 * The rules for Alliance Tournament XX.
 */
private fun allianceTournamentXXIRules(eveData: EveData) =
    TournamentRules(
        compositionRules = AtXXICompositionRules(eveData),
        fittingRules = AtXXIFittingRules(eveData)
    )
