/**
 * The UI showing a fit's mobility stats.
 */

package theorycrafter.ui.fitstats

import androidx.compose.runtime.Composable
import eve.data.*
import theorycrafter.fitting.Fit
import theorycrafter.ui.fiteditor.ValueWithDescription


/**
 * UI showing the mobility stats (speed etc.)
 */
@Composable
fun MobilityStats(fit: Fit) = with(fit.propulsion){
    val maxVelocity = maxVelocity
    val inertiaModifier = inertiaModifier.value
    val mass = mass.value

    StatsTable(
        columns = 3,
        Stat(
            label = "Maximum Velocity",
            value = maxVelocity.asSpeed(withUnits = true),
            tooltipValues = listOf(
                ValueWithDescription(
                    value = maxVelocity.asSpeed(withUnits = true, kmsThreshold = Int.MAX_VALUE),
                    description = "maximum velocity"
                )
            )
        ),
        Stat(
            label = "Align Time",
            value = alignTime.asAlignTime(withUnits = true, units = "s"),
            tooltipValues = listOf(
                ValueWithDescription(
                    value = mass.asShipMass(withUnits = true),
                    description = "mass"
                ),
                ValueWithDescription(
                    value = inertiaModifier.asInertiaModifier(withUnits = true),
                    description = "inertia modifier"
                ),
            )
        ),
        Stat(
            label = "Warp Speed",
            value = warpSpeed.asWarpSpeed(withUnits = true),
        )
    )
}
