package theorycrafter.ui.widgets

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import compose.utils.VerticallyCenteredRow
import theorycrafter.ui.Switch
import theorycrafter.ui.TheorycrafterTheme


/**
 * A switch with some text.
 */
@Composable
fun SwitchWithText(
    text: String,
    detailedText: String,
    checked: Boolean,
    onCheckChange: (Boolean) -> Unit,
    modifier: Modifier
) {
    VerticallyCenteredRow(modifier) {
        Column(
            modifier = Modifier.weight(1f),
            verticalArrangement = Arrangement.spacedBy(TheorycrafterTheme.spacing.xxxsmall)
        ) {
            Text(text)
            Text(
                text = detailedText,
                style = TheorycrafterTheme.textStyles.detailedText(),
            )
        }
        TheorycrafterTheme.Switch(
            checked = checked,
            onCheckedChange = onCheckChange
        )
    }
}
