package theorycrafter.ui.widgets

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.*
import androidx.compose.material.Snackbar
import androidx.compose.material.SnackbarHost
import androidx.compose.material.SnackbarHostState
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import theorycrafter.ui.TheorycrafterTheme


/**
 * A scaffold for a layout with two side-panels, a middle panel and a status bar.
 *
 * It can also be a snackbar host, if given a [snackbarHostState].
 */
@Composable
fun ThreePanelScaffold(


    /**
     * The modifier.
     */
    modifier: Modifier = Modifier,


    /**
     * The left side-panel.
     */
    left: (@Composable BoxScope.() -> Unit)? = null,


    /**
     * The middle panel.
     */
    middle: @Composable BoxScope.() -> Unit,


    /**
     * The right panel.
     */
    right: (@Composable BoxScope.() -> Unit)? = null,


    /**
     * The status bar.
     */
    statusBar: (@Composable BoxScope.() -> Unit)? = null,


    /**
     * The [SnackbarHostState] for displaying a snackbar in this [ThreePanelScaffold].
     */
    snackbarHostState: SnackbarHostState? = null


) {
    Box(modifier = modifier) {
        val colors = TheorycrafterTheme.colors.threePanelScaffold()
        Column {
            Row(
                modifier = Modifier.weight(1.0f, fill = true)
            ) {
                if (left != null) {
                    Box(
                        modifier = Modifier
                            .fillMaxHeight()
                            .background(colors.sideBackground),
                        content = left
                    )
                }

                Box(
                    modifier = Modifier
                        .weight(1.0f, fill = true)
                        .fillMaxHeight()
                        .background(colors.middleBackground),
                    content = middle
                )

                if (right != null) {
                    Box(
                        modifier = Modifier
                            .fillMaxHeight()
                            .background(colors.sideBackground),
                        content = right
                    )
                }
            }

            if (statusBar != null) {
                Box(
                    modifier = Modifier
                        .fillMaxWidth()
                        .background(colors.statusBarBackground),
                    content = statusBar,
                )
            }
        }

        if (snackbarHostState != null) {
            SnackbarHost(
                hostState = snackbarHostState,
                modifier = Modifier
                    .align(Alignment.BottomCenter)
                    .padding(bottom = TheorycrafterTheme.spacing.large),
            ) {
                Snackbar(
                    snackbarData = it,
                    modifier = Modifier.widthIn(max = TheorycrafterTheme.sizes.maxSnackbarWidth)
                )
            }
        }
    }

}
