package theorycrafter.ui.fiteditor

import androidx.compose.ui.test.assertAny
import androidx.compose.ui.test.assertCountEquals
import androidx.compose.ui.test.filter
import androidx.compose.ui.test.hasText
import theorycrafter.TheorycrafterContext.eveData
import theorycrafter.TheorycrafterContext.fits
import theorycrafter.TheorycrafterTest
import theorycrafter.onSubtreeRootedAt
import theorycrafter.runBlockingTest
import theorycrafter.setApplicationContent
import kotlin.test.Test
import kotlin.test.assertTrue


/**
 * Tests remote effects
 */
class RemoteEffectsTest: TheorycrafterTest() {


    /**
     * Tests adding a hostile and a friendly remote module effect (in the same rack), and then removing them.
     */
    @Test
    fun addAndRemoveHostileAndFriendlyRemoteModuleEffect() = runBlockingTest {
        val fit = newFit(shipName = "Caracal")

        rule.setApplicationContent {
            FitEditor(fit)
        }

        val nosferatuType = eveData.moduleType("Medium Energy Nosferatu I")
        val capTransmitterType = eveData.moduleType("Medium Remote Capacitor Transmitter I")
        val nosferatu = fits.modifyAndSave {
            fit.addModuleEffect(nosferatuType)!!
        }
        val capTransmitter = fits.modifyAndSave {
            fit.addModuleEffect(capTransmitterType)!!
        }

        rule.onSubtreeRootedAt(Nodes.FitEditor.hostileModuleEffectRow(0))
            .assertAny(hasText(nosferatuType.name))
        rule.onSubtreeRootedAt(Nodes.FitEditor.friendlyModuleEffectRow(0))
            .assertAny(hasText(capTransmitterType.name))

        fits.modifyAndSave {
            fit.removeModuleEffect(nosferatu)
        }
        rule.onSubtreeRootedAt(Nodes.FitEditor.hostileModuleEffectRow(0))
            .filter(hasText(nosferatuType.name))
            .assertCountEquals(0)

        fits.modifyAndSave {
            fit.removeModuleEffect(capTransmitter)
        }
        rule.onSubtreeRootedAt(Nodes.FitEditor.friendlyModuleEffectRow(0))
            .filter(hasText(capTransmitterType.name))
            .assertCountEquals(0)

        assertTrue(fit.remoteEffects.allModule.isEmpty(), message = "Remote modules not cleared")
    }


}