package eve.data

/**
 * The interface for an Eve object that has an associated icon.
 */
interface EveObjectWithIcon {

    /**
     * Returns whether the object actually has an icon.
     */
    val hasIcon: Boolean

    /**
     * Returns the resource path of this item type's icon; `null` if the object doesn't actually have an icon.
     */
    fun iconResourcePath(): String?

}
