/**
 * Methods for identifying implants.
 */

package eve.data.typeid

import eve.data.BoosterType
import eve.data.EveData


/**
 * Returns whether the given booster is a "Blue Pill" booster.
 * Note that this includes the "Antipharmakon Thureo" booster.
 */
context(EveData)
fun BoosterType.isBluePill() =
    variationParentTypeId == 9950


/**
 * Returns whether the given booster is an "Exile" booster.
 * Note that this includes the "Antipharmakon Kosybo" booster.
 */
context(EveData)
fun BoosterType.isExile() =
    variationParentTypeId == 15479


/**
 * Returns whether the given booster is a "Mindflood" booster.
 * Note that this includes the "Antipharmakon Aeolis" booster
 */
context(EveData)
fun BoosterType.isMindflood() =
    variationParentTypeId == 15463


/**
 * Returns whether the given booster is an "X-Instinct" booster.
 */
context(EveData)
fun BoosterType.isXInstinct() =
    variationParentTypeId == 15457


/**
 * Returns whether the given booster is a "Drop" booster.
 * Note that this includes the "Antipharmakon Iokira" booster.
 */
context(EveData)
fun BoosterType.isDrop() =
    variationParentTypeId == 15466


/**
 * Returns whether the given booster is a "Frentix" booster.
 */
context(EveData)
fun BoosterType.isFrentix() =
    variationParentTypeId == 15460


/**
 * Returns whether the given booster is a "Sooth Sayer" booster.
 */
context(EveData)
fun BoosterType.isSoothSayer() =
    variationParentTypeId == 10164


/**
 * Returns whether the given booster is a "Crash" booster.
 */
context(EveData)
fun BoosterType.isCrash() =
    variationParentTypeId == 9947


/**
 * Returns whether the given booster is an "Agency `Hardshell`" booster.
 */
context(EveData)
fun BoosterType.isAgencyHardshell() =
    variationParentTypeId == 46001


/**
 * Returns whether the given booster is an "Agency `Overclocker`" booster.
 */
context(EveData)
fun BoosterType.isAgencyOverclocker() =
    variationParentTypeId == 46004


/**
 * Returns whether the given booster is an "Agency Pyrolancea" booster.
 */
context(EveData)
fun BoosterType.isAgencyPyrolancea() =
    variationParentTypeId == 45998


/**
 * Returns whether the given booster is the "Quafe Zero Classic" booster.
 */
context(EveData)
fun BoosterType.isQuafeZeroClassic() =
    itemId == 3898


/**
 * Returns whether the given booster is a "Quafe Zero Green Apple" booster.
 */
context(EveData)
fun BoosterType.isQuafeZeroGreenApple() =
    variationParentTypeId == 60575


/**
 * Returns whether the given booster is an "Antipharmakon Toxot" booster.
 */
context(EveData)
fun BoosterType.isAntipharmakonToxot() =
    itemId == 36911


/**
 * Returns whether the given booster is a "Veilguard" booster.
 */
context(EveData)
fun BoosterType.isVeilguard() =
    itemId == 59633


/**
 * Returns whether the given booster is an AIR booster.
 */
context(EveData)
fun BoosterType.isAIR() = name.contains("AIR")


/**
 * Returns whether the given booster is a Wightstorm booster.
 */
context(EveData)
fun BoosterType.isWightstorm() = name.contains("Wightstorm")


/**
 * Returns whether the given booster is a Wightstorm Cetana booster.
 */
context(EveData)
fun BoosterType.isWightstormCetana() = isWightstorm() && name.contains("Cetana")


/**
 * Returns whether the given booster is a Wightstorm Manasikara booster.
 */
context(EveData)
fun BoosterType.isWightstormManasikara() = isWightstorm() && name.contains("Manasikara")


/**
 * Returns whether the given booster is a Wightstorm Nirvana booster.
 */
context(EveData)
fun BoosterType.isWightstormNirvana() = isWightstorm() && name.contains("Nirvana")


/**
 * Returns whether the given booster is a Wightstorm Rapture booster.
 */
context(EveData)
fun BoosterType.isWightstormRapture() = isWightstorm() && name.contains("Rapture")


/**
 * Returns whether the given booster is a Wightstorm Sunyata booster.
 */
context(EveData)
fun BoosterType.isWightstormSunyata() = isWightstorm() && name.contains("Sunyata")


/**
 * Returns whether the given booster is a Wightstorm Vitarka booster.
 */
context(EveData)
fun BoosterType.isWightstormVitarka() = isWightstorm() && name.contains("Vitarka")





